/*
 * Decompiled with CFR 0.152.
 */
package io.gitea.model;

import com.google.gson.annotations.SerializedName;
import io.gitea.model.CommitStatus;
import io.gitea.model.Repository;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="CombinedStatus holds the combined state of several statuses for a single commit")
public class CombinedStatus {
    @SerializedName(value="commit_url")
    private String commitUrl = null;
    @SerializedName(value="repository")
    private Repository repository = null;
    @SerializedName(value="sha")
    private String sha = null;
    @SerializedName(value="state")
    private String state = null;
    @SerializedName(value="statuses")
    private List<CommitStatus> statuses = null;
    @SerializedName(value="total_count")
    private Long totalCount = null;
    @SerializedName(value="url")
    private String url = null;

    public CombinedStatus commitUrl(String commitUrl) {
        this.commitUrl = commitUrl;
        return this;
    }

    @ApiModelProperty(value="")
    public String getCommitUrl() {
        return this.commitUrl;
    }

    public void setCommitUrl(String commitUrl) {
        this.commitUrl = commitUrl;
    }

    public CombinedStatus repository(Repository repository) {
        this.repository = repository;
        return this;
    }

    @ApiModelProperty(value="")
    public Repository getRepository() {
        return this.repository;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public CombinedStatus sha(String sha) {
        this.sha = sha;
        return this;
    }

    @ApiModelProperty(value="")
    public String getSha() {
        return this.sha;
    }

    public void setSha(String sha) {
        this.sha = sha;
    }

    public CombinedStatus state(String state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(value="")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public CombinedStatus statuses(List<CommitStatus> statuses) {
        this.statuses = statuses;
        return this;
    }

    public CombinedStatus addStatusesItem(CommitStatus statusesItem) {
        if (this.statuses == null) {
            this.statuses = new ArrayList<CommitStatus>();
        }
        this.statuses.add(statusesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<CommitStatus> getStatuses() {
        return this.statuses;
    }

    public void setStatuses(List<CommitStatus> statuses) {
        this.statuses = statuses;
    }

    public CombinedStatus totalCount(Long totalCount) {
        this.totalCount = totalCount;
        return this;
    }

    @ApiModelProperty(value="")
    public Long getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(Long totalCount) {
        this.totalCount = totalCount;
    }

    public CombinedStatus url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(value="")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CombinedStatus combinedStatus = (CombinedStatus)o;
        return Objects.equals(this.commitUrl, combinedStatus.commitUrl) && Objects.equals(this.repository, combinedStatus.repository) && Objects.equals(this.sha, combinedStatus.sha) && Objects.equals(this.state, combinedStatus.state) && Objects.equals(this.statuses, combinedStatus.statuses) && Objects.equals(this.totalCount, combinedStatus.totalCount) && Objects.equals(this.url, combinedStatus.url);
    }

    public int hashCode() {
        return Objects.hash(this.commitUrl, this.repository, this.sha, this.state, this.statuses, this.totalCount, this.url);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CombinedStatus {\n");
        sb.append("    commitUrl: ").append(this.toIndentedString(this.commitUrl)).append("\n");
        sb.append("    repository: ").append(this.toIndentedString(this.repository)).append("\n");
        sb.append("    sha: ").append(this.toIndentedString(this.sha)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    statuses: ").append(this.toIndentedString(this.statuses)).append("\n");
        sb.append("    totalCount: ").append(this.toIndentedString(this.totalCount)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

