/*
 * Decompiled with CFR 0.152.
 */
package io.gitea.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.gitea.ApiCallback;
import io.gitea.ApiClient;
import io.gitea.ApiException;
import io.gitea.ApiResponse;
import io.gitea.Configuration;
import io.gitea.Pair;
import io.gitea.ProgressRequestBody;
import io.gitea.ProgressResponseBody;
import io.gitea.model.AddCollaboratorOption;
import io.gitea.model.AnnotatedTag;
import io.gitea.model.Attachment;
import io.gitea.model.Branch;
import io.gitea.model.BranchProtection;
import io.gitea.model.ChangedFile;
import io.gitea.model.CombinedStatus;
import io.gitea.model.Commit;
import io.gitea.model.CommitStatus;
import io.gitea.model.ContentsResponse;
import io.gitea.model.CreateBranchProtectionOption;
import io.gitea.model.CreateBranchRepoOption;
import io.gitea.model.CreateFileOptions;
import io.gitea.model.CreateForkOption;
import io.gitea.model.CreateHookOption;
import io.gitea.model.CreateKeyOption;
import io.gitea.model.CreatePullRequestOption;
import io.gitea.model.CreatePullReviewOptions;
import io.gitea.model.CreatePushMirrorOption;
import io.gitea.model.CreateReleaseOption;
import io.gitea.model.CreateRepoOption;
import io.gitea.model.CreateStatusOption;
import io.gitea.model.CreateTagOption;
import io.gitea.model.CreateWikiPageOptions;
import io.gitea.model.DeleteFileOptions;
import io.gitea.model.DeployKey;
import io.gitea.model.DismissPullReviewOptions;
import io.gitea.model.EditAttachmentOptions;
import io.gitea.model.EditBranchProtectionOption;
import io.gitea.model.EditGitHookOption;
import io.gitea.model.EditHookOption;
import io.gitea.model.EditPullRequestOption;
import io.gitea.model.EditReleaseOption;
import io.gitea.model.EditRepoOption;
import io.gitea.model.FileDeleteResponse;
import io.gitea.model.FileResponse;
import io.gitea.model.GenerateRepoOption;
import io.gitea.model.GitBlobResponse;
import io.gitea.model.GitHook;
import io.gitea.model.GitTreeResponse;
import io.gitea.model.Hook;
import io.gitea.model.IssueTemplate;
import io.gitea.model.MergePullRequestOption;
import io.gitea.model.MigrateRepoOptions;
import io.gitea.model.Note;
import io.gitea.model.PullRequest;
import io.gitea.model.PullReview;
import io.gitea.model.PullReviewComment;
import io.gitea.model.PullReviewRequestOptions;
import io.gitea.model.PushMirror;
import io.gitea.model.Reference;
import io.gitea.model.Release;
import io.gitea.model.RepoCollaboratorPermission;
import io.gitea.model.RepoTopicOptions;
import io.gitea.model.Repository;
import io.gitea.model.SearchResults;
import io.gitea.model.SubmitPullReviewOptions;
import io.gitea.model.Tag;
import io.gitea.model.Team;
import io.gitea.model.TopicName;
import io.gitea.model.TopicResponse;
import io.gitea.model.TrackedTime;
import io.gitea.model.TransferRepoOption;
import io.gitea.model.UpdateFileOptions;
import io.gitea.model.User;
import io.gitea.model.WatchInfo;
import io.gitea.model.WikiCommitList;
import io.gitea.model.WikiPage;
import io.gitea.model.WikiPageMetaData;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.threeten.bp.OffsetDateTime;

public class RepositoryApi {
    private ApiClient apiClient;

    public RepositoryApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RepositoryApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call acceptRepoTransferCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/transfer/accept".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call acceptRepoTransferValidateBeforeCall(String owner, String repo, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling acceptRepoTransfer(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling acceptRepoTransfer(Async)");
        }
        Call call = this.acceptRepoTransferCall(owner, repo, progressListener, progressRequestListener);
        return call;
    }

    public Repository acceptRepoTransfer(String owner, String repo) throws ApiException {
        ApiResponse<Repository> resp = this.acceptRepoTransferWithHttpInfo(owner, repo);
        return resp.getData();
    }

    public ApiResponse<Repository> acceptRepoTransferWithHttpInfo(String owner, String repo) throws ApiException {
        Call call = this.acceptRepoTransferValidateBeforeCall(owner, repo, null, null);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call acceptRepoTransferAsync(String owner, String repo, final ApiCallback<Repository> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.acceptRepoTransferValidateBeforeCall(owner, repo, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call createCurrentUserRepoCall(CreateRepoOption body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateRepoOption localVarPostBody = body;
        String localVarPath = "/user/repos";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createCurrentUserRepoValidateBeforeCall(CreateRepoOption body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.createCurrentUserRepoCall(body, progressListener, progressRequestListener);
        return call;
    }

    public Repository createCurrentUserRepo(CreateRepoOption body) throws ApiException {
        ApiResponse<Repository> resp = this.createCurrentUserRepoWithHttpInfo(body);
        return resp.getData();
    }

    public ApiResponse<Repository> createCurrentUserRepoWithHttpInfo(CreateRepoOption body) throws ApiException {
        Call call = this.createCurrentUserRepoValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createCurrentUserRepoAsync(CreateRepoOption body, final ApiCallback<Repository> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createCurrentUserRepoValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call createForkCall(String owner, String repo, CreateForkOption body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateForkOption localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}/forks".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createForkValidateBeforeCall(String owner, String repo, CreateForkOption body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling createFork(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling createFork(Async)");
        }
        Call call = this.createForkCall(owner, repo, body, progressListener, progressRequestListener);
        return call;
    }

    public Repository createFork(String owner, String repo, CreateForkOption body) throws ApiException {
        ApiResponse<Repository> resp = this.createForkWithHttpInfo(owner, repo, body);
        return resp.getData();
    }

    public ApiResponse<Repository> createForkWithHttpInfo(String owner, String repo, CreateForkOption body) throws ApiException {
        Call call = this.createForkValidateBeforeCall(owner, repo, body, null, null);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createForkAsync(String owner, String repo, CreateForkOption body, final ApiCallback<Repository> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createForkValidateBeforeCall(owner, repo, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call generateRepoCall(String templateOwner, String templateRepo, GenerateRepoOption body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        GenerateRepoOption localVarPostBody = body;
        String localVarPath = "/repos/{template_owner}/{template_repo}/generate".replaceAll("\\{template_owner\\}", this.apiClient.escapeString(templateOwner.toString())).replaceAll("\\{template_repo\\}", this.apiClient.escapeString(templateRepo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call generateRepoValidateBeforeCall(String templateOwner, String templateRepo, GenerateRepoOption body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (templateOwner == null) {
            throw new ApiException("Missing the required parameter 'templateOwner' when calling generateRepo(Async)");
        }
        if (templateRepo == null) {
            throw new ApiException("Missing the required parameter 'templateRepo' when calling generateRepo(Async)");
        }
        Call call = this.generateRepoCall(templateOwner, templateRepo, body, progressListener, progressRequestListener);
        return call;
    }

    public Repository generateRepo(String templateOwner, String templateRepo, GenerateRepoOption body) throws ApiException {
        ApiResponse<Repository> resp = this.generateRepoWithHttpInfo(templateOwner, templateRepo, body);
        return resp.getData();
    }

    public ApiResponse<Repository> generateRepoWithHttpInfo(String templateOwner, String templateRepo, GenerateRepoOption body) throws ApiException {
        Call call = this.generateRepoValidateBeforeCall(templateOwner, templateRepo, body, null, null);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call generateRepoAsync(String templateOwner, String templateRepo, GenerateRepoOption body, final ApiCallback<Repository> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.generateRepoValidateBeforeCall(templateOwner, templateRepo, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getAnnotatedTagCall(String owner, String repo, String sha, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/git/tags/{sha}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{sha\\}", this.apiClient.escapeString(sha.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAnnotatedTagValidateBeforeCall(String owner, String repo, String sha, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling getAnnotatedTag(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling getAnnotatedTag(Async)");
        }
        if (sha == null) {
            throw new ApiException("Missing the required parameter 'sha' when calling getAnnotatedTag(Async)");
        }
        Call call = this.getAnnotatedTagCall(owner, repo, sha, progressListener, progressRequestListener);
        return call;
    }

    public AnnotatedTag getAnnotatedTag(String owner, String repo, String sha) throws ApiException {
        ApiResponse<AnnotatedTag> resp = this.getAnnotatedTagWithHttpInfo(owner, repo, sha);
        return resp.getData();
    }

    public ApiResponse<AnnotatedTag> getAnnotatedTagWithHttpInfo(String owner, String repo, String sha) throws ApiException {
        Call call = this.getAnnotatedTagValidateBeforeCall(owner, repo, sha, null, null);
        Type localVarReturnType = new TypeToken<AnnotatedTag>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAnnotatedTagAsync(String owner, String repo, String sha, final ApiCallback<AnnotatedTag> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAnnotatedTagValidateBeforeCall(owner, repo, sha, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AnnotatedTag>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getBlobCall(String owner, String repo, String sha, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/git/blobs/{sha}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{sha\\}", this.apiClient.escapeString(sha.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getBlobValidateBeforeCall(String owner, String repo, String sha, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling getBlob(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling getBlob(Async)");
        }
        if (sha == null) {
            throw new ApiException("Missing the required parameter 'sha' when calling getBlob(Async)");
        }
        Call call = this.getBlobCall(owner, repo, sha, progressListener, progressRequestListener);
        return call;
    }

    public GitBlobResponse getBlob(String owner, String repo, String sha) throws ApiException {
        ApiResponse<GitBlobResponse> resp = this.getBlobWithHttpInfo(owner, repo, sha);
        return resp.getData();
    }

    public ApiResponse<GitBlobResponse> getBlobWithHttpInfo(String owner, String repo, String sha) throws ApiException {
        Call call = this.getBlobValidateBeforeCall(owner, repo, sha, null, null);
        Type localVarReturnType = new TypeToken<GitBlobResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getBlobAsync(String owner, String repo, String sha, final ApiCallback<GitBlobResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getBlobValidateBeforeCall(owner, repo, sha, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GitBlobResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTreeCall(String owner, String repo, String sha, Boolean recursive, Integer page, Integer perPage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/git/trees/{sha}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{sha\\}", this.apiClient.escapeString(sha.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (recursive != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("recursive", recursive));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (perPage != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("per_page", perPage));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTreeValidateBeforeCall(String owner, String repo, String sha, Boolean recursive, Integer page, Integer perPage, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling getTree(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling getTree(Async)");
        }
        if (sha == null) {
            throw new ApiException("Missing the required parameter 'sha' when calling getTree(Async)");
        }
        Call call = this.getTreeCall(owner, repo, sha, recursive, page, perPage, progressListener, progressRequestListener);
        return call;
    }

    public GitTreeResponse getTree(String owner, String repo, String sha, Boolean recursive, Integer page, Integer perPage) throws ApiException {
        ApiResponse<GitTreeResponse> resp = this.getTreeWithHttpInfo(owner, repo, sha, recursive, page, perPage);
        return resp.getData();
    }

    public ApiResponse<GitTreeResponse> getTreeWithHttpInfo(String owner, String repo, String sha, Boolean recursive, Integer page, Integer perPage) throws ApiException {
        Call call = this.getTreeValidateBeforeCall(owner, repo, sha, recursive, page, perPage, null, null);
        Type localVarReturnType = new TypeToken<GitTreeResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTreeAsync(String owner, String repo, String sha, Boolean recursive, Integer page, Integer perPage, final ApiCallback<GitTreeResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTreeValidateBeforeCall(owner, repo, sha, recursive, page, perPage, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GitTreeResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call listForksCall(String owner, String repo, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/forks".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call listForksValidateBeforeCall(String owner, String repo, Integer page, Integer limit, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling listForks(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling listForks(Async)");
        }
        Call call = this.listForksCall(owner, repo, page, limit, progressListener, progressRequestListener);
        return call;
    }

    public List<Repository> listForks(String owner, String repo, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<Repository>> resp = this.listForksWithHttpInfo(owner, repo, page, limit);
        return resp.getData();
    }

    public ApiResponse<List<Repository>> listForksWithHttpInfo(String owner, String repo, Integer page, Integer limit) throws ApiException {
        Call call = this.listForksValidateBeforeCall(owner, repo, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<Repository>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listForksAsync(String owner, String repo, Integer page, Integer limit, final ApiCallback<List<Repository>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listForksValidateBeforeCall(owner, repo, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Repository>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call rejectRepoTransferCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/transfer/reject".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call rejectRepoTransferValidateBeforeCall(String owner, String repo, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling rejectRepoTransfer(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling rejectRepoTransfer(Async)");
        }
        Call call = this.rejectRepoTransferCall(owner, repo, progressListener, progressRequestListener);
        return call;
    }

    public Repository rejectRepoTransfer(String owner, String repo) throws ApiException {
        ApiResponse<Repository> resp = this.rejectRepoTransferWithHttpInfo(owner, repo);
        return resp.getData();
    }

    public ApiResponse<Repository> rejectRepoTransferWithHttpInfo(String owner, String repo) throws ApiException {
        Call call = this.rejectRepoTransferValidateBeforeCall(owner, repo, null, null);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call rejectRepoTransferAsync(String owner, String repo, final ApiCallback<Repository> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.rejectRepoTransferValidateBeforeCall(owner, repo, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoAddCollaboratorCall(String owner, String repo, String collaborator, AddCollaboratorOption body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        AddCollaboratorOption localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}/collaborators/{collaborator}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{collaborator\\}", this.apiClient.escapeString(collaborator.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoAddCollaboratorValidateBeforeCall(String owner, String repo, String collaborator, AddCollaboratorOption body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoAddCollaborator(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoAddCollaborator(Async)");
        }
        if (collaborator == null) {
            throw new ApiException("Missing the required parameter 'collaborator' when calling repoAddCollaborator(Async)");
        }
        Call call = this.repoAddCollaboratorCall(owner, repo, collaborator, body, progressListener, progressRequestListener);
        return call;
    }

    public void repoAddCollaborator(String owner, String repo, String collaborator, AddCollaboratorOption body) throws ApiException {
        this.repoAddCollaboratorWithHttpInfo(owner, repo, collaborator, body);
    }

    public ApiResponse<Void> repoAddCollaboratorWithHttpInfo(String owner, String repo, String collaborator, AddCollaboratorOption body) throws ApiException {
        Call call = this.repoAddCollaboratorValidateBeforeCall(owner, repo, collaborator, body, null, null);
        return this.apiClient.execute(call);
    }

    public Call repoAddCollaboratorAsync(String owner, String repo, String collaborator, AddCollaboratorOption body, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoAddCollaboratorValidateBeforeCall(owner, repo, collaborator, body, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call repoAddPushMirrorCall(String owner, String repo, CreatePushMirrorOption body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreatePushMirrorOption localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}/push_mirrors".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoAddPushMirrorValidateBeforeCall(String owner, String repo, CreatePushMirrorOption body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoAddPushMirror(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoAddPushMirror(Async)");
        }
        Call call = this.repoAddPushMirrorCall(owner, repo, body, progressListener, progressRequestListener);
        return call;
    }

    public PushMirror repoAddPushMirror(String owner, String repo, CreatePushMirrorOption body) throws ApiException {
        ApiResponse<PushMirror> resp = this.repoAddPushMirrorWithHttpInfo(owner, repo, body);
        return resp.getData();
    }

    public ApiResponse<PushMirror> repoAddPushMirrorWithHttpInfo(String owner, String repo, CreatePushMirrorOption body) throws ApiException {
        Call call = this.repoAddPushMirrorValidateBeforeCall(owner, repo, body, null, null);
        Type localVarReturnType = new TypeToken<PushMirror>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoAddPushMirrorAsync(String owner, String repo, CreatePushMirrorOption body, final ApiCallback<PushMirror> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoAddPushMirrorValidateBeforeCall(owner, repo, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PushMirror>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoAddTeamCall(String owner, String repo, String team, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/teams/{team}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{team\\}", this.apiClient.escapeString(team.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoAddTeamValidateBeforeCall(String owner, String repo, String team, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoAddTeam(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoAddTeam(Async)");
        }
        if (team == null) {
            throw new ApiException("Missing the required parameter 'team' when calling repoAddTeam(Async)");
        }
        Call call = this.repoAddTeamCall(owner, repo, team, progressListener, progressRequestListener);
        return call;
    }

    public void repoAddTeam(String owner, String repo, String team) throws ApiException {
        this.repoAddTeamWithHttpInfo(owner, repo, team);
    }

    public ApiResponse<Void> repoAddTeamWithHttpInfo(String owner, String repo, String team) throws ApiException {
        Call call = this.repoAddTeamValidateBeforeCall(owner, repo, team, null, null);
        return this.apiClient.execute(call);
    }

    public Call repoAddTeamAsync(String owner, String repo, String team, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoAddTeamValidateBeforeCall(owner, repo, team, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call repoAddTopicCall(String owner, String repo, String topic, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/topics/{topic}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{topic\\}", this.apiClient.escapeString(topic.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoAddTopicValidateBeforeCall(String owner, String repo, String topic, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoAddTopic(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoAddTopic(Async)");
        }
        if (topic == null) {
            throw new ApiException("Missing the required parameter 'topic' when calling repoAddTopic(Async)");
        }
        Call call = this.repoAddTopicCall(owner, repo, topic, progressListener, progressRequestListener);
        return call;
    }

    public void repoAddTopic(String owner, String repo, String topic) throws ApiException {
        this.repoAddTopicWithHttpInfo(owner, repo, topic);
    }

    public ApiResponse<Void> repoAddTopicWithHttpInfo(String owner, String repo, String topic) throws ApiException {
        Call call = this.repoAddTopicValidateBeforeCall(owner, repo, topic, null, null);
        return this.apiClient.execute(call);
    }

    public Call repoAddTopicAsync(String owner, String repo, String topic, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoAddTopicValidateBeforeCall(owner, repo, topic, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call repoApplyDiffPatchCall(String owner, String repo, UpdateFileOptions body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UpdateFileOptions localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}/diffpatch".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoApplyDiffPatchValidateBeforeCall(String owner, String repo, UpdateFileOptions body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoApplyDiffPatch(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoApplyDiffPatch(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling repoApplyDiffPatch(Async)");
        }
        Call call = this.repoApplyDiffPatchCall(owner, repo, body, progressListener, progressRequestListener);
        return call;
    }

    public FileResponse repoApplyDiffPatch(String owner, String repo, UpdateFileOptions body) throws ApiException {
        ApiResponse<FileResponse> resp = this.repoApplyDiffPatchWithHttpInfo(owner, repo, body);
        return resp.getData();
    }

    public ApiResponse<FileResponse> repoApplyDiffPatchWithHttpInfo(String owner, String repo, UpdateFileOptions body) throws ApiException {
        Call call = this.repoApplyDiffPatchValidateBeforeCall(owner, repo, body, null, null);
        Type localVarReturnType = new TypeToken<FileResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoApplyDiffPatchAsync(String owner, String repo, UpdateFileOptions body, final ApiCallback<FileResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoApplyDiffPatchValidateBeforeCall(owner, repo, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FileResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoCancelScheduledAutoMergeCall(String owner, String repo, Long index, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/pulls/{index}/merge".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoCancelScheduledAutoMergeValidateBeforeCall(String owner, String repo, Long index, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoCancelScheduledAutoMerge(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoCancelScheduledAutoMerge(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling repoCancelScheduledAutoMerge(Async)");
        }
        Call call = this.repoCancelScheduledAutoMergeCall(owner, repo, index, progressListener, progressRequestListener);
        return call;
    }

    public void repoCancelScheduledAutoMerge(String owner, String repo, Long index) throws ApiException {
        this.repoCancelScheduledAutoMergeWithHttpInfo(owner, repo, index);
    }

    public ApiResponse<Void> repoCancelScheduledAutoMergeWithHttpInfo(String owner, String repo, Long index) throws ApiException {
        Call call = this.repoCancelScheduledAutoMergeValidateBeforeCall(owner, repo, index, null, null);
        return this.apiClient.execute(call);
    }

    public Call repoCancelScheduledAutoMergeAsync(String owner, String repo, Long index, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoCancelScheduledAutoMergeValidateBeforeCall(owner, repo, index, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call repoCheckCollaboratorCall(String owner, String repo, String collaborator, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/collaborators/{collaborator}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{collaborator\\}", this.apiClient.escapeString(collaborator.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoCheckCollaboratorValidateBeforeCall(String owner, String repo, String collaborator, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoCheckCollaborator(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoCheckCollaborator(Async)");
        }
        if (collaborator == null) {
            throw new ApiException("Missing the required parameter 'collaborator' when calling repoCheckCollaborator(Async)");
        }
        Call call = this.repoCheckCollaboratorCall(owner, repo, collaborator, progressListener, progressRequestListener);
        return call;
    }

    public void repoCheckCollaborator(String owner, String repo, String collaborator) throws ApiException {
        this.repoCheckCollaboratorWithHttpInfo(owner, repo, collaborator);
    }

    public ApiResponse<Void> repoCheckCollaboratorWithHttpInfo(String owner, String repo, String collaborator) throws ApiException {
        Call call = this.repoCheckCollaboratorValidateBeforeCall(owner, repo, collaborator, null, null);
        return this.apiClient.execute(call);
    }

    public Call repoCheckCollaboratorAsync(String owner, String repo, String collaborator, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoCheckCollaboratorValidateBeforeCall(owner, repo, collaborator, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call repoCheckTeamCall(String owner, String repo, String team, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/teams/{team}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{team\\}", this.apiClient.escapeString(team.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoCheckTeamValidateBeforeCall(String owner, String repo, String team, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoCheckTeam(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoCheckTeam(Async)");
        }
        if (team == null) {
            throw new ApiException("Missing the required parameter 'team' when calling repoCheckTeam(Async)");
        }
        Call call = this.repoCheckTeamCall(owner, repo, team, progressListener, progressRequestListener);
        return call;
    }

    public Team repoCheckTeam(String owner, String repo, String team) throws ApiException {
        ApiResponse<Team> resp = this.repoCheckTeamWithHttpInfo(owner, repo, team);
        return resp.getData();
    }

    public ApiResponse<Team> repoCheckTeamWithHttpInfo(String owner, String repo, String team) throws ApiException {
        Call call = this.repoCheckTeamValidateBeforeCall(owner, repo, team, null, null);
        Type localVarReturnType = new TypeToken<Team>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoCheckTeamAsync(String owner, String repo, String team, final ApiCallback<Team> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoCheckTeamValidateBeforeCall(owner, repo, team, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Team>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoCreateBranchCall(String owner, String repo, CreateBranchRepoOption body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateBranchRepoOption localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}/branches".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoCreateBranchValidateBeforeCall(String owner, String repo, CreateBranchRepoOption body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoCreateBranch(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoCreateBranch(Async)");
        }
        Call call = this.repoCreateBranchCall(owner, repo, body, progressListener, progressRequestListener);
        return call;
    }

    public Branch repoCreateBranch(String owner, String repo, CreateBranchRepoOption body) throws ApiException {
        ApiResponse<Branch> resp = this.repoCreateBranchWithHttpInfo(owner, repo, body);
        return resp.getData();
    }

    public ApiResponse<Branch> repoCreateBranchWithHttpInfo(String owner, String repo, CreateBranchRepoOption body) throws ApiException {
        Call call = this.repoCreateBranchValidateBeforeCall(owner, repo, body, null, null);
        Type localVarReturnType = new TypeToken<Branch>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoCreateBranchAsync(String owner, String repo, CreateBranchRepoOption body, final ApiCallback<Branch> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoCreateBranchValidateBeforeCall(owner, repo, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Branch>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoCreateBranchProtectionCall(String owner, String repo, CreateBranchProtectionOption body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateBranchProtectionOption localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}/branch_protections".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoCreateBranchProtectionValidateBeforeCall(String owner, String repo, CreateBranchProtectionOption body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoCreateBranchProtection(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoCreateBranchProtection(Async)");
        }
        Call call = this.repoCreateBranchProtectionCall(owner, repo, body, progressListener, progressRequestListener);
        return call;
    }

    public BranchProtection repoCreateBranchProtection(String owner, String repo, CreateBranchProtectionOption body) throws ApiException {
        ApiResponse<BranchProtection> resp = this.repoCreateBranchProtectionWithHttpInfo(owner, repo, body);
        return resp.getData();
    }

    public ApiResponse<BranchProtection> repoCreateBranchProtectionWithHttpInfo(String owner, String repo, CreateBranchProtectionOption body) throws ApiException {
        Call call = this.repoCreateBranchProtectionValidateBeforeCall(owner, repo, body, null, null);
        Type localVarReturnType = new TypeToken<BranchProtection>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoCreateBranchProtectionAsync(String owner, String repo, CreateBranchProtectionOption body, final ApiCallback<BranchProtection> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoCreateBranchProtectionValidateBeforeCall(owner, repo, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<BranchProtection>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoCreateFileCall(String owner, String repo, String filepath, CreateFileOptions body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateFileOptions localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}/contents/{filepath}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{filepath\\}", this.apiClient.escapeString(filepath.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoCreateFileValidateBeforeCall(String owner, String repo, String filepath, CreateFileOptions body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoCreateFile(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoCreateFile(Async)");
        }
        if (filepath == null) {
            throw new ApiException("Missing the required parameter 'filepath' when calling repoCreateFile(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling repoCreateFile(Async)");
        }
        Call call = this.repoCreateFileCall(owner, repo, filepath, body, progressListener, progressRequestListener);
        return call;
    }

    public FileResponse repoCreateFile(String owner, String repo, String filepath, CreateFileOptions body) throws ApiException {
        ApiResponse<FileResponse> resp = this.repoCreateFileWithHttpInfo(owner, repo, filepath, body);
        return resp.getData();
    }

    public ApiResponse<FileResponse> repoCreateFileWithHttpInfo(String owner, String repo, String filepath, CreateFileOptions body) throws ApiException {
        Call call = this.repoCreateFileValidateBeforeCall(owner, repo, filepath, body, null, null);
        Type localVarReturnType = new TypeToken<FileResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoCreateFileAsync(String owner, String repo, String filepath, CreateFileOptions body, final ApiCallback<FileResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoCreateFileValidateBeforeCall(owner, repo, filepath, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FileResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoCreateHookCall(String owner, String repo, CreateHookOption body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateHookOption localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}/hooks".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoCreateHookValidateBeforeCall(String owner, String repo, CreateHookOption body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoCreateHook(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoCreateHook(Async)");
        }
        Call call = this.repoCreateHookCall(owner, repo, body, progressListener, progressRequestListener);
        return call;
    }

    public Hook repoCreateHook(String owner, String repo, CreateHookOption body) throws ApiException {
        ApiResponse<Hook> resp = this.repoCreateHookWithHttpInfo(owner, repo, body);
        return resp.getData();
    }

    public ApiResponse<Hook> repoCreateHookWithHttpInfo(String owner, String repo, CreateHookOption body) throws ApiException {
        Call call = this.repoCreateHookValidateBeforeCall(owner, repo, body, null, null);
        Type localVarReturnType = new TypeToken<Hook>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoCreateHookAsync(String owner, String repo, CreateHookOption body, final ApiCallback<Hook> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoCreateHookValidateBeforeCall(owner, repo, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Hook>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoCreateKeyCall(String owner, String repo, CreateKeyOption body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateKeyOption localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}/keys".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoCreateKeyValidateBeforeCall(String owner, String repo, CreateKeyOption body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoCreateKey(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoCreateKey(Async)");
        }
        Call call = this.repoCreateKeyCall(owner, repo, body, progressListener, progressRequestListener);
        return call;
    }

    public DeployKey repoCreateKey(String owner, String repo, CreateKeyOption body) throws ApiException {
        ApiResponse<DeployKey> resp = this.repoCreateKeyWithHttpInfo(owner, repo, body);
        return resp.getData();
    }

    public ApiResponse<DeployKey> repoCreateKeyWithHttpInfo(String owner, String repo, CreateKeyOption body) throws ApiException {
        Call call = this.repoCreateKeyValidateBeforeCall(owner, repo, body, null, null);
        Type localVarReturnType = new TypeToken<DeployKey>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoCreateKeyAsync(String owner, String repo, CreateKeyOption body, final ApiCallback<DeployKey> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoCreateKeyValidateBeforeCall(owner, repo, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeployKey>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoCreatePullRequestCall(String owner, String repo, CreatePullRequestOption body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreatePullRequestOption localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}/pulls".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoCreatePullRequestValidateBeforeCall(String owner, String repo, CreatePullRequestOption body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoCreatePullRequest(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoCreatePullRequest(Async)");
        }
        Call call = this.repoCreatePullRequestCall(owner, repo, body, progressListener, progressRequestListener);
        return call;
    }

    public PullRequest repoCreatePullRequest(String owner, String repo, CreatePullRequestOption body) throws ApiException {
        ApiResponse<PullRequest> resp = this.repoCreatePullRequestWithHttpInfo(owner, repo, body);
        return resp.getData();
    }

    public ApiResponse<PullRequest> repoCreatePullRequestWithHttpInfo(String owner, String repo, CreatePullRequestOption body) throws ApiException {
        Call call = this.repoCreatePullRequestValidateBeforeCall(owner, repo, body, null, null);
        Type localVarReturnType = new TypeToken<PullRequest>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoCreatePullRequestAsync(String owner, String repo, CreatePullRequestOption body, final ApiCallback<PullRequest> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoCreatePullRequestValidateBeforeCall(owner, repo, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PullRequest>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoCreatePullReviewCall(String owner, String repo, Long index, CreatePullReviewOptions body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreatePullReviewOptions localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}/pulls/{index}/reviews".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoCreatePullReviewValidateBeforeCall(String owner, String repo, Long index, CreatePullReviewOptions body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoCreatePullReview(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoCreatePullReview(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling repoCreatePullReview(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling repoCreatePullReview(Async)");
        }
        Call call = this.repoCreatePullReviewCall(owner, repo, index, body, progressListener, progressRequestListener);
        return call;
    }

    public PullReview repoCreatePullReview(String owner, String repo, Long index, CreatePullReviewOptions body) throws ApiException {
        ApiResponse<PullReview> resp = this.repoCreatePullReviewWithHttpInfo(owner, repo, index, body);
        return resp.getData();
    }

    public ApiResponse<PullReview> repoCreatePullReviewWithHttpInfo(String owner, String repo, Long index, CreatePullReviewOptions body) throws ApiException {
        Call call = this.repoCreatePullReviewValidateBeforeCall(owner, repo, index, body, null, null);
        Type localVarReturnType = new TypeToken<PullReview>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoCreatePullReviewAsync(String owner, String repo, Long index, CreatePullReviewOptions body, final ApiCallback<PullReview> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoCreatePullReviewValidateBeforeCall(owner, repo, index, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PullReview>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoCreatePullReviewRequestsCall(String owner, String repo, Long index, PullReviewRequestOptions body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        PullReviewRequestOptions localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}/pulls/{index}/requested_reviewers".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoCreatePullReviewRequestsValidateBeforeCall(String owner, String repo, Long index, PullReviewRequestOptions body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoCreatePullReviewRequests(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoCreatePullReviewRequests(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling repoCreatePullReviewRequests(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling repoCreatePullReviewRequests(Async)");
        }
        Call call = this.repoCreatePullReviewRequestsCall(owner, repo, index, body, progressListener, progressRequestListener);
        return call;
    }

    public List<PullReview> repoCreatePullReviewRequests(String owner, String repo, Long index, PullReviewRequestOptions body) throws ApiException {
        ApiResponse<List<PullReview>> resp = this.repoCreatePullReviewRequestsWithHttpInfo(owner, repo, index, body);
        return resp.getData();
    }

    public ApiResponse<List<PullReview>> repoCreatePullReviewRequestsWithHttpInfo(String owner, String repo, Long index, PullReviewRequestOptions body) throws ApiException {
        Call call = this.repoCreatePullReviewRequestsValidateBeforeCall(owner, repo, index, body, null, null);
        Type localVarReturnType = new TypeToken<List<PullReview>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoCreatePullReviewRequestsAsync(String owner, String repo, Long index, PullReviewRequestOptions body, final ApiCallback<List<PullReview>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoCreatePullReviewRequestsValidateBeforeCall(owner, repo, index, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<PullReview>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoCreateReleaseCall(String owner, String repo, CreateReleaseOption body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateReleaseOption localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}/releases".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoCreateReleaseValidateBeforeCall(String owner, String repo, CreateReleaseOption body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoCreateRelease(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoCreateRelease(Async)");
        }
        Call call = this.repoCreateReleaseCall(owner, repo, body, progressListener, progressRequestListener);
        return call;
    }

    public Release repoCreateRelease(String owner, String repo, CreateReleaseOption body) throws ApiException {
        ApiResponse<Release> resp = this.repoCreateReleaseWithHttpInfo(owner, repo, body);
        return resp.getData();
    }

    public ApiResponse<Release> repoCreateReleaseWithHttpInfo(String owner, String repo, CreateReleaseOption body) throws ApiException {
        Call call = this.repoCreateReleaseValidateBeforeCall(owner, repo, body, null, null);
        Type localVarReturnType = new TypeToken<Release>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoCreateReleaseAsync(String owner, String repo, CreateReleaseOption body, final ApiCallback<Release> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoCreateReleaseValidateBeforeCall(owner, repo, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Release>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoCreateReleaseAttachmentCall(String owner, String repo, Long id, File attachment, String name, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/releases/{id}/assets".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (name != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("name", name));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (attachment != null) {
            localVarFormParams.put("attachment", attachment);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoCreateReleaseAttachmentValidateBeforeCall(String owner, String repo, Long id, File attachment, String name, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoCreateReleaseAttachment(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoCreateReleaseAttachment(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoCreateReleaseAttachment(Async)");
        }
        if (attachment == null) {
            throw new ApiException("Missing the required parameter 'attachment' when calling repoCreateReleaseAttachment(Async)");
        }
        Call call = this.repoCreateReleaseAttachmentCall(owner, repo, id, attachment, name, progressListener, progressRequestListener);
        return call;
    }

    public Attachment repoCreateReleaseAttachment(String owner, String repo, Long id, File attachment, String name) throws ApiException {
        ApiResponse<Attachment> resp = this.repoCreateReleaseAttachmentWithHttpInfo(owner, repo, id, attachment, name);
        return resp.getData();
    }

    public ApiResponse<Attachment> repoCreateReleaseAttachmentWithHttpInfo(String owner, String repo, Long id, File attachment, String name) throws ApiException {
        Call call = this.repoCreateReleaseAttachmentValidateBeforeCall(owner, repo, id, attachment, name, null, null);
        Type localVarReturnType = new TypeToken<Attachment>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoCreateReleaseAttachmentAsync(String owner, String repo, Long id, File attachment, String name, final ApiCallback<Attachment> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoCreateReleaseAttachmentValidateBeforeCall(owner, repo, id, attachment, name, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Attachment>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoCreateStatusCall(String owner, String repo, String sha, CreateStatusOption body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateStatusOption localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}/statuses/{sha}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{sha\\}", this.apiClient.escapeString(sha.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoCreateStatusValidateBeforeCall(String owner, String repo, String sha, CreateStatusOption body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoCreateStatus(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoCreateStatus(Async)");
        }
        if (sha == null) {
            throw new ApiException("Missing the required parameter 'sha' when calling repoCreateStatus(Async)");
        }
        Call call = this.repoCreateStatusCall(owner, repo, sha, body, progressListener, progressRequestListener);
        return call;
    }

    public CommitStatus repoCreateStatus(String owner, String repo, String sha, CreateStatusOption body) throws ApiException {
        ApiResponse<CommitStatus> resp = this.repoCreateStatusWithHttpInfo(owner, repo, sha, body);
        return resp.getData();
    }

    public ApiResponse<CommitStatus> repoCreateStatusWithHttpInfo(String owner, String repo, String sha, CreateStatusOption body) throws ApiException {
        Call call = this.repoCreateStatusValidateBeforeCall(owner, repo, sha, body, null, null);
        Type localVarReturnType = new TypeToken<CommitStatus>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoCreateStatusAsync(String owner, String repo, String sha, CreateStatusOption body, final ApiCallback<CommitStatus> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoCreateStatusValidateBeforeCall(owner, repo, sha, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommitStatus>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoCreateTagCall(String owner, String repo, CreateTagOption body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateTagOption localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}/tags".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoCreateTagValidateBeforeCall(String owner, String repo, CreateTagOption body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoCreateTag(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoCreateTag(Async)");
        }
        Call call = this.repoCreateTagCall(owner, repo, body, progressListener, progressRequestListener);
        return call;
    }

    public Tag repoCreateTag(String owner, String repo, CreateTagOption body) throws ApiException {
        ApiResponse<Tag> resp = this.repoCreateTagWithHttpInfo(owner, repo, body);
        return resp.getData();
    }

    public ApiResponse<Tag> repoCreateTagWithHttpInfo(String owner, String repo, CreateTagOption body) throws ApiException {
        Call call = this.repoCreateTagValidateBeforeCall(owner, repo, body, null, null);
        Type localVarReturnType = new TypeToken<Tag>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoCreateTagAsync(String owner, String repo, CreateTagOption body, final ApiCallback<Tag> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoCreateTagValidateBeforeCall(owner, repo, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Tag>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoCreateWikiPageCall(String owner, String repo, CreateWikiPageOptions body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateWikiPageOptions localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}/wiki/new".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/html"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoCreateWikiPageValidateBeforeCall(String owner, String repo, CreateWikiPageOptions body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoCreateWikiPage(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoCreateWikiPage(Async)");
        }
        Call call = this.repoCreateWikiPageCall(owner, repo, body, progressListener, progressRequestListener);
        return call;
    }

    public WikiPage repoCreateWikiPage(String owner, String repo, CreateWikiPageOptions body) throws ApiException {
        ApiResponse<WikiPage> resp = this.repoCreateWikiPageWithHttpInfo(owner, repo, body);
        return resp.getData();
    }

    public ApiResponse<WikiPage> repoCreateWikiPageWithHttpInfo(String owner, String repo, CreateWikiPageOptions body) throws ApiException {
        Call call = this.repoCreateWikiPageValidateBeforeCall(owner, repo, body, null, null);
        Type localVarReturnType = new TypeToken<WikiPage>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoCreateWikiPageAsync(String owner, String repo, CreateWikiPageOptions body, final ApiCallback<WikiPage> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoCreateWikiPageValidateBeforeCall(owner, repo, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WikiPage>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoDeleteCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoDeleteValidateBeforeCall(String owner, String repo, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoDelete(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoDelete(Async)");
        }
        Call call = this.repoDeleteCall(owner, repo, progressListener, progressRequestListener);
        return call;
    }

    public void repoDelete(String owner, String repo) throws ApiException {
        this.repoDeleteWithHttpInfo(owner, repo);
    }

    public ApiResponse<Void> repoDeleteWithHttpInfo(String owner, String repo) throws ApiException {
        Call call = this.repoDeleteValidateBeforeCall(owner, repo, null, null);
        return this.apiClient.execute(call);
    }

    public Call repoDeleteAsync(String owner, String repo, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoDeleteValidateBeforeCall(owner, repo, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call repoDeleteBranchCall(String owner, String repo, String branch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/branches/{branch}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{branch\\}", this.apiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoDeleteBranchValidateBeforeCall(String owner, String repo, String branch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoDeleteBranch(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoDeleteBranch(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling repoDeleteBranch(Async)");
        }
        Call call = this.repoDeleteBranchCall(owner, repo, branch, progressListener, progressRequestListener);
        return call;
    }

    public void repoDeleteBranch(String owner, String repo, String branch) throws ApiException {
        this.repoDeleteBranchWithHttpInfo(owner, repo, branch);
    }

    public ApiResponse<Void> repoDeleteBranchWithHttpInfo(String owner, String repo, String branch) throws ApiException {
        Call call = this.repoDeleteBranchValidateBeforeCall(owner, repo, branch, null, null);
        return this.apiClient.execute(call);
    }

    public Call repoDeleteBranchAsync(String owner, String repo, String branch, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoDeleteBranchValidateBeforeCall(owner, repo, branch, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call repoDeleteBranchProtectionCall(String owner, String repo, String name, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/branch_protections/{name}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoDeleteBranchProtectionValidateBeforeCall(String owner, String repo, String name, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoDeleteBranchProtection(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoDeleteBranchProtection(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling repoDeleteBranchProtection(Async)");
        }
        Call call = this.repoDeleteBranchProtectionCall(owner, repo, name, progressListener, progressRequestListener);
        return call;
    }

    public void repoDeleteBranchProtection(String owner, String repo, String name) throws ApiException {
        this.repoDeleteBranchProtectionWithHttpInfo(owner, repo, name);
    }

    public ApiResponse<Void> repoDeleteBranchProtectionWithHttpInfo(String owner, String repo, String name) throws ApiException {
        Call call = this.repoDeleteBranchProtectionValidateBeforeCall(owner, repo, name, null, null);
        return this.apiClient.execute(call);
    }

    public Call repoDeleteBranchProtectionAsync(String owner, String repo, String name, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoDeleteBranchProtectionValidateBeforeCall(owner, repo, name, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call repoDeleteCollaboratorCall(String owner, String repo, String collaborator, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/collaborators/{collaborator}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{collaborator\\}", this.apiClient.escapeString(collaborator.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoDeleteCollaboratorValidateBeforeCall(String owner, String repo, String collaborator, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoDeleteCollaborator(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoDeleteCollaborator(Async)");
        }
        if (collaborator == null) {
            throw new ApiException("Missing the required parameter 'collaborator' when calling repoDeleteCollaborator(Async)");
        }
        Call call = this.repoDeleteCollaboratorCall(owner, repo, collaborator, progressListener, progressRequestListener);
        return call;
    }

    public void repoDeleteCollaborator(String owner, String repo, String collaborator) throws ApiException {
        this.repoDeleteCollaboratorWithHttpInfo(owner, repo, collaborator);
    }

    public ApiResponse<Void> repoDeleteCollaboratorWithHttpInfo(String owner, String repo, String collaborator) throws ApiException {
        Call call = this.repoDeleteCollaboratorValidateBeforeCall(owner, repo, collaborator, null, null);
        return this.apiClient.execute(call);
    }

    public Call repoDeleteCollaboratorAsync(String owner, String repo, String collaborator, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoDeleteCollaboratorValidateBeforeCall(owner, repo, collaborator, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call repoDeleteFileCall(String owner, String repo, String filepath, DeleteFileOptions body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        DeleteFileOptions localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}/contents/{filepath}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{filepath\\}", this.apiClient.escapeString(filepath.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoDeleteFileValidateBeforeCall(String owner, String repo, String filepath, DeleteFileOptions body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoDeleteFile(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoDeleteFile(Async)");
        }
        if (filepath == null) {
            throw new ApiException("Missing the required parameter 'filepath' when calling repoDeleteFile(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling repoDeleteFile(Async)");
        }
        Call call = this.repoDeleteFileCall(owner, repo, filepath, body, progressListener, progressRequestListener);
        return call;
    }

    public FileDeleteResponse repoDeleteFile(String owner, String repo, String filepath, DeleteFileOptions body) throws ApiException {
        ApiResponse<FileDeleteResponse> resp = this.repoDeleteFileWithHttpInfo(owner, repo, filepath, body);
        return resp.getData();
    }

    public ApiResponse<FileDeleteResponse> repoDeleteFileWithHttpInfo(String owner, String repo, String filepath, DeleteFileOptions body) throws ApiException {
        Call call = this.repoDeleteFileValidateBeforeCall(owner, repo, filepath, body, null, null);
        Type localVarReturnType = new TypeToken<FileDeleteResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoDeleteFileAsync(String owner, String repo, String filepath, DeleteFileOptions body, final ApiCallback<FileDeleteResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoDeleteFileValidateBeforeCall(owner, repo, filepath, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FileDeleteResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoDeleteGitHookCall(String owner, String repo, String id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/hooks/git/{id}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoDeleteGitHookValidateBeforeCall(String owner, String repo, String id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoDeleteGitHook(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoDeleteGitHook(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoDeleteGitHook(Async)");
        }
        Call call = this.repoDeleteGitHookCall(owner, repo, id, progressListener, progressRequestListener);
        return call;
    }

    public void repoDeleteGitHook(String owner, String repo, String id) throws ApiException {
        this.repoDeleteGitHookWithHttpInfo(owner, repo, id);
    }

    public ApiResponse<Void> repoDeleteGitHookWithHttpInfo(String owner, String repo, String id) throws ApiException {
        Call call = this.repoDeleteGitHookValidateBeforeCall(owner, repo, id, null, null);
        return this.apiClient.execute(call);
    }

    public Call repoDeleteGitHookAsync(String owner, String repo, String id, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoDeleteGitHookValidateBeforeCall(owner, repo, id, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call repoDeleteHookCall(String owner, String repo, Long id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/hooks/{id}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoDeleteHookValidateBeforeCall(String owner, String repo, Long id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoDeleteHook(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoDeleteHook(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoDeleteHook(Async)");
        }
        Call call = this.repoDeleteHookCall(owner, repo, id, progressListener, progressRequestListener);
        return call;
    }

    public void repoDeleteHook(String owner, String repo, Long id) throws ApiException {
        this.repoDeleteHookWithHttpInfo(owner, repo, id);
    }

    public ApiResponse<Void> repoDeleteHookWithHttpInfo(String owner, String repo, Long id) throws ApiException {
        Call call = this.repoDeleteHookValidateBeforeCall(owner, repo, id, null, null);
        return this.apiClient.execute(call);
    }

    public Call repoDeleteHookAsync(String owner, String repo, Long id, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoDeleteHookValidateBeforeCall(owner, repo, id, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call repoDeleteKeyCall(String owner, String repo, Long id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/keys/{id}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/html"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoDeleteKeyValidateBeforeCall(String owner, String repo, Long id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoDeleteKey(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoDeleteKey(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoDeleteKey(Async)");
        }
        Call call = this.repoDeleteKeyCall(owner, repo, id, progressListener, progressRequestListener);
        return call;
    }

    public void repoDeleteKey(String owner, String repo, Long id) throws ApiException {
        this.repoDeleteKeyWithHttpInfo(owner, repo, id);
    }

    public ApiResponse<Void> repoDeleteKeyWithHttpInfo(String owner, String repo, Long id) throws ApiException {
        Call call = this.repoDeleteKeyValidateBeforeCall(owner, repo, id, null, null);
        return this.apiClient.execute(call);
    }

    public Call repoDeleteKeyAsync(String owner, String repo, Long id, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoDeleteKeyValidateBeforeCall(owner, repo, id, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call repoDeletePullReviewCall(String owner, String repo, Long index, Long id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/pulls/{index}/reviews/{id}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoDeletePullReviewValidateBeforeCall(String owner, String repo, Long index, Long id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoDeletePullReview(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoDeletePullReview(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling repoDeletePullReview(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoDeletePullReview(Async)");
        }
        Call call = this.repoDeletePullReviewCall(owner, repo, index, id, progressListener, progressRequestListener);
        return call;
    }

    public void repoDeletePullReview(String owner, String repo, Long index, Long id) throws ApiException {
        this.repoDeletePullReviewWithHttpInfo(owner, repo, index, id);
    }

    public ApiResponse<Void> repoDeletePullReviewWithHttpInfo(String owner, String repo, Long index, Long id) throws ApiException {
        Call call = this.repoDeletePullReviewValidateBeforeCall(owner, repo, index, id, null, null);
        return this.apiClient.execute(call);
    }

    public Call repoDeletePullReviewAsync(String owner, String repo, Long index, Long id, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoDeletePullReviewValidateBeforeCall(owner, repo, index, id, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call repoDeletePullReviewRequestsCall(String owner, String repo, Long index, PullReviewRequestOptions body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        PullReviewRequestOptions localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}/pulls/{index}/requested_reviewers".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoDeletePullReviewRequestsValidateBeforeCall(String owner, String repo, Long index, PullReviewRequestOptions body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoDeletePullReviewRequests(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoDeletePullReviewRequests(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling repoDeletePullReviewRequests(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling repoDeletePullReviewRequests(Async)");
        }
        Call call = this.repoDeletePullReviewRequestsCall(owner, repo, index, body, progressListener, progressRequestListener);
        return call;
    }

    public void repoDeletePullReviewRequests(String owner, String repo, Long index, PullReviewRequestOptions body) throws ApiException {
        this.repoDeletePullReviewRequestsWithHttpInfo(owner, repo, index, body);
    }

    public ApiResponse<Void> repoDeletePullReviewRequestsWithHttpInfo(String owner, String repo, Long index, PullReviewRequestOptions body) throws ApiException {
        Call call = this.repoDeletePullReviewRequestsValidateBeforeCall(owner, repo, index, body, null, null);
        return this.apiClient.execute(call);
    }

    public Call repoDeletePullReviewRequestsAsync(String owner, String repo, Long index, PullReviewRequestOptions body, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoDeletePullReviewRequestsValidateBeforeCall(owner, repo, index, body, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call repoDeletePushMirrorCall(String owner, String repo, String name, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/push_mirrors/{name}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoDeletePushMirrorValidateBeforeCall(String owner, String repo, String name, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoDeletePushMirror(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoDeletePushMirror(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling repoDeletePushMirror(Async)");
        }
        Call call = this.repoDeletePushMirrorCall(owner, repo, name, progressListener, progressRequestListener);
        return call;
    }

    public void repoDeletePushMirror(String owner, String repo, String name) throws ApiException {
        this.repoDeletePushMirrorWithHttpInfo(owner, repo, name);
    }

    public ApiResponse<Void> repoDeletePushMirrorWithHttpInfo(String owner, String repo, String name) throws ApiException {
        Call call = this.repoDeletePushMirrorValidateBeforeCall(owner, repo, name, null, null);
        return this.apiClient.execute(call);
    }

    public Call repoDeletePushMirrorAsync(String owner, String repo, String name, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoDeletePushMirrorValidateBeforeCall(owner, repo, name, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call repoDeleteReleaseCall(String owner, String repo, Long id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/releases/{id}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/html"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoDeleteReleaseValidateBeforeCall(String owner, String repo, Long id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoDeleteRelease(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoDeleteRelease(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoDeleteRelease(Async)");
        }
        Call call = this.repoDeleteReleaseCall(owner, repo, id, progressListener, progressRequestListener);
        return call;
    }

    public void repoDeleteRelease(String owner, String repo, Long id) throws ApiException {
        this.repoDeleteReleaseWithHttpInfo(owner, repo, id);
    }

    public ApiResponse<Void> repoDeleteReleaseWithHttpInfo(String owner, String repo, Long id) throws ApiException {
        Call call = this.repoDeleteReleaseValidateBeforeCall(owner, repo, id, null, null);
        return this.apiClient.execute(call);
    }

    public Call repoDeleteReleaseAsync(String owner, String repo, Long id, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoDeleteReleaseValidateBeforeCall(owner, repo, id, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call repoDeleteReleaseAttachmentCall(String owner, String repo, Long id, Long attachmentId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/releases/{id}/assets/{attachment_id}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString())).replaceAll("\\{attachment_id\\}", this.apiClient.escapeString(attachmentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoDeleteReleaseAttachmentValidateBeforeCall(String owner, String repo, Long id, Long attachmentId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoDeleteReleaseAttachment(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoDeleteReleaseAttachment(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoDeleteReleaseAttachment(Async)");
        }
        if (attachmentId == null) {
            throw new ApiException("Missing the required parameter 'attachmentId' when calling repoDeleteReleaseAttachment(Async)");
        }
        Call call = this.repoDeleteReleaseAttachmentCall(owner, repo, id, attachmentId, progressListener, progressRequestListener);
        return call;
    }

    public void repoDeleteReleaseAttachment(String owner, String repo, Long id, Long attachmentId) throws ApiException {
        this.repoDeleteReleaseAttachmentWithHttpInfo(owner, repo, id, attachmentId);
    }

    public ApiResponse<Void> repoDeleteReleaseAttachmentWithHttpInfo(String owner, String repo, Long id, Long attachmentId) throws ApiException {
        Call call = this.repoDeleteReleaseAttachmentValidateBeforeCall(owner, repo, id, attachmentId, null, null);
        return this.apiClient.execute(call);
    }

    public Call repoDeleteReleaseAttachmentAsync(String owner, String repo, Long id, Long attachmentId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoDeleteReleaseAttachmentValidateBeforeCall(owner, repo, id, attachmentId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call repoDeleteReleaseByTagCall(String owner, String repo, String tag, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/releases/tags/{tag}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{tag\\}", this.apiClient.escapeString(tag.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/html"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoDeleteReleaseByTagValidateBeforeCall(String owner, String repo, String tag, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoDeleteReleaseByTag(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoDeleteReleaseByTag(Async)");
        }
        if (tag == null) {
            throw new ApiException("Missing the required parameter 'tag' when calling repoDeleteReleaseByTag(Async)");
        }
        Call call = this.repoDeleteReleaseByTagCall(owner, repo, tag, progressListener, progressRequestListener);
        return call;
    }

    public void repoDeleteReleaseByTag(String owner, String repo, String tag) throws ApiException {
        this.repoDeleteReleaseByTagWithHttpInfo(owner, repo, tag);
    }

    public ApiResponse<Void> repoDeleteReleaseByTagWithHttpInfo(String owner, String repo, String tag) throws ApiException {
        Call call = this.repoDeleteReleaseByTagValidateBeforeCall(owner, repo, tag, null, null);
        return this.apiClient.execute(call);
    }

    public Call repoDeleteReleaseByTagAsync(String owner, String repo, String tag, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoDeleteReleaseByTagValidateBeforeCall(owner, repo, tag, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call repoDeleteTagCall(String owner, String repo, String tag, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/tags/{tag}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{tag\\}", this.apiClient.escapeString(tag.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoDeleteTagValidateBeforeCall(String owner, String repo, String tag, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoDeleteTag(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoDeleteTag(Async)");
        }
        if (tag == null) {
            throw new ApiException("Missing the required parameter 'tag' when calling repoDeleteTag(Async)");
        }
        Call call = this.repoDeleteTagCall(owner, repo, tag, progressListener, progressRequestListener);
        return call;
    }

    public void repoDeleteTag(String owner, String repo, String tag) throws ApiException {
        this.repoDeleteTagWithHttpInfo(owner, repo, tag);
    }

    public ApiResponse<Void> repoDeleteTagWithHttpInfo(String owner, String repo, String tag) throws ApiException {
        Call call = this.repoDeleteTagValidateBeforeCall(owner, repo, tag, null, null);
        return this.apiClient.execute(call);
    }

    public Call repoDeleteTagAsync(String owner, String repo, String tag, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoDeleteTagValidateBeforeCall(owner, repo, tag, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call repoDeleteTeamCall(String owner, String repo, String team, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/teams/{team}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{team\\}", this.apiClient.escapeString(team.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoDeleteTeamValidateBeforeCall(String owner, String repo, String team, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoDeleteTeam(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoDeleteTeam(Async)");
        }
        if (team == null) {
            throw new ApiException("Missing the required parameter 'team' when calling repoDeleteTeam(Async)");
        }
        Call call = this.repoDeleteTeamCall(owner, repo, team, progressListener, progressRequestListener);
        return call;
    }

    public void repoDeleteTeam(String owner, String repo, String team) throws ApiException {
        this.repoDeleteTeamWithHttpInfo(owner, repo, team);
    }

    public ApiResponse<Void> repoDeleteTeamWithHttpInfo(String owner, String repo, String team) throws ApiException {
        Call call = this.repoDeleteTeamValidateBeforeCall(owner, repo, team, null, null);
        return this.apiClient.execute(call);
    }

    public Call repoDeleteTeamAsync(String owner, String repo, String team, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoDeleteTeamValidateBeforeCall(owner, repo, team, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call repoDeleteTopicCall(String owner, String repo, String topic, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/topics/{topic}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{topic\\}", this.apiClient.escapeString(topic.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoDeleteTopicValidateBeforeCall(String owner, String repo, String topic, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoDeleteTopic(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoDeleteTopic(Async)");
        }
        if (topic == null) {
            throw new ApiException("Missing the required parameter 'topic' when calling repoDeleteTopic(Async)");
        }
        Call call = this.repoDeleteTopicCall(owner, repo, topic, progressListener, progressRequestListener);
        return call;
    }

    public void repoDeleteTopic(String owner, String repo, String topic) throws ApiException {
        this.repoDeleteTopicWithHttpInfo(owner, repo, topic);
    }

    public ApiResponse<Void> repoDeleteTopicWithHttpInfo(String owner, String repo, String topic) throws ApiException {
        Call call = this.repoDeleteTopicValidateBeforeCall(owner, repo, topic, null, null);
        return this.apiClient.execute(call);
    }

    public Call repoDeleteTopicAsync(String owner, String repo, String topic, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoDeleteTopicValidateBeforeCall(owner, repo, topic, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call repoDeleteWikiPageCall(String owner, String repo, String pageName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/wiki/page/{pageName}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{pageName\\}", this.apiClient.escapeString(pageName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/html"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoDeleteWikiPageValidateBeforeCall(String owner, String repo, String pageName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoDeleteWikiPage(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoDeleteWikiPage(Async)");
        }
        if (pageName == null) {
            throw new ApiException("Missing the required parameter 'pageName' when calling repoDeleteWikiPage(Async)");
        }
        Call call = this.repoDeleteWikiPageCall(owner, repo, pageName, progressListener, progressRequestListener);
        return call;
    }

    public void repoDeleteWikiPage(String owner, String repo, String pageName) throws ApiException {
        this.repoDeleteWikiPageWithHttpInfo(owner, repo, pageName);
    }

    public ApiResponse<Void> repoDeleteWikiPageWithHttpInfo(String owner, String repo, String pageName) throws ApiException {
        Call call = this.repoDeleteWikiPageValidateBeforeCall(owner, repo, pageName, null, null);
        return this.apiClient.execute(call);
    }

    public Call repoDeleteWikiPageAsync(String owner, String repo, String pageName, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoDeleteWikiPageValidateBeforeCall(owner, repo, pageName, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call repoDismissPullReviewCall(String owner, String repo, Long index, Long id, DismissPullReviewOptions body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        DismissPullReviewOptions localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}/pulls/{index}/reviews/{id}/dismissals".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoDismissPullReviewValidateBeforeCall(String owner, String repo, Long index, Long id, DismissPullReviewOptions body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoDismissPullReview(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoDismissPullReview(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling repoDismissPullReview(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoDismissPullReview(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling repoDismissPullReview(Async)");
        }
        Call call = this.repoDismissPullReviewCall(owner, repo, index, id, body, progressListener, progressRequestListener);
        return call;
    }

    public PullReview repoDismissPullReview(String owner, String repo, Long index, Long id, DismissPullReviewOptions body) throws ApiException {
        ApiResponse<PullReview> resp = this.repoDismissPullReviewWithHttpInfo(owner, repo, index, id, body);
        return resp.getData();
    }

    public ApiResponse<PullReview> repoDismissPullReviewWithHttpInfo(String owner, String repo, Long index, Long id, DismissPullReviewOptions body) throws ApiException {
        Call call = this.repoDismissPullReviewValidateBeforeCall(owner, repo, index, id, body, null, null);
        Type localVarReturnType = new TypeToken<PullReview>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoDismissPullReviewAsync(String owner, String repo, Long index, Long id, DismissPullReviewOptions body, final ApiCallback<PullReview> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoDismissPullReviewValidateBeforeCall(owner, repo, index, id, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PullReview>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoDownloadCommitDiffOrPatchCall(String owner, String repo, String sha, String diffType, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/git/commits/{sha}.{diffType}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{sha\\}", this.apiClient.escapeString(sha.toString())).replaceAll("\\{diffType\\}", this.apiClient.escapeString(diffType.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoDownloadCommitDiffOrPatchValidateBeforeCall(String owner, String repo, String sha, String diffType, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoDownloadCommitDiffOrPatch(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoDownloadCommitDiffOrPatch(Async)");
        }
        if (sha == null) {
            throw new ApiException("Missing the required parameter 'sha' when calling repoDownloadCommitDiffOrPatch(Async)");
        }
        if (diffType == null) {
            throw new ApiException("Missing the required parameter 'diffType' when calling repoDownloadCommitDiffOrPatch(Async)");
        }
        Call call = this.repoDownloadCommitDiffOrPatchCall(owner, repo, sha, diffType, progressListener, progressRequestListener);
        return call;
    }

    public String repoDownloadCommitDiffOrPatch(String owner, String repo, String sha, String diffType) throws ApiException {
        ApiResponse<String> resp = this.repoDownloadCommitDiffOrPatchWithHttpInfo(owner, repo, sha, diffType);
        return resp.getData();
    }

    public ApiResponse<String> repoDownloadCommitDiffOrPatchWithHttpInfo(String owner, String repo, String sha, String diffType) throws ApiException {
        Call call = this.repoDownloadCommitDiffOrPatchValidateBeforeCall(owner, repo, sha, diffType, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoDownloadCommitDiffOrPatchAsync(String owner, String repo, String sha, String diffType, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoDownloadCommitDiffOrPatchValidateBeforeCall(owner, repo, sha, diffType, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoDownloadPullDiffOrPatchCall(String owner, String repo, Long index, String diffType, Boolean binary, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/pulls/{index}.{diffType}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString())).replaceAll("\\{diffType\\}", this.apiClient.escapeString(diffType.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (binary != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("binary", binary));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoDownloadPullDiffOrPatchValidateBeforeCall(String owner, String repo, Long index, String diffType, Boolean binary, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoDownloadPullDiffOrPatch(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoDownloadPullDiffOrPatch(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling repoDownloadPullDiffOrPatch(Async)");
        }
        if (diffType == null) {
            throw new ApiException("Missing the required parameter 'diffType' when calling repoDownloadPullDiffOrPatch(Async)");
        }
        Call call = this.repoDownloadPullDiffOrPatchCall(owner, repo, index, diffType, binary, progressListener, progressRequestListener);
        return call;
    }

    public String repoDownloadPullDiffOrPatch(String owner, String repo, Long index, String diffType, Boolean binary) throws ApiException {
        ApiResponse<String> resp = this.repoDownloadPullDiffOrPatchWithHttpInfo(owner, repo, index, diffType, binary);
        return resp.getData();
    }

    public ApiResponse<String> repoDownloadPullDiffOrPatchWithHttpInfo(String owner, String repo, Long index, String diffType, Boolean binary) throws ApiException {
        Call call = this.repoDownloadPullDiffOrPatchValidateBeforeCall(owner, repo, index, diffType, binary, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoDownloadPullDiffOrPatchAsync(String owner, String repo, Long index, String diffType, Boolean binary, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoDownloadPullDiffOrPatchValidateBeforeCall(owner, repo, index, diffType, binary, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoEditCall(String owner, String repo, EditRepoOption body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        EditRepoOption localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoEditValidateBeforeCall(String owner, String repo, EditRepoOption body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoEdit(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoEdit(Async)");
        }
        Call call = this.repoEditCall(owner, repo, body, progressListener, progressRequestListener);
        return call;
    }

    public Repository repoEdit(String owner, String repo, EditRepoOption body) throws ApiException {
        ApiResponse<Repository> resp = this.repoEditWithHttpInfo(owner, repo, body);
        return resp.getData();
    }

    public ApiResponse<Repository> repoEditWithHttpInfo(String owner, String repo, EditRepoOption body) throws ApiException {
        Call call = this.repoEditValidateBeforeCall(owner, repo, body, null, null);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoEditAsync(String owner, String repo, EditRepoOption body, final ApiCallback<Repository> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoEditValidateBeforeCall(owner, repo, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoEditBranchProtectionCall(String owner, String repo, String name, EditBranchProtectionOption body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        EditBranchProtectionOption localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}/branch_protections/{name}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoEditBranchProtectionValidateBeforeCall(String owner, String repo, String name, EditBranchProtectionOption body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoEditBranchProtection(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoEditBranchProtection(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling repoEditBranchProtection(Async)");
        }
        Call call = this.repoEditBranchProtectionCall(owner, repo, name, body, progressListener, progressRequestListener);
        return call;
    }

    public BranchProtection repoEditBranchProtection(String owner, String repo, String name, EditBranchProtectionOption body) throws ApiException {
        ApiResponse<BranchProtection> resp = this.repoEditBranchProtectionWithHttpInfo(owner, repo, name, body);
        return resp.getData();
    }

    public ApiResponse<BranchProtection> repoEditBranchProtectionWithHttpInfo(String owner, String repo, String name, EditBranchProtectionOption body) throws ApiException {
        Call call = this.repoEditBranchProtectionValidateBeforeCall(owner, repo, name, body, null, null);
        Type localVarReturnType = new TypeToken<BranchProtection>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoEditBranchProtectionAsync(String owner, String repo, String name, EditBranchProtectionOption body, final ApiCallback<BranchProtection> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoEditBranchProtectionValidateBeforeCall(owner, repo, name, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<BranchProtection>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoEditGitHookCall(String owner, String repo, String id, EditGitHookOption body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        EditGitHookOption localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}/hooks/git/{id}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoEditGitHookValidateBeforeCall(String owner, String repo, String id, EditGitHookOption body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoEditGitHook(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoEditGitHook(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoEditGitHook(Async)");
        }
        Call call = this.repoEditGitHookCall(owner, repo, id, body, progressListener, progressRequestListener);
        return call;
    }

    public GitHook repoEditGitHook(String owner, String repo, String id, EditGitHookOption body) throws ApiException {
        ApiResponse<GitHook> resp = this.repoEditGitHookWithHttpInfo(owner, repo, id, body);
        return resp.getData();
    }

    public ApiResponse<GitHook> repoEditGitHookWithHttpInfo(String owner, String repo, String id, EditGitHookOption body) throws ApiException {
        Call call = this.repoEditGitHookValidateBeforeCall(owner, repo, id, body, null, null);
        Type localVarReturnType = new TypeToken<GitHook>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoEditGitHookAsync(String owner, String repo, String id, EditGitHookOption body, final ApiCallback<GitHook> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoEditGitHookValidateBeforeCall(owner, repo, id, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GitHook>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoEditHookCall(String owner, String repo, Long id, EditHookOption body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        EditHookOption localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}/hooks/{id}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoEditHookValidateBeforeCall(String owner, String repo, Long id, EditHookOption body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoEditHook(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoEditHook(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoEditHook(Async)");
        }
        Call call = this.repoEditHookCall(owner, repo, id, body, progressListener, progressRequestListener);
        return call;
    }

    public Hook repoEditHook(String owner, String repo, Long id, EditHookOption body) throws ApiException {
        ApiResponse<Hook> resp = this.repoEditHookWithHttpInfo(owner, repo, id, body);
        return resp.getData();
    }

    public ApiResponse<Hook> repoEditHookWithHttpInfo(String owner, String repo, Long id, EditHookOption body) throws ApiException {
        Call call = this.repoEditHookValidateBeforeCall(owner, repo, id, body, null, null);
        Type localVarReturnType = new TypeToken<Hook>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoEditHookAsync(String owner, String repo, Long id, EditHookOption body, final ApiCallback<Hook> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoEditHookValidateBeforeCall(owner, repo, id, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Hook>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoEditPullRequestCall(String owner, String repo, Long index, EditPullRequestOption body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        EditPullRequestOption localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}/pulls/{index}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoEditPullRequestValidateBeforeCall(String owner, String repo, Long index, EditPullRequestOption body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoEditPullRequest(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoEditPullRequest(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling repoEditPullRequest(Async)");
        }
        Call call = this.repoEditPullRequestCall(owner, repo, index, body, progressListener, progressRequestListener);
        return call;
    }

    public PullRequest repoEditPullRequest(String owner, String repo, Long index, EditPullRequestOption body) throws ApiException {
        ApiResponse<PullRequest> resp = this.repoEditPullRequestWithHttpInfo(owner, repo, index, body);
        return resp.getData();
    }

    public ApiResponse<PullRequest> repoEditPullRequestWithHttpInfo(String owner, String repo, Long index, EditPullRequestOption body) throws ApiException {
        Call call = this.repoEditPullRequestValidateBeforeCall(owner, repo, index, body, null, null);
        Type localVarReturnType = new TypeToken<PullRequest>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoEditPullRequestAsync(String owner, String repo, Long index, EditPullRequestOption body, final ApiCallback<PullRequest> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoEditPullRequestValidateBeforeCall(owner, repo, index, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PullRequest>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoEditReleaseCall(String owner, String repo, Long id, EditReleaseOption body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        EditReleaseOption localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}/releases/{id}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoEditReleaseValidateBeforeCall(String owner, String repo, Long id, EditReleaseOption body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoEditRelease(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoEditRelease(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoEditRelease(Async)");
        }
        Call call = this.repoEditReleaseCall(owner, repo, id, body, progressListener, progressRequestListener);
        return call;
    }

    public Release repoEditRelease(String owner, String repo, Long id, EditReleaseOption body) throws ApiException {
        ApiResponse<Release> resp = this.repoEditReleaseWithHttpInfo(owner, repo, id, body);
        return resp.getData();
    }

    public ApiResponse<Release> repoEditReleaseWithHttpInfo(String owner, String repo, Long id, EditReleaseOption body) throws ApiException {
        Call call = this.repoEditReleaseValidateBeforeCall(owner, repo, id, body, null, null);
        Type localVarReturnType = new TypeToken<Release>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoEditReleaseAsync(String owner, String repo, Long id, EditReleaseOption body, final ApiCallback<Release> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoEditReleaseValidateBeforeCall(owner, repo, id, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Release>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoEditReleaseAttachmentCall(String owner, String repo, Long id, Long attachmentId, EditAttachmentOptions body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        EditAttachmentOptions localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}/releases/{id}/assets/{attachment_id}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString())).replaceAll("\\{attachment_id\\}", this.apiClient.escapeString(attachmentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoEditReleaseAttachmentValidateBeforeCall(String owner, String repo, Long id, Long attachmentId, EditAttachmentOptions body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoEditReleaseAttachment(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoEditReleaseAttachment(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoEditReleaseAttachment(Async)");
        }
        if (attachmentId == null) {
            throw new ApiException("Missing the required parameter 'attachmentId' when calling repoEditReleaseAttachment(Async)");
        }
        Call call = this.repoEditReleaseAttachmentCall(owner, repo, id, attachmentId, body, progressListener, progressRequestListener);
        return call;
    }

    public Attachment repoEditReleaseAttachment(String owner, String repo, Long id, Long attachmentId, EditAttachmentOptions body) throws ApiException {
        ApiResponse<Attachment> resp = this.repoEditReleaseAttachmentWithHttpInfo(owner, repo, id, attachmentId, body);
        return resp.getData();
    }

    public ApiResponse<Attachment> repoEditReleaseAttachmentWithHttpInfo(String owner, String repo, Long id, Long attachmentId, EditAttachmentOptions body) throws ApiException {
        Call call = this.repoEditReleaseAttachmentValidateBeforeCall(owner, repo, id, attachmentId, body, null, null);
        Type localVarReturnType = new TypeToken<Attachment>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoEditReleaseAttachmentAsync(String owner, String repo, Long id, Long attachmentId, EditAttachmentOptions body, final ApiCallback<Attachment> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoEditReleaseAttachmentValidateBeforeCall(owner, repo, id, attachmentId, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Attachment>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoEditWikiPageCall(String owner, String repo, String pageName, CreateWikiPageOptions body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateWikiPageOptions localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}/wiki/page/{pageName}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{pageName\\}", this.apiClient.escapeString(pageName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/html"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoEditWikiPageValidateBeforeCall(String owner, String repo, String pageName, CreateWikiPageOptions body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoEditWikiPage(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoEditWikiPage(Async)");
        }
        if (pageName == null) {
            throw new ApiException("Missing the required parameter 'pageName' when calling repoEditWikiPage(Async)");
        }
        Call call = this.repoEditWikiPageCall(owner, repo, pageName, body, progressListener, progressRequestListener);
        return call;
    }

    public WikiPage repoEditWikiPage(String owner, String repo, String pageName, CreateWikiPageOptions body) throws ApiException {
        ApiResponse<WikiPage> resp = this.repoEditWikiPageWithHttpInfo(owner, repo, pageName, body);
        return resp.getData();
    }

    public ApiResponse<WikiPage> repoEditWikiPageWithHttpInfo(String owner, String repo, String pageName, CreateWikiPageOptions body) throws ApiException {
        Call call = this.repoEditWikiPageValidateBeforeCall(owner, repo, pageName, body, null, null);
        Type localVarReturnType = new TypeToken<WikiPage>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoEditWikiPageAsync(String owner, String repo, String pageName, CreateWikiPageOptions body, final ApiCallback<WikiPage> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoEditWikiPageValidateBeforeCall(owner, repo, pageName, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WikiPage>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoGetCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoGetValidateBeforeCall(String owner, String repo, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGet(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGet(Async)");
        }
        Call call = this.repoGetCall(owner, repo, progressListener, progressRequestListener);
        return call;
    }

    public Repository repoGet(String owner, String repo) throws ApiException {
        ApiResponse<Repository> resp = this.repoGetWithHttpInfo(owner, repo);
        return resp.getData();
    }

    public ApiResponse<Repository> repoGetWithHttpInfo(String owner, String repo) throws ApiException {
        Call call = this.repoGetValidateBeforeCall(owner, repo, null, null);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoGetAsync(String owner, String repo, final ApiCallback<Repository> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoGetValidateBeforeCall(owner, repo, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoGetAllCommitsCall(String owner, String repo, String sha, String path, Boolean stat, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/commits".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (sha != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sha", sha));
        }
        if (path != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("path", path));
        }
        if (stat != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("stat", stat));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoGetAllCommitsValidateBeforeCall(String owner, String repo, String sha, String path, Boolean stat, Integer page, Integer limit, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetAllCommits(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetAllCommits(Async)");
        }
        Call call = this.repoGetAllCommitsCall(owner, repo, sha, path, stat, page, limit, progressListener, progressRequestListener);
        return call;
    }

    public List<Commit> repoGetAllCommits(String owner, String repo, String sha, String path, Boolean stat, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<Commit>> resp = this.repoGetAllCommitsWithHttpInfo(owner, repo, sha, path, stat, page, limit);
        return resp.getData();
    }

    public ApiResponse<List<Commit>> repoGetAllCommitsWithHttpInfo(String owner, String repo, String sha, String path, Boolean stat, Integer page, Integer limit) throws ApiException {
        Call call = this.repoGetAllCommitsValidateBeforeCall(owner, repo, sha, path, stat, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<Commit>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoGetAllCommitsAsync(String owner, String repo, String sha, String path, Boolean stat, Integer page, Integer limit, final ApiCallback<List<Commit>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoGetAllCommitsValidateBeforeCall(owner, repo, sha, path, stat, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Commit>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoGetArchiveCall(String owner, String repo, String archive, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/archive/{archive}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{archive\\}", this.apiClient.escapeString(archive.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoGetArchiveValidateBeforeCall(String owner, String repo, String archive, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetArchive(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetArchive(Async)");
        }
        if (archive == null) {
            throw new ApiException("Missing the required parameter 'archive' when calling repoGetArchive(Async)");
        }
        Call call = this.repoGetArchiveCall(owner, repo, archive, progressListener, progressRequestListener);
        return call;
    }

    public void repoGetArchive(String owner, String repo, String archive) throws ApiException {
        this.repoGetArchiveWithHttpInfo(owner, repo, archive);
    }

    public ApiResponse<Void> repoGetArchiveWithHttpInfo(String owner, String repo, String archive) throws ApiException {
        Call call = this.repoGetArchiveValidateBeforeCall(owner, repo, archive, null, null);
        return this.apiClient.execute(call);
    }

    public Call repoGetArchiveAsync(String owner, String repo, String archive, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoGetArchiveValidateBeforeCall(owner, repo, archive, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call repoGetAssigneesCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/assignees".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoGetAssigneesValidateBeforeCall(String owner, String repo, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetAssignees(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetAssignees(Async)");
        }
        Call call = this.repoGetAssigneesCall(owner, repo, progressListener, progressRequestListener);
        return call;
    }

    public List<User> repoGetAssignees(String owner, String repo) throws ApiException {
        ApiResponse<List<User>> resp = this.repoGetAssigneesWithHttpInfo(owner, repo);
        return resp.getData();
    }

    public ApiResponse<List<User>> repoGetAssigneesWithHttpInfo(String owner, String repo) throws ApiException {
        Call call = this.repoGetAssigneesValidateBeforeCall(owner, repo, null, null);
        Type localVarReturnType = new TypeToken<List<User>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoGetAssigneesAsync(String owner, String repo, final ApiCallback<List<User>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoGetAssigneesValidateBeforeCall(owner, repo, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<User>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoGetBranchCall(String owner, String repo, String branch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/branches/{branch}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{branch\\}", this.apiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoGetBranchValidateBeforeCall(String owner, String repo, String branch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetBranch(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetBranch(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling repoGetBranch(Async)");
        }
        Call call = this.repoGetBranchCall(owner, repo, branch, progressListener, progressRequestListener);
        return call;
    }

    public Branch repoGetBranch(String owner, String repo, String branch) throws ApiException {
        ApiResponse<Branch> resp = this.repoGetBranchWithHttpInfo(owner, repo, branch);
        return resp.getData();
    }

    public ApiResponse<Branch> repoGetBranchWithHttpInfo(String owner, String repo, String branch) throws ApiException {
        Call call = this.repoGetBranchValidateBeforeCall(owner, repo, branch, null, null);
        Type localVarReturnType = new TypeToken<Branch>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoGetBranchAsync(String owner, String repo, String branch, final ApiCallback<Branch> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoGetBranchValidateBeforeCall(owner, repo, branch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Branch>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoGetBranchProtectionCall(String owner, String repo, String name, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/branch_protections/{name}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoGetBranchProtectionValidateBeforeCall(String owner, String repo, String name, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetBranchProtection(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetBranchProtection(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling repoGetBranchProtection(Async)");
        }
        Call call = this.repoGetBranchProtectionCall(owner, repo, name, progressListener, progressRequestListener);
        return call;
    }

    public BranchProtection repoGetBranchProtection(String owner, String repo, String name) throws ApiException {
        ApiResponse<BranchProtection> resp = this.repoGetBranchProtectionWithHttpInfo(owner, repo, name);
        return resp.getData();
    }

    public ApiResponse<BranchProtection> repoGetBranchProtectionWithHttpInfo(String owner, String repo, String name) throws ApiException {
        Call call = this.repoGetBranchProtectionValidateBeforeCall(owner, repo, name, null, null);
        Type localVarReturnType = new TypeToken<BranchProtection>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoGetBranchProtectionAsync(String owner, String repo, String name, final ApiCallback<BranchProtection> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoGetBranchProtectionValidateBeforeCall(owner, repo, name, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<BranchProtection>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoGetByIDCall(Long id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoGetByIDValidateBeforeCall(Long id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoGetByID(Async)");
        }
        Call call = this.repoGetByIDCall(id, progressListener, progressRequestListener);
        return call;
    }

    public Repository repoGetByID(Long id) throws ApiException {
        ApiResponse<Repository> resp = this.repoGetByIDWithHttpInfo(id);
        return resp.getData();
    }

    public ApiResponse<Repository> repoGetByIDWithHttpInfo(Long id) throws ApiException {
        Call call = this.repoGetByIDValidateBeforeCall(id, null, null);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoGetByIDAsync(Long id, final ApiCallback<Repository> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoGetByIDValidateBeforeCall(id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoGetCombinedStatusByRefCall(String owner, String repo, String ref, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/commits/{ref}/status".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{ref\\}", this.apiClient.escapeString(ref.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoGetCombinedStatusByRefValidateBeforeCall(String owner, String repo, String ref, Integer page, Integer limit, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetCombinedStatusByRef(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetCombinedStatusByRef(Async)");
        }
        if (ref == null) {
            throw new ApiException("Missing the required parameter 'ref' when calling repoGetCombinedStatusByRef(Async)");
        }
        Call call = this.repoGetCombinedStatusByRefCall(owner, repo, ref, page, limit, progressListener, progressRequestListener);
        return call;
    }

    public CombinedStatus repoGetCombinedStatusByRef(String owner, String repo, String ref, Integer page, Integer limit) throws ApiException {
        ApiResponse<CombinedStatus> resp = this.repoGetCombinedStatusByRefWithHttpInfo(owner, repo, ref, page, limit);
        return resp.getData();
    }

    public ApiResponse<CombinedStatus> repoGetCombinedStatusByRefWithHttpInfo(String owner, String repo, String ref, Integer page, Integer limit) throws ApiException {
        Call call = this.repoGetCombinedStatusByRefValidateBeforeCall(owner, repo, ref, page, limit, null, null);
        Type localVarReturnType = new TypeToken<CombinedStatus>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoGetCombinedStatusByRefAsync(String owner, String repo, String ref, Integer page, Integer limit, final ApiCallback<CombinedStatus> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoGetCombinedStatusByRefValidateBeforeCall(owner, repo, ref, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CombinedStatus>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoGetContentsCall(String owner, String repo, String filepath, String ref, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/contents/{filepath}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{filepath\\}", this.apiClient.escapeString(filepath.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (ref != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("ref", ref));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoGetContentsValidateBeforeCall(String owner, String repo, String filepath, String ref, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetContents(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetContents(Async)");
        }
        if (filepath == null) {
            throw new ApiException("Missing the required parameter 'filepath' when calling repoGetContents(Async)");
        }
        Call call = this.repoGetContentsCall(owner, repo, filepath, ref, progressListener, progressRequestListener);
        return call;
    }

    public ContentsResponse repoGetContents(String owner, String repo, String filepath, String ref) throws ApiException {
        ApiResponse<ContentsResponse> resp = this.repoGetContentsWithHttpInfo(owner, repo, filepath, ref);
        return resp.getData();
    }

    public ApiResponse<ContentsResponse> repoGetContentsWithHttpInfo(String owner, String repo, String filepath, String ref) throws ApiException {
        Call call = this.repoGetContentsValidateBeforeCall(owner, repo, filepath, ref, null, null);
        Type localVarReturnType = new TypeToken<ContentsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoGetContentsAsync(String owner, String repo, String filepath, String ref, final ApiCallback<ContentsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoGetContentsValidateBeforeCall(owner, repo, filepath, ref, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ContentsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoGetContentsListCall(String owner, String repo, String ref, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/contents".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (ref != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("ref", ref));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoGetContentsListValidateBeforeCall(String owner, String repo, String ref, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetContentsList(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetContentsList(Async)");
        }
        Call call = this.repoGetContentsListCall(owner, repo, ref, progressListener, progressRequestListener);
        return call;
    }

    public List<ContentsResponse> repoGetContentsList(String owner, String repo, String ref) throws ApiException {
        ApiResponse<List<ContentsResponse>> resp = this.repoGetContentsListWithHttpInfo(owner, repo, ref);
        return resp.getData();
    }

    public ApiResponse<List<ContentsResponse>> repoGetContentsListWithHttpInfo(String owner, String repo, String ref) throws ApiException {
        Call call = this.repoGetContentsListValidateBeforeCall(owner, repo, ref, null, null);
        Type localVarReturnType = new TypeToken<List<ContentsResponse>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoGetContentsListAsync(String owner, String repo, String ref, final ApiCallback<List<ContentsResponse>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoGetContentsListValidateBeforeCall(owner, repo, ref, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<ContentsResponse>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoGetEditorConfigCall(String owner, String repo, String filepath, String ref, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/editorconfig/{filepath}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{filepath\\}", this.apiClient.escapeString(filepath.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (ref != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("ref", ref));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoGetEditorConfigValidateBeforeCall(String owner, String repo, String filepath, String ref, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetEditorConfig(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetEditorConfig(Async)");
        }
        if (filepath == null) {
            throw new ApiException("Missing the required parameter 'filepath' when calling repoGetEditorConfig(Async)");
        }
        Call call = this.repoGetEditorConfigCall(owner, repo, filepath, ref, progressListener, progressRequestListener);
        return call;
    }

    public void repoGetEditorConfig(String owner, String repo, String filepath, String ref) throws ApiException {
        this.repoGetEditorConfigWithHttpInfo(owner, repo, filepath, ref);
    }

    public ApiResponse<Void> repoGetEditorConfigWithHttpInfo(String owner, String repo, String filepath, String ref) throws ApiException {
        Call call = this.repoGetEditorConfigValidateBeforeCall(owner, repo, filepath, ref, null, null);
        return this.apiClient.execute(call);
    }

    public Call repoGetEditorConfigAsync(String owner, String repo, String filepath, String ref, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoGetEditorConfigValidateBeforeCall(owner, repo, filepath, ref, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call repoGetGitHookCall(String owner, String repo, String id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/hooks/git/{id}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoGetGitHookValidateBeforeCall(String owner, String repo, String id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetGitHook(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetGitHook(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoGetGitHook(Async)");
        }
        Call call = this.repoGetGitHookCall(owner, repo, id, progressListener, progressRequestListener);
        return call;
    }

    public GitHook repoGetGitHook(String owner, String repo, String id) throws ApiException {
        ApiResponse<GitHook> resp = this.repoGetGitHookWithHttpInfo(owner, repo, id);
        return resp.getData();
    }

    public ApiResponse<GitHook> repoGetGitHookWithHttpInfo(String owner, String repo, String id) throws ApiException {
        Call call = this.repoGetGitHookValidateBeforeCall(owner, repo, id, null, null);
        Type localVarReturnType = new TypeToken<GitHook>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoGetGitHookAsync(String owner, String repo, String id, final ApiCallback<GitHook> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoGetGitHookValidateBeforeCall(owner, repo, id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GitHook>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoGetHookCall(String owner, String repo, Long id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/hooks/{id}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoGetHookValidateBeforeCall(String owner, String repo, Long id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetHook(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetHook(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoGetHook(Async)");
        }
        Call call = this.repoGetHookCall(owner, repo, id, progressListener, progressRequestListener);
        return call;
    }

    public Hook repoGetHook(String owner, String repo, Long id) throws ApiException {
        ApiResponse<Hook> resp = this.repoGetHookWithHttpInfo(owner, repo, id);
        return resp.getData();
    }

    public ApiResponse<Hook> repoGetHookWithHttpInfo(String owner, String repo, Long id) throws ApiException {
        Call call = this.repoGetHookValidateBeforeCall(owner, repo, id, null, null);
        Type localVarReturnType = new TypeToken<Hook>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoGetHookAsync(String owner, String repo, Long id, final ApiCallback<Hook> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoGetHookValidateBeforeCall(owner, repo, id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Hook>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoGetIssueTemplatesCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/issue_templates".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoGetIssueTemplatesValidateBeforeCall(String owner, String repo, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetIssueTemplates(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetIssueTemplates(Async)");
        }
        Call call = this.repoGetIssueTemplatesCall(owner, repo, progressListener, progressRequestListener);
        return call;
    }

    public List<IssueTemplate> repoGetIssueTemplates(String owner, String repo) throws ApiException {
        ApiResponse<List<IssueTemplate>> resp = this.repoGetIssueTemplatesWithHttpInfo(owner, repo);
        return resp.getData();
    }

    public ApiResponse<List<IssueTemplate>> repoGetIssueTemplatesWithHttpInfo(String owner, String repo) throws ApiException {
        Call call = this.repoGetIssueTemplatesValidateBeforeCall(owner, repo, null, null);
        Type localVarReturnType = new TypeToken<List<IssueTemplate>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoGetIssueTemplatesAsync(String owner, String repo, final ApiCallback<List<IssueTemplate>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoGetIssueTemplatesValidateBeforeCall(owner, repo, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<IssueTemplate>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoGetKeyCall(String owner, String repo, Long id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/keys/{id}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoGetKeyValidateBeforeCall(String owner, String repo, Long id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetKey(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetKey(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoGetKey(Async)");
        }
        Call call = this.repoGetKeyCall(owner, repo, id, progressListener, progressRequestListener);
        return call;
    }

    public DeployKey repoGetKey(String owner, String repo, Long id) throws ApiException {
        ApiResponse<DeployKey> resp = this.repoGetKeyWithHttpInfo(owner, repo, id);
        return resp.getData();
    }

    public ApiResponse<DeployKey> repoGetKeyWithHttpInfo(String owner, String repo, Long id) throws ApiException {
        Call call = this.repoGetKeyValidateBeforeCall(owner, repo, id, null, null);
        Type localVarReturnType = new TypeToken<DeployKey>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoGetKeyAsync(String owner, String repo, Long id, final ApiCallback<DeployKey> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoGetKeyValidateBeforeCall(owner, repo, id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeployKey>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoGetLanguagesCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/languages".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoGetLanguagesValidateBeforeCall(String owner, String repo, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetLanguages(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetLanguages(Async)");
        }
        Call call = this.repoGetLanguagesCall(owner, repo, progressListener, progressRequestListener);
        return call;
    }

    public Map<String, Long> repoGetLanguages(String owner, String repo) throws ApiException {
        ApiResponse<Map<String, Long>> resp = this.repoGetLanguagesWithHttpInfo(owner, repo);
        return resp.getData();
    }

    public ApiResponse<Map<String, Long>> repoGetLanguagesWithHttpInfo(String owner, String repo) throws ApiException {
        Call call = this.repoGetLanguagesValidateBeforeCall(owner, repo, null, null);
        Type localVarReturnType = new TypeToken<Map<String, Long>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoGetLanguagesAsync(String owner, String repo, final ApiCallback<Map<String, Long>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoGetLanguagesValidateBeforeCall(owner, repo, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Map<String, Long>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoGetNoteCall(String owner, String repo, String sha, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/git/notes/{sha}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{sha\\}", this.apiClient.escapeString(sha.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoGetNoteValidateBeforeCall(String owner, String repo, String sha, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetNote(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetNote(Async)");
        }
        if (sha == null) {
            throw new ApiException("Missing the required parameter 'sha' when calling repoGetNote(Async)");
        }
        Call call = this.repoGetNoteCall(owner, repo, sha, progressListener, progressRequestListener);
        return call;
    }

    public Note repoGetNote(String owner, String repo, String sha) throws ApiException {
        ApiResponse<Note> resp = this.repoGetNoteWithHttpInfo(owner, repo, sha);
        return resp.getData();
    }

    public ApiResponse<Note> repoGetNoteWithHttpInfo(String owner, String repo, String sha) throws ApiException {
        Call call = this.repoGetNoteValidateBeforeCall(owner, repo, sha, null, null);
        Type localVarReturnType = new TypeToken<Note>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoGetNoteAsync(String owner, String repo, String sha, final ApiCallback<Note> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoGetNoteValidateBeforeCall(owner, repo, sha, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Note>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoGetPullRequestCall(String owner, String repo, Long index, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/pulls/{index}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoGetPullRequestValidateBeforeCall(String owner, String repo, Long index, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetPullRequest(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetPullRequest(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling repoGetPullRequest(Async)");
        }
        Call call = this.repoGetPullRequestCall(owner, repo, index, progressListener, progressRequestListener);
        return call;
    }

    public PullRequest repoGetPullRequest(String owner, String repo, Long index) throws ApiException {
        ApiResponse<PullRequest> resp = this.repoGetPullRequestWithHttpInfo(owner, repo, index);
        return resp.getData();
    }

    public ApiResponse<PullRequest> repoGetPullRequestWithHttpInfo(String owner, String repo, Long index) throws ApiException {
        Call call = this.repoGetPullRequestValidateBeforeCall(owner, repo, index, null, null);
        Type localVarReturnType = new TypeToken<PullRequest>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoGetPullRequestAsync(String owner, String repo, Long index, final ApiCallback<PullRequest> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoGetPullRequestValidateBeforeCall(owner, repo, index, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PullRequest>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoGetPullRequestCommitsCall(String owner, String repo, Long index, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/pulls/{index}/commits".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoGetPullRequestCommitsValidateBeforeCall(String owner, String repo, Long index, Integer page, Integer limit, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetPullRequestCommits(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetPullRequestCommits(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling repoGetPullRequestCommits(Async)");
        }
        Call call = this.repoGetPullRequestCommitsCall(owner, repo, index, page, limit, progressListener, progressRequestListener);
        return call;
    }

    public List<Commit> repoGetPullRequestCommits(String owner, String repo, Long index, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<Commit>> resp = this.repoGetPullRequestCommitsWithHttpInfo(owner, repo, index, page, limit);
        return resp.getData();
    }

    public ApiResponse<List<Commit>> repoGetPullRequestCommitsWithHttpInfo(String owner, String repo, Long index, Integer page, Integer limit) throws ApiException {
        Call call = this.repoGetPullRequestCommitsValidateBeforeCall(owner, repo, index, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<Commit>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoGetPullRequestCommitsAsync(String owner, String repo, Long index, Integer page, Integer limit, final ApiCallback<List<Commit>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoGetPullRequestCommitsValidateBeforeCall(owner, repo, index, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Commit>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoGetPullRequestFilesCall(String owner, String repo, Long index, String skipTo, String whitespace, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/pulls/{index}/files".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (skipTo != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("skip-to", skipTo));
        }
        if (whitespace != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("whitespace", whitespace));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoGetPullRequestFilesValidateBeforeCall(String owner, String repo, Long index, String skipTo, String whitespace, Integer page, Integer limit, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetPullRequestFiles(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetPullRequestFiles(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling repoGetPullRequestFiles(Async)");
        }
        Call call = this.repoGetPullRequestFilesCall(owner, repo, index, skipTo, whitespace, page, limit, progressListener, progressRequestListener);
        return call;
    }

    public List<ChangedFile> repoGetPullRequestFiles(String owner, String repo, Long index, String skipTo, String whitespace, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<ChangedFile>> resp = this.repoGetPullRequestFilesWithHttpInfo(owner, repo, index, skipTo, whitespace, page, limit);
        return resp.getData();
    }

    public ApiResponse<List<ChangedFile>> repoGetPullRequestFilesWithHttpInfo(String owner, String repo, Long index, String skipTo, String whitespace, Integer page, Integer limit) throws ApiException {
        Call call = this.repoGetPullRequestFilesValidateBeforeCall(owner, repo, index, skipTo, whitespace, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<ChangedFile>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoGetPullRequestFilesAsync(String owner, String repo, Long index, String skipTo, String whitespace, Integer page, Integer limit, final ApiCallback<List<ChangedFile>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoGetPullRequestFilesValidateBeforeCall(owner, repo, index, skipTo, whitespace, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<ChangedFile>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoGetPullReviewCall(String owner, String repo, Long index, Long id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/pulls/{index}/reviews/{id}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoGetPullReviewValidateBeforeCall(String owner, String repo, Long index, Long id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetPullReview(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetPullReview(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling repoGetPullReview(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoGetPullReview(Async)");
        }
        Call call = this.repoGetPullReviewCall(owner, repo, index, id, progressListener, progressRequestListener);
        return call;
    }

    public PullReview repoGetPullReview(String owner, String repo, Long index, Long id) throws ApiException {
        ApiResponse<PullReview> resp = this.repoGetPullReviewWithHttpInfo(owner, repo, index, id);
        return resp.getData();
    }

    public ApiResponse<PullReview> repoGetPullReviewWithHttpInfo(String owner, String repo, Long index, Long id) throws ApiException {
        Call call = this.repoGetPullReviewValidateBeforeCall(owner, repo, index, id, null, null);
        Type localVarReturnType = new TypeToken<PullReview>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoGetPullReviewAsync(String owner, String repo, Long index, Long id, final ApiCallback<PullReview> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoGetPullReviewValidateBeforeCall(owner, repo, index, id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PullReview>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoGetPullReviewCommentsCall(String owner, String repo, Long index, Long id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/pulls/{index}/reviews/{id}/comments".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoGetPullReviewCommentsValidateBeforeCall(String owner, String repo, Long index, Long id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetPullReviewComments(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetPullReviewComments(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling repoGetPullReviewComments(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoGetPullReviewComments(Async)");
        }
        Call call = this.repoGetPullReviewCommentsCall(owner, repo, index, id, progressListener, progressRequestListener);
        return call;
    }

    public List<PullReviewComment> repoGetPullReviewComments(String owner, String repo, Long index, Long id) throws ApiException {
        ApiResponse<List<PullReviewComment>> resp = this.repoGetPullReviewCommentsWithHttpInfo(owner, repo, index, id);
        return resp.getData();
    }

    public ApiResponse<List<PullReviewComment>> repoGetPullReviewCommentsWithHttpInfo(String owner, String repo, Long index, Long id) throws ApiException {
        Call call = this.repoGetPullReviewCommentsValidateBeforeCall(owner, repo, index, id, null, null);
        Type localVarReturnType = new TypeToken<List<PullReviewComment>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoGetPullReviewCommentsAsync(String owner, String repo, Long index, Long id, final ApiCallback<List<PullReviewComment>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoGetPullReviewCommentsValidateBeforeCall(owner, repo, index, id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<PullReviewComment>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoGetPushMirrorByRemoteNameCall(String owner, String repo, String name, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/push_mirrors/{name}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoGetPushMirrorByRemoteNameValidateBeforeCall(String owner, String repo, String name, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetPushMirrorByRemoteName(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetPushMirrorByRemoteName(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling repoGetPushMirrorByRemoteName(Async)");
        }
        Call call = this.repoGetPushMirrorByRemoteNameCall(owner, repo, name, progressListener, progressRequestListener);
        return call;
    }

    public PushMirror repoGetPushMirrorByRemoteName(String owner, String repo, String name) throws ApiException {
        ApiResponse<PushMirror> resp = this.repoGetPushMirrorByRemoteNameWithHttpInfo(owner, repo, name);
        return resp.getData();
    }

    public ApiResponse<PushMirror> repoGetPushMirrorByRemoteNameWithHttpInfo(String owner, String repo, String name) throws ApiException {
        Call call = this.repoGetPushMirrorByRemoteNameValidateBeforeCall(owner, repo, name, null, null);
        Type localVarReturnType = new TypeToken<PushMirror>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoGetPushMirrorByRemoteNameAsync(String owner, String repo, String name, final ApiCallback<PushMirror> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoGetPushMirrorByRemoteNameValidateBeforeCall(owner, repo, name, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PushMirror>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoGetRawFileCall(String owner, String repo, String filepath, String ref, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/raw/{filepath}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{filepath\\}", this.apiClient.escapeString(filepath.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (ref != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("ref", ref));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoGetRawFileValidateBeforeCall(String owner, String repo, String filepath, String ref, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetRawFile(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetRawFile(Async)");
        }
        if (filepath == null) {
            throw new ApiException("Missing the required parameter 'filepath' when calling repoGetRawFile(Async)");
        }
        Call call = this.repoGetRawFileCall(owner, repo, filepath, ref, progressListener, progressRequestListener);
        return call;
    }

    public void repoGetRawFile(String owner, String repo, String filepath, String ref) throws ApiException {
        this.repoGetRawFileWithHttpInfo(owner, repo, filepath, ref);
    }

    public ApiResponse<Void> repoGetRawFileWithHttpInfo(String owner, String repo, String filepath, String ref) throws ApiException {
        Call call = this.repoGetRawFileValidateBeforeCall(owner, repo, filepath, ref, null, null);
        return this.apiClient.execute(call);
    }

    public Call repoGetRawFileAsync(String owner, String repo, String filepath, String ref, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoGetRawFileValidateBeforeCall(owner, repo, filepath, ref, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call repoGetRawFileOrLFSCall(String owner, String repo, String filepath, String ref, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/media/{filepath}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{filepath\\}", this.apiClient.escapeString(filepath.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (ref != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("ref", ref));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/html"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoGetRawFileOrLFSValidateBeforeCall(String owner, String repo, String filepath, String ref, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetRawFileOrLFS(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetRawFileOrLFS(Async)");
        }
        if (filepath == null) {
            throw new ApiException("Missing the required parameter 'filepath' when calling repoGetRawFileOrLFS(Async)");
        }
        Call call = this.repoGetRawFileOrLFSCall(owner, repo, filepath, ref, progressListener, progressRequestListener);
        return call;
    }

    public void repoGetRawFileOrLFS(String owner, String repo, String filepath, String ref) throws ApiException {
        this.repoGetRawFileOrLFSWithHttpInfo(owner, repo, filepath, ref);
    }

    public ApiResponse<Void> repoGetRawFileOrLFSWithHttpInfo(String owner, String repo, String filepath, String ref) throws ApiException {
        Call call = this.repoGetRawFileOrLFSValidateBeforeCall(owner, repo, filepath, ref, null, null);
        return this.apiClient.execute(call);
    }

    public Call repoGetRawFileOrLFSAsync(String owner, String repo, String filepath, String ref, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoGetRawFileOrLFSValidateBeforeCall(owner, repo, filepath, ref, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call repoGetReleaseCall(String owner, String repo, Long id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/releases/{id}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoGetReleaseValidateBeforeCall(String owner, String repo, Long id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetRelease(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetRelease(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoGetRelease(Async)");
        }
        Call call = this.repoGetReleaseCall(owner, repo, id, progressListener, progressRequestListener);
        return call;
    }

    public Release repoGetRelease(String owner, String repo, Long id) throws ApiException {
        ApiResponse<Release> resp = this.repoGetReleaseWithHttpInfo(owner, repo, id);
        return resp.getData();
    }

    public ApiResponse<Release> repoGetReleaseWithHttpInfo(String owner, String repo, Long id) throws ApiException {
        Call call = this.repoGetReleaseValidateBeforeCall(owner, repo, id, null, null);
        Type localVarReturnType = new TypeToken<Release>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoGetReleaseAsync(String owner, String repo, Long id, final ApiCallback<Release> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoGetReleaseValidateBeforeCall(owner, repo, id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Release>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoGetReleaseAttachmentCall(String owner, String repo, Long id, Long attachmentId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/releases/{id}/assets/{attachment_id}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString())).replaceAll("\\{attachment_id\\}", this.apiClient.escapeString(attachmentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoGetReleaseAttachmentValidateBeforeCall(String owner, String repo, Long id, Long attachmentId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetReleaseAttachment(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetReleaseAttachment(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoGetReleaseAttachment(Async)");
        }
        if (attachmentId == null) {
            throw new ApiException("Missing the required parameter 'attachmentId' when calling repoGetReleaseAttachment(Async)");
        }
        Call call = this.repoGetReleaseAttachmentCall(owner, repo, id, attachmentId, progressListener, progressRequestListener);
        return call;
    }

    public Attachment repoGetReleaseAttachment(String owner, String repo, Long id, Long attachmentId) throws ApiException {
        ApiResponse<Attachment> resp = this.repoGetReleaseAttachmentWithHttpInfo(owner, repo, id, attachmentId);
        return resp.getData();
    }

    public ApiResponse<Attachment> repoGetReleaseAttachmentWithHttpInfo(String owner, String repo, Long id, Long attachmentId) throws ApiException {
        Call call = this.repoGetReleaseAttachmentValidateBeforeCall(owner, repo, id, attachmentId, null, null);
        Type localVarReturnType = new TypeToken<Attachment>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoGetReleaseAttachmentAsync(String owner, String repo, Long id, Long attachmentId, final ApiCallback<Attachment> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoGetReleaseAttachmentValidateBeforeCall(owner, repo, id, attachmentId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Attachment>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoGetReleaseByTagCall(String owner, String repo, String tag, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/releases/tags/{tag}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{tag\\}", this.apiClient.escapeString(tag.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoGetReleaseByTagValidateBeforeCall(String owner, String repo, String tag, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetReleaseByTag(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetReleaseByTag(Async)");
        }
        if (tag == null) {
            throw new ApiException("Missing the required parameter 'tag' when calling repoGetReleaseByTag(Async)");
        }
        Call call = this.repoGetReleaseByTagCall(owner, repo, tag, progressListener, progressRequestListener);
        return call;
    }

    public Release repoGetReleaseByTag(String owner, String repo, String tag) throws ApiException {
        ApiResponse<Release> resp = this.repoGetReleaseByTagWithHttpInfo(owner, repo, tag);
        return resp.getData();
    }

    public ApiResponse<Release> repoGetReleaseByTagWithHttpInfo(String owner, String repo, String tag) throws ApiException {
        Call call = this.repoGetReleaseByTagValidateBeforeCall(owner, repo, tag, null, null);
        Type localVarReturnType = new TypeToken<Release>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoGetReleaseByTagAsync(String owner, String repo, String tag, final ApiCallback<Release> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoGetReleaseByTagValidateBeforeCall(owner, repo, tag, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Release>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoGetRepoPermissionsCall(String owner, String repo, String collaborator, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/collaborators/{collaborator}/permission".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{collaborator\\}", this.apiClient.escapeString(collaborator.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoGetRepoPermissionsValidateBeforeCall(String owner, String repo, String collaborator, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetRepoPermissions(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetRepoPermissions(Async)");
        }
        if (collaborator == null) {
            throw new ApiException("Missing the required parameter 'collaborator' when calling repoGetRepoPermissions(Async)");
        }
        Call call = this.repoGetRepoPermissionsCall(owner, repo, collaborator, progressListener, progressRequestListener);
        return call;
    }

    public RepoCollaboratorPermission repoGetRepoPermissions(String owner, String repo, String collaborator) throws ApiException {
        ApiResponse<RepoCollaboratorPermission> resp = this.repoGetRepoPermissionsWithHttpInfo(owner, repo, collaborator);
        return resp.getData();
    }

    public ApiResponse<RepoCollaboratorPermission> repoGetRepoPermissionsWithHttpInfo(String owner, String repo, String collaborator) throws ApiException {
        Call call = this.repoGetRepoPermissionsValidateBeforeCall(owner, repo, collaborator, null, null);
        Type localVarReturnType = new TypeToken<RepoCollaboratorPermission>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoGetRepoPermissionsAsync(String owner, String repo, String collaborator, final ApiCallback<RepoCollaboratorPermission> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoGetRepoPermissionsValidateBeforeCall(owner, repo, collaborator, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RepoCollaboratorPermission>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoGetReviewersCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/reviewers".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoGetReviewersValidateBeforeCall(String owner, String repo, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetReviewers(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetReviewers(Async)");
        }
        Call call = this.repoGetReviewersCall(owner, repo, progressListener, progressRequestListener);
        return call;
    }

    public List<User> repoGetReviewers(String owner, String repo) throws ApiException {
        ApiResponse<List<User>> resp = this.repoGetReviewersWithHttpInfo(owner, repo);
        return resp.getData();
    }

    public ApiResponse<List<User>> repoGetReviewersWithHttpInfo(String owner, String repo) throws ApiException {
        Call call = this.repoGetReviewersValidateBeforeCall(owner, repo, null, null);
        Type localVarReturnType = new TypeToken<List<User>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoGetReviewersAsync(String owner, String repo, final ApiCallback<List<User>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoGetReviewersValidateBeforeCall(owner, repo, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<User>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoGetSingleCommitCall(String owner, String repo, String sha, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/git/commits/{sha}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{sha\\}", this.apiClient.escapeString(sha.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoGetSingleCommitValidateBeforeCall(String owner, String repo, String sha, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetSingleCommit(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetSingleCommit(Async)");
        }
        if (sha == null) {
            throw new ApiException("Missing the required parameter 'sha' when calling repoGetSingleCommit(Async)");
        }
        Call call = this.repoGetSingleCommitCall(owner, repo, sha, progressListener, progressRequestListener);
        return call;
    }

    public Commit repoGetSingleCommit(String owner, String repo, String sha) throws ApiException {
        ApiResponse<Commit> resp = this.repoGetSingleCommitWithHttpInfo(owner, repo, sha);
        return resp.getData();
    }

    public ApiResponse<Commit> repoGetSingleCommitWithHttpInfo(String owner, String repo, String sha) throws ApiException {
        Call call = this.repoGetSingleCommitValidateBeforeCall(owner, repo, sha, null, null);
        Type localVarReturnType = new TypeToken<Commit>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoGetSingleCommitAsync(String owner, String repo, String sha, final ApiCallback<Commit> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoGetSingleCommitValidateBeforeCall(owner, repo, sha, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Commit>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoGetTagCall(String owner, String repo, String tag, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/tags/{tag}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{tag\\}", this.apiClient.escapeString(tag.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoGetTagValidateBeforeCall(String owner, String repo, String tag, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetTag(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetTag(Async)");
        }
        if (tag == null) {
            throw new ApiException("Missing the required parameter 'tag' when calling repoGetTag(Async)");
        }
        Call call = this.repoGetTagCall(owner, repo, tag, progressListener, progressRequestListener);
        return call;
    }

    public Tag repoGetTag(String owner, String repo, String tag) throws ApiException {
        ApiResponse<Tag> resp = this.repoGetTagWithHttpInfo(owner, repo, tag);
        return resp.getData();
    }

    public ApiResponse<Tag> repoGetTagWithHttpInfo(String owner, String repo, String tag) throws ApiException {
        Call call = this.repoGetTagValidateBeforeCall(owner, repo, tag, null, null);
        Type localVarReturnType = new TypeToken<Tag>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoGetTagAsync(String owner, String repo, String tag, final ApiCallback<Tag> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoGetTagValidateBeforeCall(owner, repo, tag, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Tag>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoGetWikiPageCall(String owner, String repo, String pageName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/wiki/page/{pageName}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{pageName\\}", this.apiClient.escapeString(pageName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoGetWikiPageValidateBeforeCall(String owner, String repo, String pageName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetWikiPage(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetWikiPage(Async)");
        }
        if (pageName == null) {
            throw new ApiException("Missing the required parameter 'pageName' when calling repoGetWikiPage(Async)");
        }
        Call call = this.repoGetWikiPageCall(owner, repo, pageName, progressListener, progressRequestListener);
        return call;
    }

    public WikiPage repoGetWikiPage(String owner, String repo, String pageName) throws ApiException {
        ApiResponse<WikiPage> resp = this.repoGetWikiPageWithHttpInfo(owner, repo, pageName);
        return resp.getData();
    }

    public ApiResponse<WikiPage> repoGetWikiPageWithHttpInfo(String owner, String repo, String pageName) throws ApiException {
        Call call = this.repoGetWikiPageValidateBeforeCall(owner, repo, pageName, null, null);
        Type localVarReturnType = new TypeToken<WikiPage>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoGetWikiPageAsync(String owner, String repo, String pageName, final ApiCallback<WikiPage> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoGetWikiPageValidateBeforeCall(owner, repo, pageName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WikiPage>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoGetWikiPageRevisionsCall(String owner, String repo, String pageName, Integer page, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/wiki/revisions/{pageName}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{pageName\\}", this.apiClient.escapeString(pageName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoGetWikiPageRevisionsValidateBeforeCall(String owner, String repo, String pageName, Integer page, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetWikiPageRevisions(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetWikiPageRevisions(Async)");
        }
        if (pageName == null) {
            throw new ApiException("Missing the required parameter 'pageName' when calling repoGetWikiPageRevisions(Async)");
        }
        Call call = this.repoGetWikiPageRevisionsCall(owner, repo, pageName, page, progressListener, progressRequestListener);
        return call;
    }

    public WikiCommitList repoGetWikiPageRevisions(String owner, String repo, String pageName, Integer page) throws ApiException {
        ApiResponse<WikiCommitList> resp = this.repoGetWikiPageRevisionsWithHttpInfo(owner, repo, pageName, page);
        return resp.getData();
    }

    public ApiResponse<WikiCommitList> repoGetWikiPageRevisionsWithHttpInfo(String owner, String repo, String pageName, Integer page) throws ApiException {
        Call call = this.repoGetWikiPageRevisionsValidateBeforeCall(owner, repo, pageName, page, null, null);
        Type localVarReturnType = new TypeToken<WikiCommitList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoGetWikiPageRevisionsAsync(String owner, String repo, String pageName, Integer page, final ApiCallback<WikiCommitList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoGetWikiPageRevisionsValidateBeforeCall(owner, repo, pageName, page, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WikiCommitList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoGetWikiPagesCall(String owner, String repo, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/wiki/pages".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoGetWikiPagesValidateBeforeCall(String owner, String repo, Integer page, Integer limit, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetWikiPages(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetWikiPages(Async)");
        }
        Call call = this.repoGetWikiPagesCall(owner, repo, page, limit, progressListener, progressRequestListener);
        return call;
    }

    public List<WikiPageMetaData> repoGetWikiPages(String owner, String repo, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<WikiPageMetaData>> resp = this.repoGetWikiPagesWithHttpInfo(owner, repo, page, limit);
        return resp.getData();
    }

    public ApiResponse<List<WikiPageMetaData>> repoGetWikiPagesWithHttpInfo(String owner, String repo, Integer page, Integer limit) throws ApiException {
        Call call = this.repoGetWikiPagesValidateBeforeCall(owner, repo, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<WikiPageMetaData>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoGetWikiPagesAsync(String owner, String repo, Integer page, Integer limit, final ApiCallback<List<WikiPageMetaData>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoGetWikiPagesValidateBeforeCall(owner, repo, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<WikiPageMetaData>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoListAllGitRefsCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/git/refs".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoListAllGitRefsValidateBeforeCall(String owner, String repo, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoListAllGitRefs(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoListAllGitRefs(Async)");
        }
        Call call = this.repoListAllGitRefsCall(owner, repo, progressListener, progressRequestListener);
        return call;
    }

    public List<Reference> repoListAllGitRefs(String owner, String repo) throws ApiException {
        ApiResponse<List<Reference>> resp = this.repoListAllGitRefsWithHttpInfo(owner, repo);
        return resp.getData();
    }

    public ApiResponse<List<Reference>> repoListAllGitRefsWithHttpInfo(String owner, String repo) throws ApiException {
        Call call = this.repoListAllGitRefsValidateBeforeCall(owner, repo, null, null);
        Type localVarReturnType = new TypeToken<List<Reference>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoListAllGitRefsAsync(String owner, String repo, final ApiCallback<List<Reference>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoListAllGitRefsValidateBeforeCall(owner, repo, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Reference>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoListBranchProtectionCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/branch_protections".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoListBranchProtectionValidateBeforeCall(String owner, String repo, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoListBranchProtection(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoListBranchProtection(Async)");
        }
        Call call = this.repoListBranchProtectionCall(owner, repo, progressListener, progressRequestListener);
        return call;
    }

    public List<BranchProtection> repoListBranchProtection(String owner, String repo) throws ApiException {
        ApiResponse<List<BranchProtection>> resp = this.repoListBranchProtectionWithHttpInfo(owner, repo);
        return resp.getData();
    }

    public ApiResponse<List<BranchProtection>> repoListBranchProtectionWithHttpInfo(String owner, String repo) throws ApiException {
        Call call = this.repoListBranchProtectionValidateBeforeCall(owner, repo, null, null);
        Type localVarReturnType = new TypeToken<List<BranchProtection>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoListBranchProtectionAsync(String owner, String repo, final ApiCallback<List<BranchProtection>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoListBranchProtectionValidateBeforeCall(owner, repo, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<BranchProtection>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoListBranchesCall(String owner, String repo, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/branches".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoListBranchesValidateBeforeCall(String owner, String repo, Integer page, Integer limit, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoListBranches(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoListBranches(Async)");
        }
        Call call = this.repoListBranchesCall(owner, repo, page, limit, progressListener, progressRequestListener);
        return call;
    }

    public List<Branch> repoListBranches(String owner, String repo, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<Branch>> resp = this.repoListBranchesWithHttpInfo(owner, repo, page, limit);
        return resp.getData();
    }

    public ApiResponse<List<Branch>> repoListBranchesWithHttpInfo(String owner, String repo, Integer page, Integer limit) throws ApiException {
        Call call = this.repoListBranchesValidateBeforeCall(owner, repo, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<Branch>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoListBranchesAsync(String owner, String repo, Integer page, Integer limit, final ApiCallback<List<Branch>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoListBranchesValidateBeforeCall(owner, repo, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Branch>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoListCollaboratorsCall(String owner, String repo, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/collaborators".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoListCollaboratorsValidateBeforeCall(String owner, String repo, Integer page, Integer limit, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoListCollaborators(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoListCollaborators(Async)");
        }
        Call call = this.repoListCollaboratorsCall(owner, repo, page, limit, progressListener, progressRequestListener);
        return call;
    }

    public List<User> repoListCollaborators(String owner, String repo, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<User>> resp = this.repoListCollaboratorsWithHttpInfo(owner, repo, page, limit);
        return resp.getData();
    }

    public ApiResponse<List<User>> repoListCollaboratorsWithHttpInfo(String owner, String repo, Integer page, Integer limit) throws ApiException {
        Call call = this.repoListCollaboratorsValidateBeforeCall(owner, repo, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<User>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoListCollaboratorsAsync(String owner, String repo, Integer page, Integer limit, final ApiCallback<List<User>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoListCollaboratorsValidateBeforeCall(owner, repo, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<User>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoListGitHooksCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/hooks/git".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoListGitHooksValidateBeforeCall(String owner, String repo, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoListGitHooks(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoListGitHooks(Async)");
        }
        Call call = this.repoListGitHooksCall(owner, repo, progressListener, progressRequestListener);
        return call;
    }

    public List<GitHook> repoListGitHooks(String owner, String repo) throws ApiException {
        ApiResponse<List<GitHook>> resp = this.repoListGitHooksWithHttpInfo(owner, repo);
        return resp.getData();
    }

    public ApiResponse<List<GitHook>> repoListGitHooksWithHttpInfo(String owner, String repo) throws ApiException {
        Call call = this.repoListGitHooksValidateBeforeCall(owner, repo, null, null);
        Type localVarReturnType = new TypeToken<List<GitHook>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoListGitHooksAsync(String owner, String repo, final ApiCallback<List<GitHook>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoListGitHooksValidateBeforeCall(owner, repo, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<GitHook>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoListGitRefsCall(String owner, String repo, String ref, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/git/refs/{ref}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{ref\\}", this.apiClient.escapeString(ref.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoListGitRefsValidateBeforeCall(String owner, String repo, String ref, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoListGitRefs(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoListGitRefs(Async)");
        }
        if (ref == null) {
            throw new ApiException("Missing the required parameter 'ref' when calling repoListGitRefs(Async)");
        }
        Call call = this.repoListGitRefsCall(owner, repo, ref, progressListener, progressRequestListener);
        return call;
    }

    public List<Reference> repoListGitRefs(String owner, String repo, String ref) throws ApiException {
        ApiResponse<List<Reference>> resp = this.repoListGitRefsWithHttpInfo(owner, repo, ref);
        return resp.getData();
    }

    public ApiResponse<List<Reference>> repoListGitRefsWithHttpInfo(String owner, String repo, String ref) throws ApiException {
        Call call = this.repoListGitRefsValidateBeforeCall(owner, repo, ref, null, null);
        Type localVarReturnType = new TypeToken<List<Reference>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoListGitRefsAsync(String owner, String repo, String ref, final ApiCallback<List<Reference>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoListGitRefsValidateBeforeCall(owner, repo, ref, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Reference>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoListHooksCall(String owner, String repo, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/hooks".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoListHooksValidateBeforeCall(String owner, String repo, Integer page, Integer limit, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoListHooks(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoListHooks(Async)");
        }
        Call call = this.repoListHooksCall(owner, repo, page, limit, progressListener, progressRequestListener);
        return call;
    }

    public List<Hook> repoListHooks(String owner, String repo, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<Hook>> resp = this.repoListHooksWithHttpInfo(owner, repo, page, limit);
        return resp.getData();
    }

    public ApiResponse<List<Hook>> repoListHooksWithHttpInfo(String owner, String repo, Integer page, Integer limit) throws ApiException {
        Call call = this.repoListHooksValidateBeforeCall(owner, repo, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<Hook>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoListHooksAsync(String owner, String repo, Integer page, Integer limit, final ApiCallback<List<Hook>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoListHooksValidateBeforeCall(owner, repo, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Hook>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoListKeysCall(String owner, String repo, Integer keyId, String fingerprint, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/keys".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (keyId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("key_id", keyId));
        }
        if (fingerprint != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("fingerprint", fingerprint));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoListKeysValidateBeforeCall(String owner, String repo, Integer keyId, String fingerprint, Integer page, Integer limit, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoListKeys(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoListKeys(Async)");
        }
        Call call = this.repoListKeysCall(owner, repo, keyId, fingerprint, page, limit, progressListener, progressRequestListener);
        return call;
    }

    public List<DeployKey> repoListKeys(String owner, String repo, Integer keyId, String fingerprint, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<DeployKey>> resp = this.repoListKeysWithHttpInfo(owner, repo, keyId, fingerprint, page, limit);
        return resp.getData();
    }

    public ApiResponse<List<DeployKey>> repoListKeysWithHttpInfo(String owner, String repo, Integer keyId, String fingerprint, Integer page, Integer limit) throws ApiException {
        Call call = this.repoListKeysValidateBeforeCall(owner, repo, keyId, fingerprint, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<DeployKey>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoListKeysAsync(String owner, String repo, Integer keyId, String fingerprint, Integer page, Integer limit, final ApiCallback<List<DeployKey>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoListKeysValidateBeforeCall(owner, repo, keyId, fingerprint, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<DeployKey>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoListPullRequestsCall(String owner, String repo, String state, String sort, Long milestone, List<Long> labels, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/pulls".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (state != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("state", state));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        }
        if (milestone != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("milestone", milestone));
        }
        if (labels != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "labels", labels));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoListPullRequestsValidateBeforeCall(String owner, String repo, String state, String sort, Long milestone, List<Long> labels, Integer page, Integer limit, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoListPullRequests(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoListPullRequests(Async)");
        }
        Call call = this.repoListPullRequestsCall(owner, repo, state, sort, milestone, labels, page, limit, progressListener, progressRequestListener);
        return call;
    }

    public List<PullRequest> repoListPullRequests(String owner, String repo, String state, String sort, Long milestone, List<Long> labels, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<PullRequest>> resp = this.repoListPullRequestsWithHttpInfo(owner, repo, state, sort, milestone, labels, page, limit);
        return resp.getData();
    }

    public ApiResponse<List<PullRequest>> repoListPullRequestsWithHttpInfo(String owner, String repo, String state, String sort, Long milestone, List<Long> labels, Integer page, Integer limit) throws ApiException {
        Call call = this.repoListPullRequestsValidateBeforeCall(owner, repo, state, sort, milestone, labels, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<PullRequest>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoListPullRequestsAsync(String owner, String repo, String state, String sort, Long milestone, List<Long> labels, Integer page, Integer limit, final ApiCallback<List<PullRequest>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoListPullRequestsValidateBeforeCall(owner, repo, state, sort, milestone, labels, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<PullRequest>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoListPullReviewsCall(String owner, String repo, Long index, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/pulls/{index}/reviews".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoListPullReviewsValidateBeforeCall(String owner, String repo, Long index, Integer page, Integer limit, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoListPullReviews(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoListPullReviews(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling repoListPullReviews(Async)");
        }
        Call call = this.repoListPullReviewsCall(owner, repo, index, page, limit, progressListener, progressRequestListener);
        return call;
    }

    public List<PullReview> repoListPullReviews(String owner, String repo, Long index, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<PullReview>> resp = this.repoListPullReviewsWithHttpInfo(owner, repo, index, page, limit);
        return resp.getData();
    }

    public ApiResponse<List<PullReview>> repoListPullReviewsWithHttpInfo(String owner, String repo, Long index, Integer page, Integer limit) throws ApiException {
        Call call = this.repoListPullReviewsValidateBeforeCall(owner, repo, index, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<PullReview>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoListPullReviewsAsync(String owner, String repo, Long index, Integer page, Integer limit, final ApiCallback<List<PullReview>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoListPullReviewsValidateBeforeCall(owner, repo, index, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<PullReview>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoListPushMirrorsCall(String owner, String repo, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/push_mirrors".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoListPushMirrorsValidateBeforeCall(String owner, String repo, Integer page, Integer limit, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoListPushMirrors(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoListPushMirrors(Async)");
        }
        Call call = this.repoListPushMirrorsCall(owner, repo, page, limit, progressListener, progressRequestListener);
        return call;
    }

    public List<PushMirror> repoListPushMirrors(String owner, String repo, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<PushMirror>> resp = this.repoListPushMirrorsWithHttpInfo(owner, repo, page, limit);
        return resp.getData();
    }

    public ApiResponse<List<PushMirror>> repoListPushMirrorsWithHttpInfo(String owner, String repo, Integer page, Integer limit) throws ApiException {
        Call call = this.repoListPushMirrorsValidateBeforeCall(owner, repo, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<PushMirror>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoListPushMirrorsAsync(String owner, String repo, Integer page, Integer limit, final ApiCallback<List<PushMirror>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoListPushMirrorsValidateBeforeCall(owner, repo, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<PushMirror>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoListReleaseAttachmentsCall(String owner, String repo, Long id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/releases/{id}/assets".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoListReleaseAttachmentsValidateBeforeCall(String owner, String repo, Long id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoListReleaseAttachments(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoListReleaseAttachments(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoListReleaseAttachments(Async)");
        }
        Call call = this.repoListReleaseAttachmentsCall(owner, repo, id, progressListener, progressRequestListener);
        return call;
    }

    public List<Attachment> repoListReleaseAttachments(String owner, String repo, Long id) throws ApiException {
        ApiResponse<List<Attachment>> resp = this.repoListReleaseAttachmentsWithHttpInfo(owner, repo, id);
        return resp.getData();
    }

    public ApiResponse<List<Attachment>> repoListReleaseAttachmentsWithHttpInfo(String owner, String repo, Long id) throws ApiException {
        Call call = this.repoListReleaseAttachmentsValidateBeforeCall(owner, repo, id, null, null);
        Type localVarReturnType = new TypeToken<List<Attachment>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoListReleaseAttachmentsAsync(String owner, String repo, Long id, final ApiCallback<List<Attachment>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoListReleaseAttachmentsValidateBeforeCall(owner, repo, id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Attachment>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoListReleasesCall(String owner, String repo, Boolean draft, Boolean preRelease, Integer perPage, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/releases".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (draft != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("draft", draft));
        }
        if (preRelease != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pre-release", preRelease));
        }
        if (perPage != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("per_page", perPage));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoListReleasesValidateBeforeCall(String owner, String repo, Boolean draft, Boolean preRelease, Integer perPage, Integer page, Integer limit, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoListReleases(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoListReleases(Async)");
        }
        Call call = this.repoListReleasesCall(owner, repo, draft, preRelease, perPage, page, limit, progressListener, progressRequestListener);
        return call;
    }

    public List<Release> repoListReleases(String owner, String repo, Boolean draft, Boolean preRelease, Integer perPage, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<Release>> resp = this.repoListReleasesWithHttpInfo(owner, repo, draft, preRelease, perPage, page, limit);
        return resp.getData();
    }

    public ApiResponse<List<Release>> repoListReleasesWithHttpInfo(String owner, String repo, Boolean draft, Boolean preRelease, Integer perPage, Integer page, Integer limit) throws ApiException {
        Call call = this.repoListReleasesValidateBeforeCall(owner, repo, draft, preRelease, perPage, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<Release>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoListReleasesAsync(String owner, String repo, Boolean draft, Boolean preRelease, Integer perPage, Integer page, Integer limit, final ApiCallback<List<Release>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoListReleasesValidateBeforeCall(owner, repo, draft, preRelease, perPage, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Release>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoListStargazersCall(String owner, String repo, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/stargazers".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoListStargazersValidateBeforeCall(String owner, String repo, Integer page, Integer limit, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoListStargazers(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoListStargazers(Async)");
        }
        Call call = this.repoListStargazersCall(owner, repo, page, limit, progressListener, progressRequestListener);
        return call;
    }

    public List<User> repoListStargazers(String owner, String repo, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<User>> resp = this.repoListStargazersWithHttpInfo(owner, repo, page, limit);
        return resp.getData();
    }

    public ApiResponse<List<User>> repoListStargazersWithHttpInfo(String owner, String repo, Integer page, Integer limit) throws ApiException {
        Call call = this.repoListStargazersValidateBeforeCall(owner, repo, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<User>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoListStargazersAsync(String owner, String repo, Integer page, Integer limit, final ApiCallback<List<User>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoListStargazersValidateBeforeCall(owner, repo, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<User>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoListStatusesCall(String owner, String repo, String sha, String sort, String state, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/statuses/{sha}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{sha\\}", this.apiClient.escapeString(sha.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (sort != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        }
        if (state != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("state", state));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoListStatusesValidateBeforeCall(String owner, String repo, String sha, String sort, String state, Integer page, Integer limit, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoListStatuses(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoListStatuses(Async)");
        }
        if (sha == null) {
            throw new ApiException("Missing the required parameter 'sha' when calling repoListStatuses(Async)");
        }
        Call call = this.repoListStatusesCall(owner, repo, sha, sort, state, page, limit, progressListener, progressRequestListener);
        return call;
    }

    public List<CommitStatus> repoListStatuses(String owner, String repo, String sha, String sort, String state, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<CommitStatus>> resp = this.repoListStatusesWithHttpInfo(owner, repo, sha, sort, state, page, limit);
        return resp.getData();
    }

    public ApiResponse<List<CommitStatus>> repoListStatusesWithHttpInfo(String owner, String repo, String sha, String sort, String state, Integer page, Integer limit) throws ApiException {
        Call call = this.repoListStatusesValidateBeforeCall(owner, repo, sha, sort, state, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<CommitStatus>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoListStatusesAsync(String owner, String repo, String sha, String sort, String state, Integer page, Integer limit, final ApiCallback<List<CommitStatus>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoListStatusesValidateBeforeCall(owner, repo, sha, sort, state, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<CommitStatus>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoListStatusesByRefCall(String owner, String repo, String ref, String sort, String state, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/commits/{ref}/statuses".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{ref\\}", this.apiClient.escapeString(ref.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (sort != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        }
        if (state != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("state", state));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoListStatusesByRefValidateBeforeCall(String owner, String repo, String ref, String sort, String state, Integer page, Integer limit, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoListStatusesByRef(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoListStatusesByRef(Async)");
        }
        if (ref == null) {
            throw new ApiException("Missing the required parameter 'ref' when calling repoListStatusesByRef(Async)");
        }
        Call call = this.repoListStatusesByRefCall(owner, repo, ref, sort, state, page, limit, progressListener, progressRequestListener);
        return call;
    }

    public List<CommitStatus> repoListStatusesByRef(String owner, String repo, String ref, String sort, String state, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<CommitStatus>> resp = this.repoListStatusesByRefWithHttpInfo(owner, repo, ref, sort, state, page, limit);
        return resp.getData();
    }

    public ApiResponse<List<CommitStatus>> repoListStatusesByRefWithHttpInfo(String owner, String repo, String ref, String sort, String state, Integer page, Integer limit) throws ApiException {
        Call call = this.repoListStatusesByRefValidateBeforeCall(owner, repo, ref, sort, state, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<CommitStatus>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoListStatusesByRefAsync(String owner, String repo, String ref, String sort, String state, Integer page, Integer limit, final ApiCallback<List<CommitStatus>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoListStatusesByRefValidateBeforeCall(owner, repo, ref, sort, state, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<CommitStatus>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoListSubscribersCall(String owner, String repo, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/subscribers".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoListSubscribersValidateBeforeCall(String owner, String repo, Integer page, Integer limit, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoListSubscribers(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoListSubscribers(Async)");
        }
        Call call = this.repoListSubscribersCall(owner, repo, page, limit, progressListener, progressRequestListener);
        return call;
    }

    public List<User> repoListSubscribers(String owner, String repo, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<User>> resp = this.repoListSubscribersWithHttpInfo(owner, repo, page, limit);
        return resp.getData();
    }

    public ApiResponse<List<User>> repoListSubscribersWithHttpInfo(String owner, String repo, Integer page, Integer limit) throws ApiException {
        Call call = this.repoListSubscribersValidateBeforeCall(owner, repo, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<User>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoListSubscribersAsync(String owner, String repo, Integer page, Integer limit, final ApiCallback<List<User>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoListSubscribersValidateBeforeCall(owner, repo, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<User>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoListTagsCall(String owner, String repo, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/tags".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoListTagsValidateBeforeCall(String owner, String repo, Integer page, Integer limit, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoListTags(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoListTags(Async)");
        }
        Call call = this.repoListTagsCall(owner, repo, page, limit, progressListener, progressRequestListener);
        return call;
    }

    public List<Tag> repoListTags(String owner, String repo, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<Tag>> resp = this.repoListTagsWithHttpInfo(owner, repo, page, limit);
        return resp.getData();
    }

    public ApiResponse<List<Tag>> repoListTagsWithHttpInfo(String owner, String repo, Integer page, Integer limit) throws ApiException {
        Call call = this.repoListTagsValidateBeforeCall(owner, repo, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<Tag>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoListTagsAsync(String owner, String repo, Integer page, Integer limit, final ApiCallback<List<Tag>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoListTagsValidateBeforeCall(owner, repo, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Tag>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoListTeamsCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/teams".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoListTeamsValidateBeforeCall(String owner, String repo, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoListTeams(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoListTeams(Async)");
        }
        Call call = this.repoListTeamsCall(owner, repo, progressListener, progressRequestListener);
        return call;
    }

    public List<Team> repoListTeams(String owner, String repo) throws ApiException {
        ApiResponse<List<Team>> resp = this.repoListTeamsWithHttpInfo(owner, repo);
        return resp.getData();
    }

    public ApiResponse<List<Team>> repoListTeamsWithHttpInfo(String owner, String repo) throws ApiException {
        Call call = this.repoListTeamsValidateBeforeCall(owner, repo, null, null);
        Type localVarReturnType = new TypeToken<List<Team>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoListTeamsAsync(String owner, String repo, final ApiCallback<List<Team>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoListTeamsValidateBeforeCall(owner, repo, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Team>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoListTopicsCall(String owner, String repo, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/topics".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoListTopicsValidateBeforeCall(String owner, String repo, Integer page, Integer limit, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoListTopics(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoListTopics(Async)");
        }
        Call call = this.repoListTopicsCall(owner, repo, page, limit, progressListener, progressRequestListener);
        return call;
    }

    public TopicName repoListTopics(String owner, String repo, Integer page, Integer limit) throws ApiException {
        ApiResponse<TopicName> resp = this.repoListTopicsWithHttpInfo(owner, repo, page, limit);
        return resp.getData();
    }

    public ApiResponse<TopicName> repoListTopicsWithHttpInfo(String owner, String repo, Integer page, Integer limit) throws ApiException {
        Call call = this.repoListTopicsValidateBeforeCall(owner, repo, page, limit, null, null);
        Type localVarReturnType = new TypeToken<TopicName>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoListTopicsAsync(String owner, String repo, Integer page, Integer limit, final ApiCallback<TopicName> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoListTopicsValidateBeforeCall(owner, repo, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TopicName>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoMergePullRequestCall(String owner, String repo, Long index, MergePullRequestOption body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        MergePullRequestOption localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}/pulls/{index}/merge".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoMergePullRequestValidateBeforeCall(String owner, String repo, Long index, MergePullRequestOption body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoMergePullRequest(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoMergePullRequest(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling repoMergePullRequest(Async)");
        }
        Call call = this.repoMergePullRequestCall(owner, repo, index, body, progressListener, progressRequestListener);
        return call;
    }

    public void repoMergePullRequest(String owner, String repo, Long index, MergePullRequestOption body) throws ApiException {
        this.repoMergePullRequestWithHttpInfo(owner, repo, index, body);
    }

    public ApiResponse<Void> repoMergePullRequestWithHttpInfo(String owner, String repo, Long index, MergePullRequestOption body) throws ApiException {
        Call call = this.repoMergePullRequestValidateBeforeCall(owner, repo, index, body, null, null);
        return this.apiClient.execute(call);
    }

    public Call repoMergePullRequestAsync(String owner, String repo, Long index, MergePullRequestOption body, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoMergePullRequestValidateBeforeCall(owner, repo, index, body, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call repoMigrateCall(MigrateRepoOptions body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        MigrateRepoOptions localVarPostBody = body;
        String localVarPath = "/repos/migrate";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoMigrateValidateBeforeCall(MigrateRepoOptions body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.repoMigrateCall(body, progressListener, progressRequestListener);
        return call;
    }

    public Repository repoMigrate(MigrateRepoOptions body) throws ApiException {
        ApiResponse<Repository> resp = this.repoMigrateWithHttpInfo(body);
        return resp.getData();
    }

    public ApiResponse<Repository> repoMigrateWithHttpInfo(MigrateRepoOptions body) throws ApiException {
        Call call = this.repoMigrateValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoMigrateAsync(MigrateRepoOptions body, final ApiCallback<Repository> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoMigrateValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoMirrorSyncCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/mirror-sync".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoMirrorSyncValidateBeforeCall(String owner, String repo, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoMirrorSync(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoMirrorSync(Async)");
        }
        Call call = this.repoMirrorSyncCall(owner, repo, progressListener, progressRequestListener);
        return call;
    }

    public void repoMirrorSync(String owner, String repo) throws ApiException {
        this.repoMirrorSyncWithHttpInfo(owner, repo);
    }

    public ApiResponse<Void> repoMirrorSyncWithHttpInfo(String owner, String repo) throws ApiException {
        Call call = this.repoMirrorSyncValidateBeforeCall(owner, repo, null, null);
        return this.apiClient.execute(call);
    }

    public Call repoMirrorSyncAsync(String owner, String repo, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoMirrorSyncValidateBeforeCall(owner, repo, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call repoPullRequestIsMergedCall(String owner, String repo, Long index, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/pulls/{index}/merge".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoPullRequestIsMergedValidateBeforeCall(String owner, String repo, Long index, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoPullRequestIsMerged(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoPullRequestIsMerged(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling repoPullRequestIsMerged(Async)");
        }
        Call call = this.repoPullRequestIsMergedCall(owner, repo, index, progressListener, progressRequestListener);
        return call;
    }

    public void repoPullRequestIsMerged(String owner, String repo, Long index) throws ApiException {
        this.repoPullRequestIsMergedWithHttpInfo(owner, repo, index);
    }

    public ApiResponse<Void> repoPullRequestIsMergedWithHttpInfo(String owner, String repo, Long index) throws ApiException {
        Call call = this.repoPullRequestIsMergedValidateBeforeCall(owner, repo, index, null, null);
        return this.apiClient.execute(call);
    }

    public Call repoPullRequestIsMergedAsync(String owner, String repo, Long index, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoPullRequestIsMergedValidateBeforeCall(owner, repo, index, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call repoPushMirrorSyncCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/push_mirrors-sync".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoPushMirrorSyncValidateBeforeCall(String owner, String repo, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoPushMirrorSync(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoPushMirrorSync(Async)");
        }
        Call call = this.repoPushMirrorSyncCall(owner, repo, progressListener, progressRequestListener);
        return call;
    }

    public void repoPushMirrorSync(String owner, String repo) throws ApiException {
        this.repoPushMirrorSyncWithHttpInfo(owner, repo);
    }

    public ApiResponse<Void> repoPushMirrorSyncWithHttpInfo(String owner, String repo) throws ApiException {
        Call call = this.repoPushMirrorSyncValidateBeforeCall(owner, repo, null, null);
        return this.apiClient.execute(call);
    }

    public Call repoPushMirrorSyncAsync(String owner, String repo, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoPushMirrorSyncValidateBeforeCall(owner, repo, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call repoSearchCall(String q, Boolean topic, Boolean includeDesc, Long uid, Long priorityOwnerId, Long teamId, Long starredBy, Boolean _private, Boolean isPrivate, Boolean template, Boolean archived, String mode, Boolean exclusive, String sort, String order, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/search";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (q != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("q", q));
        }
        if (topic != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("topic", topic));
        }
        if (includeDesc != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("includeDesc", includeDesc));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("uid", uid));
        }
        if (priorityOwnerId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("priority_owner_id", priorityOwnerId));
        }
        if (teamId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("team_id", teamId));
        }
        if (starredBy != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("starredBy", starredBy));
        }
        if (_private != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("private", _private));
        }
        if (isPrivate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("is_private", isPrivate));
        }
        if (template != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("template", template));
        }
        if (archived != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("archived", archived));
        }
        if (mode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("mode", mode));
        }
        if (exclusive != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("exclusive", exclusive));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        }
        if (order != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("order", order));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoSearchValidateBeforeCall(String q, Boolean topic, Boolean includeDesc, Long uid, Long priorityOwnerId, Long teamId, Long starredBy, Boolean _private, Boolean isPrivate, Boolean template, Boolean archived, String mode, Boolean exclusive, String sort, String order, Integer page, Integer limit, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.repoSearchCall(q, topic, includeDesc, uid, priorityOwnerId, teamId, starredBy, _private, isPrivate, template, archived, mode, exclusive, sort, order, page, limit, progressListener, progressRequestListener);
        return call;
    }

    public SearchResults repoSearch(String q, Boolean topic, Boolean includeDesc, Long uid, Long priorityOwnerId, Long teamId, Long starredBy, Boolean _private, Boolean isPrivate, Boolean template, Boolean archived, String mode, Boolean exclusive, String sort, String order, Integer page, Integer limit) throws ApiException {
        ApiResponse<SearchResults> resp = this.repoSearchWithHttpInfo(q, topic, includeDesc, uid, priorityOwnerId, teamId, starredBy, _private, isPrivate, template, archived, mode, exclusive, sort, order, page, limit);
        return resp.getData();
    }

    public ApiResponse<SearchResults> repoSearchWithHttpInfo(String q, Boolean topic, Boolean includeDesc, Long uid, Long priorityOwnerId, Long teamId, Long starredBy, Boolean _private, Boolean isPrivate, Boolean template, Boolean archived, String mode, Boolean exclusive, String sort, String order, Integer page, Integer limit) throws ApiException {
        Call call = this.repoSearchValidateBeforeCall(q, topic, includeDesc, uid, priorityOwnerId, teamId, starredBy, _private, isPrivate, template, archived, mode, exclusive, sort, order, page, limit, null, null);
        Type localVarReturnType = new TypeToken<SearchResults>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoSearchAsync(String q, Boolean topic, Boolean includeDesc, Long uid, Long priorityOwnerId, Long teamId, Long starredBy, Boolean _private, Boolean isPrivate, Boolean template, Boolean archived, String mode, Boolean exclusive, String sort, String order, Integer page, Integer limit, final ApiCallback<SearchResults> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoSearchValidateBeforeCall(q, topic, includeDesc, uid, priorityOwnerId, teamId, starredBy, _private, isPrivate, template, archived, mode, exclusive, sort, order, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SearchResults>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoSigningKeyCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/signing-key.gpg".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoSigningKeyValidateBeforeCall(String owner, String repo, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoSigningKey(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoSigningKey(Async)");
        }
        Call call = this.repoSigningKeyCall(owner, repo, progressListener, progressRequestListener);
        return call;
    }

    public String repoSigningKey(String owner, String repo) throws ApiException {
        ApiResponse<String> resp = this.repoSigningKeyWithHttpInfo(owner, repo);
        return resp.getData();
    }

    public ApiResponse<String> repoSigningKeyWithHttpInfo(String owner, String repo) throws ApiException {
        Call call = this.repoSigningKeyValidateBeforeCall(owner, repo, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoSigningKeyAsync(String owner, String repo, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoSigningKeyValidateBeforeCall(owner, repo, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoSubmitPullReviewCall(String owner, String repo, Long index, Long id, SubmitPullReviewOptions body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SubmitPullReviewOptions localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}/pulls/{index}/reviews/{id}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoSubmitPullReviewValidateBeforeCall(String owner, String repo, Long index, Long id, SubmitPullReviewOptions body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoSubmitPullReview(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoSubmitPullReview(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling repoSubmitPullReview(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoSubmitPullReview(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling repoSubmitPullReview(Async)");
        }
        Call call = this.repoSubmitPullReviewCall(owner, repo, index, id, body, progressListener, progressRequestListener);
        return call;
    }

    public PullReview repoSubmitPullReview(String owner, String repo, Long index, Long id, SubmitPullReviewOptions body) throws ApiException {
        ApiResponse<PullReview> resp = this.repoSubmitPullReviewWithHttpInfo(owner, repo, index, id, body);
        return resp.getData();
    }

    public ApiResponse<PullReview> repoSubmitPullReviewWithHttpInfo(String owner, String repo, Long index, Long id, SubmitPullReviewOptions body) throws ApiException {
        Call call = this.repoSubmitPullReviewValidateBeforeCall(owner, repo, index, id, body, null, null);
        Type localVarReturnType = new TypeToken<PullReview>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoSubmitPullReviewAsync(String owner, String repo, Long index, Long id, SubmitPullReviewOptions body, final ApiCallback<PullReview> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoSubmitPullReviewValidateBeforeCall(owner, repo, index, id, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PullReview>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoTestHookCall(String owner, String repo, Long id, String ref, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/hooks/{id}/tests".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (ref != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("ref", ref));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoTestHookValidateBeforeCall(String owner, String repo, Long id, String ref, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoTestHook(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoTestHook(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoTestHook(Async)");
        }
        Call call = this.repoTestHookCall(owner, repo, id, ref, progressListener, progressRequestListener);
        return call;
    }

    public void repoTestHook(String owner, String repo, Long id, String ref) throws ApiException {
        this.repoTestHookWithHttpInfo(owner, repo, id, ref);
    }

    public ApiResponse<Void> repoTestHookWithHttpInfo(String owner, String repo, Long id, String ref) throws ApiException {
        Call call = this.repoTestHookValidateBeforeCall(owner, repo, id, ref, null, null);
        return this.apiClient.execute(call);
    }

    public Call repoTestHookAsync(String owner, String repo, Long id, String ref, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoTestHookValidateBeforeCall(owner, repo, id, ref, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call repoTrackedTimesCall(String owner, String repo, String user, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/times".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (user != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("user", user));
        }
        if (since != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("since", since));
        }
        if (before != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("before", before));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoTrackedTimesValidateBeforeCall(String owner, String repo, String user, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoTrackedTimes(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoTrackedTimes(Async)");
        }
        Call call = this.repoTrackedTimesCall(owner, repo, user, since, before, page, limit, progressListener, progressRequestListener);
        return call;
    }

    public List<TrackedTime> repoTrackedTimes(String owner, String repo, String user, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<TrackedTime>> resp = this.repoTrackedTimesWithHttpInfo(owner, repo, user, since, before, page, limit);
        return resp.getData();
    }

    public ApiResponse<List<TrackedTime>> repoTrackedTimesWithHttpInfo(String owner, String repo, String user, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit) throws ApiException {
        Call call = this.repoTrackedTimesValidateBeforeCall(owner, repo, user, since, before, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<TrackedTime>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoTrackedTimesAsync(String owner, String repo, String user, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit, final ApiCallback<List<TrackedTime>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoTrackedTimesValidateBeforeCall(owner, repo, user, since, before, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<TrackedTime>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoTransferCall(String owner, String repo, TransferRepoOption body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TransferRepoOption localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}/transfer".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoTransferValidateBeforeCall(String owner, String repo, TransferRepoOption body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoTransfer(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoTransfer(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling repoTransfer(Async)");
        }
        Call call = this.repoTransferCall(owner, repo, body, progressListener, progressRequestListener);
        return call;
    }

    public Repository repoTransfer(String owner, String repo, TransferRepoOption body) throws ApiException {
        ApiResponse<Repository> resp = this.repoTransferWithHttpInfo(owner, repo, body);
        return resp.getData();
    }

    public ApiResponse<Repository> repoTransferWithHttpInfo(String owner, String repo, TransferRepoOption body) throws ApiException {
        Call call = this.repoTransferValidateBeforeCall(owner, repo, body, null, null);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoTransferAsync(String owner, String repo, TransferRepoOption body, final ApiCallback<Repository> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoTransferValidateBeforeCall(owner, repo, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoUnDismissPullReviewCall(String owner, String repo, Long index, Long id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/pulls/{index}/reviews/{id}/undismissals".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoUnDismissPullReviewValidateBeforeCall(String owner, String repo, Long index, Long id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoUnDismissPullReview(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoUnDismissPullReview(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling repoUnDismissPullReview(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoUnDismissPullReview(Async)");
        }
        Call call = this.repoUnDismissPullReviewCall(owner, repo, index, id, progressListener, progressRequestListener);
        return call;
    }

    public PullReview repoUnDismissPullReview(String owner, String repo, Long index, Long id) throws ApiException {
        ApiResponse<PullReview> resp = this.repoUnDismissPullReviewWithHttpInfo(owner, repo, index, id);
        return resp.getData();
    }

    public ApiResponse<PullReview> repoUnDismissPullReviewWithHttpInfo(String owner, String repo, Long index, Long id) throws ApiException {
        Call call = this.repoUnDismissPullReviewValidateBeforeCall(owner, repo, index, id, null, null);
        Type localVarReturnType = new TypeToken<PullReview>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoUnDismissPullReviewAsync(String owner, String repo, Long index, Long id, final ApiCallback<PullReview> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoUnDismissPullReviewValidateBeforeCall(owner, repo, index, id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PullReview>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoUpdateFileCall(String owner, String repo, String filepath, UpdateFileOptions body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UpdateFileOptions localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}/contents/{filepath}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{filepath\\}", this.apiClient.escapeString(filepath.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoUpdateFileValidateBeforeCall(String owner, String repo, String filepath, UpdateFileOptions body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoUpdateFile(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoUpdateFile(Async)");
        }
        if (filepath == null) {
            throw new ApiException("Missing the required parameter 'filepath' when calling repoUpdateFile(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling repoUpdateFile(Async)");
        }
        Call call = this.repoUpdateFileCall(owner, repo, filepath, body, progressListener, progressRequestListener);
        return call;
    }

    public FileResponse repoUpdateFile(String owner, String repo, String filepath, UpdateFileOptions body) throws ApiException {
        ApiResponse<FileResponse> resp = this.repoUpdateFileWithHttpInfo(owner, repo, filepath, body);
        return resp.getData();
    }

    public ApiResponse<FileResponse> repoUpdateFileWithHttpInfo(String owner, String repo, String filepath, UpdateFileOptions body) throws ApiException {
        Call call = this.repoUpdateFileValidateBeforeCall(owner, repo, filepath, body, null, null);
        Type localVarReturnType = new TypeToken<FileResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call repoUpdateFileAsync(String owner, String repo, String filepath, UpdateFileOptions body, final ApiCallback<FileResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoUpdateFileValidateBeforeCall(owner, repo, filepath, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FileResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call repoUpdatePullRequestCall(String owner, String repo, Long index, String style, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/pulls/{index}/update".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (style != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("style", style));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoUpdatePullRequestValidateBeforeCall(String owner, String repo, Long index, String style, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoUpdatePullRequest(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoUpdatePullRequest(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling repoUpdatePullRequest(Async)");
        }
        Call call = this.repoUpdatePullRequestCall(owner, repo, index, style, progressListener, progressRequestListener);
        return call;
    }

    public void repoUpdatePullRequest(String owner, String repo, Long index, String style) throws ApiException {
        this.repoUpdatePullRequestWithHttpInfo(owner, repo, index, style);
    }

    public ApiResponse<Void> repoUpdatePullRequestWithHttpInfo(String owner, String repo, Long index, String style) throws ApiException {
        Call call = this.repoUpdatePullRequestValidateBeforeCall(owner, repo, index, style, null, null);
        return this.apiClient.execute(call);
    }

    public Call repoUpdatePullRequestAsync(String owner, String repo, Long index, String style, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoUpdatePullRequestValidateBeforeCall(owner, repo, index, style, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call repoUpdateTopicsCall(String owner, String repo, RepoTopicOptions body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        RepoTopicOptions localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}/topics".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call repoUpdateTopicsValidateBeforeCall(String owner, String repo, RepoTopicOptions body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoUpdateTopics(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoUpdateTopics(Async)");
        }
        Call call = this.repoUpdateTopicsCall(owner, repo, body, progressListener, progressRequestListener);
        return call;
    }

    public void repoUpdateTopics(String owner, String repo, RepoTopicOptions body) throws ApiException {
        this.repoUpdateTopicsWithHttpInfo(owner, repo, body);
    }

    public ApiResponse<Void> repoUpdateTopicsWithHttpInfo(String owner, String repo, RepoTopicOptions body) throws ApiException {
        Call call = this.repoUpdateTopicsValidateBeforeCall(owner, repo, body, null, null);
        return this.apiClient.execute(call);
    }

    public Call repoUpdateTopicsAsync(String owner, String repo, RepoTopicOptions body, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.repoUpdateTopicsValidateBeforeCall(owner, repo, body, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call topicSearchCall(String q, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/topics/search";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (q != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("q", q));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call topicSearchValidateBeforeCall(String q, Integer page, Integer limit, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (q == null) {
            throw new ApiException("Missing the required parameter 'q' when calling topicSearch(Async)");
        }
        Call call = this.topicSearchCall(q, page, limit, progressListener, progressRequestListener);
        return call;
    }

    public List<TopicResponse> topicSearch(String q, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<TopicResponse>> resp = this.topicSearchWithHttpInfo(q, page, limit);
        return resp.getData();
    }

    public ApiResponse<List<TopicResponse>> topicSearchWithHttpInfo(String q, Integer page, Integer limit) throws ApiException {
        Call call = this.topicSearchValidateBeforeCall(q, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<TopicResponse>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call topicSearchAsync(String q, Integer page, Integer limit, final ApiCallback<List<TopicResponse>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.topicSearchValidateBeforeCall(q, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<TopicResponse>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call userCurrentCheckSubscriptionCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/subscription".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/html"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call userCurrentCheckSubscriptionValidateBeforeCall(String owner, String repo, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling userCurrentCheckSubscription(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling userCurrentCheckSubscription(Async)");
        }
        Call call = this.userCurrentCheckSubscriptionCall(owner, repo, progressListener, progressRequestListener);
        return call;
    }

    public WatchInfo userCurrentCheckSubscription(String owner, String repo) throws ApiException {
        ApiResponse<WatchInfo> resp = this.userCurrentCheckSubscriptionWithHttpInfo(owner, repo);
        return resp.getData();
    }

    public ApiResponse<WatchInfo> userCurrentCheckSubscriptionWithHttpInfo(String owner, String repo) throws ApiException {
        Call call = this.userCurrentCheckSubscriptionValidateBeforeCall(owner, repo, null, null);
        Type localVarReturnType = new TypeToken<WatchInfo>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call userCurrentCheckSubscriptionAsync(String owner, String repo, final ApiCallback<WatchInfo> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.userCurrentCheckSubscriptionValidateBeforeCall(owner, repo, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WatchInfo>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call userCurrentDeleteSubscriptionCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/subscription".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/html"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call userCurrentDeleteSubscriptionValidateBeforeCall(String owner, String repo, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling userCurrentDeleteSubscription(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling userCurrentDeleteSubscription(Async)");
        }
        Call call = this.userCurrentDeleteSubscriptionCall(owner, repo, progressListener, progressRequestListener);
        return call;
    }

    public void userCurrentDeleteSubscription(String owner, String repo) throws ApiException {
        this.userCurrentDeleteSubscriptionWithHttpInfo(owner, repo);
    }

    public ApiResponse<Void> userCurrentDeleteSubscriptionWithHttpInfo(String owner, String repo) throws ApiException {
        Call call = this.userCurrentDeleteSubscriptionValidateBeforeCall(owner, repo, null, null);
        return this.apiClient.execute(call);
    }

    public Call userCurrentDeleteSubscriptionAsync(String owner, String repo, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.userCurrentDeleteSubscriptionValidateBeforeCall(owner, repo, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call userCurrentPutSubscriptionCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/subscription".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/html"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call userCurrentPutSubscriptionValidateBeforeCall(String owner, String repo, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling userCurrentPutSubscription(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling userCurrentPutSubscription(Async)");
        }
        Call call = this.userCurrentPutSubscriptionCall(owner, repo, progressListener, progressRequestListener);
        return call;
    }

    public WatchInfo userCurrentPutSubscription(String owner, String repo) throws ApiException {
        ApiResponse<WatchInfo> resp = this.userCurrentPutSubscriptionWithHttpInfo(owner, repo);
        return resp.getData();
    }

    public ApiResponse<WatchInfo> userCurrentPutSubscriptionWithHttpInfo(String owner, String repo) throws ApiException {
        Call call = this.userCurrentPutSubscriptionValidateBeforeCall(owner, repo, null, null);
        Type localVarReturnType = new TypeToken<WatchInfo>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call userCurrentPutSubscriptionAsync(String owner, String repo, final ApiCallback<WatchInfo> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.userCurrentPutSubscriptionValidateBeforeCall(owner, repo, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WatchInfo>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    @Deprecated
    public Call userTrackedTimesCall(String owner, String repo, String user, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/times/{user}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{user\\}", this.apiClient.escapeString(user.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @Deprecated
    private Call userTrackedTimesValidateBeforeCall(String owner, String repo, String user, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling userTrackedTimes(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling userTrackedTimes(Async)");
        }
        if (user == null) {
            throw new ApiException("Missing the required parameter 'user' when calling userTrackedTimes(Async)");
        }
        Call call = this.userTrackedTimesCall(owner, repo, user, progressListener, progressRequestListener);
        return call;
    }

    @Deprecated
    public List<TrackedTime> userTrackedTimes(String owner, String repo, String user) throws ApiException {
        ApiResponse<List<TrackedTime>> resp = this.userTrackedTimesWithHttpInfo(owner, repo, user);
        return resp.getData();
    }

    @Deprecated
    public ApiResponse<List<TrackedTime>> userTrackedTimesWithHttpInfo(String owner, String repo, String user) throws ApiException {
        Call call = this.userTrackedTimesValidateBeforeCall(owner, repo, user, null, null);
        Type localVarReturnType = new TypeToken<List<TrackedTime>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    @Deprecated
    public Call userTrackedTimesAsync(String owner, String repo, String user, final ApiCallback<List<TrackedTime>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.userTrackedTimesValidateBeforeCall(owner, repo, user, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<TrackedTime>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

