/*
 * Decompiled with CFR 0.152.
 */
package io.gitea.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.gitea.ApiCallback;
import io.gitea.ApiClient;
import io.gitea.ApiException;
import io.gitea.ApiResponse;
import io.gitea.Configuration;
import io.gitea.Pair;
import io.gitea.ProgressRequestBody;
import io.gitea.ProgressResponseBody;
import io.gitea.model.ModelPackage;
import io.gitea.model.PackageFile;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class PackageApi {
    private ApiClient apiClient;

    public PackageApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PackageApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call deletePackageCall(String owner, String type, String name, String version, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/packages/{owner}/{type}/{name}/{version}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{type\\}", this.apiClient.escapeString(type.toString())).replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString())).replaceAll("\\{version\\}", this.apiClient.escapeString(version.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/html"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deletePackageValidateBeforeCall(String owner, String type, String name, String version, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling deletePackage(Async)");
        }
        if (type == null) {
            throw new ApiException("Missing the required parameter 'type' when calling deletePackage(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deletePackage(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling deletePackage(Async)");
        }
        Call call = this.deletePackageCall(owner, type, name, version, progressListener, progressRequestListener);
        return call;
    }

    public void deletePackage(String owner, String type, String name, String version) throws ApiException {
        this.deletePackageWithHttpInfo(owner, type, name, version);
    }

    public ApiResponse<Void> deletePackageWithHttpInfo(String owner, String type, String name, String version) throws ApiException {
        Call call = this.deletePackageValidateBeforeCall(owner, type, name, version, null, null);
        return this.apiClient.execute(call);
    }

    public Call deletePackageAsync(String owner, String type, String name, String version, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deletePackageValidateBeforeCall(owner, type, name, version, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call getPackageCall(String owner, String type, String name, String version, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/packages/{owner}/{type}/{name}/{version}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{type\\}", this.apiClient.escapeString(type.toString())).replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString())).replaceAll("\\{version\\}", this.apiClient.escapeString(version.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getPackageValidateBeforeCall(String owner, String type, String name, String version, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling getPackage(Async)");
        }
        if (type == null) {
            throw new ApiException("Missing the required parameter 'type' when calling getPackage(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getPackage(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling getPackage(Async)");
        }
        Call call = this.getPackageCall(owner, type, name, version, progressListener, progressRequestListener);
        return call;
    }

    public ModelPackage getPackage(String owner, String type, String name, String version) throws ApiException {
        ApiResponse<ModelPackage> resp = this.getPackageWithHttpInfo(owner, type, name, version);
        return resp.getData();
    }

    public ApiResponse<ModelPackage> getPackageWithHttpInfo(String owner, String type, String name, String version) throws ApiException {
        Call call = this.getPackageValidateBeforeCall(owner, type, name, version, null, null);
        Type localVarReturnType = new TypeToken<ModelPackage>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getPackageAsync(String owner, String type, String name, String version, final ApiCallback<ModelPackage> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getPackageValidateBeforeCall(owner, type, name, version, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ModelPackage>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call listPackageFilesCall(String owner, String type, String name, String version, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/packages/{owner}/{type}/{name}/{version}/files".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{type\\}", this.apiClient.escapeString(type.toString())).replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString())).replaceAll("\\{version\\}", this.apiClient.escapeString(version.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call listPackageFilesValidateBeforeCall(String owner, String type, String name, String version, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling listPackageFiles(Async)");
        }
        if (type == null) {
            throw new ApiException("Missing the required parameter 'type' when calling listPackageFiles(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling listPackageFiles(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling listPackageFiles(Async)");
        }
        Call call = this.listPackageFilesCall(owner, type, name, version, progressListener, progressRequestListener);
        return call;
    }

    public List<PackageFile> listPackageFiles(String owner, String type, String name, String version) throws ApiException {
        ApiResponse<List<PackageFile>> resp = this.listPackageFilesWithHttpInfo(owner, type, name, version);
        return resp.getData();
    }

    public ApiResponse<List<PackageFile>> listPackageFilesWithHttpInfo(String owner, String type, String name, String version) throws ApiException {
        Call call = this.listPackageFilesValidateBeforeCall(owner, type, name, version, null, null);
        Type localVarReturnType = new TypeToken<List<PackageFile>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listPackageFilesAsync(String owner, String type, String name, String version, final ApiCallback<List<PackageFile>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listPackageFilesValidateBeforeCall(owner, type, name, version, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<PackageFile>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call listPackagesCall(String owner, Integer page, Integer limit, String type, String q, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/packages/{owner}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("type", type));
        }
        if (q != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("q", q));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call listPackagesValidateBeforeCall(String owner, Integer page, Integer limit, String type, String q, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling listPackages(Async)");
        }
        Call call = this.listPackagesCall(owner, page, limit, type, q, progressListener, progressRequestListener);
        return call;
    }

    public List<ModelPackage> listPackages(String owner, Integer page, Integer limit, String type, String q) throws ApiException {
        ApiResponse<List<ModelPackage>> resp = this.listPackagesWithHttpInfo(owner, page, limit, type, q);
        return resp.getData();
    }

    public ApiResponse<List<ModelPackage>> listPackagesWithHttpInfo(String owner, Integer page, Integer limit, String type, String q) throws ApiException {
        Call call = this.listPackagesValidateBeforeCall(owner, page, limit, type, q, null, null);
        Type localVarReturnType = new TypeToken<List<ModelPackage>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listPackagesAsync(String owner, Integer page, Integer limit, String type, String q, final ApiCallback<List<ModelPackage>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listPackagesValidateBeforeCall(owner, page, limit, type, q, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<ModelPackage>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

