/*
 * Decompiled with CFR 0.152.
 */
package io.gitea.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.gitea.ApiCallback;
import io.gitea.ApiClient;
import io.gitea.ApiException;
import io.gitea.ApiResponse;
import io.gitea.Configuration;
import io.gitea.Pair;
import io.gitea.ProgressRequestBody;
import io.gitea.ProgressResponseBody;
import io.gitea.model.NotificationCount;
import io.gitea.model.NotificationThread;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.threeten.bp.OffsetDateTime;

public class NotificationApi {
    private ApiClient apiClient;

    public NotificationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public NotificationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call notifyGetListCall(Boolean all, List<String> statusTypes, List<String> subjectType, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/notifications";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (all != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("all", all));
        }
        if (statusTypes != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "status-types", statusTypes));
        }
        if (subjectType != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "subject-type", subjectType));
        }
        if (since != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("since", since));
        }
        if (before != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("before", before));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call notifyGetListValidateBeforeCall(Boolean all, List<String> statusTypes, List<String> subjectType, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.notifyGetListCall(all, statusTypes, subjectType, since, before, page, limit, progressListener, progressRequestListener);
        return call;
    }

    public List<NotificationThread> notifyGetList(Boolean all, List<String> statusTypes, List<String> subjectType, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<NotificationThread>> resp = this.notifyGetListWithHttpInfo(all, statusTypes, subjectType, since, before, page, limit);
        return resp.getData();
    }

    public ApiResponse<List<NotificationThread>> notifyGetListWithHttpInfo(Boolean all, List<String> statusTypes, List<String> subjectType, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit) throws ApiException {
        Call call = this.notifyGetListValidateBeforeCall(all, statusTypes, subjectType, since, before, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<NotificationThread>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call notifyGetListAsync(Boolean all, List<String> statusTypes, List<String> subjectType, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit, final ApiCallback<List<NotificationThread>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.notifyGetListValidateBeforeCall(all, statusTypes, subjectType, since, before, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<NotificationThread>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call notifyGetRepoListCall(String owner, String repo, Boolean all, List<String> statusTypes, List<String> subjectType, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/notifications".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (all != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("all", all));
        }
        if (statusTypes != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "status-types", statusTypes));
        }
        if (subjectType != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "subject-type", subjectType));
        }
        if (since != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("since", since));
        }
        if (before != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("before", before));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call notifyGetRepoListValidateBeforeCall(String owner, String repo, Boolean all, List<String> statusTypes, List<String> subjectType, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling notifyGetRepoList(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling notifyGetRepoList(Async)");
        }
        Call call = this.notifyGetRepoListCall(owner, repo, all, statusTypes, subjectType, since, before, page, limit, progressListener, progressRequestListener);
        return call;
    }

    public List<NotificationThread> notifyGetRepoList(String owner, String repo, Boolean all, List<String> statusTypes, List<String> subjectType, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<NotificationThread>> resp = this.notifyGetRepoListWithHttpInfo(owner, repo, all, statusTypes, subjectType, since, before, page, limit);
        return resp.getData();
    }

    public ApiResponse<List<NotificationThread>> notifyGetRepoListWithHttpInfo(String owner, String repo, Boolean all, List<String> statusTypes, List<String> subjectType, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit) throws ApiException {
        Call call = this.notifyGetRepoListValidateBeforeCall(owner, repo, all, statusTypes, subjectType, since, before, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<NotificationThread>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call notifyGetRepoListAsync(String owner, String repo, Boolean all, List<String> statusTypes, List<String> subjectType, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit, final ApiCallback<List<NotificationThread>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.notifyGetRepoListValidateBeforeCall(owner, repo, all, statusTypes, subjectType, since, before, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<NotificationThread>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call notifyGetThreadCall(String id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/notifications/threads/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call notifyGetThreadValidateBeforeCall(String id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling notifyGetThread(Async)");
        }
        Call call = this.notifyGetThreadCall(id, progressListener, progressRequestListener);
        return call;
    }

    public NotificationThread notifyGetThread(String id) throws ApiException {
        ApiResponse<NotificationThread> resp = this.notifyGetThreadWithHttpInfo(id);
        return resp.getData();
    }

    public ApiResponse<NotificationThread> notifyGetThreadWithHttpInfo(String id) throws ApiException {
        Call call = this.notifyGetThreadValidateBeforeCall(id, null, null);
        Type localVarReturnType = new TypeToken<NotificationThread>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call notifyGetThreadAsync(String id, final ApiCallback<NotificationThread> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.notifyGetThreadValidateBeforeCall(id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<NotificationThread>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call notifyNewAvailableCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/notifications/new";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/html"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call notifyNewAvailableValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.notifyNewAvailableCall(progressListener, progressRequestListener);
        return call;
    }

    public NotificationCount notifyNewAvailable() throws ApiException {
        ApiResponse<NotificationCount> resp = this.notifyNewAvailableWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<NotificationCount> notifyNewAvailableWithHttpInfo() throws ApiException {
        Call call = this.notifyNewAvailableValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<NotificationCount>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call notifyNewAvailableAsync(final ApiCallback<NotificationCount> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.notifyNewAvailableValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<NotificationCount>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call notifyReadListCall(OffsetDateTime lastReadAt, String all, List<String> statusTypes, String toStatus, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/notifications";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (lastReadAt != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("last_read_at", lastReadAt));
        }
        if (all != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("all", all));
        }
        if (statusTypes != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "status-types", statusTypes));
        }
        if (toStatus != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("to-status", toStatus));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call notifyReadListValidateBeforeCall(OffsetDateTime lastReadAt, String all, List<String> statusTypes, String toStatus, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.notifyReadListCall(lastReadAt, all, statusTypes, toStatus, progressListener, progressRequestListener);
        return call;
    }

    public List<NotificationThread> notifyReadList(OffsetDateTime lastReadAt, String all, List<String> statusTypes, String toStatus) throws ApiException {
        ApiResponse<List<NotificationThread>> resp = this.notifyReadListWithHttpInfo(lastReadAt, all, statusTypes, toStatus);
        return resp.getData();
    }

    public ApiResponse<List<NotificationThread>> notifyReadListWithHttpInfo(OffsetDateTime lastReadAt, String all, List<String> statusTypes, String toStatus) throws ApiException {
        Call call = this.notifyReadListValidateBeforeCall(lastReadAt, all, statusTypes, toStatus, null, null);
        Type localVarReturnType = new TypeToken<List<NotificationThread>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call notifyReadListAsync(OffsetDateTime lastReadAt, String all, List<String> statusTypes, String toStatus, final ApiCallback<List<NotificationThread>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.notifyReadListValidateBeforeCall(lastReadAt, all, statusTypes, toStatus, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<NotificationThread>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call notifyReadRepoListCall(String owner, String repo, String all, List<String> statusTypes, String toStatus, OffsetDateTime lastReadAt, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/notifications".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (all != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("all", all));
        }
        if (statusTypes != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "status-types", statusTypes));
        }
        if (toStatus != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("to-status", toStatus));
        }
        if (lastReadAt != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("last_read_at", lastReadAt));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call notifyReadRepoListValidateBeforeCall(String owner, String repo, String all, List<String> statusTypes, String toStatus, OffsetDateTime lastReadAt, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling notifyReadRepoList(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling notifyReadRepoList(Async)");
        }
        Call call = this.notifyReadRepoListCall(owner, repo, all, statusTypes, toStatus, lastReadAt, progressListener, progressRequestListener);
        return call;
    }

    public List<NotificationThread> notifyReadRepoList(String owner, String repo, String all, List<String> statusTypes, String toStatus, OffsetDateTime lastReadAt) throws ApiException {
        ApiResponse<List<NotificationThread>> resp = this.notifyReadRepoListWithHttpInfo(owner, repo, all, statusTypes, toStatus, lastReadAt);
        return resp.getData();
    }

    public ApiResponse<List<NotificationThread>> notifyReadRepoListWithHttpInfo(String owner, String repo, String all, List<String> statusTypes, String toStatus, OffsetDateTime lastReadAt) throws ApiException {
        Call call = this.notifyReadRepoListValidateBeforeCall(owner, repo, all, statusTypes, toStatus, lastReadAt, null, null);
        Type localVarReturnType = new TypeToken<List<NotificationThread>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call notifyReadRepoListAsync(String owner, String repo, String all, List<String> statusTypes, String toStatus, OffsetDateTime lastReadAt, final ApiCallback<List<NotificationThread>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.notifyReadRepoListValidateBeforeCall(owner, repo, all, statusTypes, toStatus, lastReadAt, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<NotificationThread>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call notifyReadThreadCall(String id, String toStatus, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/notifications/threads/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (toStatus != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("to-status", toStatus));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call notifyReadThreadValidateBeforeCall(String id, String toStatus, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling notifyReadThread(Async)");
        }
        Call call = this.notifyReadThreadCall(id, toStatus, progressListener, progressRequestListener);
        return call;
    }

    public NotificationThread notifyReadThread(String id, String toStatus) throws ApiException {
        ApiResponse<NotificationThread> resp = this.notifyReadThreadWithHttpInfo(id, toStatus);
        return resp.getData();
    }

    public ApiResponse<NotificationThread> notifyReadThreadWithHttpInfo(String id, String toStatus) throws ApiException {
        Call call = this.notifyReadThreadValidateBeforeCall(id, toStatus, null, null);
        Type localVarReturnType = new TypeToken<NotificationThread>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call notifyReadThreadAsync(String id, String toStatus, final ApiCallback<NotificationThread> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.notifyReadThreadValidateBeforeCall(id, toStatus, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<NotificationThread>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

