/*
 * Decompiled with CFR 0.152.
 */
package io.gitea.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.gitea.ApiCallback;
import io.gitea.ApiClient;
import io.gitea.ApiException;
import io.gitea.ApiResponse;
import io.gitea.Configuration;
import io.gitea.Pair;
import io.gitea.ProgressRequestBody;
import io.gitea.ProgressResponseBody;
import io.gitea.model.AddTimeOption;
import io.gitea.model.Comment;
import io.gitea.model.CreateIssueCommentOption;
import io.gitea.model.CreateIssueOption;
import io.gitea.model.CreateLabelOption;
import io.gitea.model.CreateMilestoneOption;
import io.gitea.model.EditDeadlineOption;
import io.gitea.model.EditIssueCommentOption;
import io.gitea.model.EditIssueOption;
import io.gitea.model.EditLabelOption;
import io.gitea.model.EditMilestoneOption;
import io.gitea.model.EditReactionOption;
import io.gitea.model.Issue;
import io.gitea.model.IssueDeadline;
import io.gitea.model.IssueLabelsOption;
import io.gitea.model.Label;
import io.gitea.model.Milestone;
import io.gitea.model.Reaction;
import io.gitea.model.TimelineComment;
import io.gitea.model.TrackedTime;
import io.gitea.model.User;
import io.gitea.model.WatchInfo;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.threeten.bp.OffsetDateTime;

public class IssueApi {
    private ApiClient apiClient;

    public IssueApi() {
        this(Configuration.getDefaultApiClient());
    }

    public IssueApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call issueAddLabelCall(String owner, String repo, Long index, IssueLabelsOption body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        IssueLabelsOption localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/labels".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issueAddLabelValidateBeforeCall(String owner, String repo, Long index, IssueLabelsOption body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueAddLabel(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueAddLabel(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueAddLabel(Async)");
        }
        Call call = this.issueAddLabelCall(owner, repo, index, body, progressListener, progressRequestListener);
        return call;
    }

    public List<Label> issueAddLabel(String owner, String repo, Long index, IssueLabelsOption body) throws ApiException {
        ApiResponse<List<Label>> resp = this.issueAddLabelWithHttpInfo(owner, repo, index, body);
        return resp.getData();
    }

    public ApiResponse<List<Label>> issueAddLabelWithHttpInfo(String owner, String repo, Long index, IssueLabelsOption body) throws ApiException {
        Call call = this.issueAddLabelValidateBeforeCall(owner, repo, index, body, null, null);
        Type localVarReturnType = new TypeToken<List<Label>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call issueAddLabelAsync(String owner, String repo, Long index, IssueLabelsOption body, final ApiCallback<List<Label>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueAddLabelValidateBeforeCall(owner, repo, index, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Label>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call issueAddSubscriptionCall(String owner, String repo, Long index, String user, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/subscriptions/{user}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString())).replaceAll("\\{user\\}", this.apiClient.escapeString(user.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issueAddSubscriptionValidateBeforeCall(String owner, String repo, Long index, String user, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueAddSubscription(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueAddSubscription(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueAddSubscription(Async)");
        }
        if (user == null) {
            throw new ApiException("Missing the required parameter 'user' when calling issueAddSubscription(Async)");
        }
        Call call = this.issueAddSubscriptionCall(owner, repo, index, user, progressListener, progressRequestListener);
        return call;
    }

    public void issueAddSubscription(String owner, String repo, Long index, String user) throws ApiException {
        this.issueAddSubscriptionWithHttpInfo(owner, repo, index, user);
    }

    public ApiResponse<Void> issueAddSubscriptionWithHttpInfo(String owner, String repo, Long index, String user) throws ApiException {
        Call call = this.issueAddSubscriptionValidateBeforeCall(owner, repo, index, user, null, null);
        return this.apiClient.execute(call);
    }

    public Call issueAddSubscriptionAsync(String owner, String repo, Long index, String user, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueAddSubscriptionValidateBeforeCall(owner, repo, index, user, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call issueAddTimeCall(String owner, String repo, Long index, AddTimeOption body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        AddTimeOption localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/times".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issueAddTimeValidateBeforeCall(String owner, String repo, Long index, AddTimeOption body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueAddTime(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueAddTime(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueAddTime(Async)");
        }
        Call call = this.issueAddTimeCall(owner, repo, index, body, progressListener, progressRequestListener);
        return call;
    }

    public TrackedTime issueAddTime(String owner, String repo, Long index, AddTimeOption body) throws ApiException {
        ApiResponse<TrackedTime> resp = this.issueAddTimeWithHttpInfo(owner, repo, index, body);
        return resp.getData();
    }

    public ApiResponse<TrackedTime> issueAddTimeWithHttpInfo(String owner, String repo, Long index, AddTimeOption body) throws ApiException {
        Call call = this.issueAddTimeValidateBeforeCall(owner, repo, index, body, null, null);
        Type localVarReturnType = new TypeToken<TrackedTime>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call issueAddTimeAsync(String owner, String repo, Long index, AddTimeOption body, final ApiCallback<TrackedTime> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueAddTimeValidateBeforeCall(owner, repo, index, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TrackedTime>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call issueCheckSubscriptionCall(String owner, String repo, Long index, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/subscriptions/check".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issueCheckSubscriptionValidateBeforeCall(String owner, String repo, Long index, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueCheckSubscription(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueCheckSubscription(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueCheckSubscription(Async)");
        }
        Call call = this.issueCheckSubscriptionCall(owner, repo, index, progressListener, progressRequestListener);
        return call;
    }

    public WatchInfo issueCheckSubscription(String owner, String repo, Long index) throws ApiException {
        ApiResponse<WatchInfo> resp = this.issueCheckSubscriptionWithHttpInfo(owner, repo, index);
        return resp.getData();
    }

    public ApiResponse<WatchInfo> issueCheckSubscriptionWithHttpInfo(String owner, String repo, Long index) throws ApiException {
        Call call = this.issueCheckSubscriptionValidateBeforeCall(owner, repo, index, null, null);
        Type localVarReturnType = new TypeToken<WatchInfo>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call issueCheckSubscriptionAsync(String owner, String repo, Long index, final ApiCallback<WatchInfo> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueCheckSubscriptionValidateBeforeCall(owner, repo, index, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WatchInfo>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call issueClearLabelsCall(String owner, String repo, Long index, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/labels".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issueClearLabelsValidateBeforeCall(String owner, String repo, Long index, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueClearLabels(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueClearLabels(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueClearLabels(Async)");
        }
        Call call = this.issueClearLabelsCall(owner, repo, index, progressListener, progressRequestListener);
        return call;
    }

    public void issueClearLabels(String owner, String repo, Long index) throws ApiException {
        this.issueClearLabelsWithHttpInfo(owner, repo, index);
    }

    public ApiResponse<Void> issueClearLabelsWithHttpInfo(String owner, String repo, Long index) throws ApiException {
        Call call = this.issueClearLabelsValidateBeforeCall(owner, repo, index, null, null);
        return this.apiClient.execute(call);
    }

    public Call issueClearLabelsAsync(String owner, String repo, Long index, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueClearLabelsValidateBeforeCall(owner, repo, index, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call issueCreateCommentCall(String owner, String repo, Long index, CreateIssueCommentOption body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateIssueCommentOption localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/comments".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issueCreateCommentValidateBeforeCall(String owner, String repo, Long index, CreateIssueCommentOption body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueCreateComment(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueCreateComment(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueCreateComment(Async)");
        }
        Call call = this.issueCreateCommentCall(owner, repo, index, body, progressListener, progressRequestListener);
        return call;
    }

    public Comment issueCreateComment(String owner, String repo, Long index, CreateIssueCommentOption body) throws ApiException {
        ApiResponse<Comment> resp = this.issueCreateCommentWithHttpInfo(owner, repo, index, body);
        return resp.getData();
    }

    public ApiResponse<Comment> issueCreateCommentWithHttpInfo(String owner, String repo, Long index, CreateIssueCommentOption body) throws ApiException {
        Call call = this.issueCreateCommentValidateBeforeCall(owner, repo, index, body, null, null);
        Type localVarReturnType = new TypeToken<Comment>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call issueCreateCommentAsync(String owner, String repo, Long index, CreateIssueCommentOption body, final ApiCallback<Comment> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueCreateCommentValidateBeforeCall(owner, repo, index, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Comment>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call issueCreateIssueCall(String owner, String repo, CreateIssueOption body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateIssueOption localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}/issues".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issueCreateIssueValidateBeforeCall(String owner, String repo, CreateIssueOption body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueCreateIssue(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueCreateIssue(Async)");
        }
        Call call = this.issueCreateIssueCall(owner, repo, body, progressListener, progressRequestListener);
        return call;
    }

    public Issue issueCreateIssue(String owner, String repo, CreateIssueOption body) throws ApiException {
        ApiResponse<Issue> resp = this.issueCreateIssueWithHttpInfo(owner, repo, body);
        return resp.getData();
    }

    public ApiResponse<Issue> issueCreateIssueWithHttpInfo(String owner, String repo, CreateIssueOption body) throws ApiException {
        Call call = this.issueCreateIssueValidateBeforeCall(owner, repo, body, null, null);
        Type localVarReturnType = new TypeToken<Issue>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call issueCreateIssueAsync(String owner, String repo, CreateIssueOption body, final ApiCallback<Issue> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueCreateIssueValidateBeforeCall(owner, repo, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Issue>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call issueCreateLabelCall(String owner, String repo, CreateLabelOption body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateLabelOption localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}/labels".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issueCreateLabelValidateBeforeCall(String owner, String repo, CreateLabelOption body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueCreateLabel(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueCreateLabel(Async)");
        }
        Call call = this.issueCreateLabelCall(owner, repo, body, progressListener, progressRequestListener);
        return call;
    }

    public Label issueCreateLabel(String owner, String repo, CreateLabelOption body) throws ApiException {
        ApiResponse<Label> resp = this.issueCreateLabelWithHttpInfo(owner, repo, body);
        return resp.getData();
    }

    public ApiResponse<Label> issueCreateLabelWithHttpInfo(String owner, String repo, CreateLabelOption body) throws ApiException {
        Call call = this.issueCreateLabelValidateBeforeCall(owner, repo, body, null, null);
        Type localVarReturnType = new TypeToken<Label>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call issueCreateLabelAsync(String owner, String repo, CreateLabelOption body, final ApiCallback<Label> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueCreateLabelValidateBeforeCall(owner, repo, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Label>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call issueCreateMilestoneCall(String owner, String repo, CreateMilestoneOption body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateMilestoneOption localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}/milestones".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issueCreateMilestoneValidateBeforeCall(String owner, String repo, CreateMilestoneOption body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueCreateMilestone(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueCreateMilestone(Async)");
        }
        Call call = this.issueCreateMilestoneCall(owner, repo, body, progressListener, progressRequestListener);
        return call;
    }

    public Milestone issueCreateMilestone(String owner, String repo, CreateMilestoneOption body) throws ApiException {
        ApiResponse<Milestone> resp = this.issueCreateMilestoneWithHttpInfo(owner, repo, body);
        return resp.getData();
    }

    public ApiResponse<Milestone> issueCreateMilestoneWithHttpInfo(String owner, String repo, CreateMilestoneOption body) throws ApiException {
        Call call = this.issueCreateMilestoneValidateBeforeCall(owner, repo, body, null, null);
        Type localVarReturnType = new TypeToken<Milestone>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call issueCreateMilestoneAsync(String owner, String repo, CreateMilestoneOption body, final ApiCallback<Milestone> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueCreateMilestoneValidateBeforeCall(owner, repo, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Milestone>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call issueDeleteCall(String owner, String repo, Long index, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/html"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issueDeleteValidateBeforeCall(String owner, String repo, Long index, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueDelete(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueDelete(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueDelete(Async)");
        }
        Call call = this.issueDeleteCall(owner, repo, index, progressListener, progressRequestListener);
        return call;
    }

    public void issueDelete(String owner, String repo, Long index) throws ApiException {
        this.issueDeleteWithHttpInfo(owner, repo, index);
    }

    public ApiResponse<Void> issueDeleteWithHttpInfo(String owner, String repo, Long index) throws ApiException {
        Call call = this.issueDeleteValidateBeforeCall(owner, repo, index, null, null);
        return this.apiClient.execute(call);
    }

    public Call issueDeleteAsync(String owner, String repo, Long index, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueDeleteValidateBeforeCall(owner, repo, index, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call issueDeleteCommentCall(String owner, String repo, Long id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/issues/comments/{id}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/html"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issueDeleteCommentValidateBeforeCall(String owner, String repo, Long id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueDeleteComment(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueDeleteComment(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling issueDeleteComment(Async)");
        }
        Call call = this.issueDeleteCommentCall(owner, repo, id, progressListener, progressRequestListener);
        return call;
    }

    public void issueDeleteComment(String owner, String repo, Long id) throws ApiException {
        this.issueDeleteCommentWithHttpInfo(owner, repo, id);
    }

    public ApiResponse<Void> issueDeleteCommentWithHttpInfo(String owner, String repo, Long id) throws ApiException {
        Call call = this.issueDeleteCommentValidateBeforeCall(owner, repo, id, null, null);
        return this.apiClient.execute(call);
    }

    public Call issueDeleteCommentAsync(String owner, String repo, Long id, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueDeleteCommentValidateBeforeCall(owner, repo, id, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    @Deprecated
    public Call issueDeleteCommentDeprecatedCall(String owner, String repo, Integer index, Long id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/comments/{id}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/html"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @Deprecated
    private Call issueDeleteCommentDeprecatedValidateBeforeCall(String owner, String repo, Integer index, Long id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueDeleteCommentDeprecated(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueDeleteCommentDeprecated(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueDeleteCommentDeprecated(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling issueDeleteCommentDeprecated(Async)");
        }
        Call call = this.issueDeleteCommentDeprecatedCall(owner, repo, index, id, progressListener, progressRequestListener);
        return call;
    }

    @Deprecated
    public void issueDeleteCommentDeprecated(String owner, String repo, Integer index, Long id) throws ApiException {
        this.issueDeleteCommentDeprecatedWithHttpInfo(owner, repo, index, id);
    }

    @Deprecated
    public ApiResponse<Void> issueDeleteCommentDeprecatedWithHttpInfo(String owner, String repo, Integer index, Long id) throws ApiException {
        Call call = this.issueDeleteCommentDeprecatedValidateBeforeCall(owner, repo, index, id, null, null);
        return this.apiClient.execute(call);
    }

    @Deprecated
    public Call issueDeleteCommentDeprecatedAsync(String owner, String repo, Integer index, Long id, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueDeleteCommentDeprecatedValidateBeforeCall(owner, repo, index, id, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call issueDeleteCommentReactionCall(String owner, String repo, Long id, EditReactionOption content, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        EditReactionOption localVarPostBody = content;
        String localVarPath = "/repos/{owner}/{repo}/issues/comments/{id}/reactions".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issueDeleteCommentReactionValidateBeforeCall(String owner, String repo, Long id, EditReactionOption content, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueDeleteCommentReaction(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueDeleteCommentReaction(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling issueDeleteCommentReaction(Async)");
        }
        Call call = this.issueDeleteCommentReactionCall(owner, repo, id, content, progressListener, progressRequestListener);
        return call;
    }

    public void issueDeleteCommentReaction(String owner, String repo, Long id, EditReactionOption content) throws ApiException {
        this.issueDeleteCommentReactionWithHttpInfo(owner, repo, id, content);
    }

    public ApiResponse<Void> issueDeleteCommentReactionWithHttpInfo(String owner, String repo, Long id, EditReactionOption content) throws ApiException {
        Call call = this.issueDeleteCommentReactionValidateBeforeCall(owner, repo, id, content, null, null);
        return this.apiClient.execute(call);
    }

    public Call issueDeleteCommentReactionAsync(String owner, String repo, Long id, EditReactionOption content, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueDeleteCommentReactionValidateBeforeCall(owner, repo, id, content, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call issueDeleteIssueReactionCall(String owner, String repo, Long index, EditReactionOption content, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        EditReactionOption localVarPostBody = content;
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/reactions".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issueDeleteIssueReactionValidateBeforeCall(String owner, String repo, Long index, EditReactionOption content, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueDeleteIssueReaction(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueDeleteIssueReaction(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueDeleteIssueReaction(Async)");
        }
        Call call = this.issueDeleteIssueReactionCall(owner, repo, index, content, progressListener, progressRequestListener);
        return call;
    }

    public void issueDeleteIssueReaction(String owner, String repo, Long index, EditReactionOption content) throws ApiException {
        this.issueDeleteIssueReactionWithHttpInfo(owner, repo, index, content);
    }

    public ApiResponse<Void> issueDeleteIssueReactionWithHttpInfo(String owner, String repo, Long index, EditReactionOption content) throws ApiException {
        Call call = this.issueDeleteIssueReactionValidateBeforeCall(owner, repo, index, content, null, null);
        return this.apiClient.execute(call);
    }

    public Call issueDeleteIssueReactionAsync(String owner, String repo, Long index, EditReactionOption content, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueDeleteIssueReactionValidateBeforeCall(owner, repo, index, content, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call issueDeleteLabelCall(String owner, String repo, Long id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/labels/{id}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/html"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issueDeleteLabelValidateBeforeCall(String owner, String repo, Long id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueDeleteLabel(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueDeleteLabel(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling issueDeleteLabel(Async)");
        }
        Call call = this.issueDeleteLabelCall(owner, repo, id, progressListener, progressRequestListener);
        return call;
    }

    public void issueDeleteLabel(String owner, String repo, Long id) throws ApiException {
        this.issueDeleteLabelWithHttpInfo(owner, repo, id);
    }

    public ApiResponse<Void> issueDeleteLabelWithHttpInfo(String owner, String repo, Long id) throws ApiException {
        Call call = this.issueDeleteLabelValidateBeforeCall(owner, repo, id, null, null);
        return this.apiClient.execute(call);
    }

    public Call issueDeleteLabelAsync(String owner, String repo, Long id, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueDeleteLabelValidateBeforeCall(owner, repo, id, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call issueDeleteMilestoneCall(String owner, String repo, String id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/milestones/{id}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/html"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issueDeleteMilestoneValidateBeforeCall(String owner, String repo, String id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueDeleteMilestone(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueDeleteMilestone(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling issueDeleteMilestone(Async)");
        }
        Call call = this.issueDeleteMilestoneCall(owner, repo, id, progressListener, progressRequestListener);
        return call;
    }

    public void issueDeleteMilestone(String owner, String repo, String id) throws ApiException {
        this.issueDeleteMilestoneWithHttpInfo(owner, repo, id);
    }

    public ApiResponse<Void> issueDeleteMilestoneWithHttpInfo(String owner, String repo, String id) throws ApiException {
        Call call = this.issueDeleteMilestoneValidateBeforeCall(owner, repo, id, null, null);
        return this.apiClient.execute(call);
    }

    public Call issueDeleteMilestoneAsync(String owner, String repo, String id, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueDeleteMilestoneValidateBeforeCall(owner, repo, id, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call issueDeleteStopWatchCall(String owner, String repo, Long index, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/stopwatch/delete".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issueDeleteStopWatchValidateBeforeCall(String owner, String repo, Long index, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueDeleteStopWatch(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueDeleteStopWatch(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueDeleteStopWatch(Async)");
        }
        Call call = this.issueDeleteStopWatchCall(owner, repo, index, progressListener, progressRequestListener);
        return call;
    }

    public void issueDeleteStopWatch(String owner, String repo, Long index) throws ApiException {
        this.issueDeleteStopWatchWithHttpInfo(owner, repo, index);
    }

    public ApiResponse<Void> issueDeleteStopWatchWithHttpInfo(String owner, String repo, Long index) throws ApiException {
        Call call = this.issueDeleteStopWatchValidateBeforeCall(owner, repo, index, null, null);
        return this.apiClient.execute(call);
    }

    public Call issueDeleteStopWatchAsync(String owner, String repo, Long index, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueDeleteStopWatchValidateBeforeCall(owner, repo, index, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call issueDeleteSubscriptionCall(String owner, String repo, Long index, String user, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/subscriptions/{user}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString())).replaceAll("\\{user\\}", this.apiClient.escapeString(user.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issueDeleteSubscriptionValidateBeforeCall(String owner, String repo, Long index, String user, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueDeleteSubscription(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueDeleteSubscription(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueDeleteSubscription(Async)");
        }
        if (user == null) {
            throw new ApiException("Missing the required parameter 'user' when calling issueDeleteSubscription(Async)");
        }
        Call call = this.issueDeleteSubscriptionCall(owner, repo, index, user, progressListener, progressRequestListener);
        return call;
    }

    public void issueDeleteSubscription(String owner, String repo, Long index, String user) throws ApiException {
        this.issueDeleteSubscriptionWithHttpInfo(owner, repo, index, user);
    }

    public ApiResponse<Void> issueDeleteSubscriptionWithHttpInfo(String owner, String repo, Long index, String user) throws ApiException {
        Call call = this.issueDeleteSubscriptionValidateBeforeCall(owner, repo, index, user, null, null);
        return this.apiClient.execute(call);
    }

    public Call issueDeleteSubscriptionAsync(String owner, String repo, Long index, String user, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueDeleteSubscriptionValidateBeforeCall(owner, repo, index, user, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call issueDeleteTimeCall(String owner, String repo, Long index, Long id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/times/{id}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issueDeleteTimeValidateBeforeCall(String owner, String repo, Long index, Long id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueDeleteTime(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueDeleteTime(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueDeleteTime(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling issueDeleteTime(Async)");
        }
        Call call = this.issueDeleteTimeCall(owner, repo, index, id, progressListener, progressRequestListener);
        return call;
    }

    public void issueDeleteTime(String owner, String repo, Long index, Long id) throws ApiException {
        this.issueDeleteTimeWithHttpInfo(owner, repo, index, id);
    }

    public ApiResponse<Void> issueDeleteTimeWithHttpInfo(String owner, String repo, Long index, Long id) throws ApiException {
        Call call = this.issueDeleteTimeValidateBeforeCall(owner, repo, index, id, null, null);
        return this.apiClient.execute(call);
    }

    public Call issueDeleteTimeAsync(String owner, String repo, Long index, Long id, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueDeleteTimeValidateBeforeCall(owner, repo, index, id, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call issueEditCommentCall(String owner, String repo, Long id, EditIssueCommentOption body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        EditIssueCommentOption localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}/issues/comments/{id}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issueEditCommentValidateBeforeCall(String owner, String repo, Long id, EditIssueCommentOption body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueEditComment(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueEditComment(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling issueEditComment(Async)");
        }
        Call call = this.issueEditCommentCall(owner, repo, id, body, progressListener, progressRequestListener);
        return call;
    }

    public Comment issueEditComment(String owner, String repo, Long id, EditIssueCommentOption body) throws ApiException {
        ApiResponse<Comment> resp = this.issueEditCommentWithHttpInfo(owner, repo, id, body);
        return resp.getData();
    }

    public ApiResponse<Comment> issueEditCommentWithHttpInfo(String owner, String repo, Long id, EditIssueCommentOption body) throws ApiException {
        Call call = this.issueEditCommentValidateBeforeCall(owner, repo, id, body, null, null);
        Type localVarReturnType = new TypeToken<Comment>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call issueEditCommentAsync(String owner, String repo, Long id, EditIssueCommentOption body, final ApiCallback<Comment> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueEditCommentValidateBeforeCall(owner, repo, id, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Comment>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    @Deprecated
    public Call issueEditCommentDeprecatedCall(String owner, String repo, Integer index, Long id, EditIssueCommentOption body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        EditIssueCommentOption localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/comments/{id}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @Deprecated
    private Call issueEditCommentDeprecatedValidateBeforeCall(String owner, String repo, Integer index, Long id, EditIssueCommentOption body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueEditCommentDeprecated(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueEditCommentDeprecated(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueEditCommentDeprecated(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling issueEditCommentDeprecated(Async)");
        }
        Call call = this.issueEditCommentDeprecatedCall(owner, repo, index, id, body, progressListener, progressRequestListener);
        return call;
    }

    @Deprecated
    public Comment issueEditCommentDeprecated(String owner, String repo, Integer index, Long id, EditIssueCommentOption body) throws ApiException {
        ApiResponse<Comment> resp = this.issueEditCommentDeprecatedWithHttpInfo(owner, repo, index, id, body);
        return resp.getData();
    }

    @Deprecated
    public ApiResponse<Comment> issueEditCommentDeprecatedWithHttpInfo(String owner, String repo, Integer index, Long id, EditIssueCommentOption body) throws ApiException {
        Call call = this.issueEditCommentDeprecatedValidateBeforeCall(owner, repo, index, id, body, null, null);
        Type localVarReturnType = new TypeToken<Comment>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    @Deprecated
    public Call issueEditCommentDeprecatedAsync(String owner, String repo, Integer index, Long id, EditIssueCommentOption body, final ApiCallback<Comment> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueEditCommentDeprecatedValidateBeforeCall(owner, repo, index, id, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Comment>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call issueEditIssueCall(String owner, String repo, Long index, EditIssueOption body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        EditIssueOption localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issueEditIssueValidateBeforeCall(String owner, String repo, Long index, EditIssueOption body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueEditIssue(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueEditIssue(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueEditIssue(Async)");
        }
        Call call = this.issueEditIssueCall(owner, repo, index, body, progressListener, progressRequestListener);
        return call;
    }

    public Issue issueEditIssue(String owner, String repo, Long index, EditIssueOption body) throws ApiException {
        ApiResponse<Issue> resp = this.issueEditIssueWithHttpInfo(owner, repo, index, body);
        return resp.getData();
    }

    public ApiResponse<Issue> issueEditIssueWithHttpInfo(String owner, String repo, Long index, EditIssueOption body) throws ApiException {
        Call call = this.issueEditIssueValidateBeforeCall(owner, repo, index, body, null, null);
        Type localVarReturnType = new TypeToken<Issue>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call issueEditIssueAsync(String owner, String repo, Long index, EditIssueOption body, final ApiCallback<Issue> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueEditIssueValidateBeforeCall(owner, repo, index, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Issue>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call issueEditIssueDeadlineCall(String owner, String repo, Long index, EditDeadlineOption body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        EditDeadlineOption localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/deadline".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issueEditIssueDeadlineValidateBeforeCall(String owner, String repo, Long index, EditDeadlineOption body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueEditIssueDeadline(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueEditIssueDeadline(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueEditIssueDeadline(Async)");
        }
        Call call = this.issueEditIssueDeadlineCall(owner, repo, index, body, progressListener, progressRequestListener);
        return call;
    }

    public IssueDeadline issueEditIssueDeadline(String owner, String repo, Long index, EditDeadlineOption body) throws ApiException {
        ApiResponse<IssueDeadline> resp = this.issueEditIssueDeadlineWithHttpInfo(owner, repo, index, body);
        return resp.getData();
    }

    public ApiResponse<IssueDeadline> issueEditIssueDeadlineWithHttpInfo(String owner, String repo, Long index, EditDeadlineOption body) throws ApiException {
        Call call = this.issueEditIssueDeadlineValidateBeforeCall(owner, repo, index, body, null, null);
        Type localVarReturnType = new TypeToken<IssueDeadline>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call issueEditIssueDeadlineAsync(String owner, String repo, Long index, EditDeadlineOption body, final ApiCallback<IssueDeadline> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueEditIssueDeadlineValidateBeforeCall(owner, repo, index, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<IssueDeadline>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call issueEditLabelCall(String owner, String repo, Long id, EditLabelOption body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        EditLabelOption localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}/labels/{id}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issueEditLabelValidateBeforeCall(String owner, String repo, Long id, EditLabelOption body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueEditLabel(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueEditLabel(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling issueEditLabel(Async)");
        }
        Call call = this.issueEditLabelCall(owner, repo, id, body, progressListener, progressRequestListener);
        return call;
    }

    public Label issueEditLabel(String owner, String repo, Long id, EditLabelOption body) throws ApiException {
        ApiResponse<Label> resp = this.issueEditLabelWithHttpInfo(owner, repo, id, body);
        return resp.getData();
    }

    public ApiResponse<Label> issueEditLabelWithHttpInfo(String owner, String repo, Long id, EditLabelOption body) throws ApiException {
        Call call = this.issueEditLabelValidateBeforeCall(owner, repo, id, body, null, null);
        Type localVarReturnType = new TypeToken<Label>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call issueEditLabelAsync(String owner, String repo, Long id, EditLabelOption body, final ApiCallback<Label> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueEditLabelValidateBeforeCall(owner, repo, id, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Label>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call issueEditMilestoneCall(String owner, String repo, String id, EditMilestoneOption body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        EditMilestoneOption localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}/milestones/{id}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issueEditMilestoneValidateBeforeCall(String owner, String repo, String id, EditMilestoneOption body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueEditMilestone(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueEditMilestone(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling issueEditMilestone(Async)");
        }
        Call call = this.issueEditMilestoneCall(owner, repo, id, body, progressListener, progressRequestListener);
        return call;
    }

    public Milestone issueEditMilestone(String owner, String repo, String id, EditMilestoneOption body) throws ApiException {
        ApiResponse<Milestone> resp = this.issueEditMilestoneWithHttpInfo(owner, repo, id, body);
        return resp.getData();
    }

    public ApiResponse<Milestone> issueEditMilestoneWithHttpInfo(String owner, String repo, String id, EditMilestoneOption body) throws ApiException {
        Call call = this.issueEditMilestoneValidateBeforeCall(owner, repo, id, body, null, null);
        Type localVarReturnType = new TypeToken<Milestone>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call issueEditMilestoneAsync(String owner, String repo, String id, EditMilestoneOption body, final ApiCallback<Milestone> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueEditMilestoneValidateBeforeCall(owner, repo, id, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Milestone>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call issueGetCommentCall(String owner, String repo, Long id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/issues/comments/{id}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issueGetCommentValidateBeforeCall(String owner, String repo, Long id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueGetComment(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueGetComment(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling issueGetComment(Async)");
        }
        Call call = this.issueGetCommentCall(owner, repo, id, progressListener, progressRequestListener);
        return call;
    }

    public Comment issueGetComment(String owner, String repo, Long id) throws ApiException {
        ApiResponse<Comment> resp = this.issueGetCommentWithHttpInfo(owner, repo, id);
        return resp.getData();
    }

    public ApiResponse<Comment> issueGetCommentWithHttpInfo(String owner, String repo, Long id) throws ApiException {
        Call call = this.issueGetCommentValidateBeforeCall(owner, repo, id, null, null);
        Type localVarReturnType = new TypeToken<Comment>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call issueGetCommentAsync(String owner, String repo, Long id, final ApiCallback<Comment> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueGetCommentValidateBeforeCall(owner, repo, id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Comment>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call issueGetCommentReactionsCall(String owner, String repo, Long id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/issues/comments/{id}/reactions".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issueGetCommentReactionsValidateBeforeCall(String owner, String repo, Long id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueGetCommentReactions(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueGetCommentReactions(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling issueGetCommentReactions(Async)");
        }
        Call call = this.issueGetCommentReactionsCall(owner, repo, id, progressListener, progressRequestListener);
        return call;
    }

    public List<Reaction> issueGetCommentReactions(String owner, String repo, Long id) throws ApiException {
        ApiResponse<List<Reaction>> resp = this.issueGetCommentReactionsWithHttpInfo(owner, repo, id);
        return resp.getData();
    }

    public ApiResponse<List<Reaction>> issueGetCommentReactionsWithHttpInfo(String owner, String repo, Long id) throws ApiException {
        Call call = this.issueGetCommentReactionsValidateBeforeCall(owner, repo, id, null, null);
        Type localVarReturnType = new TypeToken<List<Reaction>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call issueGetCommentReactionsAsync(String owner, String repo, Long id, final ApiCallback<List<Reaction>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueGetCommentReactionsValidateBeforeCall(owner, repo, id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Reaction>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call issueGetCommentsCall(String owner, String repo, Long index, OffsetDateTime since, OffsetDateTime before, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/comments".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (since != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("since", since));
        }
        if (before != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("before", before));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issueGetCommentsValidateBeforeCall(String owner, String repo, Long index, OffsetDateTime since, OffsetDateTime before, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueGetComments(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueGetComments(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueGetComments(Async)");
        }
        Call call = this.issueGetCommentsCall(owner, repo, index, since, before, progressListener, progressRequestListener);
        return call;
    }

    public List<Comment> issueGetComments(String owner, String repo, Long index, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        ApiResponse<List<Comment>> resp = this.issueGetCommentsWithHttpInfo(owner, repo, index, since, before);
        return resp.getData();
    }

    public ApiResponse<List<Comment>> issueGetCommentsWithHttpInfo(String owner, String repo, Long index, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        Call call = this.issueGetCommentsValidateBeforeCall(owner, repo, index, since, before, null, null);
        Type localVarReturnType = new TypeToken<List<Comment>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call issueGetCommentsAsync(String owner, String repo, Long index, OffsetDateTime since, OffsetDateTime before, final ApiCallback<List<Comment>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueGetCommentsValidateBeforeCall(owner, repo, index, since, before, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Comment>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call issueGetCommentsAndTimelineCall(String owner, String repo, Long index, OffsetDateTime since, Integer page, Integer limit, OffsetDateTime before, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/timeline".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (since != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("since", since));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (before != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("before", before));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issueGetCommentsAndTimelineValidateBeforeCall(String owner, String repo, Long index, OffsetDateTime since, Integer page, Integer limit, OffsetDateTime before, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueGetCommentsAndTimeline(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueGetCommentsAndTimeline(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueGetCommentsAndTimeline(Async)");
        }
        Call call = this.issueGetCommentsAndTimelineCall(owner, repo, index, since, page, limit, before, progressListener, progressRequestListener);
        return call;
    }

    public List<TimelineComment> issueGetCommentsAndTimeline(String owner, String repo, Long index, OffsetDateTime since, Integer page, Integer limit, OffsetDateTime before) throws ApiException {
        ApiResponse<List<TimelineComment>> resp = this.issueGetCommentsAndTimelineWithHttpInfo(owner, repo, index, since, page, limit, before);
        return resp.getData();
    }

    public ApiResponse<List<TimelineComment>> issueGetCommentsAndTimelineWithHttpInfo(String owner, String repo, Long index, OffsetDateTime since, Integer page, Integer limit, OffsetDateTime before) throws ApiException {
        Call call = this.issueGetCommentsAndTimelineValidateBeforeCall(owner, repo, index, since, page, limit, before, null, null);
        Type localVarReturnType = new TypeToken<List<TimelineComment>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call issueGetCommentsAndTimelineAsync(String owner, String repo, Long index, OffsetDateTime since, Integer page, Integer limit, OffsetDateTime before, final ApiCallback<List<TimelineComment>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueGetCommentsAndTimelineValidateBeforeCall(owner, repo, index, since, page, limit, before, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<TimelineComment>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call issueGetIssueCall(String owner, String repo, Long index, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issueGetIssueValidateBeforeCall(String owner, String repo, Long index, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueGetIssue(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueGetIssue(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueGetIssue(Async)");
        }
        Call call = this.issueGetIssueCall(owner, repo, index, progressListener, progressRequestListener);
        return call;
    }

    public Issue issueGetIssue(String owner, String repo, Long index) throws ApiException {
        ApiResponse<Issue> resp = this.issueGetIssueWithHttpInfo(owner, repo, index);
        return resp.getData();
    }

    public ApiResponse<Issue> issueGetIssueWithHttpInfo(String owner, String repo, Long index) throws ApiException {
        Call call = this.issueGetIssueValidateBeforeCall(owner, repo, index, null, null);
        Type localVarReturnType = new TypeToken<Issue>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call issueGetIssueAsync(String owner, String repo, Long index, final ApiCallback<Issue> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueGetIssueValidateBeforeCall(owner, repo, index, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Issue>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call issueGetIssueReactionsCall(String owner, String repo, Long index, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/reactions".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issueGetIssueReactionsValidateBeforeCall(String owner, String repo, Long index, Integer page, Integer limit, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueGetIssueReactions(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueGetIssueReactions(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueGetIssueReactions(Async)");
        }
        Call call = this.issueGetIssueReactionsCall(owner, repo, index, page, limit, progressListener, progressRequestListener);
        return call;
    }

    public List<Reaction> issueGetIssueReactions(String owner, String repo, Long index, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<Reaction>> resp = this.issueGetIssueReactionsWithHttpInfo(owner, repo, index, page, limit);
        return resp.getData();
    }

    public ApiResponse<List<Reaction>> issueGetIssueReactionsWithHttpInfo(String owner, String repo, Long index, Integer page, Integer limit) throws ApiException {
        Call call = this.issueGetIssueReactionsValidateBeforeCall(owner, repo, index, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<Reaction>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call issueGetIssueReactionsAsync(String owner, String repo, Long index, Integer page, Integer limit, final ApiCallback<List<Reaction>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueGetIssueReactionsValidateBeforeCall(owner, repo, index, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Reaction>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call issueGetLabelCall(String owner, String repo, Long id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/labels/{id}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issueGetLabelValidateBeforeCall(String owner, String repo, Long id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueGetLabel(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueGetLabel(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling issueGetLabel(Async)");
        }
        Call call = this.issueGetLabelCall(owner, repo, id, progressListener, progressRequestListener);
        return call;
    }

    public Label issueGetLabel(String owner, String repo, Long id) throws ApiException {
        ApiResponse<Label> resp = this.issueGetLabelWithHttpInfo(owner, repo, id);
        return resp.getData();
    }

    public ApiResponse<Label> issueGetLabelWithHttpInfo(String owner, String repo, Long id) throws ApiException {
        Call call = this.issueGetLabelValidateBeforeCall(owner, repo, id, null, null);
        Type localVarReturnType = new TypeToken<Label>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call issueGetLabelAsync(String owner, String repo, Long id, final ApiCallback<Label> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueGetLabelValidateBeforeCall(owner, repo, id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Label>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call issueGetLabelsCall(String owner, String repo, Long index, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/labels".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issueGetLabelsValidateBeforeCall(String owner, String repo, Long index, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueGetLabels(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueGetLabels(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueGetLabels(Async)");
        }
        Call call = this.issueGetLabelsCall(owner, repo, index, progressListener, progressRequestListener);
        return call;
    }

    public List<Label> issueGetLabels(String owner, String repo, Long index) throws ApiException {
        ApiResponse<List<Label>> resp = this.issueGetLabelsWithHttpInfo(owner, repo, index);
        return resp.getData();
    }

    public ApiResponse<List<Label>> issueGetLabelsWithHttpInfo(String owner, String repo, Long index) throws ApiException {
        Call call = this.issueGetLabelsValidateBeforeCall(owner, repo, index, null, null);
        Type localVarReturnType = new TypeToken<List<Label>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call issueGetLabelsAsync(String owner, String repo, Long index, final ApiCallback<List<Label>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueGetLabelsValidateBeforeCall(owner, repo, index, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Label>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call issueGetMilestoneCall(String owner, String repo, String id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/milestones/{id}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issueGetMilestoneValidateBeforeCall(String owner, String repo, String id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueGetMilestone(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueGetMilestone(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling issueGetMilestone(Async)");
        }
        Call call = this.issueGetMilestoneCall(owner, repo, id, progressListener, progressRequestListener);
        return call;
    }

    public Milestone issueGetMilestone(String owner, String repo, String id) throws ApiException {
        ApiResponse<Milestone> resp = this.issueGetMilestoneWithHttpInfo(owner, repo, id);
        return resp.getData();
    }

    public ApiResponse<Milestone> issueGetMilestoneWithHttpInfo(String owner, String repo, String id) throws ApiException {
        Call call = this.issueGetMilestoneValidateBeforeCall(owner, repo, id, null, null);
        Type localVarReturnType = new TypeToken<Milestone>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call issueGetMilestoneAsync(String owner, String repo, String id, final ApiCallback<Milestone> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueGetMilestoneValidateBeforeCall(owner, repo, id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Milestone>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call issueGetMilestonesListCall(String owner, String repo, String state, String name, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/milestones".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (state != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("state", state));
        }
        if (name != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("name", name));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issueGetMilestonesListValidateBeforeCall(String owner, String repo, String state, String name, Integer page, Integer limit, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueGetMilestonesList(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueGetMilestonesList(Async)");
        }
        Call call = this.issueGetMilestonesListCall(owner, repo, state, name, page, limit, progressListener, progressRequestListener);
        return call;
    }

    public List<Milestone> issueGetMilestonesList(String owner, String repo, String state, String name, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<Milestone>> resp = this.issueGetMilestonesListWithHttpInfo(owner, repo, state, name, page, limit);
        return resp.getData();
    }

    public ApiResponse<List<Milestone>> issueGetMilestonesListWithHttpInfo(String owner, String repo, String state, String name, Integer page, Integer limit) throws ApiException {
        Call call = this.issueGetMilestonesListValidateBeforeCall(owner, repo, state, name, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<Milestone>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call issueGetMilestonesListAsync(String owner, String repo, String state, String name, Integer page, Integer limit, final ApiCallback<List<Milestone>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueGetMilestonesListValidateBeforeCall(owner, repo, state, name, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Milestone>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call issueGetRepoCommentsCall(String owner, String repo, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/issues/comments".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (since != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("since", since));
        }
        if (before != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("before", before));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issueGetRepoCommentsValidateBeforeCall(String owner, String repo, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueGetRepoComments(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueGetRepoComments(Async)");
        }
        Call call = this.issueGetRepoCommentsCall(owner, repo, since, before, page, limit, progressListener, progressRequestListener);
        return call;
    }

    public List<Comment> issueGetRepoComments(String owner, String repo, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<Comment>> resp = this.issueGetRepoCommentsWithHttpInfo(owner, repo, since, before, page, limit);
        return resp.getData();
    }

    public ApiResponse<List<Comment>> issueGetRepoCommentsWithHttpInfo(String owner, String repo, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit) throws ApiException {
        Call call = this.issueGetRepoCommentsValidateBeforeCall(owner, repo, since, before, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<Comment>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call issueGetRepoCommentsAsync(String owner, String repo, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit, final ApiCallback<List<Comment>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueGetRepoCommentsValidateBeforeCall(owner, repo, since, before, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Comment>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call issueListIssuesCall(String owner, String repo, String state, String labels, String q, String type, String milestones, OffsetDateTime since, OffsetDateTime before, String createdBy, String assignedBy, String mentionedBy, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/issues".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (state != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("state", state));
        }
        if (labels != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("labels", labels));
        }
        if (q != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("q", q));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("type", type));
        }
        if (milestones != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("milestones", milestones));
        }
        if (since != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("since", since));
        }
        if (before != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("before", before));
        }
        if (createdBy != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("created_by", createdBy));
        }
        if (assignedBy != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("assigned_by", assignedBy));
        }
        if (mentionedBy != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("mentioned_by", mentionedBy));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issueListIssuesValidateBeforeCall(String owner, String repo, String state, String labels, String q, String type, String milestones, OffsetDateTime since, OffsetDateTime before, String createdBy, String assignedBy, String mentionedBy, Integer page, Integer limit, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueListIssues(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueListIssues(Async)");
        }
        Call call = this.issueListIssuesCall(owner, repo, state, labels, q, type, milestones, since, before, createdBy, assignedBy, mentionedBy, page, limit, progressListener, progressRequestListener);
        return call;
    }

    public List<Issue> issueListIssues(String owner, String repo, String state, String labels, String q, String type, String milestones, OffsetDateTime since, OffsetDateTime before, String createdBy, String assignedBy, String mentionedBy, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<Issue>> resp = this.issueListIssuesWithHttpInfo(owner, repo, state, labels, q, type, milestones, since, before, createdBy, assignedBy, mentionedBy, page, limit);
        return resp.getData();
    }

    public ApiResponse<List<Issue>> issueListIssuesWithHttpInfo(String owner, String repo, String state, String labels, String q, String type, String milestones, OffsetDateTime since, OffsetDateTime before, String createdBy, String assignedBy, String mentionedBy, Integer page, Integer limit) throws ApiException {
        Call call = this.issueListIssuesValidateBeforeCall(owner, repo, state, labels, q, type, milestones, since, before, createdBy, assignedBy, mentionedBy, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<Issue>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call issueListIssuesAsync(String owner, String repo, String state, String labels, String q, String type, String milestones, OffsetDateTime since, OffsetDateTime before, String createdBy, String assignedBy, String mentionedBy, Integer page, Integer limit, final ApiCallback<List<Issue>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueListIssuesValidateBeforeCall(owner, repo, state, labels, q, type, milestones, since, before, createdBy, assignedBy, mentionedBy, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Issue>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call issueListLabelsCall(String owner, String repo, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/labels".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issueListLabelsValidateBeforeCall(String owner, String repo, Integer page, Integer limit, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueListLabels(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueListLabels(Async)");
        }
        Call call = this.issueListLabelsCall(owner, repo, page, limit, progressListener, progressRequestListener);
        return call;
    }

    public List<Label> issueListLabels(String owner, String repo, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<Label>> resp = this.issueListLabelsWithHttpInfo(owner, repo, page, limit);
        return resp.getData();
    }

    public ApiResponse<List<Label>> issueListLabelsWithHttpInfo(String owner, String repo, Integer page, Integer limit) throws ApiException {
        Call call = this.issueListLabelsValidateBeforeCall(owner, repo, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<Label>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call issueListLabelsAsync(String owner, String repo, Integer page, Integer limit, final ApiCallback<List<Label>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueListLabelsValidateBeforeCall(owner, repo, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Label>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call issuePostCommentReactionCall(String owner, String repo, Long id, EditReactionOption content, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        EditReactionOption localVarPostBody = content;
        String localVarPath = "/repos/{owner}/{repo}/issues/comments/{id}/reactions".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issuePostCommentReactionValidateBeforeCall(String owner, String repo, Long id, EditReactionOption content, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issuePostCommentReaction(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issuePostCommentReaction(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling issuePostCommentReaction(Async)");
        }
        Call call = this.issuePostCommentReactionCall(owner, repo, id, content, progressListener, progressRequestListener);
        return call;
    }

    public Reaction issuePostCommentReaction(String owner, String repo, Long id, EditReactionOption content) throws ApiException {
        ApiResponse<Reaction> resp = this.issuePostCommentReactionWithHttpInfo(owner, repo, id, content);
        return resp.getData();
    }

    public ApiResponse<Reaction> issuePostCommentReactionWithHttpInfo(String owner, String repo, Long id, EditReactionOption content) throws ApiException {
        Call call = this.issuePostCommentReactionValidateBeforeCall(owner, repo, id, content, null, null);
        Type localVarReturnType = new TypeToken<Reaction>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call issuePostCommentReactionAsync(String owner, String repo, Long id, EditReactionOption content, final ApiCallback<Reaction> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issuePostCommentReactionValidateBeforeCall(owner, repo, id, content, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Reaction>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call issuePostIssueReactionCall(String owner, String repo, Long index, EditReactionOption content, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        EditReactionOption localVarPostBody = content;
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/reactions".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issuePostIssueReactionValidateBeforeCall(String owner, String repo, Long index, EditReactionOption content, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issuePostIssueReaction(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issuePostIssueReaction(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issuePostIssueReaction(Async)");
        }
        Call call = this.issuePostIssueReactionCall(owner, repo, index, content, progressListener, progressRequestListener);
        return call;
    }

    public Reaction issuePostIssueReaction(String owner, String repo, Long index, EditReactionOption content) throws ApiException {
        ApiResponse<Reaction> resp = this.issuePostIssueReactionWithHttpInfo(owner, repo, index, content);
        return resp.getData();
    }

    public ApiResponse<Reaction> issuePostIssueReactionWithHttpInfo(String owner, String repo, Long index, EditReactionOption content) throws ApiException {
        Call call = this.issuePostIssueReactionValidateBeforeCall(owner, repo, index, content, null, null);
        Type localVarReturnType = new TypeToken<Reaction>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call issuePostIssueReactionAsync(String owner, String repo, Long index, EditReactionOption content, final ApiCallback<Reaction> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issuePostIssueReactionValidateBeforeCall(owner, repo, index, content, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Reaction>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call issueRemoveLabelCall(String owner, String repo, Long index, Long id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/labels/{id}".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issueRemoveLabelValidateBeforeCall(String owner, String repo, Long index, Long id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueRemoveLabel(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueRemoveLabel(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueRemoveLabel(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling issueRemoveLabel(Async)");
        }
        Call call = this.issueRemoveLabelCall(owner, repo, index, id, progressListener, progressRequestListener);
        return call;
    }

    public void issueRemoveLabel(String owner, String repo, Long index, Long id) throws ApiException {
        this.issueRemoveLabelWithHttpInfo(owner, repo, index, id);
    }

    public ApiResponse<Void> issueRemoveLabelWithHttpInfo(String owner, String repo, Long index, Long id) throws ApiException {
        Call call = this.issueRemoveLabelValidateBeforeCall(owner, repo, index, id, null, null);
        return this.apiClient.execute(call);
    }

    public Call issueRemoveLabelAsync(String owner, String repo, Long index, Long id, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueRemoveLabelValidateBeforeCall(owner, repo, index, id, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call issueReplaceLabelsCall(String owner, String repo, Long index, IssueLabelsOption body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        IssueLabelsOption localVarPostBody = body;
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/labels".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issueReplaceLabelsValidateBeforeCall(String owner, String repo, Long index, IssueLabelsOption body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueReplaceLabels(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueReplaceLabels(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueReplaceLabels(Async)");
        }
        Call call = this.issueReplaceLabelsCall(owner, repo, index, body, progressListener, progressRequestListener);
        return call;
    }

    public List<Label> issueReplaceLabels(String owner, String repo, Long index, IssueLabelsOption body) throws ApiException {
        ApiResponse<List<Label>> resp = this.issueReplaceLabelsWithHttpInfo(owner, repo, index, body);
        return resp.getData();
    }

    public ApiResponse<List<Label>> issueReplaceLabelsWithHttpInfo(String owner, String repo, Long index, IssueLabelsOption body) throws ApiException {
        Call call = this.issueReplaceLabelsValidateBeforeCall(owner, repo, index, body, null, null);
        Type localVarReturnType = new TypeToken<List<Label>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call issueReplaceLabelsAsync(String owner, String repo, Long index, IssueLabelsOption body, final ApiCallback<List<Label>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueReplaceLabelsValidateBeforeCall(owner, repo, index, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Label>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call issueResetTimeCall(String owner, String repo, Long index, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/times".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issueResetTimeValidateBeforeCall(String owner, String repo, Long index, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueResetTime(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueResetTime(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueResetTime(Async)");
        }
        Call call = this.issueResetTimeCall(owner, repo, index, progressListener, progressRequestListener);
        return call;
    }

    public void issueResetTime(String owner, String repo, Long index) throws ApiException {
        this.issueResetTimeWithHttpInfo(owner, repo, index);
    }

    public ApiResponse<Void> issueResetTimeWithHttpInfo(String owner, String repo, Long index) throws ApiException {
        Call call = this.issueResetTimeValidateBeforeCall(owner, repo, index, null, null);
        return this.apiClient.execute(call);
    }

    public Call issueResetTimeAsync(String owner, String repo, Long index, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueResetTimeValidateBeforeCall(owner, repo, index, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call issueSearchIssuesCall(String state, String labels, String milestones, String q, Long priorityRepoId, String type, OffsetDateTime since, OffsetDateTime before, Boolean assigned, Boolean created, Boolean mentioned, Boolean reviewRequested, String owner, String team, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/issues/search";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (state != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("state", state));
        }
        if (labels != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("labels", labels));
        }
        if (milestones != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("milestones", milestones));
        }
        if (q != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("q", q));
        }
        if (priorityRepoId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("priority_repo_id", priorityRepoId));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("type", type));
        }
        if (since != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("since", since));
        }
        if (before != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("before", before));
        }
        if (assigned != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("assigned", assigned));
        }
        if (created != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("created", created));
        }
        if (mentioned != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("mentioned", mentioned));
        }
        if (reviewRequested != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("review_requested", reviewRequested));
        }
        if (owner != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("owner", owner));
        }
        if (team != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("team", team));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issueSearchIssuesValidateBeforeCall(String state, String labels, String milestones, String q, Long priorityRepoId, String type, OffsetDateTime since, OffsetDateTime before, Boolean assigned, Boolean created, Boolean mentioned, Boolean reviewRequested, String owner, String team, Integer page, Integer limit, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.issueSearchIssuesCall(state, labels, milestones, q, priorityRepoId, type, since, before, assigned, created, mentioned, reviewRequested, owner, team, page, limit, progressListener, progressRequestListener);
        return call;
    }

    public List<Issue> issueSearchIssues(String state, String labels, String milestones, String q, Long priorityRepoId, String type, OffsetDateTime since, OffsetDateTime before, Boolean assigned, Boolean created, Boolean mentioned, Boolean reviewRequested, String owner, String team, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<Issue>> resp = this.issueSearchIssuesWithHttpInfo(state, labels, milestones, q, priorityRepoId, type, since, before, assigned, created, mentioned, reviewRequested, owner, team, page, limit);
        return resp.getData();
    }

    public ApiResponse<List<Issue>> issueSearchIssuesWithHttpInfo(String state, String labels, String milestones, String q, Long priorityRepoId, String type, OffsetDateTime since, OffsetDateTime before, Boolean assigned, Boolean created, Boolean mentioned, Boolean reviewRequested, String owner, String team, Integer page, Integer limit) throws ApiException {
        Call call = this.issueSearchIssuesValidateBeforeCall(state, labels, milestones, q, priorityRepoId, type, since, before, assigned, created, mentioned, reviewRequested, owner, team, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<Issue>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call issueSearchIssuesAsync(String state, String labels, String milestones, String q, Long priorityRepoId, String type, OffsetDateTime since, OffsetDateTime before, Boolean assigned, Boolean created, Boolean mentioned, Boolean reviewRequested, String owner, String team, Integer page, Integer limit, final ApiCallback<List<Issue>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueSearchIssuesValidateBeforeCall(state, labels, milestones, q, priorityRepoId, type, since, before, assigned, created, mentioned, reviewRequested, owner, team, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Issue>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call issueStartStopWatchCall(String owner, String repo, Long index, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/stopwatch/start".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issueStartStopWatchValidateBeforeCall(String owner, String repo, Long index, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueStartStopWatch(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueStartStopWatch(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueStartStopWatch(Async)");
        }
        Call call = this.issueStartStopWatchCall(owner, repo, index, progressListener, progressRequestListener);
        return call;
    }

    public void issueStartStopWatch(String owner, String repo, Long index) throws ApiException {
        this.issueStartStopWatchWithHttpInfo(owner, repo, index);
    }

    public ApiResponse<Void> issueStartStopWatchWithHttpInfo(String owner, String repo, Long index) throws ApiException {
        Call call = this.issueStartStopWatchValidateBeforeCall(owner, repo, index, null, null);
        return this.apiClient.execute(call);
    }

    public Call issueStartStopWatchAsync(String owner, String repo, Long index, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueStartStopWatchValidateBeforeCall(owner, repo, index, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call issueStopStopWatchCall(String owner, String repo, Long index, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/stopwatch/stop".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issueStopStopWatchValidateBeforeCall(String owner, String repo, Long index, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueStopStopWatch(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueStopStopWatch(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueStopStopWatch(Async)");
        }
        Call call = this.issueStopStopWatchCall(owner, repo, index, progressListener, progressRequestListener);
        return call;
    }

    public void issueStopStopWatch(String owner, String repo, Long index) throws ApiException {
        this.issueStopStopWatchWithHttpInfo(owner, repo, index);
    }

    public ApiResponse<Void> issueStopStopWatchWithHttpInfo(String owner, String repo, Long index) throws ApiException {
        Call call = this.issueStopStopWatchValidateBeforeCall(owner, repo, index, null, null);
        return this.apiClient.execute(call);
    }

    public Call issueStopStopWatchAsync(String owner, String repo, Long index, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueStopStopWatchValidateBeforeCall(owner, repo, index, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call issueSubscriptionsCall(String owner, String repo, Long index, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/subscriptions".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issueSubscriptionsValidateBeforeCall(String owner, String repo, Long index, Integer page, Integer limit, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueSubscriptions(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueSubscriptions(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueSubscriptions(Async)");
        }
        Call call = this.issueSubscriptionsCall(owner, repo, index, page, limit, progressListener, progressRequestListener);
        return call;
    }

    public List<User> issueSubscriptions(String owner, String repo, Long index, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<User>> resp = this.issueSubscriptionsWithHttpInfo(owner, repo, index, page, limit);
        return resp.getData();
    }

    public ApiResponse<List<User>> issueSubscriptionsWithHttpInfo(String owner, String repo, Long index, Integer page, Integer limit) throws ApiException {
        Call call = this.issueSubscriptionsValidateBeforeCall(owner, repo, index, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<User>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call issueSubscriptionsAsync(String owner, String repo, Long index, Integer page, Integer limit, final ApiCallback<List<User>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueSubscriptionsValidateBeforeCall(owner, repo, index, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<User>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call issueTrackedTimesCall(String owner, String repo, Long index, String user, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/times".replaceAll("\\{owner\\}", this.apiClient.escapeString(owner.toString())).replaceAll("\\{repo\\}", this.apiClient.escapeString(repo.toString())).replaceAll("\\{index\\}", this.apiClient.escapeString(index.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (user != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("user", user));
        }
        if (since != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("since", since));
        }
        if (before != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("before", before));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call issueTrackedTimesValidateBeforeCall(String owner, String repo, Long index, String user, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueTrackedTimes(Async)");
        }
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueTrackedTimes(Async)");
        }
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueTrackedTimes(Async)");
        }
        Call call = this.issueTrackedTimesCall(owner, repo, index, user, since, before, page, limit, progressListener, progressRequestListener);
        return call;
    }

    public List<TrackedTime> issueTrackedTimes(String owner, String repo, Long index, String user, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<TrackedTime>> resp = this.issueTrackedTimesWithHttpInfo(owner, repo, index, user, since, before, page, limit);
        return resp.getData();
    }

    public ApiResponse<List<TrackedTime>> issueTrackedTimesWithHttpInfo(String owner, String repo, Long index, String user, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit) throws ApiException {
        Call call = this.issueTrackedTimesValidateBeforeCall(owner, repo, index, user, since, before, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<TrackedTime>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call issueTrackedTimesAsync(String owner, String repo, Long index, String user, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit, final ApiCallback<List<TrackedTime>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.issueTrackedTimesValidateBeforeCall(owner, repo, index, user, since, before, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<TrackedTime>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

