/*
 * Decompiled with CFR 0.152.
 */
package io.gitea.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.gitea.ApiCallback;
import io.gitea.ApiClient;
import io.gitea.ApiException;
import io.gitea.ApiResponse;
import io.gitea.Configuration;
import io.gitea.Pair;
import io.gitea.ProgressRequestBody;
import io.gitea.ProgressResponseBody;
import io.gitea.model.ActivityPub;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class ActivitypubApi {
    private ApiClient apiClient;

    public ActivitypubApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ActivitypubApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call activitypubPersonCall(String username, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/activitypub/user/{username}".replaceAll("\\{username\\}", this.apiClient.escapeString(username.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call activitypubPersonValidateBeforeCall(String username, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (username == null) {
            throw new ApiException("Missing the required parameter 'username' when calling activitypubPerson(Async)");
        }
        Call call = this.activitypubPersonCall(username, progressListener, progressRequestListener);
        return call;
    }

    public ActivityPub activitypubPerson(String username) throws ApiException {
        ApiResponse<ActivityPub> resp = this.activitypubPersonWithHttpInfo(username);
        return resp.getData();
    }

    public ApiResponse<ActivityPub> activitypubPersonWithHttpInfo(String username) throws ApiException {
        Call call = this.activitypubPersonValidateBeforeCall(username, null, null);
        Type localVarReturnType = new TypeToken<ActivityPub>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call activitypubPersonAsync(String username, final ApiCallback<ActivityPub> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.activitypubPersonValidateBeforeCall(username, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ActivityPub>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call activitypubPersonInboxCall(String username, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/activitypub/user/{username}/inbox".replaceAll("\\{username\\}", this.apiClient.escapeString(username.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call activitypubPersonInboxValidateBeforeCall(String username, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (username == null) {
            throw new ApiException("Missing the required parameter 'username' when calling activitypubPersonInbox(Async)");
        }
        Call call = this.activitypubPersonInboxCall(username, progressListener, progressRequestListener);
        return call;
    }

    public void activitypubPersonInbox(String username) throws ApiException {
        this.activitypubPersonInboxWithHttpInfo(username);
    }

    public ApiResponse<Void> activitypubPersonInboxWithHttpInfo(String username) throws ApiException {
        Call call = this.activitypubPersonInboxValidateBeforeCall(username, null, null);
        return this.apiClient.execute(call);
    }

    public Call activitypubPersonInboxAsync(String username, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.activitypubPersonInboxValidateBeforeCall(username, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }
}

