/*
 * Gitea API.
 * This documentation describes the Gitea API.
 *
 * OpenAPI spec version: 1.18.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.gitea.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.gitea.model.GitEntry;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * GitTreeResponse returns a git tree
 */
@ApiModel(description = "GitTreeResponse returns a git tree")

public class GitTreeResponse {
  @SerializedName("page")
  private Long page = null;

  @SerializedName("sha")
  private String sha = null;

  @SerializedName("total_count")
  private Long totalCount = null;

  @SerializedName("tree")
  private List<GitEntry> tree = null;

  @SerializedName("truncated")
  private Boolean truncated = null;

  @SerializedName("url")
  private String url = null;

  public GitTreeResponse page(Long page) {
    this.page = page;
    return this;
  }

   /**
   * Get page
   * @return page
  **/
  @ApiModelProperty(value = "")
  public Long getPage() {
    return page;
  }

  public void setPage(Long page) {
    this.page = page;
  }

  public GitTreeResponse sha(String sha) {
    this.sha = sha;
    return this;
  }

   /**
   * Get sha
   * @return sha
  **/
  @ApiModelProperty(value = "")
  public String getSha() {
    return sha;
  }

  public void setSha(String sha) {
    this.sha = sha;
  }

  public GitTreeResponse totalCount(Long totalCount) {
    this.totalCount = totalCount;
    return this;
  }

   /**
   * Get totalCount
   * @return totalCount
  **/
  @ApiModelProperty(value = "")
  public Long getTotalCount() {
    return totalCount;
  }

  public void setTotalCount(Long totalCount) {
    this.totalCount = totalCount;
  }

  public GitTreeResponse tree(List<GitEntry> tree) {
    this.tree = tree;
    return this;
  }

  public GitTreeResponse addTreeItem(GitEntry treeItem) {
    if (this.tree == null) {
      this.tree = new ArrayList<GitEntry>();
    }
    this.tree.add(treeItem);
    return this;
  }

   /**
   * Get tree
   * @return tree
  **/
  @ApiModelProperty(value = "")
  public List<GitEntry> getTree() {
    return tree;
  }

  public void setTree(List<GitEntry> tree) {
    this.tree = tree;
  }

  public GitTreeResponse truncated(Boolean truncated) {
    this.truncated = truncated;
    return this;
  }

   /**
   * Get truncated
   * @return truncated
  **/
  @ApiModelProperty(value = "")
  public Boolean isTruncated() {
    return truncated;
  }

  public void setTruncated(Boolean truncated) {
    this.truncated = truncated;
  }

  public GitTreeResponse url(String url) {
    this.url = url;
    return this;
  }

   /**
   * Get url
   * @return url
  **/
  @ApiModelProperty(value = "")
  public String getUrl() {
    return url;
  }

  public void setUrl(String url) {
    this.url = url;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GitTreeResponse gitTreeResponse = (GitTreeResponse) o;
    return Objects.equals(this.page, gitTreeResponse.page) &&
        Objects.equals(this.sha, gitTreeResponse.sha) &&
        Objects.equals(this.totalCount, gitTreeResponse.totalCount) &&
        Objects.equals(this.tree, gitTreeResponse.tree) &&
        Objects.equals(this.truncated, gitTreeResponse.truncated) &&
        Objects.equals(this.url, gitTreeResponse.url);
  }

  @Override
  public int hashCode() {
    return Objects.hash(page, sha, totalCount, tree, truncated, url);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GitTreeResponse {\n");
    
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    sha: ").append(toIndentedString(sha)).append("\n");
    sb.append("    totalCount: ").append(toIndentedString(totalCount)).append("\n");
    sb.append("    tree: ").append(toIndentedString(tree)).append("\n");
    sb.append("    truncated: ").append(toIndentedString(truncated)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

