/*
 * Gitea API.
 * This documentation describes the Gitea API.
 *
 * OpenAPI spec version: 1.18.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.gitea.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.gitea.model.CommitStatus;
import io.gitea.model.Repository;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * CombinedStatus holds the combined state of several statuses for a single commit
 */
@ApiModel(description = "CombinedStatus holds the combined state of several statuses for a single commit")

public class CombinedStatus {
  @SerializedName("commit_url")
  private String commitUrl = null;

  @SerializedName("repository")
  private Repository repository = null;

  @SerializedName("sha")
  private String sha = null;

  @SerializedName("state")
  private String state = null;

  @SerializedName("statuses")
  private List<CommitStatus> statuses = null;

  @SerializedName("total_count")
  private Long totalCount = null;

  @SerializedName("url")
  private String url = null;

  public CombinedStatus commitUrl(String commitUrl) {
    this.commitUrl = commitUrl;
    return this;
  }

   /**
   * Get commitUrl
   * @return commitUrl
  **/
  @ApiModelProperty(value = "")
  public String getCommitUrl() {
    return commitUrl;
  }

  public void setCommitUrl(String commitUrl) {
    this.commitUrl = commitUrl;
  }

  public CombinedStatus repository(Repository repository) {
    this.repository = repository;
    return this;
  }

   /**
   * Get repository
   * @return repository
  **/
  @ApiModelProperty(value = "")
  public Repository getRepository() {
    return repository;
  }

  public void setRepository(Repository repository) {
    this.repository = repository;
  }

  public CombinedStatus sha(String sha) {
    this.sha = sha;
    return this;
  }

   /**
   * Get sha
   * @return sha
  **/
  @ApiModelProperty(value = "")
  public String getSha() {
    return sha;
  }

  public void setSha(String sha) {
    this.sha = sha;
  }

  public CombinedStatus state(String state) {
    this.state = state;
    return this;
  }

   /**
   * Get state
   * @return state
  **/
  @ApiModelProperty(value = "")
  public String getState() {
    return state;
  }

  public void setState(String state) {
    this.state = state;
  }

  public CombinedStatus statuses(List<CommitStatus> statuses) {
    this.statuses = statuses;
    return this;
  }

  public CombinedStatus addStatusesItem(CommitStatus statusesItem) {
    if (this.statuses == null) {
      this.statuses = new ArrayList<CommitStatus>();
    }
    this.statuses.add(statusesItem);
    return this;
  }

   /**
   * Get statuses
   * @return statuses
  **/
  @ApiModelProperty(value = "")
  public List<CommitStatus> getStatuses() {
    return statuses;
  }

  public void setStatuses(List<CommitStatus> statuses) {
    this.statuses = statuses;
  }

  public CombinedStatus totalCount(Long totalCount) {
    this.totalCount = totalCount;
    return this;
  }

   /**
   * Get totalCount
   * @return totalCount
  **/
  @ApiModelProperty(value = "")
  public Long getTotalCount() {
    return totalCount;
  }

  public void setTotalCount(Long totalCount) {
    this.totalCount = totalCount;
  }

  public CombinedStatus url(String url) {
    this.url = url;
    return this;
  }

   /**
   * Get url
   * @return url
  **/
  @ApiModelProperty(value = "")
  public String getUrl() {
    return url;
  }

  public void setUrl(String url) {
    this.url = url;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CombinedStatus combinedStatus = (CombinedStatus) o;
    return Objects.equals(this.commitUrl, combinedStatus.commitUrl) &&
        Objects.equals(this.repository, combinedStatus.repository) &&
        Objects.equals(this.sha, combinedStatus.sha) &&
        Objects.equals(this.state, combinedStatus.state) &&
        Objects.equals(this.statuses, combinedStatus.statuses) &&
        Objects.equals(this.totalCount, combinedStatus.totalCount) &&
        Objects.equals(this.url, combinedStatus.url);
  }

  @Override
  public int hashCode() {
    return Objects.hash(commitUrl, repository, sha, state, statuses, totalCount, url);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CombinedStatus {\n");
    
    sb.append("    commitUrl: ").append(toIndentedString(commitUrl)).append("\n");
    sb.append("    repository: ").append(toIndentedString(repository)).append("\n");
    sb.append("    sha: ").append(toIndentedString(sha)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    statuses: ").append(toIndentedString(statuses)).append("\n");
    sb.append("    totalCount: ").append(toIndentedString(totalCount)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

