/*
 * Gitea API.
 * This documentation describes the Gitea API.
 *
 * OpenAPI spec version: 1.18.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.gitea.api;

import io.gitea.ApiCallback;
import io.gitea.ApiClient;
import io.gitea.ApiException;
import io.gitea.ApiResponse;
import io.gitea.Configuration;
import io.gitea.Pair;
import io.gitea.ProgressRequestBody;
import io.gitea.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import io.gitea.model.APIError;
import io.gitea.model.AddCollaboratorOption;
import io.gitea.model.AnnotatedTag;
import io.gitea.model.Attachment;
import io.gitea.model.Branch;
import io.gitea.model.BranchProtection;
import io.gitea.model.ChangedFile;
import io.gitea.model.CombinedStatus;
import io.gitea.model.Commit;
import io.gitea.model.CommitStatus;
import io.gitea.model.ContentsResponse;
import io.gitea.model.CreateBranchProtectionOption;
import io.gitea.model.CreateBranchRepoOption;
import io.gitea.model.CreateFileOptions;
import io.gitea.model.CreateForkOption;
import io.gitea.model.CreateHookOption;
import io.gitea.model.CreateKeyOption;
import io.gitea.model.CreatePullRequestOption;
import io.gitea.model.CreatePullReviewOptions;
import io.gitea.model.CreatePushMirrorOption;
import io.gitea.model.CreateReleaseOption;
import io.gitea.model.CreateRepoOption;
import io.gitea.model.CreateStatusOption;
import io.gitea.model.CreateTagOption;
import io.gitea.model.CreateWikiPageOptions;
import io.gitea.model.DeleteFileOptions;
import io.gitea.model.DeployKey;
import io.gitea.model.DismissPullReviewOptions;
import io.gitea.model.EditAttachmentOptions;
import io.gitea.model.EditBranchProtectionOption;
import io.gitea.model.EditGitHookOption;
import io.gitea.model.EditHookOption;
import io.gitea.model.EditPullRequestOption;
import io.gitea.model.EditReleaseOption;
import io.gitea.model.EditRepoOption;
import java.io.File;
import io.gitea.model.FileDeleteResponse;
import io.gitea.model.FileResponse;
import io.gitea.model.GenerateRepoOption;
import io.gitea.model.GitBlobResponse;
import io.gitea.model.GitHook;
import io.gitea.model.GitTreeResponse;
import io.gitea.model.Hook;
import io.gitea.model.IssueTemplate;
import io.gitea.model.MergePullRequestOption;
import io.gitea.model.MigrateRepoOptions;
import io.gitea.model.Note;
import org.threeten.bp.OffsetDateTime;
import io.gitea.model.PullRequest;
import io.gitea.model.PullReview;
import io.gitea.model.PullReviewComment;
import io.gitea.model.PullReviewRequestOptions;
import io.gitea.model.PushMirror;
import io.gitea.model.Reference;
import io.gitea.model.Release;
import io.gitea.model.RepoCollaboratorPermission;
import io.gitea.model.RepoTopicOptions;
import io.gitea.model.Repository;
import io.gitea.model.SearchResults;
import io.gitea.model.SubmitPullReviewOptions;
import io.gitea.model.Tag;
import io.gitea.model.Team;
import io.gitea.model.TopicName;
import io.gitea.model.TopicResponse;
import io.gitea.model.TrackedTime;
import io.gitea.model.TransferRepoOption;
import io.gitea.model.UpdateFileOptions;
import io.gitea.model.User;
import io.gitea.model.WatchInfo;
import io.gitea.model.WikiCommitList;
import io.gitea.model.WikiPage;
import io.gitea.model.WikiPageMetaData;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RepositoryApi {
    private ApiClient apiClient;

    public RepositoryApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RepositoryApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for acceptRepoTransfer
     * @param owner owner of the repo to transfer (required)
     * @param repo name of the repo to transfer (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call acceptRepoTransferCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/transfer/accept"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call acceptRepoTransferValidateBeforeCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling acceptRepoTransfer(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling acceptRepoTransfer(Async)");
        }
        

        com.squareup.okhttp.Call call = acceptRepoTransferCall(owner, repo, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Accept a repo transfer
     * 
     * @param owner owner of the repo to transfer (required)
     * @param repo name of the repo to transfer (required)
     * @return Repository
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Repository acceptRepoTransfer(String owner, String repo) throws ApiException {
        ApiResponse<Repository> resp = acceptRepoTransferWithHttpInfo(owner, repo);
        return resp.getData();
    }

    /**
     * Accept a repo transfer
     * 
     * @param owner owner of the repo to transfer (required)
     * @param repo name of the repo to transfer (required)
     * @return ApiResponse&lt;Repository&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Repository> acceptRepoTransferWithHttpInfo(String owner, String repo) throws ApiException {
        com.squareup.okhttp.Call call = acceptRepoTransferValidateBeforeCall(owner, repo, null, null);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Accept a repo transfer (asynchronously)
     * 
     * @param owner owner of the repo to transfer (required)
     * @param repo name of the repo to transfer (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call acceptRepoTransferAsync(String owner, String repo, final ApiCallback<Repository> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = acceptRepoTransferValidateBeforeCall(owner, repo, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for createCurrentUserRepo
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call createCurrentUserRepoCall(CreateRepoOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/user/repos";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call createCurrentUserRepoValidateBeforeCall(CreateRepoOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        

        com.squareup.okhttp.Call call = createCurrentUserRepoCall(body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Create a repository
     * 
     * @param body  (optional)
     * @return Repository
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Repository createCurrentUserRepo(CreateRepoOption body) throws ApiException {
        ApiResponse<Repository> resp = createCurrentUserRepoWithHttpInfo(body);
        return resp.getData();
    }

    /**
     * Create a repository
     * 
     * @param body  (optional)
     * @return ApiResponse&lt;Repository&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Repository> createCurrentUserRepoWithHttpInfo(CreateRepoOption body) throws ApiException {
        com.squareup.okhttp.Call call = createCurrentUserRepoValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Create a repository (asynchronously)
     * 
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call createCurrentUserRepoAsync(CreateRepoOption body, final ApiCallback<Repository> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = createCurrentUserRepoValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for createFork
     * @param owner owner of the repo to fork (required)
     * @param repo name of the repo to fork (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call createForkCall(String owner, String repo, CreateForkOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/forks"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call createForkValidateBeforeCall(String owner, String repo, CreateForkOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling createFork(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling createFork(Async)");
        }
        

        com.squareup.okhttp.Call call = createForkCall(owner, repo, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Fork a repository
     * 
     * @param owner owner of the repo to fork (required)
     * @param repo name of the repo to fork (required)
     * @param body  (optional)
     * @return Repository
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Repository createFork(String owner, String repo, CreateForkOption body) throws ApiException {
        ApiResponse<Repository> resp = createForkWithHttpInfo(owner, repo, body);
        return resp.getData();
    }

    /**
     * Fork a repository
     * 
     * @param owner owner of the repo to fork (required)
     * @param repo name of the repo to fork (required)
     * @param body  (optional)
     * @return ApiResponse&lt;Repository&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Repository> createForkWithHttpInfo(String owner, String repo, CreateForkOption body) throws ApiException {
        com.squareup.okhttp.Call call = createForkValidateBeforeCall(owner, repo, body, null, null);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Fork a repository (asynchronously)
     * 
     * @param owner owner of the repo to fork (required)
     * @param repo name of the repo to fork (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call createForkAsync(String owner, String repo, CreateForkOption body, final ApiCallback<Repository> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = createForkValidateBeforeCall(owner, repo, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for generateRepo
     * @param templateOwner name of the template repository owner (required)
     * @param templateRepo name of the template repository (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call generateRepoCall(String templateOwner, String templateRepo, GenerateRepoOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{template_owner}/{template_repo}/generate"
            .replaceAll("\\{" + "template_owner" + "\\}", apiClient.escapeString(templateOwner.toString()))
            .replaceAll("\\{" + "template_repo" + "\\}", apiClient.escapeString(templateRepo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call generateRepoValidateBeforeCall(String templateOwner, String templateRepo, GenerateRepoOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'templateOwner' is set
        if (templateOwner == null) {
            throw new ApiException("Missing the required parameter 'templateOwner' when calling generateRepo(Async)");
        }
        
        // verify the required parameter 'templateRepo' is set
        if (templateRepo == null) {
            throw new ApiException("Missing the required parameter 'templateRepo' when calling generateRepo(Async)");
        }
        

        com.squareup.okhttp.Call call = generateRepoCall(templateOwner, templateRepo, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Create a repository using a template
     * 
     * @param templateOwner name of the template repository owner (required)
     * @param templateRepo name of the template repository (required)
     * @param body  (optional)
     * @return Repository
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Repository generateRepo(String templateOwner, String templateRepo, GenerateRepoOption body) throws ApiException {
        ApiResponse<Repository> resp = generateRepoWithHttpInfo(templateOwner, templateRepo, body);
        return resp.getData();
    }

    /**
     * Create a repository using a template
     * 
     * @param templateOwner name of the template repository owner (required)
     * @param templateRepo name of the template repository (required)
     * @param body  (optional)
     * @return ApiResponse&lt;Repository&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Repository> generateRepoWithHttpInfo(String templateOwner, String templateRepo, GenerateRepoOption body) throws ApiException {
        com.squareup.okhttp.Call call = generateRepoValidateBeforeCall(templateOwner, templateRepo, body, null, null);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Create a repository using a template (asynchronously)
     * 
     * @param templateOwner name of the template repository owner (required)
     * @param templateRepo name of the template repository (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call generateRepoAsync(String templateOwner, String templateRepo, GenerateRepoOption body, final ApiCallback<Repository> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = generateRepoValidateBeforeCall(templateOwner, templateRepo, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getAnnotatedTag
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param sha sha of the tag. The Git tags API only supports annotated tag objects, not lightweight tags. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getAnnotatedTagCall(String owner, String repo, String sha, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/git/tags/{sha}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "sha" + "\\}", apiClient.escapeString(sha.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getAnnotatedTagValidateBeforeCall(String owner, String repo, String sha, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling getAnnotatedTag(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling getAnnotatedTag(Async)");
        }
        
        // verify the required parameter 'sha' is set
        if (sha == null) {
            throw new ApiException("Missing the required parameter 'sha' when calling getAnnotatedTag(Async)");
        }
        

        com.squareup.okhttp.Call call = getAnnotatedTagCall(owner, repo, sha, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Gets the tag object of an annotated tag (not lightweight tags)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param sha sha of the tag. The Git tags API only supports annotated tag objects, not lightweight tags. (required)
     * @return AnnotatedTag
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public AnnotatedTag getAnnotatedTag(String owner, String repo, String sha) throws ApiException {
        ApiResponse<AnnotatedTag> resp = getAnnotatedTagWithHttpInfo(owner, repo, sha);
        return resp.getData();
    }

    /**
     * Gets the tag object of an annotated tag (not lightweight tags)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param sha sha of the tag. The Git tags API only supports annotated tag objects, not lightweight tags. (required)
     * @return ApiResponse&lt;AnnotatedTag&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<AnnotatedTag> getAnnotatedTagWithHttpInfo(String owner, String repo, String sha) throws ApiException {
        com.squareup.okhttp.Call call = getAnnotatedTagValidateBeforeCall(owner, repo, sha, null, null);
        Type localVarReturnType = new TypeToken<AnnotatedTag>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Gets the tag object of an annotated tag (not lightweight tags) (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param sha sha of the tag. The Git tags API only supports annotated tag objects, not lightweight tags. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getAnnotatedTagAsync(String owner, String repo, String sha, final ApiCallback<AnnotatedTag> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getAnnotatedTagValidateBeforeCall(owner, repo, sha, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AnnotatedTag>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getBlob
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param sha sha of the commit (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getBlobCall(String owner, String repo, String sha, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/git/blobs/{sha}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "sha" + "\\}", apiClient.escapeString(sha.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getBlobValidateBeforeCall(String owner, String repo, String sha, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling getBlob(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling getBlob(Async)");
        }
        
        // verify the required parameter 'sha' is set
        if (sha == null) {
            throw new ApiException("Missing the required parameter 'sha' when calling getBlob(Async)");
        }
        

        com.squareup.okhttp.Call call = getBlobCall(owner, repo, sha, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Gets the blob of a repository.
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param sha sha of the commit (required)
     * @return GitBlobResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GitBlobResponse getBlob(String owner, String repo, String sha) throws ApiException {
        ApiResponse<GitBlobResponse> resp = getBlobWithHttpInfo(owner, repo, sha);
        return resp.getData();
    }

    /**
     * Gets the blob of a repository.
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param sha sha of the commit (required)
     * @return ApiResponse&lt;GitBlobResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GitBlobResponse> getBlobWithHttpInfo(String owner, String repo, String sha) throws ApiException {
        com.squareup.okhttp.Call call = getBlobValidateBeforeCall(owner, repo, sha, null, null);
        Type localVarReturnType = new TypeToken<GitBlobResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Gets the blob of a repository. (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param sha sha of the commit (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getBlobAsync(String owner, String repo, String sha, final ApiCallback<GitBlobResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getBlobValidateBeforeCall(owner, repo, sha, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GitBlobResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getTree
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param sha sha of the commit (required)
     * @param recursive show all directories and files (optional)
     * @param page page number; the &#39;truncated&#39; field in the response will be true if there are still more items after this page, false if the last page (optional)
     * @param perPage number of items per page (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getTreeCall(String owner, String repo, String sha, Boolean recursive, Integer page, Integer perPage, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/git/trees/{sha}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "sha" + "\\}", apiClient.escapeString(sha.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (recursive != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("recursive", recursive));
        if (page != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        if (perPage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("per_page", perPage));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getTreeValidateBeforeCall(String owner, String repo, String sha, Boolean recursive, Integer page, Integer perPage, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling getTree(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling getTree(Async)");
        }
        
        // verify the required parameter 'sha' is set
        if (sha == null) {
            throw new ApiException("Missing the required parameter 'sha' when calling getTree(Async)");
        }
        

        com.squareup.okhttp.Call call = getTreeCall(owner, repo, sha, recursive, page, perPage, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Gets the tree of a repository.
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param sha sha of the commit (required)
     * @param recursive show all directories and files (optional)
     * @param page page number; the &#39;truncated&#39; field in the response will be true if there are still more items after this page, false if the last page (optional)
     * @param perPage number of items per page (optional)
     * @return GitTreeResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GitTreeResponse getTree(String owner, String repo, String sha, Boolean recursive, Integer page, Integer perPage) throws ApiException {
        ApiResponse<GitTreeResponse> resp = getTreeWithHttpInfo(owner, repo, sha, recursive, page, perPage);
        return resp.getData();
    }

    /**
     * Gets the tree of a repository.
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param sha sha of the commit (required)
     * @param recursive show all directories and files (optional)
     * @param page page number; the &#39;truncated&#39; field in the response will be true if there are still more items after this page, false if the last page (optional)
     * @param perPage number of items per page (optional)
     * @return ApiResponse&lt;GitTreeResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GitTreeResponse> getTreeWithHttpInfo(String owner, String repo, String sha, Boolean recursive, Integer page, Integer perPage) throws ApiException {
        com.squareup.okhttp.Call call = getTreeValidateBeforeCall(owner, repo, sha, recursive, page, perPage, null, null);
        Type localVarReturnType = new TypeToken<GitTreeResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Gets the tree of a repository. (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param sha sha of the commit (required)
     * @param recursive show all directories and files (optional)
     * @param page page number; the &#39;truncated&#39; field in the response will be true if there are still more items after this page, false if the last page (optional)
     * @param perPage number of items per page (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getTreeAsync(String owner, String repo, String sha, Boolean recursive, Integer page, Integer perPage, final ApiCallback<GitTreeResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getTreeValidateBeforeCall(owner, repo, sha, recursive, page, perPage, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GitTreeResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for listForks
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call listForksCall(String owner, String repo, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/forks"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call listForksValidateBeforeCall(String owner, String repo, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling listForks(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling listForks(Async)");
        }
        

        com.squareup.okhttp.Call call = listForksCall(owner, repo, page, limit, progressListener, progressRequestListener);
        return call;

    }

    /**
     * List a repository&#39;s forks
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return List&lt;Repository&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<Repository> listForks(String owner, String repo, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<Repository>> resp = listForksWithHttpInfo(owner, repo, page, limit);
        return resp.getData();
    }

    /**
     * List a repository&#39;s forks
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return ApiResponse&lt;List&lt;Repository&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<Repository>> listForksWithHttpInfo(String owner, String repo, Integer page, Integer limit) throws ApiException {
        com.squareup.okhttp.Call call = listForksValidateBeforeCall(owner, repo, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<Repository>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * List a repository&#39;s forks (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call listForksAsync(String owner, String repo, Integer page, Integer limit, final ApiCallback<List<Repository>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = listForksValidateBeforeCall(owner, repo, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Repository>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for rejectRepoTransfer
     * @param owner owner of the repo to transfer (required)
     * @param repo name of the repo to transfer (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call rejectRepoTransferCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/transfer/reject"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call rejectRepoTransferValidateBeforeCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling rejectRepoTransfer(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling rejectRepoTransfer(Async)");
        }
        

        com.squareup.okhttp.Call call = rejectRepoTransferCall(owner, repo, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Reject a repo transfer
     * 
     * @param owner owner of the repo to transfer (required)
     * @param repo name of the repo to transfer (required)
     * @return Repository
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Repository rejectRepoTransfer(String owner, String repo) throws ApiException {
        ApiResponse<Repository> resp = rejectRepoTransferWithHttpInfo(owner, repo);
        return resp.getData();
    }

    /**
     * Reject a repo transfer
     * 
     * @param owner owner of the repo to transfer (required)
     * @param repo name of the repo to transfer (required)
     * @return ApiResponse&lt;Repository&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Repository> rejectRepoTransferWithHttpInfo(String owner, String repo) throws ApiException {
        com.squareup.okhttp.Call call = rejectRepoTransferValidateBeforeCall(owner, repo, null, null);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Reject a repo transfer (asynchronously)
     * 
     * @param owner owner of the repo to transfer (required)
     * @param repo name of the repo to transfer (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call rejectRepoTransferAsync(String owner, String repo, final ApiCallback<Repository> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = rejectRepoTransferValidateBeforeCall(owner, repo, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoAddCollaborator
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param collaborator username of the collaborator to add (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoAddCollaboratorCall(String owner, String repo, String collaborator, AddCollaboratorOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/collaborators/{collaborator}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "collaborator" + "\\}", apiClient.escapeString(collaborator.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoAddCollaboratorValidateBeforeCall(String owner, String repo, String collaborator, AddCollaboratorOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoAddCollaborator(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoAddCollaborator(Async)");
        }
        
        // verify the required parameter 'collaborator' is set
        if (collaborator == null) {
            throw new ApiException("Missing the required parameter 'collaborator' when calling repoAddCollaborator(Async)");
        }
        

        com.squareup.okhttp.Call call = repoAddCollaboratorCall(owner, repo, collaborator, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Add a collaborator to a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param collaborator username of the collaborator to add (required)
     * @param body  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void repoAddCollaborator(String owner, String repo, String collaborator, AddCollaboratorOption body) throws ApiException {
        repoAddCollaboratorWithHttpInfo(owner, repo, collaborator, body);
    }

    /**
     * Add a collaborator to a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param collaborator username of the collaborator to add (required)
     * @param body  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> repoAddCollaboratorWithHttpInfo(String owner, String repo, String collaborator, AddCollaboratorOption body) throws ApiException {
        com.squareup.okhttp.Call call = repoAddCollaboratorValidateBeforeCall(owner, repo, collaborator, body, null, null);
        return apiClient.execute(call);
    }

    /**
     * Add a collaborator to a repository (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param collaborator username of the collaborator to add (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoAddCollaboratorAsync(String owner, String repo, String collaborator, AddCollaboratorOption body, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoAddCollaboratorValidateBeforeCall(owner, repo, collaborator, body, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for repoAddPushMirror
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoAddPushMirrorCall(String owner, String repo, CreatePushMirrorOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/push_mirrors"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoAddPushMirrorValidateBeforeCall(String owner, String repo, CreatePushMirrorOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoAddPushMirror(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoAddPushMirror(Async)");
        }
        

        com.squareup.okhttp.Call call = repoAddPushMirrorCall(owner, repo, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * add a push mirror to the repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @return PushMirror
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public PushMirror repoAddPushMirror(String owner, String repo, CreatePushMirrorOption body) throws ApiException {
        ApiResponse<PushMirror> resp = repoAddPushMirrorWithHttpInfo(owner, repo, body);
        return resp.getData();
    }

    /**
     * add a push mirror to the repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @return ApiResponse&lt;PushMirror&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<PushMirror> repoAddPushMirrorWithHttpInfo(String owner, String repo, CreatePushMirrorOption body) throws ApiException {
        com.squareup.okhttp.Call call = repoAddPushMirrorValidateBeforeCall(owner, repo, body, null, null);
        Type localVarReturnType = new TypeToken<PushMirror>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * add a push mirror to the repository (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoAddPushMirrorAsync(String owner, String repo, CreatePushMirrorOption body, final ApiCallback<PushMirror> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoAddPushMirrorValidateBeforeCall(owner, repo, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PushMirror>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoAddTeam
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param team team name (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoAddTeamCall(String owner, String repo, String team, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/teams/{team}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "team" + "\\}", apiClient.escapeString(team.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoAddTeamValidateBeforeCall(String owner, String repo, String team, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoAddTeam(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoAddTeam(Async)");
        }
        
        // verify the required parameter 'team' is set
        if (team == null) {
            throw new ApiException("Missing the required parameter 'team' when calling repoAddTeam(Async)");
        }
        

        com.squareup.okhttp.Call call = repoAddTeamCall(owner, repo, team, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Add a team to a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param team team name (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void repoAddTeam(String owner, String repo, String team) throws ApiException {
        repoAddTeamWithHttpInfo(owner, repo, team);
    }

    /**
     * Add a team to a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param team team name (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> repoAddTeamWithHttpInfo(String owner, String repo, String team) throws ApiException {
        com.squareup.okhttp.Call call = repoAddTeamValidateBeforeCall(owner, repo, team, null, null);
        return apiClient.execute(call);
    }

    /**
     * Add a team to a repository (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param team team name (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoAddTeamAsync(String owner, String repo, String team, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoAddTeamValidateBeforeCall(owner, repo, team, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for repoAddTopic
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param topic name of the topic to add (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoAddTopicCall(String owner, String repo, String topic, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/topics/{topic}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "topic" + "\\}", apiClient.escapeString(topic.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoAddTopicValidateBeforeCall(String owner, String repo, String topic, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoAddTopic(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoAddTopic(Async)");
        }
        
        // verify the required parameter 'topic' is set
        if (topic == null) {
            throw new ApiException("Missing the required parameter 'topic' when calling repoAddTopic(Async)");
        }
        

        com.squareup.okhttp.Call call = repoAddTopicCall(owner, repo, topic, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Add a topic to a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param topic name of the topic to add (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void repoAddTopic(String owner, String repo, String topic) throws ApiException {
        repoAddTopicWithHttpInfo(owner, repo, topic);
    }

    /**
     * Add a topic to a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param topic name of the topic to add (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> repoAddTopicWithHttpInfo(String owner, String repo, String topic) throws ApiException {
        com.squareup.okhttp.Call call = repoAddTopicValidateBeforeCall(owner, repo, topic, null, null);
        return apiClient.execute(call);
    }

    /**
     * Add a topic to a repository (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param topic name of the topic to add (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoAddTopicAsync(String owner, String repo, String topic, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoAddTopicValidateBeforeCall(owner, repo, topic, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for repoApplyDiffPatch
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoApplyDiffPatchCall(String owner, String repo, UpdateFileOptions body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/diffpatch"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoApplyDiffPatchValidateBeforeCall(String owner, String repo, UpdateFileOptions body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoApplyDiffPatch(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoApplyDiffPatch(Async)");
        }
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling repoApplyDiffPatch(Async)");
        }
        

        com.squareup.okhttp.Call call = repoApplyDiffPatchCall(owner, repo, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Apply diff patch to repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (required)
     * @return FileResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public FileResponse repoApplyDiffPatch(String owner, String repo, UpdateFileOptions body) throws ApiException {
        ApiResponse<FileResponse> resp = repoApplyDiffPatchWithHttpInfo(owner, repo, body);
        return resp.getData();
    }

    /**
     * Apply diff patch to repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (required)
     * @return ApiResponse&lt;FileResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<FileResponse> repoApplyDiffPatchWithHttpInfo(String owner, String repo, UpdateFileOptions body) throws ApiException {
        com.squareup.okhttp.Call call = repoApplyDiffPatchValidateBeforeCall(owner, repo, body, null, null);
        Type localVarReturnType = new TypeToken<FileResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Apply diff patch to repository (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoApplyDiffPatchAsync(String owner, String repo, UpdateFileOptions body, final ApiCallback<FileResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoApplyDiffPatchValidateBeforeCall(owner, repo, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FileResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoCancelScheduledAutoMerge
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request to merge (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoCancelScheduledAutoMergeCall(String owner, String repo, Long index, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/pulls/{index}/merge"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoCancelScheduledAutoMergeValidateBeforeCall(String owner, String repo, Long index, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoCancelScheduledAutoMerge(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoCancelScheduledAutoMerge(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling repoCancelScheduledAutoMerge(Async)");
        }
        

        com.squareup.okhttp.Call call = repoCancelScheduledAutoMergeCall(owner, repo, index, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Cancel the scheduled auto merge for the given pull request
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request to merge (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void repoCancelScheduledAutoMerge(String owner, String repo, Long index) throws ApiException {
        repoCancelScheduledAutoMergeWithHttpInfo(owner, repo, index);
    }

    /**
     * Cancel the scheduled auto merge for the given pull request
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request to merge (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> repoCancelScheduledAutoMergeWithHttpInfo(String owner, String repo, Long index) throws ApiException {
        com.squareup.okhttp.Call call = repoCancelScheduledAutoMergeValidateBeforeCall(owner, repo, index, null, null);
        return apiClient.execute(call);
    }

    /**
     * Cancel the scheduled auto merge for the given pull request (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request to merge (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoCancelScheduledAutoMergeAsync(String owner, String repo, Long index, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoCancelScheduledAutoMergeValidateBeforeCall(owner, repo, index, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for repoCheckCollaborator
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param collaborator username of the collaborator (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoCheckCollaboratorCall(String owner, String repo, String collaborator, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/collaborators/{collaborator}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "collaborator" + "\\}", apiClient.escapeString(collaborator.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoCheckCollaboratorValidateBeforeCall(String owner, String repo, String collaborator, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoCheckCollaborator(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoCheckCollaborator(Async)");
        }
        
        // verify the required parameter 'collaborator' is set
        if (collaborator == null) {
            throw new ApiException("Missing the required parameter 'collaborator' when calling repoCheckCollaborator(Async)");
        }
        

        com.squareup.okhttp.Call call = repoCheckCollaboratorCall(owner, repo, collaborator, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Check if a user is a collaborator of a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param collaborator username of the collaborator (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void repoCheckCollaborator(String owner, String repo, String collaborator) throws ApiException {
        repoCheckCollaboratorWithHttpInfo(owner, repo, collaborator);
    }

    /**
     * Check if a user is a collaborator of a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param collaborator username of the collaborator (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> repoCheckCollaboratorWithHttpInfo(String owner, String repo, String collaborator) throws ApiException {
        com.squareup.okhttp.Call call = repoCheckCollaboratorValidateBeforeCall(owner, repo, collaborator, null, null);
        return apiClient.execute(call);
    }

    /**
     * Check if a user is a collaborator of a repository (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param collaborator username of the collaborator (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoCheckCollaboratorAsync(String owner, String repo, String collaborator, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoCheckCollaboratorValidateBeforeCall(owner, repo, collaborator, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for repoCheckTeam
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param team team name (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoCheckTeamCall(String owner, String repo, String team, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/teams/{team}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "team" + "\\}", apiClient.escapeString(team.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoCheckTeamValidateBeforeCall(String owner, String repo, String team, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoCheckTeam(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoCheckTeam(Async)");
        }
        
        // verify the required parameter 'team' is set
        if (team == null) {
            throw new ApiException("Missing the required parameter 'team' when calling repoCheckTeam(Async)");
        }
        

        com.squareup.okhttp.Call call = repoCheckTeamCall(owner, repo, team, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Check if a team is assigned to a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param team team name (required)
     * @return Team
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Team repoCheckTeam(String owner, String repo, String team) throws ApiException {
        ApiResponse<Team> resp = repoCheckTeamWithHttpInfo(owner, repo, team);
        return resp.getData();
    }

    /**
     * Check if a team is assigned to a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param team team name (required)
     * @return ApiResponse&lt;Team&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Team> repoCheckTeamWithHttpInfo(String owner, String repo, String team) throws ApiException {
        com.squareup.okhttp.Call call = repoCheckTeamValidateBeforeCall(owner, repo, team, null, null);
        Type localVarReturnType = new TypeToken<Team>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Check if a team is assigned to a repository (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param team team name (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoCheckTeamAsync(String owner, String repo, String team, final ApiCallback<Team> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoCheckTeamValidateBeforeCall(owner, repo, team, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Team>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoCreateBranch
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoCreateBranchCall(String owner, String repo, CreateBranchRepoOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/branches"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoCreateBranchValidateBeforeCall(String owner, String repo, CreateBranchRepoOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoCreateBranch(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoCreateBranch(Async)");
        }
        

        com.squareup.okhttp.Call call = repoCreateBranchCall(owner, repo, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Create a branch
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @return Branch
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Branch repoCreateBranch(String owner, String repo, CreateBranchRepoOption body) throws ApiException {
        ApiResponse<Branch> resp = repoCreateBranchWithHttpInfo(owner, repo, body);
        return resp.getData();
    }

    /**
     * Create a branch
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @return ApiResponse&lt;Branch&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Branch> repoCreateBranchWithHttpInfo(String owner, String repo, CreateBranchRepoOption body) throws ApiException {
        com.squareup.okhttp.Call call = repoCreateBranchValidateBeforeCall(owner, repo, body, null, null);
        Type localVarReturnType = new TypeToken<Branch>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Create a branch (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoCreateBranchAsync(String owner, String repo, CreateBranchRepoOption body, final ApiCallback<Branch> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoCreateBranchValidateBeforeCall(owner, repo, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Branch>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoCreateBranchProtection
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoCreateBranchProtectionCall(String owner, String repo, CreateBranchProtectionOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/branch_protections"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoCreateBranchProtectionValidateBeforeCall(String owner, String repo, CreateBranchProtectionOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoCreateBranchProtection(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoCreateBranchProtection(Async)");
        }
        

        com.squareup.okhttp.Call call = repoCreateBranchProtectionCall(owner, repo, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Create a branch protections for a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @return BranchProtection
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public BranchProtection repoCreateBranchProtection(String owner, String repo, CreateBranchProtectionOption body) throws ApiException {
        ApiResponse<BranchProtection> resp = repoCreateBranchProtectionWithHttpInfo(owner, repo, body);
        return resp.getData();
    }

    /**
     * Create a branch protections for a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @return ApiResponse&lt;BranchProtection&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<BranchProtection> repoCreateBranchProtectionWithHttpInfo(String owner, String repo, CreateBranchProtectionOption body) throws ApiException {
        com.squareup.okhttp.Call call = repoCreateBranchProtectionValidateBeforeCall(owner, repo, body, null, null);
        Type localVarReturnType = new TypeToken<BranchProtection>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Create a branch protections for a repository (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoCreateBranchProtectionAsync(String owner, String repo, CreateBranchProtectionOption body, final ApiCallback<BranchProtection> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoCreateBranchProtectionValidateBeforeCall(owner, repo, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<BranchProtection>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoCreateFile
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param filepath path of the file to create (required)
     * @param body  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoCreateFileCall(String owner, String repo, String filepath, CreateFileOptions body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/contents/{filepath}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "filepath" + "\\}", apiClient.escapeString(filepath.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoCreateFileValidateBeforeCall(String owner, String repo, String filepath, CreateFileOptions body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoCreateFile(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoCreateFile(Async)");
        }
        
        // verify the required parameter 'filepath' is set
        if (filepath == null) {
            throw new ApiException("Missing the required parameter 'filepath' when calling repoCreateFile(Async)");
        }
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling repoCreateFile(Async)");
        }
        

        com.squareup.okhttp.Call call = repoCreateFileCall(owner, repo, filepath, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Create a file in a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param filepath path of the file to create (required)
     * @param body  (required)
     * @return FileResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public FileResponse repoCreateFile(String owner, String repo, String filepath, CreateFileOptions body) throws ApiException {
        ApiResponse<FileResponse> resp = repoCreateFileWithHttpInfo(owner, repo, filepath, body);
        return resp.getData();
    }

    /**
     * Create a file in a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param filepath path of the file to create (required)
     * @param body  (required)
     * @return ApiResponse&lt;FileResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<FileResponse> repoCreateFileWithHttpInfo(String owner, String repo, String filepath, CreateFileOptions body) throws ApiException {
        com.squareup.okhttp.Call call = repoCreateFileValidateBeforeCall(owner, repo, filepath, body, null, null);
        Type localVarReturnType = new TypeToken<FileResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Create a file in a repository (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param filepath path of the file to create (required)
     * @param body  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoCreateFileAsync(String owner, String repo, String filepath, CreateFileOptions body, final ApiCallback<FileResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoCreateFileValidateBeforeCall(owner, repo, filepath, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FileResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoCreateHook
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoCreateHookCall(String owner, String repo, CreateHookOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/hooks"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoCreateHookValidateBeforeCall(String owner, String repo, CreateHookOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoCreateHook(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoCreateHook(Async)");
        }
        

        com.squareup.okhttp.Call call = repoCreateHookCall(owner, repo, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Create a hook
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @return Hook
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Hook repoCreateHook(String owner, String repo, CreateHookOption body) throws ApiException {
        ApiResponse<Hook> resp = repoCreateHookWithHttpInfo(owner, repo, body);
        return resp.getData();
    }

    /**
     * Create a hook
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @return ApiResponse&lt;Hook&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Hook> repoCreateHookWithHttpInfo(String owner, String repo, CreateHookOption body) throws ApiException {
        com.squareup.okhttp.Call call = repoCreateHookValidateBeforeCall(owner, repo, body, null, null);
        Type localVarReturnType = new TypeToken<Hook>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Create a hook (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoCreateHookAsync(String owner, String repo, CreateHookOption body, final ApiCallback<Hook> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoCreateHookValidateBeforeCall(owner, repo, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Hook>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoCreateKey
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoCreateKeyCall(String owner, String repo, CreateKeyOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/keys"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoCreateKeyValidateBeforeCall(String owner, String repo, CreateKeyOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoCreateKey(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoCreateKey(Async)");
        }
        

        com.squareup.okhttp.Call call = repoCreateKeyCall(owner, repo, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Add a key to a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @return DeployKey
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public DeployKey repoCreateKey(String owner, String repo, CreateKeyOption body) throws ApiException {
        ApiResponse<DeployKey> resp = repoCreateKeyWithHttpInfo(owner, repo, body);
        return resp.getData();
    }

    /**
     * Add a key to a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @return ApiResponse&lt;DeployKey&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<DeployKey> repoCreateKeyWithHttpInfo(String owner, String repo, CreateKeyOption body) throws ApiException {
        com.squareup.okhttp.Call call = repoCreateKeyValidateBeforeCall(owner, repo, body, null, null);
        Type localVarReturnType = new TypeToken<DeployKey>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Add a key to a repository (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoCreateKeyAsync(String owner, String repo, CreateKeyOption body, final ApiCallback<DeployKey> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoCreateKeyValidateBeforeCall(owner, repo, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeployKey>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoCreatePullRequest
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoCreatePullRequestCall(String owner, String repo, CreatePullRequestOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/pulls"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoCreatePullRequestValidateBeforeCall(String owner, String repo, CreatePullRequestOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoCreatePullRequest(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoCreatePullRequest(Async)");
        }
        

        com.squareup.okhttp.Call call = repoCreatePullRequestCall(owner, repo, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Create a pull request
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @return PullRequest
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public PullRequest repoCreatePullRequest(String owner, String repo, CreatePullRequestOption body) throws ApiException {
        ApiResponse<PullRequest> resp = repoCreatePullRequestWithHttpInfo(owner, repo, body);
        return resp.getData();
    }

    /**
     * Create a pull request
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @return ApiResponse&lt;PullRequest&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<PullRequest> repoCreatePullRequestWithHttpInfo(String owner, String repo, CreatePullRequestOption body) throws ApiException {
        com.squareup.okhttp.Call call = repoCreatePullRequestValidateBeforeCall(owner, repo, body, null, null);
        Type localVarReturnType = new TypeToken<PullRequest>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Create a pull request (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoCreatePullRequestAsync(String owner, String repo, CreatePullRequestOption body, final ApiCallback<PullRequest> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoCreatePullRequestValidateBeforeCall(owner, repo, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PullRequest>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoCreatePullReview
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request (required)
     * @param body  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoCreatePullReviewCall(String owner, String repo, Long index, CreatePullReviewOptions body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/pulls/{index}/reviews"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoCreatePullReviewValidateBeforeCall(String owner, String repo, Long index, CreatePullReviewOptions body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoCreatePullReview(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoCreatePullReview(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling repoCreatePullReview(Async)");
        }
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling repoCreatePullReview(Async)");
        }
        

        com.squareup.okhttp.Call call = repoCreatePullReviewCall(owner, repo, index, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Create a review to an pull request
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request (required)
     * @param body  (required)
     * @return PullReview
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public PullReview repoCreatePullReview(String owner, String repo, Long index, CreatePullReviewOptions body) throws ApiException {
        ApiResponse<PullReview> resp = repoCreatePullReviewWithHttpInfo(owner, repo, index, body);
        return resp.getData();
    }

    /**
     * Create a review to an pull request
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request (required)
     * @param body  (required)
     * @return ApiResponse&lt;PullReview&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<PullReview> repoCreatePullReviewWithHttpInfo(String owner, String repo, Long index, CreatePullReviewOptions body) throws ApiException {
        com.squareup.okhttp.Call call = repoCreatePullReviewValidateBeforeCall(owner, repo, index, body, null, null);
        Type localVarReturnType = new TypeToken<PullReview>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Create a review to an pull request (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request (required)
     * @param body  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoCreatePullReviewAsync(String owner, String repo, Long index, CreatePullReviewOptions body, final ApiCallback<PullReview> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoCreatePullReviewValidateBeforeCall(owner, repo, index, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PullReview>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoCreatePullReviewRequests
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request (required)
     * @param body  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoCreatePullReviewRequestsCall(String owner, String repo, Long index, PullReviewRequestOptions body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/pulls/{index}/requested_reviewers"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoCreatePullReviewRequestsValidateBeforeCall(String owner, String repo, Long index, PullReviewRequestOptions body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoCreatePullReviewRequests(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoCreatePullReviewRequests(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling repoCreatePullReviewRequests(Async)");
        }
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling repoCreatePullReviewRequests(Async)");
        }
        

        com.squareup.okhttp.Call call = repoCreatePullReviewRequestsCall(owner, repo, index, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * create review requests for a pull request
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request (required)
     * @param body  (required)
     * @return List&lt;PullReview&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<PullReview> repoCreatePullReviewRequests(String owner, String repo, Long index, PullReviewRequestOptions body) throws ApiException {
        ApiResponse<List<PullReview>> resp = repoCreatePullReviewRequestsWithHttpInfo(owner, repo, index, body);
        return resp.getData();
    }

    /**
     * create review requests for a pull request
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request (required)
     * @param body  (required)
     * @return ApiResponse&lt;List&lt;PullReview&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<PullReview>> repoCreatePullReviewRequestsWithHttpInfo(String owner, String repo, Long index, PullReviewRequestOptions body) throws ApiException {
        com.squareup.okhttp.Call call = repoCreatePullReviewRequestsValidateBeforeCall(owner, repo, index, body, null, null);
        Type localVarReturnType = new TypeToken<List<PullReview>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * create review requests for a pull request (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request (required)
     * @param body  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoCreatePullReviewRequestsAsync(String owner, String repo, Long index, PullReviewRequestOptions body, final ApiCallback<List<PullReview>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoCreatePullReviewRequestsValidateBeforeCall(owner, repo, index, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<PullReview>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoCreateRelease
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoCreateReleaseCall(String owner, String repo, CreateReleaseOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/releases"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoCreateReleaseValidateBeforeCall(String owner, String repo, CreateReleaseOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoCreateRelease(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoCreateRelease(Async)");
        }
        

        com.squareup.okhttp.Call call = repoCreateReleaseCall(owner, repo, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Create a release
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @return Release
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Release repoCreateRelease(String owner, String repo, CreateReleaseOption body) throws ApiException {
        ApiResponse<Release> resp = repoCreateReleaseWithHttpInfo(owner, repo, body);
        return resp.getData();
    }

    /**
     * Create a release
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @return ApiResponse&lt;Release&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Release> repoCreateReleaseWithHttpInfo(String owner, String repo, CreateReleaseOption body) throws ApiException {
        com.squareup.okhttp.Call call = repoCreateReleaseValidateBeforeCall(owner, repo, body, null, null);
        Type localVarReturnType = new TypeToken<Release>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Create a release (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoCreateReleaseAsync(String owner, String repo, CreateReleaseOption body, final ApiCallback<Release> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoCreateReleaseValidateBeforeCall(owner, repo, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Release>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoCreateReleaseAttachment
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the release (required)
     * @param attachment attachment to upload (required)
     * @param name name of the attachment (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoCreateReleaseAttachmentCall(String owner, String repo, Long id, File attachment, String name, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/releases/{id}/assets"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (name != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("name", name));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (attachment != null)
        localVarFormParams.put("attachment", attachment);

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "multipart/form-data"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoCreateReleaseAttachmentValidateBeforeCall(String owner, String repo, Long id, File attachment, String name, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoCreateReleaseAttachment(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoCreateReleaseAttachment(Async)");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoCreateReleaseAttachment(Async)");
        }
        
        // verify the required parameter 'attachment' is set
        if (attachment == null) {
            throw new ApiException("Missing the required parameter 'attachment' when calling repoCreateReleaseAttachment(Async)");
        }
        

        com.squareup.okhttp.Call call = repoCreateReleaseAttachmentCall(owner, repo, id, attachment, name, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Create a release attachment
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the release (required)
     * @param attachment attachment to upload (required)
     * @param name name of the attachment (optional)
     * @return Attachment
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Attachment repoCreateReleaseAttachment(String owner, String repo, Long id, File attachment, String name) throws ApiException {
        ApiResponse<Attachment> resp = repoCreateReleaseAttachmentWithHttpInfo(owner, repo, id, attachment, name);
        return resp.getData();
    }

    /**
     * Create a release attachment
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the release (required)
     * @param attachment attachment to upload (required)
     * @param name name of the attachment (optional)
     * @return ApiResponse&lt;Attachment&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Attachment> repoCreateReleaseAttachmentWithHttpInfo(String owner, String repo, Long id, File attachment, String name) throws ApiException {
        com.squareup.okhttp.Call call = repoCreateReleaseAttachmentValidateBeforeCall(owner, repo, id, attachment, name, null, null);
        Type localVarReturnType = new TypeToken<Attachment>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Create a release attachment (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the release (required)
     * @param attachment attachment to upload (required)
     * @param name name of the attachment (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoCreateReleaseAttachmentAsync(String owner, String repo, Long id, File attachment, String name, final ApiCallback<Attachment> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoCreateReleaseAttachmentValidateBeforeCall(owner, repo, id, attachment, name, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Attachment>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoCreateStatus
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param sha sha of the commit (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoCreateStatusCall(String owner, String repo, String sha, CreateStatusOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/statuses/{sha}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "sha" + "\\}", apiClient.escapeString(sha.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoCreateStatusValidateBeforeCall(String owner, String repo, String sha, CreateStatusOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoCreateStatus(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoCreateStatus(Async)");
        }
        
        // verify the required parameter 'sha' is set
        if (sha == null) {
            throw new ApiException("Missing the required parameter 'sha' when calling repoCreateStatus(Async)");
        }
        

        com.squareup.okhttp.Call call = repoCreateStatusCall(owner, repo, sha, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Create a commit status
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param sha sha of the commit (required)
     * @param body  (optional)
     * @return CommitStatus
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommitStatus repoCreateStatus(String owner, String repo, String sha, CreateStatusOption body) throws ApiException {
        ApiResponse<CommitStatus> resp = repoCreateStatusWithHttpInfo(owner, repo, sha, body);
        return resp.getData();
    }

    /**
     * Create a commit status
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param sha sha of the commit (required)
     * @param body  (optional)
     * @return ApiResponse&lt;CommitStatus&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommitStatus> repoCreateStatusWithHttpInfo(String owner, String repo, String sha, CreateStatusOption body) throws ApiException {
        com.squareup.okhttp.Call call = repoCreateStatusValidateBeforeCall(owner, repo, sha, body, null, null);
        Type localVarReturnType = new TypeToken<CommitStatus>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Create a commit status (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param sha sha of the commit (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoCreateStatusAsync(String owner, String repo, String sha, CreateStatusOption body, final ApiCallback<CommitStatus> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoCreateStatusValidateBeforeCall(owner, repo, sha, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommitStatus>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoCreateTag
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoCreateTagCall(String owner, String repo, CreateTagOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/tags"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoCreateTagValidateBeforeCall(String owner, String repo, CreateTagOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoCreateTag(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoCreateTag(Async)");
        }
        

        com.squareup.okhttp.Call call = repoCreateTagCall(owner, repo, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Create a new git tag in a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @return Tag
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Tag repoCreateTag(String owner, String repo, CreateTagOption body) throws ApiException {
        ApiResponse<Tag> resp = repoCreateTagWithHttpInfo(owner, repo, body);
        return resp.getData();
    }

    /**
     * Create a new git tag in a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @return ApiResponse&lt;Tag&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Tag> repoCreateTagWithHttpInfo(String owner, String repo, CreateTagOption body) throws ApiException {
        com.squareup.okhttp.Call call = repoCreateTagValidateBeforeCall(owner, repo, body, null, null);
        Type localVarReturnType = new TypeToken<Tag>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Create a new git tag in a repository (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoCreateTagAsync(String owner, String repo, CreateTagOption body, final ApiCallback<Tag> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoCreateTagValidateBeforeCall(owner, repo, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Tag>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoCreateWikiPage
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoCreateWikiPageCall(String owner, String repo, CreateWikiPageOptions body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/wiki/new"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/html"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoCreateWikiPageValidateBeforeCall(String owner, String repo, CreateWikiPageOptions body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoCreateWikiPage(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoCreateWikiPage(Async)");
        }
        

        com.squareup.okhttp.Call call = repoCreateWikiPageCall(owner, repo, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Create a wiki page
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @return WikiPage
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public WikiPage repoCreateWikiPage(String owner, String repo, CreateWikiPageOptions body) throws ApiException {
        ApiResponse<WikiPage> resp = repoCreateWikiPageWithHttpInfo(owner, repo, body);
        return resp.getData();
    }

    /**
     * Create a wiki page
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @return ApiResponse&lt;WikiPage&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<WikiPage> repoCreateWikiPageWithHttpInfo(String owner, String repo, CreateWikiPageOptions body) throws ApiException {
        com.squareup.okhttp.Call call = repoCreateWikiPageValidateBeforeCall(owner, repo, body, null, null);
        Type localVarReturnType = new TypeToken<WikiPage>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Create a wiki page (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoCreateWikiPageAsync(String owner, String repo, CreateWikiPageOptions body, final ApiCallback<WikiPage> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoCreateWikiPageValidateBeforeCall(owner, repo, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WikiPage>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoDelete
     * @param owner owner of the repo to delete (required)
     * @param repo name of the repo to delete (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoDeleteCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoDeleteValidateBeforeCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoDelete(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoDelete(Async)");
        }
        

        com.squareup.okhttp.Call call = repoDeleteCall(owner, repo, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete a repository
     * 
     * @param owner owner of the repo to delete (required)
     * @param repo name of the repo to delete (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void repoDelete(String owner, String repo) throws ApiException {
        repoDeleteWithHttpInfo(owner, repo);
    }

    /**
     * Delete a repository
     * 
     * @param owner owner of the repo to delete (required)
     * @param repo name of the repo to delete (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> repoDeleteWithHttpInfo(String owner, String repo) throws ApiException {
        com.squareup.okhttp.Call call = repoDeleteValidateBeforeCall(owner, repo, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete a repository (asynchronously)
     * 
     * @param owner owner of the repo to delete (required)
     * @param repo name of the repo to delete (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoDeleteAsync(String owner, String repo, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoDeleteValidateBeforeCall(owner, repo, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for repoDeleteBranch
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param branch branch to delete (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoDeleteBranchCall(String owner, String repo, String branch, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/branches/{branch}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "branch" + "\\}", apiClient.escapeString(branch.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoDeleteBranchValidateBeforeCall(String owner, String repo, String branch, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoDeleteBranch(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoDeleteBranch(Async)");
        }
        
        // verify the required parameter 'branch' is set
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling repoDeleteBranch(Async)");
        }
        

        com.squareup.okhttp.Call call = repoDeleteBranchCall(owner, repo, branch, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete a specific branch from a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param branch branch to delete (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void repoDeleteBranch(String owner, String repo, String branch) throws ApiException {
        repoDeleteBranchWithHttpInfo(owner, repo, branch);
    }

    /**
     * Delete a specific branch from a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param branch branch to delete (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> repoDeleteBranchWithHttpInfo(String owner, String repo, String branch) throws ApiException {
        com.squareup.okhttp.Call call = repoDeleteBranchValidateBeforeCall(owner, repo, branch, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete a specific branch from a repository (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param branch branch to delete (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoDeleteBranchAsync(String owner, String repo, String branch, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoDeleteBranchValidateBeforeCall(owner, repo, branch, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for repoDeleteBranchProtection
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param name name of protected branch (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoDeleteBranchProtectionCall(String owner, String repo, String name, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/branch_protections/{name}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoDeleteBranchProtectionValidateBeforeCall(String owner, String repo, String name, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoDeleteBranchProtection(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoDeleteBranchProtection(Async)");
        }
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling repoDeleteBranchProtection(Async)");
        }
        

        com.squareup.okhttp.Call call = repoDeleteBranchProtectionCall(owner, repo, name, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete a specific branch protection for the repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param name name of protected branch (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void repoDeleteBranchProtection(String owner, String repo, String name) throws ApiException {
        repoDeleteBranchProtectionWithHttpInfo(owner, repo, name);
    }

    /**
     * Delete a specific branch protection for the repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param name name of protected branch (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> repoDeleteBranchProtectionWithHttpInfo(String owner, String repo, String name) throws ApiException {
        com.squareup.okhttp.Call call = repoDeleteBranchProtectionValidateBeforeCall(owner, repo, name, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete a specific branch protection for the repository (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param name name of protected branch (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoDeleteBranchProtectionAsync(String owner, String repo, String name, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoDeleteBranchProtectionValidateBeforeCall(owner, repo, name, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for repoDeleteCollaborator
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param collaborator username of the collaborator to delete (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoDeleteCollaboratorCall(String owner, String repo, String collaborator, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/collaborators/{collaborator}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "collaborator" + "\\}", apiClient.escapeString(collaborator.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoDeleteCollaboratorValidateBeforeCall(String owner, String repo, String collaborator, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoDeleteCollaborator(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoDeleteCollaborator(Async)");
        }
        
        // verify the required parameter 'collaborator' is set
        if (collaborator == null) {
            throw new ApiException("Missing the required parameter 'collaborator' when calling repoDeleteCollaborator(Async)");
        }
        

        com.squareup.okhttp.Call call = repoDeleteCollaboratorCall(owner, repo, collaborator, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete a collaborator from a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param collaborator username of the collaborator to delete (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void repoDeleteCollaborator(String owner, String repo, String collaborator) throws ApiException {
        repoDeleteCollaboratorWithHttpInfo(owner, repo, collaborator);
    }

    /**
     * Delete a collaborator from a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param collaborator username of the collaborator to delete (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> repoDeleteCollaboratorWithHttpInfo(String owner, String repo, String collaborator) throws ApiException {
        com.squareup.okhttp.Call call = repoDeleteCollaboratorValidateBeforeCall(owner, repo, collaborator, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete a collaborator from a repository (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param collaborator username of the collaborator to delete (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoDeleteCollaboratorAsync(String owner, String repo, String collaborator, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoDeleteCollaboratorValidateBeforeCall(owner, repo, collaborator, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for repoDeleteFile
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param filepath path of the file to delete (required)
     * @param body  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoDeleteFileCall(String owner, String repo, String filepath, DeleteFileOptions body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/contents/{filepath}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "filepath" + "\\}", apiClient.escapeString(filepath.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoDeleteFileValidateBeforeCall(String owner, String repo, String filepath, DeleteFileOptions body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoDeleteFile(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoDeleteFile(Async)");
        }
        
        // verify the required parameter 'filepath' is set
        if (filepath == null) {
            throw new ApiException("Missing the required parameter 'filepath' when calling repoDeleteFile(Async)");
        }
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling repoDeleteFile(Async)");
        }
        

        com.squareup.okhttp.Call call = repoDeleteFileCall(owner, repo, filepath, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete a file in a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param filepath path of the file to delete (required)
     * @param body  (required)
     * @return FileDeleteResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public FileDeleteResponse repoDeleteFile(String owner, String repo, String filepath, DeleteFileOptions body) throws ApiException {
        ApiResponse<FileDeleteResponse> resp = repoDeleteFileWithHttpInfo(owner, repo, filepath, body);
        return resp.getData();
    }

    /**
     * Delete a file in a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param filepath path of the file to delete (required)
     * @param body  (required)
     * @return ApiResponse&lt;FileDeleteResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<FileDeleteResponse> repoDeleteFileWithHttpInfo(String owner, String repo, String filepath, DeleteFileOptions body) throws ApiException {
        com.squareup.okhttp.Call call = repoDeleteFileValidateBeforeCall(owner, repo, filepath, body, null, null);
        Type localVarReturnType = new TypeToken<FileDeleteResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Delete a file in a repository (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param filepath path of the file to delete (required)
     * @param body  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoDeleteFileAsync(String owner, String repo, String filepath, DeleteFileOptions body, final ApiCallback<FileDeleteResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoDeleteFileValidateBeforeCall(owner, repo, filepath, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FileDeleteResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoDeleteGitHook
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the hook to get (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoDeleteGitHookCall(String owner, String repo, String id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/hooks/git/{id}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoDeleteGitHookValidateBeforeCall(String owner, String repo, String id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoDeleteGitHook(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoDeleteGitHook(Async)");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoDeleteGitHook(Async)");
        }
        

        com.squareup.okhttp.Call call = repoDeleteGitHookCall(owner, repo, id, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete a Git hook in a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the hook to get (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void repoDeleteGitHook(String owner, String repo, String id) throws ApiException {
        repoDeleteGitHookWithHttpInfo(owner, repo, id);
    }

    /**
     * Delete a Git hook in a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the hook to get (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> repoDeleteGitHookWithHttpInfo(String owner, String repo, String id) throws ApiException {
        com.squareup.okhttp.Call call = repoDeleteGitHookValidateBeforeCall(owner, repo, id, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete a Git hook in a repository (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the hook to get (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoDeleteGitHookAsync(String owner, String repo, String id, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoDeleteGitHookValidateBeforeCall(owner, repo, id, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for repoDeleteHook
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the hook to delete (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoDeleteHookCall(String owner, String repo, Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/hooks/{id}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoDeleteHookValidateBeforeCall(String owner, String repo, Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoDeleteHook(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoDeleteHook(Async)");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoDeleteHook(Async)");
        }
        

        com.squareup.okhttp.Call call = repoDeleteHookCall(owner, repo, id, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete a hook in a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the hook to delete (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void repoDeleteHook(String owner, String repo, Long id) throws ApiException {
        repoDeleteHookWithHttpInfo(owner, repo, id);
    }

    /**
     * Delete a hook in a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the hook to delete (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> repoDeleteHookWithHttpInfo(String owner, String repo, Long id) throws ApiException {
        com.squareup.okhttp.Call call = repoDeleteHookValidateBeforeCall(owner, repo, id, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete a hook in a repository (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the hook to delete (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoDeleteHookAsync(String owner, String repo, Long id, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoDeleteHookValidateBeforeCall(owner, repo, id, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for repoDeleteKey
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the key to delete (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoDeleteKeyCall(String owner, String repo, Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/keys/{id}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/html"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoDeleteKeyValidateBeforeCall(String owner, String repo, Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoDeleteKey(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoDeleteKey(Async)");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoDeleteKey(Async)");
        }
        

        com.squareup.okhttp.Call call = repoDeleteKeyCall(owner, repo, id, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete a key from a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the key to delete (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void repoDeleteKey(String owner, String repo, Long id) throws ApiException {
        repoDeleteKeyWithHttpInfo(owner, repo, id);
    }

    /**
     * Delete a key from a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the key to delete (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> repoDeleteKeyWithHttpInfo(String owner, String repo, Long id) throws ApiException {
        com.squareup.okhttp.Call call = repoDeleteKeyValidateBeforeCall(owner, repo, id, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete a key from a repository (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the key to delete (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoDeleteKeyAsync(String owner, String repo, Long id, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoDeleteKeyValidateBeforeCall(owner, repo, id, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for repoDeletePullReview
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request (required)
     * @param id id of the review (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoDeletePullReviewCall(String owner, String repo, Long index, Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/pulls/{index}/reviews/{id}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()))
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoDeletePullReviewValidateBeforeCall(String owner, String repo, Long index, Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoDeletePullReview(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoDeletePullReview(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling repoDeletePullReview(Async)");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoDeletePullReview(Async)");
        }
        

        com.squareup.okhttp.Call call = repoDeletePullReviewCall(owner, repo, index, id, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete a specific review from a pull request
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request (required)
     * @param id id of the review (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void repoDeletePullReview(String owner, String repo, Long index, Long id) throws ApiException {
        repoDeletePullReviewWithHttpInfo(owner, repo, index, id);
    }

    /**
     * Delete a specific review from a pull request
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request (required)
     * @param id id of the review (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> repoDeletePullReviewWithHttpInfo(String owner, String repo, Long index, Long id) throws ApiException {
        com.squareup.okhttp.Call call = repoDeletePullReviewValidateBeforeCall(owner, repo, index, id, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete a specific review from a pull request (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request (required)
     * @param id id of the review (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoDeletePullReviewAsync(String owner, String repo, Long index, Long id, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoDeletePullReviewValidateBeforeCall(owner, repo, index, id, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for repoDeletePullReviewRequests
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request (required)
     * @param body  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoDeletePullReviewRequestsCall(String owner, String repo, Long index, PullReviewRequestOptions body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/pulls/{index}/requested_reviewers"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoDeletePullReviewRequestsValidateBeforeCall(String owner, String repo, Long index, PullReviewRequestOptions body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoDeletePullReviewRequests(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoDeletePullReviewRequests(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling repoDeletePullReviewRequests(Async)");
        }
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling repoDeletePullReviewRequests(Async)");
        }
        

        com.squareup.okhttp.Call call = repoDeletePullReviewRequestsCall(owner, repo, index, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * cancel review requests for a pull request
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request (required)
     * @param body  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void repoDeletePullReviewRequests(String owner, String repo, Long index, PullReviewRequestOptions body) throws ApiException {
        repoDeletePullReviewRequestsWithHttpInfo(owner, repo, index, body);
    }

    /**
     * cancel review requests for a pull request
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request (required)
     * @param body  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> repoDeletePullReviewRequestsWithHttpInfo(String owner, String repo, Long index, PullReviewRequestOptions body) throws ApiException {
        com.squareup.okhttp.Call call = repoDeletePullReviewRequestsValidateBeforeCall(owner, repo, index, body, null, null);
        return apiClient.execute(call);
    }

    /**
     * cancel review requests for a pull request (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request (required)
     * @param body  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoDeletePullReviewRequestsAsync(String owner, String repo, Long index, PullReviewRequestOptions body, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoDeletePullReviewRequestsValidateBeforeCall(owner, repo, index, body, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for repoDeletePushMirror
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param name remote name of the pushMirror (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoDeletePushMirrorCall(String owner, String repo, String name, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/push_mirrors/{name}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoDeletePushMirrorValidateBeforeCall(String owner, String repo, String name, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoDeletePushMirror(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoDeletePushMirror(Async)");
        }
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling repoDeletePushMirror(Async)");
        }
        

        com.squareup.okhttp.Call call = repoDeletePushMirrorCall(owner, repo, name, progressListener, progressRequestListener);
        return call;

    }

    /**
     * deletes a push mirror from a repository by remoteName
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param name remote name of the pushMirror (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void repoDeletePushMirror(String owner, String repo, String name) throws ApiException {
        repoDeletePushMirrorWithHttpInfo(owner, repo, name);
    }

    /**
     * deletes a push mirror from a repository by remoteName
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param name remote name of the pushMirror (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> repoDeletePushMirrorWithHttpInfo(String owner, String repo, String name) throws ApiException {
        com.squareup.okhttp.Call call = repoDeletePushMirrorValidateBeforeCall(owner, repo, name, null, null);
        return apiClient.execute(call);
    }

    /**
     * deletes a push mirror from a repository by remoteName (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param name remote name of the pushMirror (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoDeletePushMirrorAsync(String owner, String repo, String name, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoDeletePushMirrorValidateBeforeCall(owner, repo, name, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for repoDeleteRelease
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the release to delete (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoDeleteReleaseCall(String owner, String repo, Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/releases/{id}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/html"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoDeleteReleaseValidateBeforeCall(String owner, String repo, Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoDeleteRelease(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoDeleteRelease(Async)");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoDeleteRelease(Async)");
        }
        

        com.squareup.okhttp.Call call = repoDeleteReleaseCall(owner, repo, id, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete a release
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the release to delete (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void repoDeleteRelease(String owner, String repo, Long id) throws ApiException {
        repoDeleteReleaseWithHttpInfo(owner, repo, id);
    }

    /**
     * Delete a release
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the release to delete (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> repoDeleteReleaseWithHttpInfo(String owner, String repo, Long id) throws ApiException {
        com.squareup.okhttp.Call call = repoDeleteReleaseValidateBeforeCall(owner, repo, id, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete a release (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the release to delete (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoDeleteReleaseAsync(String owner, String repo, Long id, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoDeleteReleaseValidateBeforeCall(owner, repo, id, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for repoDeleteReleaseAttachment
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the release (required)
     * @param attachmentId id of the attachment to delete (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoDeleteReleaseAttachmentCall(String owner, String repo, Long id, Long attachmentId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/releases/{id}/assets/{attachment_id}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()))
            .replaceAll("\\{" + "attachment_id" + "\\}", apiClient.escapeString(attachmentId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoDeleteReleaseAttachmentValidateBeforeCall(String owner, String repo, Long id, Long attachmentId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoDeleteReleaseAttachment(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoDeleteReleaseAttachment(Async)");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoDeleteReleaseAttachment(Async)");
        }
        
        // verify the required parameter 'attachmentId' is set
        if (attachmentId == null) {
            throw new ApiException("Missing the required parameter 'attachmentId' when calling repoDeleteReleaseAttachment(Async)");
        }
        

        com.squareup.okhttp.Call call = repoDeleteReleaseAttachmentCall(owner, repo, id, attachmentId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete a release attachment
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the release (required)
     * @param attachmentId id of the attachment to delete (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void repoDeleteReleaseAttachment(String owner, String repo, Long id, Long attachmentId) throws ApiException {
        repoDeleteReleaseAttachmentWithHttpInfo(owner, repo, id, attachmentId);
    }

    /**
     * Delete a release attachment
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the release (required)
     * @param attachmentId id of the attachment to delete (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> repoDeleteReleaseAttachmentWithHttpInfo(String owner, String repo, Long id, Long attachmentId) throws ApiException {
        com.squareup.okhttp.Call call = repoDeleteReleaseAttachmentValidateBeforeCall(owner, repo, id, attachmentId, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete a release attachment (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the release (required)
     * @param attachmentId id of the attachment to delete (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoDeleteReleaseAttachmentAsync(String owner, String repo, Long id, Long attachmentId, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoDeleteReleaseAttachmentValidateBeforeCall(owner, repo, id, attachmentId, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for repoDeleteReleaseByTag
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param tag tag name of the release to delete (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoDeleteReleaseByTagCall(String owner, String repo, String tag, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/releases/tags/{tag}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "tag" + "\\}", apiClient.escapeString(tag.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/html"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoDeleteReleaseByTagValidateBeforeCall(String owner, String repo, String tag, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoDeleteReleaseByTag(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoDeleteReleaseByTag(Async)");
        }
        
        // verify the required parameter 'tag' is set
        if (tag == null) {
            throw new ApiException("Missing the required parameter 'tag' when calling repoDeleteReleaseByTag(Async)");
        }
        

        com.squareup.okhttp.Call call = repoDeleteReleaseByTagCall(owner, repo, tag, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete a release by tag name
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param tag tag name of the release to delete (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void repoDeleteReleaseByTag(String owner, String repo, String tag) throws ApiException {
        repoDeleteReleaseByTagWithHttpInfo(owner, repo, tag);
    }

    /**
     * Delete a release by tag name
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param tag tag name of the release to delete (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> repoDeleteReleaseByTagWithHttpInfo(String owner, String repo, String tag) throws ApiException {
        com.squareup.okhttp.Call call = repoDeleteReleaseByTagValidateBeforeCall(owner, repo, tag, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete a release by tag name (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param tag tag name of the release to delete (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoDeleteReleaseByTagAsync(String owner, String repo, String tag, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoDeleteReleaseByTagValidateBeforeCall(owner, repo, tag, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for repoDeleteTag
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param tag name of tag to delete (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoDeleteTagCall(String owner, String repo, String tag, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/tags/{tag}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "tag" + "\\}", apiClient.escapeString(tag.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoDeleteTagValidateBeforeCall(String owner, String repo, String tag, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoDeleteTag(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoDeleteTag(Async)");
        }
        
        // verify the required parameter 'tag' is set
        if (tag == null) {
            throw new ApiException("Missing the required parameter 'tag' when calling repoDeleteTag(Async)");
        }
        

        com.squareup.okhttp.Call call = repoDeleteTagCall(owner, repo, tag, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete a repository&#39;s tag by name
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param tag name of tag to delete (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void repoDeleteTag(String owner, String repo, String tag) throws ApiException {
        repoDeleteTagWithHttpInfo(owner, repo, tag);
    }

    /**
     * Delete a repository&#39;s tag by name
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param tag name of tag to delete (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> repoDeleteTagWithHttpInfo(String owner, String repo, String tag) throws ApiException {
        com.squareup.okhttp.Call call = repoDeleteTagValidateBeforeCall(owner, repo, tag, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete a repository&#39;s tag by name (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param tag name of tag to delete (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoDeleteTagAsync(String owner, String repo, String tag, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoDeleteTagValidateBeforeCall(owner, repo, tag, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for repoDeleteTeam
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param team team name (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoDeleteTeamCall(String owner, String repo, String team, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/teams/{team}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "team" + "\\}", apiClient.escapeString(team.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoDeleteTeamValidateBeforeCall(String owner, String repo, String team, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoDeleteTeam(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoDeleteTeam(Async)");
        }
        
        // verify the required parameter 'team' is set
        if (team == null) {
            throw new ApiException("Missing the required parameter 'team' when calling repoDeleteTeam(Async)");
        }
        

        com.squareup.okhttp.Call call = repoDeleteTeamCall(owner, repo, team, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete a team from a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param team team name (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void repoDeleteTeam(String owner, String repo, String team) throws ApiException {
        repoDeleteTeamWithHttpInfo(owner, repo, team);
    }

    /**
     * Delete a team from a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param team team name (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> repoDeleteTeamWithHttpInfo(String owner, String repo, String team) throws ApiException {
        com.squareup.okhttp.Call call = repoDeleteTeamValidateBeforeCall(owner, repo, team, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete a team from a repository (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param team team name (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoDeleteTeamAsync(String owner, String repo, String team, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoDeleteTeamValidateBeforeCall(owner, repo, team, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for repoDeleteTopic
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param topic name of the topic to delete (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoDeleteTopicCall(String owner, String repo, String topic, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/topics/{topic}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "topic" + "\\}", apiClient.escapeString(topic.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoDeleteTopicValidateBeforeCall(String owner, String repo, String topic, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoDeleteTopic(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoDeleteTopic(Async)");
        }
        
        // verify the required parameter 'topic' is set
        if (topic == null) {
            throw new ApiException("Missing the required parameter 'topic' when calling repoDeleteTopic(Async)");
        }
        

        com.squareup.okhttp.Call call = repoDeleteTopicCall(owner, repo, topic, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete a topic from a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param topic name of the topic to delete (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void repoDeleteTopic(String owner, String repo, String topic) throws ApiException {
        repoDeleteTopicWithHttpInfo(owner, repo, topic);
    }

    /**
     * Delete a topic from a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param topic name of the topic to delete (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> repoDeleteTopicWithHttpInfo(String owner, String repo, String topic) throws ApiException {
        com.squareup.okhttp.Call call = repoDeleteTopicValidateBeforeCall(owner, repo, topic, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete a topic from a repository (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param topic name of the topic to delete (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoDeleteTopicAsync(String owner, String repo, String topic, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoDeleteTopicValidateBeforeCall(owner, repo, topic, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for repoDeleteWikiPage
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param pageName name of the page (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoDeleteWikiPageCall(String owner, String repo, String pageName, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/wiki/page/{pageName}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "pageName" + "\\}", apiClient.escapeString(pageName.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/html"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoDeleteWikiPageValidateBeforeCall(String owner, String repo, String pageName, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoDeleteWikiPage(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoDeleteWikiPage(Async)");
        }
        
        // verify the required parameter 'pageName' is set
        if (pageName == null) {
            throw new ApiException("Missing the required parameter 'pageName' when calling repoDeleteWikiPage(Async)");
        }
        

        com.squareup.okhttp.Call call = repoDeleteWikiPageCall(owner, repo, pageName, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete a wiki page
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param pageName name of the page (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void repoDeleteWikiPage(String owner, String repo, String pageName) throws ApiException {
        repoDeleteWikiPageWithHttpInfo(owner, repo, pageName);
    }

    /**
     * Delete a wiki page
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param pageName name of the page (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> repoDeleteWikiPageWithHttpInfo(String owner, String repo, String pageName) throws ApiException {
        com.squareup.okhttp.Call call = repoDeleteWikiPageValidateBeforeCall(owner, repo, pageName, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete a wiki page (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param pageName name of the page (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoDeleteWikiPageAsync(String owner, String repo, String pageName, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoDeleteWikiPageValidateBeforeCall(owner, repo, pageName, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for repoDismissPullReview
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request (required)
     * @param id id of the review (required)
     * @param body  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoDismissPullReviewCall(String owner, String repo, Long index, Long id, DismissPullReviewOptions body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/pulls/{index}/reviews/{id}/dismissals"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()))
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoDismissPullReviewValidateBeforeCall(String owner, String repo, Long index, Long id, DismissPullReviewOptions body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoDismissPullReview(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoDismissPullReview(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling repoDismissPullReview(Async)");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoDismissPullReview(Async)");
        }
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling repoDismissPullReview(Async)");
        }
        

        com.squareup.okhttp.Call call = repoDismissPullReviewCall(owner, repo, index, id, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Dismiss a review for a pull request
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request (required)
     * @param id id of the review (required)
     * @param body  (required)
     * @return PullReview
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public PullReview repoDismissPullReview(String owner, String repo, Long index, Long id, DismissPullReviewOptions body) throws ApiException {
        ApiResponse<PullReview> resp = repoDismissPullReviewWithHttpInfo(owner, repo, index, id, body);
        return resp.getData();
    }

    /**
     * Dismiss a review for a pull request
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request (required)
     * @param id id of the review (required)
     * @param body  (required)
     * @return ApiResponse&lt;PullReview&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<PullReview> repoDismissPullReviewWithHttpInfo(String owner, String repo, Long index, Long id, DismissPullReviewOptions body) throws ApiException {
        com.squareup.okhttp.Call call = repoDismissPullReviewValidateBeforeCall(owner, repo, index, id, body, null, null);
        Type localVarReturnType = new TypeToken<PullReview>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Dismiss a review for a pull request (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request (required)
     * @param id id of the review (required)
     * @param body  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoDismissPullReviewAsync(String owner, String repo, Long index, Long id, DismissPullReviewOptions body, final ApiCallback<PullReview> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoDismissPullReviewValidateBeforeCall(owner, repo, index, id, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PullReview>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoDownloadCommitDiffOrPatch
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param sha SHA of the commit to get (required)
     * @param diffType whether the output is diff or patch (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoDownloadCommitDiffOrPatchCall(String owner, String repo, String sha, String diffType, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/git/commits/{sha}.{diffType}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "sha" + "\\}", apiClient.escapeString(sha.toString()))
            .replaceAll("\\{" + "diffType" + "\\}", apiClient.escapeString(diffType.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoDownloadCommitDiffOrPatchValidateBeforeCall(String owner, String repo, String sha, String diffType, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoDownloadCommitDiffOrPatch(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoDownloadCommitDiffOrPatch(Async)");
        }
        
        // verify the required parameter 'sha' is set
        if (sha == null) {
            throw new ApiException("Missing the required parameter 'sha' when calling repoDownloadCommitDiffOrPatch(Async)");
        }
        
        // verify the required parameter 'diffType' is set
        if (diffType == null) {
            throw new ApiException("Missing the required parameter 'diffType' when calling repoDownloadCommitDiffOrPatch(Async)");
        }
        

        com.squareup.okhttp.Call call = repoDownloadCommitDiffOrPatchCall(owner, repo, sha, diffType, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get a commit&#39;s diff or patch
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param sha SHA of the commit to get (required)
     * @param diffType whether the output is diff or patch (required)
     * @return String
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public String repoDownloadCommitDiffOrPatch(String owner, String repo, String sha, String diffType) throws ApiException {
        ApiResponse<String> resp = repoDownloadCommitDiffOrPatchWithHttpInfo(owner, repo, sha, diffType);
        return resp.getData();
    }

    /**
     * Get a commit&#39;s diff or patch
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param sha SHA of the commit to get (required)
     * @param diffType whether the output is diff or patch (required)
     * @return ApiResponse&lt;String&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<String> repoDownloadCommitDiffOrPatchWithHttpInfo(String owner, String repo, String sha, String diffType) throws ApiException {
        com.squareup.okhttp.Call call = repoDownloadCommitDiffOrPatchValidateBeforeCall(owner, repo, sha, diffType, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get a commit&#39;s diff or patch (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param sha SHA of the commit to get (required)
     * @param diffType whether the output is diff or patch (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoDownloadCommitDiffOrPatchAsync(String owner, String repo, String sha, String diffType, final ApiCallback<String> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoDownloadCommitDiffOrPatchValidateBeforeCall(owner, repo, sha, diffType, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoDownloadPullDiffOrPatch
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request to get (required)
     * @param diffType whether the output is diff or patch (required)
     * @param binary whether to include binary file changes. if true, the diff is applicable with &#x60;git apply&#x60; (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoDownloadPullDiffOrPatchCall(String owner, String repo, Long index, String diffType, Boolean binary, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/pulls/{index}.{diffType}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()))
            .replaceAll("\\{" + "diffType" + "\\}", apiClient.escapeString(diffType.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (binary != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("binary", binary));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoDownloadPullDiffOrPatchValidateBeforeCall(String owner, String repo, Long index, String diffType, Boolean binary, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoDownloadPullDiffOrPatch(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoDownloadPullDiffOrPatch(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling repoDownloadPullDiffOrPatch(Async)");
        }
        
        // verify the required parameter 'diffType' is set
        if (diffType == null) {
            throw new ApiException("Missing the required parameter 'diffType' when calling repoDownloadPullDiffOrPatch(Async)");
        }
        

        com.squareup.okhttp.Call call = repoDownloadPullDiffOrPatchCall(owner, repo, index, diffType, binary, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get a pull request diff or patch
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request to get (required)
     * @param diffType whether the output is diff or patch (required)
     * @param binary whether to include binary file changes. if true, the diff is applicable with &#x60;git apply&#x60; (optional)
     * @return String
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public String repoDownloadPullDiffOrPatch(String owner, String repo, Long index, String diffType, Boolean binary) throws ApiException {
        ApiResponse<String> resp = repoDownloadPullDiffOrPatchWithHttpInfo(owner, repo, index, diffType, binary);
        return resp.getData();
    }

    /**
     * Get a pull request diff or patch
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request to get (required)
     * @param diffType whether the output is diff or patch (required)
     * @param binary whether to include binary file changes. if true, the diff is applicable with &#x60;git apply&#x60; (optional)
     * @return ApiResponse&lt;String&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<String> repoDownloadPullDiffOrPatchWithHttpInfo(String owner, String repo, Long index, String diffType, Boolean binary) throws ApiException {
        com.squareup.okhttp.Call call = repoDownloadPullDiffOrPatchValidateBeforeCall(owner, repo, index, diffType, binary, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get a pull request diff or patch (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request to get (required)
     * @param diffType whether the output is diff or patch (required)
     * @param binary whether to include binary file changes. if true, the diff is applicable with &#x60;git apply&#x60; (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoDownloadPullDiffOrPatchAsync(String owner, String repo, Long index, String diffType, Boolean binary, final ApiCallback<String> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoDownloadPullDiffOrPatchValidateBeforeCall(owner, repo, index, diffType, binary, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoEdit
     * @param owner owner of the repo to edit (required)
     * @param repo name of the repo to edit (required)
     * @param body Properties of a repo that you can edit (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoEditCall(String owner, String repo, EditRepoOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoEditValidateBeforeCall(String owner, String repo, EditRepoOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoEdit(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoEdit(Async)");
        }
        

        com.squareup.okhttp.Call call = repoEditCall(owner, repo, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Edit a repository&#39;s properties. Only fields that are set will be changed.
     * 
     * @param owner owner of the repo to edit (required)
     * @param repo name of the repo to edit (required)
     * @param body Properties of a repo that you can edit (optional)
     * @return Repository
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Repository repoEdit(String owner, String repo, EditRepoOption body) throws ApiException {
        ApiResponse<Repository> resp = repoEditWithHttpInfo(owner, repo, body);
        return resp.getData();
    }

    /**
     * Edit a repository&#39;s properties. Only fields that are set will be changed.
     * 
     * @param owner owner of the repo to edit (required)
     * @param repo name of the repo to edit (required)
     * @param body Properties of a repo that you can edit (optional)
     * @return ApiResponse&lt;Repository&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Repository> repoEditWithHttpInfo(String owner, String repo, EditRepoOption body) throws ApiException {
        com.squareup.okhttp.Call call = repoEditValidateBeforeCall(owner, repo, body, null, null);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Edit a repository&#39;s properties. Only fields that are set will be changed. (asynchronously)
     * 
     * @param owner owner of the repo to edit (required)
     * @param repo name of the repo to edit (required)
     * @param body Properties of a repo that you can edit (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoEditAsync(String owner, String repo, EditRepoOption body, final ApiCallback<Repository> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoEditValidateBeforeCall(owner, repo, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoEditBranchProtection
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param name name of protected branch (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoEditBranchProtectionCall(String owner, String repo, String name, EditBranchProtectionOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/branch_protections/{name}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoEditBranchProtectionValidateBeforeCall(String owner, String repo, String name, EditBranchProtectionOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoEditBranchProtection(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoEditBranchProtection(Async)");
        }
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling repoEditBranchProtection(Async)");
        }
        

        com.squareup.okhttp.Call call = repoEditBranchProtectionCall(owner, repo, name, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Edit a branch protections for a repository. Only fields that are set will be changed
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param name name of protected branch (required)
     * @param body  (optional)
     * @return BranchProtection
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public BranchProtection repoEditBranchProtection(String owner, String repo, String name, EditBranchProtectionOption body) throws ApiException {
        ApiResponse<BranchProtection> resp = repoEditBranchProtectionWithHttpInfo(owner, repo, name, body);
        return resp.getData();
    }

    /**
     * Edit a branch protections for a repository. Only fields that are set will be changed
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param name name of protected branch (required)
     * @param body  (optional)
     * @return ApiResponse&lt;BranchProtection&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<BranchProtection> repoEditBranchProtectionWithHttpInfo(String owner, String repo, String name, EditBranchProtectionOption body) throws ApiException {
        com.squareup.okhttp.Call call = repoEditBranchProtectionValidateBeforeCall(owner, repo, name, body, null, null);
        Type localVarReturnType = new TypeToken<BranchProtection>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Edit a branch protections for a repository. Only fields that are set will be changed (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param name name of protected branch (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoEditBranchProtectionAsync(String owner, String repo, String name, EditBranchProtectionOption body, final ApiCallback<BranchProtection> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoEditBranchProtectionValidateBeforeCall(owner, repo, name, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<BranchProtection>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoEditGitHook
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the hook to get (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoEditGitHookCall(String owner, String repo, String id, EditGitHookOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/hooks/git/{id}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoEditGitHookValidateBeforeCall(String owner, String repo, String id, EditGitHookOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoEditGitHook(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoEditGitHook(Async)");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoEditGitHook(Async)");
        }
        

        com.squareup.okhttp.Call call = repoEditGitHookCall(owner, repo, id, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Edit a Git hook in a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the hook to get (required)
     * @param body  (optional)
     * @return GitHook
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GitHook repoEditGitHook(String owner, String repo, String id, EditGitHookOption body) throws ApiException {
        ApiResponse<GitHook> resp = repoEditGitHookWithHttpInfo(owner, repo, id, body);
        return resp.getData();
    }

    /**
     * Edit a Git hook in a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the hook to get (required)
     * @param body  (optional)
     * @return ApiResponse&lt;GitHook&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GitHook> repoEditGitHookWithHttpInfo(String owner, String repo, String id, EditGitHookOption body) throws ApiException {
        com.squareup.okhttp.Call call = repoEditGitHookValidateBeforeCall(owner, repo, id, body, null, null);
        Type localVarReturnType = new TypeToken<GitHook>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Edit a Git hook in a repository (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the hook to get (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoEditGitHookAsync(String owner, String repo, String id, EditGitHookOption body, final ApiCallback<GitHook> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoEditGitHookValidateBeforeCall(owner, repo, id, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GitHook>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoEditHook
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id index of the hook (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoEditHookCall(String owner, String repo, Long id, EditHookOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/hooks/{id}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoEditHookValidateBeforeCall(String owner, String repo, Long id, EditHookOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoEditHook(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoEditHook(Async)");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoEditHook(Async)");
        }
        

        com.squareup.okhttp.Call call = repoEditHookCall(owner, repo, id, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Edit a hook in a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id index of the hook (required)
     * @param body  (optional)
     * @return Hook
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Hook repoEditHook(String owner, String repo, Long id, EditHookOption body) throws ApiException {
        ApiResponse<Hook> resp = repoEditHookWithHttpInfo(owner, repo, id, body);
        return resp.getData();
    }

    /**
     * Edit a hook in a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id index of the hook (required)
     * @param body  (optional)
     * @return ApiResponse&lt;Hook&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Hook> repoEditHookWithHttpInfo(String owner, String repo, Long id, EditHookOption body) throws ApiException {
        com.squareup.okhttp.Call call = repoEditHookValidateBeforeCall(owner, repo, id, body, null, null);
        Type localVarReturnType = new TypeToken<Hook>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Edit a hook in a repository (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id index of the hook (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoEditHookAsync(String owner, String repo, Long id, EditHookOption body, final ApiCallback<Hook> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoEditHookValidateBeforeCall(owner, repo, id, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Hook>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoEditPullRequest
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request to edit (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoEditPullRequestCall(String owner, String repo, Long index, EditPullRequestOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/pulls/{index}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoEditPullRequestValidateBeforeCall(String owner, String repo, Long index, EditPullRequestOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoEditPullRequest(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoEditPullRequest(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling repoEditPullRequest(Async)");
        }
        

        com.squareup.okhttp.Call call = repoEditPullRequestCall(owner, repo, index, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Update a pull request. If using deadline only the date will be taken into account, and time of day ignored.
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request to edit (required)
     * @param body  (optional)
     * @return PullRequest
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public PullRequest repoEditPullRequest(String owner, String repo, Long index, EditPullRequestOption body) throws ApiException {
        ApiResponse<PullRequest> resp = repoEditPullRequestWithHttpInfo(owner, repo, index, body);
        return resp.getData();
    }

    /**
     * Update a pull request. If using deadline only the date will be taken into account, and time of day ignored.
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request to edit (required)
     * @param body  (optional)
     * @return ApiResponse&lt;PullRequest&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<PullRequest> repoEditPullRequestWithHttpInfo(String owner, String repo, Long index, EditPullRequestOption body) throws ApiException {
        com.squareup.okhttp.Call call = repoEditPullRequestValidateBeforeCall(owner, repo, index, body, null, null);
        Type localVarReturnType = new TypeToken<PullRequest>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Update a pull request. If using deadline only the date will be taken into account, and time of day ignored. (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request to edit (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoEditPullRequestAsync(String owner, String repo, Long index, EditPullRequestOption body, final ApiCallback<PullRequest> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoEditPullRequestValidateBeforeCall(owner, repo, index, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PullRequest>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoEditRelease
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the release to edit (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoEditReleaseCall(String owner, String repo, Long id, EditReleaseOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/releases/{id}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoEditReleaseValidateBeforeCall(String owner, String repo, Long id, EditReleaseOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoEditRelease(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoEditRelease(Async)");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoEditRelease(Async)");
        }
        

        com.squareup.okhttp.Call call = repoEditReleaseCall(owner, repo, id, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Update a release
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the release to edit (required)
     * @param body  (optional)
     * @return Release
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Release repoEditRelease(String owner, String repo, Long id, EditReleaseOption body) throws ApiException {
        ApiResponse<Release> resp = repoEditReleaseWithHttpInfo(owner, repo, id, body);
        return resp.getData();
    }

    /**
     * Update a release
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the release to edit (required)
     * @param body  (optional)
     * @return ApiResponse&lt;Release&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Release> repoEditReleaseWithHttpInfo(String owner, String repo, Long id, EditReleaseOption body) throws ApiException {
        com.squareup.okhttp.Call call = repoEditReleaseValidateBeforeCall(owner, repo, id, body, null, null);
        Type localVarReturnType = new TypeToken<Release>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Update a release (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the release to edit (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoEditReleaseAsync(String owner, String repo, Long id, EditReleaseOption body, final ApiCallback<Release> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoEditReleaseValidateBeforeCall(owner, repo, id, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Release>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoEditReleaseAttachment
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the release (required)
     * @param attachmentId id of the attachment to edit (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoEditReleaseAttachmentCall(String owner, String repo, Long id, Long attachmentId, EditAttachmentOptions body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/releases/{id}/assets/{attachment_id}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()))
            .replaceAll("\\{" + "attachment_id" + "\\}", apiClient.escapeString(attachmentId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoEditReleaseAttachmentValidateBeforeCall(String owner, String repo, Long id, Long attachmentId, EditAttachmentOptions body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoEditReleaseAttachment(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoEditReleaseAttachment(Async)");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoEditReleaseAttachment(Async)");
        }
        
        // verify the required parameter 'attachmentId' is set
        if (attachmentId == null) {
            throw new ApiException("Missing the required parameter 'attachmentId' when calling repoEditReleaseAttachment(Async)");
        }
        

        com.squareup.okhttp.Call call = repoEditReleaseAttachmentCall(owner, repo, id, attachmentId, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Edit a release attachment
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the release (required)
     * @param attachmentId id of the attachment to edit (required)
     * @param body  (optional)
     * @return Attachment
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Attachment repoEditReleaseAttachment(String owner, String repo, Long id, Long attachmentId, EditAttachmentOptions body) throws ApiException {
        ApiResponse<Attachment> resp = repoEditReleaseAttachmentWithHttpInfo(owner, repo, id, attachmentId, body);
        return resp.getData();
    }

    /**
     * Edit a release attachment
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the release (required)
     * @param attachmentId id of the attachment to edit (required)
     * @param body  (optional)
     * @return ApiResponse&lt;Attachment&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Attachment> repoEditReleaseAttachmentWithHttpInfo(String owner, String repo, Long id, Long attachmentId, EditAttachmentOptions body) throws ApiException {
        com.squareup.okhttp.Call call = repoEditReleaseAttachmentValidateBeforeCall(owner, repo, id, attachmentId, body, null, null);
        Type localVarReturnType = new TypeToken<Attachment>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Edit a release attachment (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the release (required)
     * @param attachmentId id of the attachment to edit (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoEditReleaseAttachmentAsync(String owner, String repo, Long id, Long attachmentId, EditAttachmentOptions body, final ApiCallback<Attachment> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoEditReleaseAttachmentValidateBeforeCall(owner, repo, id, attachmentId, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Attachment>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoEditWikiPage
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param pageName name of the page (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoEditWikiPageCall(String owner, String repo, String pageName, CreateWikiPageOptions body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/wiki/page/{pageName}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "pageName" + "\\}", apiClient.escapeString(pageName.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/html"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoEditWikiPageValidateBeforeCall(String owner, String repo, String pageName, CreateWikiPageOptions body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoEditWikiPage(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoEditWikiPage(Async)");
        }
        
        // verify the required parameter 'pageName' is set
        if (pageName == null) {
            throw new ApiException("Missing the required parameter 'pageName' when calling repoEditWikiPage(Async)");
        }
        

        com.squareup.okhttp.Call call = repoEditWikiPageCall(owner, repo, pageName, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Edit a wiki page
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param pageName name of the page (required)
     * @param body  (optional)
     * @return WikiPage
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public WikiPage repoEditWikiPage(String owner, String repo, String pageName, CreateWikiPageOptions body) throws ApiException {
        ApiResponse<WikiPage> resp = repoEditWikiPageWithHttpInfo(owner, repo, pageName, body);
        return resp.getData();
    }

    /**
     * Edit a wiki page
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param pageName name of the page (required)
     * @param body  (optional)
     * @return ApiResponse&lt;WikiPage&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<WikiPage> repoEditWikiPageWithHttpInfo(String owner, String repo, String pageName, CreateWikiPageOptions body) throws ApiException {
        com.squareup.okhttp.Call call = repoEditWikiPageValidateBeforeCall(owner, repo, pageName, body, null, null);
        Type localVarReturnType = new TypeToken<WikiPage>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Edit a wiki page (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param pageName name of the page (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoEditWikiPageAsync(String owner, String repo, String pageName, CreateWikiPageOptions body, final ApiCallback<WikiPage> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoEditWikiPageValidateBeforeCall(owner, repo, pageName, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WikiPage>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoGet
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoGetCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoGetValidateBeforeCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGet(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGet(Async)");
        }
        

        com.squareup.okhttp.Call call = repoGetCall(owner, repo, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @return Repository
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Repository repoGet(String owner, String repo) throws ApiException {
        ApiResponse<Repository> resp = repoGetWithHttpInfo(owner, repo);
        return resp.getData();
    }

    /**
     * Get a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @return ApiResponse&lt;Repository&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Repository> repoGetWithHttpInfo(String owner, String repo) throws ApiException {
        com.squareup.okhttp.Call call = repoGetValidateBeforeCall(owner, repo, null, null);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get a repository (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoGetAsync(String owner, String repo, final ApiCallback<Repository> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoGetValidateBeforeCall(owner, repo, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoGetAllCommits
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param sha SHA or branch to start listing commits from (usually &#39;master&#39;) (optional)
     * @param path filepath of a file/dir (optional)
     * @param stat include diff stats for every commit (disable for speedup, default &#39;true&#39;) (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (ignored if used with &#39;path&#39;) (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoGetAllCommitsCall(String owner, String repo, String sha, String path, Boolean stat, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/commits"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (sha != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("sha", sha));
        if (path != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("path", path));
        if (stat != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("stat", stat));
        if (page != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoGetAllCommitsValidateBeforeCall(String owner, String repo, String sha, String path, Boolean stat, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetAllCommits(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetAllCommits(Async)");
        }
        

        com.squareup.okhttp.Call call = repoGetAllCommitsCall(owner, repo, sha, path, stat, page, limit, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get a list of all commits from a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param sha SHA or branch to start listing commits from (usually &#39;master&#39;) (optional)
     * @param path filepath of a file/dir (optional)
     * @param stat include diff stats for every commit (disable for speedup, default &#39;true&#39;) (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (ignored if used with &#39;path&#39;) (optional)
     * @return List&lt;Commit&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<Commit> repoGetAllCommits(String owner, String repo, String sha, String path, Boolean stat, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<Commit>> resp = repoGetAllCommitsWithHttpInfo(owner, repo, sha, path, stat, page, limit);
        return resp.getData();
    }

    /**
     * Get a list of all commits from a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param sha SHA or branch to start listing commits from (usually &#39;master&#39;) (optional)
     * @param path filepath of a file/dir (optional)
     * @param stat include diff stats for every commit (disable for speedup, default &#39;true&#39;) (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (ignored if used with &#39;path&#39;) (optional)
     * @return ApiResponse&lt;List&lt;Commit&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<Commit>> repoGetAllCommitsWithHttpInfo(String owner, String repo, String sha, String path, Boolean stat, Integer page, Integer limit) throws ApiException {
        com.squareup.okhttp.Call call = repoGetAllCommitsValidateBeforeCall(owner, repo, sha, path, stat, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<Commit>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get a list of all commits from a repository (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param sha SHA or branch to start listing commits from (usually &#39;master&#39;) (optional)
     * @param path filepath of a file/dir (optional)
     * @param stat include diff stats for every commit (disable for speedup, default &#39;true&#39;) (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (ignored if used with &#39;path&#39;) (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoGetAllCommitsAsync(String owner, String repo, String sha, String path, Boolean stat, Integer page, Integer limit, final ApiCallback<List<Commit>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoGetAllCommitsValidateBeforeCall(owner, repo, sha, path, stat, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Commit>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoGetArchive
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param archive the git reference for download with attached archive format (e.g. master.zip) (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoGetArchiveCall(String owner, String repo, String archive, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/archive/{archive}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "archive" + "\\}", apiClient.escapeString(archive.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoGetArchiveValidateBeforeCall(String owner, String repo, String archive, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetArchive(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetArchive(Async)");
        }
        
        // verify the required parameter 'archive' is set
        if (archive == null) {
            throw new ApiException("Missing the required parameter 'archive' when calling repoGetArchive(Async)");
        }
        

        com.squareup.okhttp.Call call = repoGetArchiveCall(owner, repo, archive, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get an archive of a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param archive the git reference for download with attached archive format (e.g. master.zip) (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void repoGetArchive(String owner, String repo, String archive) throws ApiException {
        repoGetArchiveWithHttpInfo(owner, repo, archive);
    }

    /**
     * Get an archive of a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param archive the git reference for download with attached archive format (e.g. master.zip) (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> repoGetArchiveWithHttpInfo(String owner, String repo, String archive) throws ApiException {
        com.squareup.okhttp.Call call = repoGetArchiveValidateBeforeCall(owner, repo, archive, null, null);
        return apiClient.execute(call);
    }

    /**
     * Get an archive of a repository (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param archive the git reference for download with attached archive format (e.g. master.zip) (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoGetArchiveAsync(String owner, String repo, String archive, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoGetArchiveValidateBeforeCall(owner, repo, archive, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for repoGetAssignees
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoGetAssigneesCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/assignees"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoGetAssigneesValidateBeforeCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetAssignees(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetAssignees(Async)");
        }
        

        com.squareup.okhttp.Call call = repoGetAssigneesCall(owner, repo, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Return all users that have write access and can be assigned to issues
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @return List&lt;User&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<User> repoGetAssignees(String owner, String repo) throws ApiException {
        ApiResponse<List<User>> resp = repoGetAssigneesWithHttpInfo(owner, repo);
        return resp.getData();
    }

    /**
     * Return all users that have write access and can be assigned to issues
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @return ApiResponse&lt;List&lt;User&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<User>> repoGetAssigneesWithHttpInfo(String owner, String repo) throws ApiException {
        com.squareup.okhttp.Call call = repoGetAssigneesValidateBeforeCall(owner, repo, null, null);
        Type localVarReturnType = new TypeToken<List<User>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Return all users that have write access and can be assigned to issues (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoGetAssigneesAsync(String owner, String repo, final ApiCallback<List<User>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoGetAssigneesValidateBeforeCall(owner, repo, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<User>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoGetBranch
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param branch branch to get (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoGetBranchCall(String owner, String repo, String branch, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/branches/{branch}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "branch" + "\\}", apiClient.escapeString(branch.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoGetBranchValidateBeforeCall(String owner, String repo, String branch, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetBranch(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetBranch(Async)");
        }
        
        // verify the required parameter 'branch' is set
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling repoGetBranch(Async)");
        }
        

        com.squareup.okhttp.Call call = repoGetBranchCall(owner, repo, branch, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Retrieve a specific branch from a repository, including its effective branch protection
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param branch branch to get (required)
     * @return Branch
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Branch repoGetBranch(String owner, String repo, String branch) throws ApiException {
        ApiResponse<Branch> resp = repoGetBranchWithHttpInfo(owner, repo, branch);
        return resp.getData();
    }

    /**
     * Retrieve a specific branch from a repository, including its effective branch protection
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param branch branch to get (required)
     * @return ApiResponse&lt;Branch&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Branch> repoGetBranchWithHttpInfo(String owner, String repo, String branch) throws ApiException {
        com.squareup.okhttp.Call call = repoGetBranchValidateBeforeCall(owner, repo, branch, null, null);
        Type localVarReturnType = new TypeToken<Branch>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Retrieve a specific branch from a repository, including its effective branch protection (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param branch branch to get (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoGetBranchAsync(String owner, String repo, String branch, final ApiCallback<Branch> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoGetBranchValidateBeforeCall(owner, repo, branch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Branch>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoGetBranchProtection
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param name name of protected branch (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoGetBranchProtectionCall(String owner, String repo, String name, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/branch_protections/{name}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoGetBranchProtectionValidateBeforeCall(String owner, String repo, String name, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetBranchProtection(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetBranchProtection(Async)");
        }
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling repoGetBranchProtection(Async)");
        }
        

        com.squareup.okhttp.Call call = repoGetBranchProtectionCall(owner, repo, name, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get a specific branch protection for the repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param name name of protected branch (required)
     * @return BranchProtection
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public BranchProtection repoGetBranchProtection(String owner, String repo, String name) throws ApiException {
        ApiResponse<BranchProtection> resp = repoGetBranchProtectionWithHttpInfo(owner, repo, name);
        return resp.getData();
    }

    /**
     * Get a specific branch protection for the repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param name name of protected branch (required)
     * @return ApiResponse&lt;BranchProtection&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<BranchProtection> repoGetBranchProtectionWithHttpInfo(String owner, String repo, String name) throws ApiException {
        com.squareup.okhttp.Call call = repoGetBranchProtectionValidateBeforeCall(owner, repo, name, null, null);
        Type localVarReturnType = new TypeToken<BranchProtection>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get a specific branch protection for the repository (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param name name of protected branch (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoGetBranchProtectionAsync(String owner, String repo, String name, final ApiCallback<BranchProtection> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoGetBranchProtectionValidateBeforeCall(owner, repo, name, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<BranchProtection>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoGetByID
     * @param id id of the repo to get (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoGetByIDCall(Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repositories/{id}"
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoGetByIDValidateBeforeCall(Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoGetByID(Async)");
        }
        

        com.squareup.okhttp.Call call = repoGetByIDCall(id, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get a repository by id
     * 
     * @param id id of the repo to get (required)
     * @return Repository
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Repository repoGetByID(Long id) throws ApiException {
        ApiResponse<Repository> resp = repoGetByIDWithHttpInfo(id);
        return resp.getData();
    }

    /**
     * Get a repository by id
     * 
     * @param id id of the repo to get (required)
     * @return ApiResponse&lt;Repository&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Repository> repoGetByIDWithHttpInfo(Long id) throws ApiException {
        com.squareup.okhttp.Call call = repoGetByIDValidateBeforeCall(id, null, null);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get a repository by id (asynchronously)
     * 
     * @param id id of the repo to get (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoGetByIDAsync(Long id, final ApiCallback<Repository> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoGetByIDValidateBeforeCall(id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoGetCombinedStatusByRef
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param ref name of branch/tag/commit (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoGetCombinedStatusByRefCall(String owner, String repo, String ref, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/commits/{ref}/status"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "ref" + "\\}", apiClient.escapeString(ref.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoGetCombinedStatusByRefValidateBeforeCall(String owner, String repo, String ref, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetCombinedStatusByRef(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetCombinedStatusByRef(Async)");
        }
        
        // verify the required parameter 'ref' is set
        if (ref == null) {
            throw new ApiException("Missing the required parameter 'ref' when calling repoGetCombinedStatusByRef(Async)");
        }
        

        com.squareup.okhttp.Call call = repoGetCombinedStatusByRefCall(owner, repo, ref, page, limit, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get a commit&#39;s combined status, by branch/tag/commit reference
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param ref name of branch/tag/commit (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return CombinedStatus
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CombinedStatus repoGetCombinedStatusByRef(String owner, String repo, String ref, Integer page, Integer limit) throws ApiException {
        ApiResponse<CombinedStatus> resp = repoGetCombinedStatusByRefWithHttpInfo(owner, repo, ref, page, limit);
        return resp.getData();
    }

    /**
     * Get a commit&#39;s combined status, by branch/tag/commit reference
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param ref name of branch/tag/commit (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return ApiResponse&lt;CombinedStatus&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CombinedStatus> repoGetCombinedStatusByRefWithHttpInfo(String owner, String repo, String ref, Integer page, Integer limit) throws ApiException {
        com.squareup.okhttp.Call call = repoGetCombinedStatusByRefValidateBeforeCall(owner, repo, ref, page, limit, null, null);
        Type localVarReturnType = new TypeToken<CombinedStatus>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get a commit&#39;s combined status, by branch/tag/commit reference (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param ref name of branch/tag/commit (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoGetCombinedStatusByRefAsync(String owner, String repo, String ref, Integer page, Integer limit, final ApiCallback<CombinedStatus> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoGetCombinedStatusByRefValidateBeforeCall(owner, repo, ref, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CombinedStatus>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoGetContents
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param filepath path of the dir, file, symlink or submodule in the repo (required)
     * @param ref The name of the commit/branch/tag. Default the repository’s default branch (usually master) (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoGetContentsCall(String owner, String repo, String filepath, String ref, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/contents/{filepath}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "filepath" + "\\}", apiClient.escapeString(filepath.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (ref != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("ref", ref));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoGetContentsValidateBeforeCall(String owner, String repo, String filepath, String ref, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetContents(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetContents(Async)");
        }
        
        // verify the required parameter 'filepath' is set
        if (filepath == null) {
            throw new ApiException("Missing the required parameter 'filepath' when calling repoGetContents(Async)");
        }
        

        com.squareup.okhttp.Call call = repoGetContentsCall(owner, repo, filepath, ref, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Gets the metadata and contents (if a file) of an entry in a repository, or a list of entries if a dir
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param filepath path of the dir, file, symlink or submodule in the repo (required)
     * @param ref The name of the commit/branch/tag. Default the repository’s default branch (usually master) (optional)
     * @return ContentsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ContentsResponse repoGetContents(String owner, String repo, String filepath, String ref) throws ApiException {
        ApiResponse<ContentsResponse> resp = repoGetContentsWithHttpInfo(owner, repo, filepath, ref);
        return resp.getData();
    }

    /**
     * Gets the metadata and contents (if a file) of an entry in a repository, or a list of entries if a dir
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param filepath path of the dir, file, symlink or submodule in the repo (required)
     * @param ref The name of the commit/branch/tag. Default the repository’s default branch (usually master) (optional)
     * @return ApiResponse&lt;ContentsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ContentsResponse> repoGetContentsWithHttpInfo(String owner, String repo, String filepath, String ref) throws ApiException {
        com.squareup.okhttp.Call call = repoGetContentsValidateBeforeCall(owner, repo, filepath, ref, null, null);
        Type localVarReturnType = new TypeToken<ContentsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Gets the metadata and contents (if a file) of an entry in a repository, or a list of entries if a dir (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param filepath path of the dir, file, symlink or submodule in the repo (required)
     * @param ref The name of the commit/branch/tag. Default the repository’s default branch (usually master) (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoGetContentsAsync(String owner, String repo, String filepath, String ref, final ApiCallback<ContentsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoGetContentsValidateBeforeCall(owner, repo, filepath, ref, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ContentsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoGetContentsList
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param ref The name of the commit/branch/tag. Default the repository’s default branch (usually master) (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoGetContentsListCall(String owner, String repo, String ref, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/contents"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (ref != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("ref", ref));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoGetContentsListValidateBeforeCall(String owner, String repo, String ref, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetContentsList(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetContentsList(Async)");
        }
        

        com.squareup.okhttp.Call call = repoGetContentsListCall(owner, repo, ref, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Gets the metadata of all the entries of the root dir
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param ref The name of the commit/branch/tag. Default the repository’s default branch (usually master) (optional)
     * @return List&lt;ContentsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<ContentsResponse> repoGetContentsList(String owner, String repo, String ref) throws ApiException {
        ApiResponse<List<ContentsResponse>> resp = repoGetContentsListWithHttpInfo(owner, repo, ref);
        return resp.getData();
    }

    /**
     * Gets the metadata of all the entries of the root dir
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param ref The name of the commit/branch/tag. Default the repository’s default branch (usually master) (optional)
     * @return ApiResponse&lt;List&lt;ContentsResponse&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<ContentsResponse>> repoGetContentsListWithHttpInfo(String owner, String repo, String ref) throws ApiException {
        com.squareup.okhttp.Call call = repoGetContentsListValidateBeforeCall(owner, repo, ref, null, null);
        Type localVarReturnType = new TypeToken<List<ContentsResponse>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Gets the metadata of all the entries of the root dir (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param ref The name of the commit/branch/tag. Default the repository’s default branch (usually master) (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoGetContentsListAsync(String owner, String repo, String ref, final ApiCallback<List<ContentsResponse>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoGetContentsListValidateBeforeCall(owner, repo, ref, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<ContentsResponse>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoGetEditorConfig
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param filepath filepath of file to get (required)
     * @param ref The name of the commit/branch/tag. Default the repository’s default branch (usually master) (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoGetEditorConfigCall(String owner, String repo, String filepath, String ref, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/editorconfig/{filepath}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "filepath" + "\\}", apiClient.escapeString(filepath.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (ref != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("ref", ref));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoGetEditorConfigValidateBeforeCall(String owner, String repo, String filepath, String ref, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetEditorConfig(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetEditorConfig(Async)");
        }
        
        // verify the required parameter 'filepath' is set
        if (filepath == null) {
            throw new ApiException("Missing the required parameter 'filepath' when calling repoGetEditorConfig(Async)");
        }
        

        com.squareup.okhttp.Call call = repoGetEditorConfigCall(owner, repo, filepath, ref, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get the EditorConfig definitions of a file in a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param filepath filepath of file to get (required)
     * @param ref The name of the commit/branch/tag. Default the repository’s default branch (usually master) (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void repoGetEditorConfig(String owner, String repo, String filepath, String ref) throws ApiException {
        repoGetEditorConfigWithHttpInfo(owner, repo, filepath, ref);
    }

    /**
     * Get the EditorConfig definitions of a file in a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param filepath filepath of file to get (required)
     * @param ref The name of the commit/branch/tag. Default the repository’s default branch (usually master) (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> repoGetEditorConfigWithHttpInfo(String owner, String repo, String filepath, String ref) throws ApiException {
        com.squareup.okhttp.Call call = repoGetEditorConfigValidateBeforeCall(owner, repo, filepath, ref, null, null);
        return apiClient.execute(call);
    }

    /**
     * Get the EditorConfig definitions of a file in a repository (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param filepath filepath of file to get (required)
     * @param ref The name of the commit/branch/tag. Default the repository’s default branch (usually master) (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoGetEditorConfigAsync(String owner, String repo, String filepath, String ref, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoGetEditorConfigValidateBeforeCall(owner, repo, filepath, ref, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for repoGetGitHook
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the hook to get (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoGetGitHookCall(String owner, String repo, String id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/hooks/git/{id}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoGetGitHookValidateBeforeCall(String owner, String repo, String id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetGitHook(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetGitHook(Async)");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoGetGitHook(Async)");
        }
        

        com.squareup.okhttp.Call call = repoGetGitHookCall(owner, repo, id, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get a Git hook
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the hook to get (required)
     * @return GitHook
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GitHook repoGetGitHook(String owner, String repo, String id) throws ApiException {
        ApiResponse<GitHook> resp = repoGetGitHookWithHttpInfo(owner, repo, id);
        return resp.getData();
    }

    /**
     * Get a Git hook
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the hook to get (required)
     * @return ApiResponse&lt;GitHook&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GitHook> repoGetGitHookWithHttpInfo(String owner, String repo, String id) throws ApiException {
        com.squareup.okhttp.Call call = repoGetGitHookValidateBeforeCall(owner, repo, id, null, null);
        Type localVarReturnType = new TypeToken<GitHook>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get a Git hook (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the hook to get (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoGetGitHookAsync(String owner, String repo, String id, final ApiCallback<GitHook> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoGetGitHookValidateBeforeCall(owner, repo, id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GitHook>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoGetHook
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the hook to get (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoGetHookCall(String owner, String repo, Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/hooks/{id}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoGetHookValidateBeforeCall(String owner, String repo, Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetHook(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetHook(Async)");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoGetHook(Async)");
        }
        

        com.squareup.okhttp.Call call = repoGetHookCall(owner, repo, id, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get a hook
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the hook to get (required)
     * @return Hook
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Hook repoGetHook(String owner, String repo, Long id) throws ApiException {
        ApiResponse<Hook> resp = repoGetHookWithHttpInfo(owner, repo, id);
        return resp.getData();
    }

    /**
     * Get a hook
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the hook to get (required)
     * @return ApiResponse&lt;Hook&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Hook> repoGetHookWithHttpInfo(String owner, String repo, Long id) throws ApiException {
        com.squareup.okhttp.Call call = repoGetHookValidateBeforeCall(owner, repo, id, null, null);
        Type localVarReturnType = new TypeToken<Hook>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get a hook (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the hook to get (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoGetHookAsync(String owner, String repo, Long id, final ApiCallback<Hook> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoGetHookValidateBeforeCall(owner, repo, id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Hook>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoGetIssueTemplates
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoGetIssueTemplatesCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/issue_templates"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoGetIssueTemplatesValidateBeforeCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetIssueTemplates(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetIssueTemplates(Async)");
        }
        

        com.squareup.okhttp.Call call = repoGetIssueTemplatesCall(owner, repo, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get available issue templates for a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @return List&lt;IssueTemplate&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<IssueTemplate> repoGetIssueTemplates(String owner, String repo) throws ApiException {
        ApiResponse<List<IssueTemplate>> resp = repoGetIssueTemplatesWithHttpInfo(owner, repo);
        return resp.getData();
    }

    /**
     * Get available issue templates for a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @return ApiResponse&lt;List&lt;IssueTemplate&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<IssueTemplate>> repoGetIssueTemplatesWithHttpInfo(String owner, String repo) throws ApiException {
        com.squareup.okhttp.Call call = repoGetIssueTemplatesValidateBeforeCall(owner, repo, null, null);
        Type localVarReturnType = new TypeToken<List<IssueTemplate>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get available issue templates for a repository (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoGetIssueTemplatesAsync(String owner, String repo, final ApiCallback<List<IssueTemplate>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoGetIssueTemplatesValidateBeforeCall(owner, repo, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<IssueTemplate>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoGetKey
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the key to get (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoGetKeyCall(String owner, String repo, Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/keys/{id}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoGetKeyValidateBeforeCall(String owner, String repo, Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetKey(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetKey(Async)");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoGetKey(Async)");
        }
        

        com.squareup.okhttp.Call call = repoGetKeyCall(owner, repo, id, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get a repository&#39;s key by id
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the key to get (required)
     * @return DeployKey
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public DeployKey repoGetKey(String owner, String repo, Long id) throws ApiException {
        ApiResponse<DeployKey> resp = repoGetKeyWithHttpInfo(owner, repo, id);
        return resp.getData();
    }

    /**
     * Get a repository&#39;s key by id
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the key to get (required)
     * @return ApiResponse&lt;DeployKey&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<DeployKey> repoGetKeyWithHttpInfo(String owner, String repo, Long id) throws ApiException {
        com.squareup.okhttp.Call call = repoGetKeyValidateBeforeCall(owner, repo, id, null, null);
        Type localVarReturnType = new TypeToken<DeployKey>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get a repository&#39;s key by id (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the key to get (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoGetKeyAsync(String owner, String repo, Long id, final ApiCallback<DeployKey> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoGetKeyValidateBeforeCall(owner, repo, id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeployKey>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoGetLanguages
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoGetLanguagesCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/languages"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoGetLanguagesValidateBeforeCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetLanguages(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetLanguages(Async)");
        }
        

        com.squareup.okhttp.Call call = repoGetLanguagesCall(owner, repo, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get languages and number of bytes of code written
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @return Map&lt;String, Long&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Map<String, Long> repoGetLanguages(String owner, String repo) throws ApiException {
        ApiResponse<Map<String, Long>> resp = repoGetLanguagesWithHttpInfo(owner, repo);
        return resp.getData();
    }

    /**
     * Get languages and number of bytes of code written
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @return ApiResponse&lt;Map&lt;String, Long&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Map<String, Long>> repoGetLanguagesWithHttpInfo(String owner, String repo) throws ApiException {
        com.squareup.okhttp.Call call = repoGetLanguagesValidateBeforeCall(owner, repo, null, null);
        Type localVarReturnType = new TypeToken<Map<String, Long>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get languages and number of bytes of code written (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoGetLanguagesAsync(String owner, String repo, final ApiCallback<Map<String, Long>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoGetLanguagesValidateBeforeCall(owner, repo, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Map<String, Long>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoGetNote
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param sha a git ref or commit sha (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoGetNoteCall(String owner, String repo, String sha, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/git/notes/{sha}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "sha" + "\\}", apiClient.escapeString(sha.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoGetNoteValidateBeforeCall(String owner, String repo, String sha, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetNote(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetNote(Async)");
        }
        
        // verify the required parameter 'sha' is set
        if (sha == null) {
            throw new ApiException("Missing the required parameter 'sha' when calling repoGetNote(Async)");
        }
        

        com.squareup.okhttp.Call call = repoGetNoteCall(owner, repo, sha, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get a note corresponding to a single commit from a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param sha a git ref or commit sha (required)
     * @return Note
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Note repoGetNote(String owner, String repo, String sha) throws ApiException {
        ApiResponse<Note> resp = repoGetNoteWithHttpInfo(owner, repo, sha);
        return resp.getData();
    }

    /**
     * Get a note corresponding to a single commit from a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param sha a git ref or commit sha (required)
     * @return ApiResponse&lt;Note&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Note> repoGetNoteWithHttpInfo(String owner, String repo, String sha) throws ApiException {
        com.squareup.okhttp.Call call = repoGetNoteValidateBeforeCall(owner, repo, sha, null, null);
        Type localVarReturnType = new TypeToken<Note>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get a note corresponding to a single commit from a repository (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param sha a git ref or commit sha (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoGetNoteAsync(String owner, String repo, String sha, final ApiCallback<Note> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoGetNoteValidateBeforeCall(owner, repo, sha, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Note>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoGetPullRequest
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request to get (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoGetPullRequestCall(String owner, String repo, Long index, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/pulls/{index}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoGetPullRequestValidateBeforeCall(String owner, String repo, Long index, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetPullRequest(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetPullRequest(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling repoGetPullRequest(Async)");
        }
        

        com.squareup.okhttp.Call call = repoGetPullRequestCall(owner, repo, index, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get a pull request
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request to get (required)
     * @return PullRequest
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public PullRequest repoGetPullRequest(String owner, String repo, Long index) throws ApiException {
        ApiResponse<PullRequest> resp = repoGetPullRequestWithHttpInfo(owner, repo, index);
        return resp.getData();
    }

    /**
     * Get a pull request
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request to get (required)
     * @return ApiResponse&lt;PullRequest&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<PullRequest> repoGetPullRequestWithHttpInfo(String owner, String repo, Long index) throws ApiException {
        com.squareup.okhttp.Call call = repoGetPullRequestValidateBeforeCall(owner, repo, index, null, null);
        Type localVarReturnType = new TypeToken<PullRequest>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get a pull request (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request to get (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoGetPullRequestAsync(String owner, String repo, Long index, final ApiCallback<PullRequest> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoGetPullRequestValidateBeforeCall(owner, repo, index, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PullRequest>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoGetPullRequestCommits
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request to get (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoGetPullRequestCommitsCall(String owner, String repo, Long index, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/pulls/{index}/commits"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoGetPullRequestCommitsValidateBeforeCall(String owner, String repo, Long index, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetPullRequestCommits(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetPullRequestCommits(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling repoGetPullRequestCommits(Async)");
        }
        

        com.squareup.okhttp.Call call = repoGetPullRequestCommitsCall(owner, repo, index, page, limit, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get commits for a pull request
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request to get (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return List&lt;Commit&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<Commit> repoGetPullRequestCommits(String owner, String repo, Long index, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<Commit>> resp = repoGetPullRequestCommitsWithHttpInfo(owner, repo, index, page, limit);
        return resp.getData();
    }

    /**
     * Get commits for a pull request
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request to get (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return ApiResponse&lt;List&lt;Commit&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<Commit>> repoGetPullRequestCommitsWithHttpInfo(String owner, String repo, Long index, Integer page, Integer limit) throws ApiException {
        com.squareup.okhttp.Call call = repoGetPullRequestCommitsValidateBeforeCall(owner, repo, index, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<Commit>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get commits for a pull request (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request to get (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoGetPullRequestCommitsAsync(String owner, String repo, Long index, Integer page, Integer limit, final ApiCallback<List<Commit>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoGetPullRequestCommitsValidateBeforeCall(owner, repo, index, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Commit>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoGetPullRequestFiles
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request to get (required)
     * @param skipTo skip to given file (optional)
     * @param whitespace whitespace behavior (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoGetPullRequestFilesCall(String owner, String repo, Long index, String skipTo, String whitespace, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/pulls/{index}/files"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (skipTo != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("skip-to", skipTo));
        if (whitespace != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("whitespace", whitespace));
        if (page != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoGetPullRequestFilesValidateBeforeCall(String owner, String repo, Long index, String skipTo, String whitespace, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetPullRequestFiles(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetPullRequestFiles(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling repoGetPullRequestFiles(Async)");
        }
        

        com.squareup.okhttp.Call call = repoGetPullRequestFilesCall(owner, repo, index, skipTo, whitespace, page, limit, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get changed files for a pull request
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request to get (required)
     * @param skipTo skip to given file (optional)
     * @param whitespace whitespace behavior (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return List&lt;ChangedFile&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<ChangedFile> repoGetPullRequestFiles(String owner, String repo, Long index, String skipTo, String whitespace, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<ChangedFile>> resp = repoGetPullRequestFilesWithHttpInfo(owner, repo, index, skipTo, whitespace, page, limit);
        return resp.getData();
    }

    /**
     * Get changed files for a pull request
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request to get (required)
     * @param skipTo skip to given file (optional)
     * @param whitespace whitespace behavior (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return ApiResponse&lt;List&lt;ChangedFile&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<ChangedFile>> repoGetPullRequestFilesWithHttpInfo(String owner, String repo, Long index, String skipTo, String whitespace, Integer page, Integer limit) throws ApiException {
        com.squareup.okhttp.Call call = repoGetPullRequestFilesValidateBeforeCall(owner, repo, index, skipTo, whitespace, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<ChangedFile>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get changed files for a pull request (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request to get (required)
     * @param skipTo skip to given file (optional)
     * @param whitespace whitespace behavior (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoGetPullRequestFilesAsync(String owner, String repo, Long index, String skipTo, String whitespace, Integer page, Integer limit, final ApiCallback<List<ChangedFile>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoGetPullRequestFilesValidateBeforeCall(owner, repo, index, skipTo, whitespace, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<ChangedFile>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoGetPullReview
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request (required)
     * @param id id of the review (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoGetPullReviewCall(String owner, String repo, Long index, Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/pulls/{index}/reviews/{id}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()))
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoGetPullReviewValidateBeforeCall(String owner, String repo, Long index, Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetPullReview(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetPullReview(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling repoGetPullReview(Async)");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoGetPullReview(Async)");
        }
        

        com.squareup.okhttp.Call call = repoGetPullReviewCall(owner, repo, index, id, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get a specific review for a pull request
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request (required)
     * @param id id of the review (required)
     * @return PullReview
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public PullReview repoGetPullReview(String owner, String repo, Long index, Long id) throws ApiException {
        ApiResponse<PullReview> resp = repoGetPullReviewWithHttpInfo(owner, repo, index, id);
        return resp.getData();
    }

    /**
     * Get a specific review for a pull request
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request (required)
     * @param id id of the review (required)
     * @return ApiResponse&lt;PullReview&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<PullReview> repoGetPullReviewWithHttpInfo(String owner, String repo, Long index, Long id) throws ApiException {
        com.squareup.okhttp.Call call = repoGetPullReviewValidateBeforeCall(owner, repo, index, id, null, null);
        Type localVarReturnType = new TypeToken<PullReview>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get a specific review for a pull request (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request (required)
     * @param id id of the review (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoGetPullReviewAsync(String owner, String repo, Long index, Long id, final ApiCallback<PullReview> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoGetPullReviewValidateBeforeCall(owner, repo, index, id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PullReview>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoGetPullReviewComments
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request (required)
     * @param id id of the review (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoGetPullReviewCommentsCall(String owner, String repo, Long index, Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/pulls/{index}/reviews/{id}/comments"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()))
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoGetPullReviewCommentsValidateBeforeCall(String owner, String repo, Long index, Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetPullReviewComments(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetPullReviewComments(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling repoGetPullReviewComments(Async)");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoGetPullReviewComments(Async)");
        }
        

        com.squareup.okhttp.Call call = repoGetPullReviewCommentsCall(owner, repo, index, id, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get a specific review for a pull request
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request (required)
     * @param id id of the review (required)
     * @return List&lt;PullReviewComment&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<PullReviewComment> repoGetPullReviewComments(String owner, String repo, Long index, Long id) throws ApiException {
        ApiResponse<List<PullReviewComment>> resp = repoGetPullReviewCommentsWithHttpInfo(owner, repo, index, id);
        return resp.getData();
    }

    /**
     * Get a specific review for a pull request
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request (required)
     * @param id id of the review (required)
     * @return ApiResponse&lt;List&lt;PullReviewComment&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<PullReviewComment>> repoGetPullReviewCommentsWithHttpInfo(String owner, String repo, Long index, Long id) throws ApiException {
        com.squareup.okhttp.Call call = repoGetPullReviewCommentsValidateBeforeCall(owner, repo, index, id, null, null);
        Type localVarReturnType = new TypeToken<List<PullReviewComment>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get a specific review for a pull request (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request (required)
     * @param id id of the review (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoGetPullReviewCommentsAsync(String owner, String repo, Long index, Long id, final ApiCallback<List<PullReviewComment>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoGetPullReviewCommentsValidateBeforeCall(owner, repo, index, id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<PullReviewComment>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoGetPushMirrorByRemoteName
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param name remote name of push mirror (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoGetPushMirrorByRemoteNameCall(String owner, String repo, String name, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/push_mirrors/{name}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoGetPushMirrorByRemoteNameValidateBeforeCall(String owner, String repo, String name, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetPushMirrorByRemoteName(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetPushMirrorByRemoteName(Async)");
        }
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling repoGetPushMirrorByRemoteName(Async)");
        }
        

        com.squareup.okhttp.Call call = repoGetPushMirrorByRemoteNameCall(owner, repo, name, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get push mirror of the repository by remoteName
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param name remote name of push mirror (required)
     * @return PushMirror
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public PushMirror repoGetPushMirrorByRemoteName(String owner, String repo, String name) throws ApiException {
        ApiResponse<PushMirror> resp = repoGetPushMirrorByRemoteNameWithHttpInfo(owner, repo, name);
        return resp.getData();
    }

    /**
     * Get push mirror of the repository by remoteName
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param name remote name of push mirror (required)
     * @return ApiResponse&lt;PushMirror&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<PushMirror> repoGetPushMirrorByRemoteNameWithHttpInfo(String owner, String repo, String name) throws ApiException {
        com.squareup.okhttp.Call call = repoGetPushMirrorByRemoteNameValidateBeforeCall(owner, repo, name, null, null);
        Type localVarReturnType = new TypeToken<PushMirror>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get push mirror of the repository by remoteName (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param name remote name of push mirror (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoGetPushMirrorByRemoteNameAsync(String owner, String repo, String name, final ApiCallback<PushMirror> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoGetPushMirrorByRemoteNameValidateBeforeCall(owner, repo, name, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PushMirror>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoGetRawFile
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param filepath filepath of the file to get (required)
     * @param ref The name of the commit/branch/tag. Default the repository’s default branch (usually master) (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoGetRawFileCall(String owner, String repo, String filepath, String ref, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/raw/{filepath}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "filepath" + "\\}", apiClient.escapeString(filepath.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (ref != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("ref", ref));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoGetRawFileValidateBeforeCall(String owner, String repo, String filepath, String ref, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetRawFile(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetRawFile(Async)");
        }
        
        // verify the required parameter 'filepath' is set
        if (filepath == null) {
            throw new ApiException("Missing the required parameter 'filepath' when calling repoGetRawFile(Async)");
        }
        

        com.squareup.okhttp.Call call = repoGetRawFileCall(owner, repo, filepath, ref, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get a file from a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param filepath filepath of the file to get (required)
     * @param ref The name of the commit/branch/tag. Default the repository’s default branch (usually master) (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void repoGetRawFile(String owner, String repo, String filepath, String ref) throws ApiException {
        repoGetRawFileWithHttpInfo(owner, repo, filepath, ref);
    }

    /**
     * Get a file from a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param filepath filepath of the file to get (required)
     * @param ref The name of the commit/branch/tag. Default the repository’s default branch (usually master) (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> repoGetRawFileWithHttpInfo(String owner, String repo, String filepath, String ref) throws ApiException {
        com.squareup.okhttp.Call call = repoGetRawFileValidateBeforeCall(owner, repo, filepath, ref, null, null);
        return apiClient.execute(call);
    }

    /**
     * Get a file from a repository (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param filepath filepath of the file to get (required)
     * @param ref The name of the commit/branch/tag. Default the repository’s default branch (usually master) (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoGetRawFileAsync(String owner, String repo, String filepath, String ref, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoGetRawFileValidateBeforeCall(owner, repo, filepath, ref, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for repoGetRawFileOrLFS
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param filepath filepath of the file to get (required)
     * @param ref The name of the commit/branch/tag. Default the repository’s default branch (usually master) (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoGetRawFileOrLFSCall(String owner, String repo, String filepath, String ref, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/media/{filepath}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "filepath" + "\\}", apiClient.escapeString(filepath.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (ref != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("ref", ref));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/html"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoGetRawFileOrLFSValidateBeforeCall(String owner, String repo, String filepath, String ref, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetRawFileOrLFS(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetRawFileOrLFS(Async)");
        }
        
        // verify the required parameter 'filepath' is set
        if (filepath == null) {
            throw new ApiException("Missing the required parameter 'filepath' when calling repoGetRawFileOrLFS(Async)");
        }
        

        com.squareup.okhttp.Call call = repoGetRawFileOrLFSCall(owner, repo, filepath, ref, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get a file or it&#39;s LFS object from a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param filepath filepath of the file to get (required)
     * @param ref The name of the commit/branch/tag. Default the repository’s default branch (usually master) (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void repoGetRawFileOrLFS(String owner, String repo, String filepath, String ref) throws ApiException {
        repoGetRawFileOrLFSWithHttpInfo(owner, repo, filepath, ref);
    }

    /**
     * Get a file or it&#39;s LFS object from a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param filepath filepath of the file to get (required)
     * @param ref The name of the commit/branch/tag. Default the repository’s default branch (usually master) (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> repoGetRawFileOrLFSWithHttpInfo(String owner, String repo, String filepath, String ref) throws ApiException {
        com.squareup.okhttp.Call call = repoGetRawFileOrLFSValidateBeforeCall(owner, repo, filepath, ref, null, null);
        return apiClient.execute(call);
    }

    /**
     * Get a file or it&#39;s LFS object from a repository (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param filepath filepath of the file to get (required)
     * @param ref The name of the commit/branch/tag. Default the repository’s default branch (usually master) (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoGetRawFileOrLFSAsync(String owner, String repo, String filepath, String ref, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoGetRawFileOrLFSValidateBeforeCall(owner, repo, filepath, ref, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for repoGetRelease
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the release to get (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoGetReleaseCall(String owner, String repo, Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/releases/{id}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoGetReleaseValidateBeforeCall(String owner, String repo, Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetRelease(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetRelease(Async)");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoGetRelease(Async)");
        }
        

        com.squareup.okhttp.Call call = repoGetReleaseCall(owner, repo, id, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get a release
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the release to get (required)
     * @return Release
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Release repoGetRelease(String owner, String repo, Long id) throws ApiException {
        ApiResponse<Release> resp = repoGetReleaseWithHttpInfo(owner, repo, id);
        return resp.getData();
    }

    /**
     * Get a release
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the release to get (required)
     * @return ApiResponse&lt;Release&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Release> repoGetReleaseWithHttpInfo(String owner, String repo, Long id) throws ApiException {
        com.squareup.okhttp.Call call = repoGetReleaseValidateBeforeCall(owner, repo, id, null, null);
        Type localVarReturnType = new TypeToken<Release>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get a release (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the release to get (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoGetReleaseAsync(String owner, String repo, Long id, final ApiCallback<Release> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoGetReleaseValidateBeforeCall(owner, repo, id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Release>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoGetReleaseAttachment
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the release (required)
     * @param attachmentId id of the attachment to get (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoGetReleaseAttachmentCall(String owner, String repo, Long id, Long attachmentId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/releases/{id}/assets/{attachment_id}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()))
            .replaceAll("\\{" + "attachment_id" + "\\}", apiClient.escapeString(attachmentId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoGetReleaseAttachmentValidateBeforeCall(String owner, String repo, Long id, Long attachmentId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetReleaseAttachment(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetReleaseAttachment(Async)");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoGetReleaseAttachment(Async)");
        }
        
        // verify the required parameter 'attachmentId' is set
        if (attachmentId == null) {
            throw new ApiException("Missing the required parameter 'attachmentId' when calling repoGetReleaseAttachment(Async)");
        }
        

        com.squareup.okhttp.Call call = repoGetReleaseAttachmentCall(owner, repo, id, attachmentId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get a release attachment
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the release (required)
     * @param attachmentId id of the attachment to get (required)
     * @return Attachment
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Attachment repoGetReleaseAttachment(String owner, String repo, Long id, Long attachmentId) throws ApiException {
        ApiResponse<Attachment> resp = repoGetReleaseAttachmentWithHttpInfo(owner, repo, id, attachmentId);
        return resp.getData();
    }

    /**
     * Get a release attachment
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the release (required)
     * @param attachmentId id of the attachment to get (required)
     * @return ApiResponse&lt;Attachment&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Attachment> repoGetReleaseAttachmentWithHttpInfo(String owner, String repo, Long id, Long attachmentId) throws ApiException {
        com.squareup.okhttp.Call call = repoGetReleaseAttachmentValidateBeforeCall(owner, repo, id, attachmentId, null, null);
        Type localVarReturnType = new TypeToken<Attachment>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get a release attachment (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the release (required)
     * @param attachmentId id of the attachment to get (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoGetReleaseAttachmentAsync(String owner, String repo, Long id, Long attachmentId, final ApiCallback<Attachment> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoGetReleaseAttachmentValidateBeforeCall(owner, repo, id, attachmentId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Attachment>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoGetReleaseByTag
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param tag tag name of the release to get (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoGetReleaseByTagCall(String owner, String repo, String tag, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/releases/tags/{tag}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "tag" + "\\}", apiClient.escapeString(tag.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoGetReleaseByTagValidateBeforeCall(String owner, String repo, String tag, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetReleaseByTag(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetReleaseByTag(Async)");
        }
        
        // verify the required parameter 'tag' is set
        if (tag == null) {
            throw new ApiException("Missing the required parameter 'tag' when calling repoGetReleaseByTag(Async)");
        }
        

        com.squareup.okhttp.Call call = repoGetReleaseByTagCall(owner, repo, tag, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get a release by tag name
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param tag tag name of the release to get (required)
     * @return Release
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Release repoGetReleaseByTag(String owner, String repo, String tag) throws ApiException {
        ApiResponse<Release> resp = repoGetReleaseByTagWithHttpInfo(owner, repo, tag);
        return resp.getData();
    }

    /**
     * Get a release by tag name
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param tag tag name of the release to get (required)
     * @return ApiResponse&lt;Release&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Release> repoGetReleaseByTagWithHttpInfo(String owner, String repo, String tag) throws ApiException {
        com.squareup.okhttp.Call call = repoGetReleaseByTagValidateBeforeCall(owner, repo, tag, null, null);
        Type localVarReturnType = new TypeToken<Release>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get a release by tag name (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param tag tag name of the release to get (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoGetReleaseByTagAsync(String owner, String repo, String tag, final ApiCallback<Release> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoGetReleaseByTagValidateBeforeCall(owner, repo, tag, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Release>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoGetRepoPermissions
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param collaborator username of the collaborator (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoGetRepoPermissionsCall(String owner, String repo, String collaborator, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/collaborators/{collaborator}/permission"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "collaborator" + "\\}", apiClient.escapeString(collaborator.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoGetRepoPermissionsValidateBeforeCall(String owner, String repo, String collaborator, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetRepoPermissions(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetRepoPermissions(Async)");
        }
        
        // verify the required parameter 'collaborator' is set
        if (collaborator == null) {
            throw new ApiException("Missing the required parameter 'collaborator' when calling repoGetRepoPermissions(Async)");
        }
        

        com.squareup.okhttp.Call call = repoGetRepoPermissionsCall(owner, repo, collaborator, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get repository permissions for a user
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param collaborator username of the collaborator (required)
     * @return RepoCollaboratorPermission
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public RepoCollaboratorPermission repoGetRepoPermissions(String owner, String repo, String collaborator) throws ApiException {
        ApiResponse<RepoCollaboratorPermission> resp = repoGetRepoPermissionsWithHttpInfo(owner, repo, collaborator);
        return resp.getData();
    }

    /**
     * Get repository permissions for a user
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param collaborator username of the collaborator (required)
     * @return ApiResponse&lt;RepoCollaboratorPermission&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<RepoCollaboratorPermission> repoGetRepoPermissionsWithHttpInfo(String owner, String repo, String collaborator) throws ApiException {
        com.squareup.okhttp.Call call = repoGetRepoPermissionsValidateBeforeCall(owner, repo, collaborator, null, null);
        Type localVarReturnType = new TypeToken<RepoCollaboratorPermission>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get repository permissions for a user (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param collaborator username of the collaborator (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoGetRepoPermissionsAsync(String owner, String repo, String collaborator, final ApiCallback<RepoCollaboratorPermission> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoGetRepoPermissionsValidateBeforeCall(owner, repo, collaborator, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RepoCollaboratorPermission>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoGetReviewers
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoGetReviewersCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/reviewers"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoGetReviewersValidateBeforeCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetReviewers(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetReviewers(Async)");
        }
        

        com.squareup.okhttp.Call call = repoGetReviewersCall(owner, repo, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Return all users that can be requested to review in this repo
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @return List&lt;User&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<User> repoGetReviewers(String owner, String repo) throws ApiException {
        ApiResponse<List<User>> resp = repoGetReviewersWithHttpInfo(owner, repo);
        return resp.getData();
    }

    /**
     * Return all users that can be requested to review in this repo
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @return ApiResponse&lt;List&lt;User&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<User>> repoGetReviewersWithHttpInfo(String owner, String repo) throws ApiException {
        com.squareup.okhttp.Call call = repoGetReviewersValidateBeforeCall(owner, repo, null, null);
        Type localVarReturnType = new TypeToken<List<User>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Return all users that can be requested to review in this repo (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoGetReviewersAsync(String owner, String repo, final ApiCallback<List<User>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoGetReviewersValidateBeforeCall(owner, repo, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<User>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoGetSingleCommit
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param sha a git ref or commit sha (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoGetSingleCommitCall(String owner, String repo, String sha, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/git/commits/{sha}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "sha" + "\\}", apiClient.escapeString(sha.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoGetSingleCommitValidateBeforeCall(String owner, String repo, String sha, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetSingleCommit(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetSingleCommit(Async)");
        }
        
        // verify the required parameter 'sha' is set
        if (sha == null) {
            throw new ApiException("Missing the required parameter 'sha' when calling repoGetSingleCommit(Async)");
        }
        

        com.squareup.okhttp.Call call = repoGetSingleCommitCall(owner, repo, sha, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get a single commit from a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param sha a git ref or commit sha (required)
     * @return Commit
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Commit repoGetSingleCommit(String owner, String repo, String sha) throws ApiException {
        ApiResponse<Commit> resp = repoGetSingleCommitWithHttpInfo(owner, repo, sha);
        return resp.getData();
    }

    /**
     * Get a single commit from a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param sha a git ref or commit sha (required)
     * @return ApiResponse&lt;Commit&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Commit> repoGetSingleCommitWithHttpInfo(String owner, String repo, String sha) throws ApiException {
        com.squareup.okhttp.Call call = repoGetSingleCommitValidateBeforeCall(owner, repo, sha, null, null);
        Type localVarReturnType = new TypeToken<Commit>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get a single commit from a repository (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param sha a git ref or commit sha (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoGetSingleCommitAsync(String owner, String repo, String sha, final ApiCallback<Commit> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoGetSingleCommitValidateBeforeCall(owner, repo, sha, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Commit>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoGetTag
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param tag name of tag (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoGetTagCall(String owner, String repo, String tag, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/tags/{tag}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "tag" + "\\}", apiClient.escapeString(tag.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoGetTagValidateBeforeCall(String owner, String repo, String tag, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetTag(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetTag(Async)");
        }
        
        // verify the required parameter 'tag' is set
        if (tag == null) {
            throw new ApiException("Missing the required parameter 'tag' when calling repoGetTag(Async)");
        }
        

        com.squareup.okhttp.Call call = repoGetTagCall(owner, repo, tag, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get the tag of a repository by tag name
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param tag name of tag (required)
     * @return Tag
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Tag repoGetTag(String owner, String repo, String tag) throws ApiException {
        ApiResponse<Tag> resp = repoGetTagWithHttpInfo(owner, repo, tag);
        return resp.getData();
    }

    /**
     * Get the tag of a repository by tag name
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param tag name of tag (required)
     * @return ApiResponse&lt;Tag&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Tag> repoGetTagWithHttpInfo(String owner, String repo, String tag) throws ApiException {
        com.squareup.okhttp.Call call = repoGetTagValidateBeforeCall(owner, repo, tag, null, null);
        Type localVarReturnType = new TypeToken<Tag>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get the tag of a repository by tag name (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param tag name of tag (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoGetTagAsync(String owner, String repo, String tag, final ApiCallback<Tag> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoGetTagValidateBeforeCall(owner, repo, tag, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Tag>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoGetWikiPage
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param pageName name of the page (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoGetWikiPageCall(String owner, String repo, String pageName, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/wiki/page/{pageName}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "pageName" + "\\}", apiClient.escapeString(pageName.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoGetWikiPageValidateBeforeCall(String owner, String repo, String pageName, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetWikiPage(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetWikiPage(Async)");
        }
        
        // verify the required parameter 'pageName' is set
        if (pageName == null) {
            throw new ApiException("Missing the required parameter 'pageName' when calling repoGetWikiPage(Async)");
        }
        

        com.squareup.okhttp.Call call = repoGetWikiPageCall(owner, repo, pageName, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get a wiki page
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param pageName name of the page (required)
     * @return WikiPage
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public WikiPage repoGetWikiPage(String owner, String repo, String pageName) throws ApiException {
        ApiResponse<WikiPage> resp = repoGetWikiPageWithHttpInfo(owner, repo, pageName);
        return resp.getData();
    }

    /**
     * Get a wiki page
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param pageName name of the page (required)
     * @return ApiResponse&lt;WikiPage&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<WikiPage> repoGetWikiPageWithHttpInfo(String owner, String repo, String pageName) throws ApiException {
        com.squareup.okhttp.Call call = repoGetWikiPageValidateBeforeCall(owner, repo, pageName, null, null);
        Type localVarReturnType = new TypeToken<WikiPage>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get a wiki page (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param pageName name of the page (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoGetWikiPageAsync(String owner, String repo, String pageName, final ApiCallback<WikiPage> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoGetWikiPageValidateBeforeCall(owner, repo, pageName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WikiPage>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoGetWikiPageRevisions
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param pageName name of the page (required)
     * @param page page number of results to return (1-based) (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoGetWikiPageRevisionsCall(String owner, String repo, String pageName, Integer page, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/wiki/revisions/{pageName}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "pageName" + "\\}", apiClient.escapeString(pageName.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("page", page));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoGetWikiPageRevisionsValidateBeforeCall(String owner, String repo, String pageName, Integer page, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetWikiPageRevisions(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetWikiPageRevisions(Async)");
        }
        
        // verify the required parameter 'pageName' is set
        if (pageName == null) {
            throw new ApiException("Missing the required parameter 'pageName' when calling repoGetWikiPageRevisions(Async)");
        }
        

        com.squareup.okhttp.Call call = repoGetWikiPageRevisionsCall(owner, repo, pageName, page, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get revisions of a wiki page
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param pageName name of the page (required)
     * @param page page number of results to return (1-based) (optional)
     * @return WikiCommitList
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public WikiCommitList repoGetWikiPageRevisions(String owner, String repo, String pageName, Integer page) throws ApiException {
        ApiResponse<WikiCommitList> resp = repoGetWikiPageRevisionsWithHttpInfo(owner, repo, pageName, page);
        return resp.getData();
    }

    /**
     * Get revisions of a wiki page
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param pageName name of the page (required)
     * @param page page number of results to return (1-based) (optional)
     * @return ApiResponse&lt;WikiCommitList&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<WikiCommitList> repoGetWikiPageRevisionsWithHttpInfo(String owner, String repo, String pageName, Integer page) throws ApiException {
        com.squareup.okhttp.Call call = repoGetWikiPageRevisionsValidateBeforeCall(owner, repo, pageName, page, null, null);
        Type localVarReturnType = new TypeToken<WikiCommitList>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get revisions of a wiki page (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param pageName name of the page (required)
     * @param page page number of results to return (1-based) (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoGetWikiPageRevisionsAsync(String owner, String repo, String pageName, Integer page, final ApiCallback<WikiCommitList> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoGetWikiPageRevisionsValidateBeforeCall(owner, repo, pageName, page, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WikiCommitList>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoGetWikiPages
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoGetWikiPagesCall(String owner, String repo, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/wiki/pages"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoGetWikiPagesValidateBeforeCall(String owner, String repo, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoGetWikiPages(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoGetWikiPages(Async)");
        }
        

        com.squareup.okhttp.Call call = repoGetWikiPagesCall(owner, repo, page, limit, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get all wiki pages
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return List&lt;WikiPageMetaData&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<WikiPageMetaData> repoGetWikiPages(String owner, String repo, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<WikiPageMetaData>> resp = repoGetWikiPagesWithHttpInfo(owner, repo, page, limit);
        return resp.getData();
    }

    /**
     * Get all wiki pages
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return ApiResponse&lt;List&lt;WikiPageMetaData&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<WikiPageMetaData>> repoGetWikiPagesWithHttpInfo(String owner, String repo, Integer page, Integer limit) throws ApiException {
        com.squareup.okhttp.Call call = repoGetWikiPagesValidateBeforeCall(owner, repo, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<WikiPageMetaData>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get all wiki pages (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoGetWikiPagesAsync(String owner, String repo, Integer page, Integer limit, final ApiCallback<List<WikiPageMetaData>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoGetWikiPagesValidateBeforeCall(owner, repo, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<WikiPageMetaData>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoListAllGitRefs
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoListAllGitRefsCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/git/refs"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoListAllGitRefsValidateBeforeCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoListAllGitRefs(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoListAllGitRefs(Async)");
        }
        

        com.squareup.okhttp.Call call = repoListAllGitRefsCall(owner, repo, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get specified ref or filtered repository&#39;s refs
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @return List&lt;Reference&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<Reference> repoListAllGitRefs(String owner, String repo) throws ApiException {
        ApiResponse<List<Reference>> resp = repoListAllGitRefsWithHttpInfo(owner, repo);
        return resp.getData();
    }

    /**
     * Get specified ref or filtered repository&#39;s refs
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @return ApiResponse&lt;List&lt;Reference&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<Reference>> repoListAllGitRefsWithHttpInfo(String owner, String repo) throws ApiException {
        com.squareup.okhttp.Call call = repoListAllGitRefsValidateBeforeCall(owner, repo, null, null);
        Type localVarReturnType = new TypeToken<List<Reference>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get specified ref or filtered repository&#39;s refs (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoListAllGitRefsAsync(String owner, String repo, final ApiCallback<List<Reference>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoListAllGitRefsValidateBeforeCall(owner, repo, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Reference>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoListBranchProtection
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoListBranchProtectionCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/branch_protections"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoListBranchProtectionValidateBeforeCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoListBranchProtection(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoListBranchProtection(Async)");
        }
        

        com.squareup.okhttp.Call call = repoListBranchProtectionCall(owner, repo, progressListener, progressRequestListener);
        return call;

    }

    /**
     * List branch protections for a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @return List&lt;BranchProtection&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<BranchProtection> repoListBranchProtection(String owner, String repo) throws ApiException {
        ApiResponse<List<BranchProtection>> resp = repoListBranchProtectionWithHttpInfo(owner, repo);
        return resp.getData();
    }

    /**
     * List branch protections for a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @return ApiResponse&lt;List&lt;BranchProtection&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<BranchProtection>> repoListBranchProtectionWithHttpInfo(String owner, String repo) throws ApiException {
        com.squareup.okhttp.Call call = repoListBranchProtectionValidateBeforeCall(owner, repo, null, null);
        Type localVarReturnType = new TypeToken<List<BranchProtection>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * List branch protections for a repository (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoListBranchProtectionAsync(String owner, String repo, final ApiCallback<List<BranchProtection>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoListBranchProtectionValidateBeforeCall(owner, repo, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<BranchProtection>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoListBranches
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoListBranchesCall(String owner, String repo, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/branches"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoListBranchesValidateBeforeCall(String owner, String repo, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoListBranches(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoListBranches(Async)");
        }
        

        com.squareup.okhttp.Call call = repoListBranchesCall(owner, repo, page, limit, progressListener, progressRequestListener);
        return call;

    }

    /**
     * List a repository&#39;s branches
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return List&lt;Branch&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<Branch> repoListBranches(String owner, String repo, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<Branch>> resp = repoListBranchesWithHttpInfo(owner, repo, page, limit);
        return resp.getData();
    }

    /**
     * List a repository&#39;s branches
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return ApiResponse&lt;List&lt;Branch&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<Branch>> repoListBranchesWithHttpInfo(String owner, String repo, Integer page, Integer limit) throws ApiException {
        com.squareup.okhttp.Call call = repoListBranchesValidateBeforeCall(owner, repo, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<Branch>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * List a repository&#39;s branches (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoListBranchesAsync(String owner, String repo, Integer page, Integer limit, final ApiCallback<List<Branch>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoListBranchesValidateBeforeCall(owner, repo, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Branch>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoListCollaborators
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoListCollaboratorsCall(String owner, String repo, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/collaborators"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoListCollaboratorsValidateBeforeCall(String owner, String repo, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoListCollaborators(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoListCollaborators(Async)");
        }
        

        com.squareup.okhttp.Call call = repoListCollaboratorsCall(owner, repo, page, limit, progressListener, progressRequestListener);
        return call;

    }

    /**
     * List a repository&#39;s collaborators
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return List&lt;User&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<User> repoListCollaborators(String owner, String repo, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<User>> resp = repoListCollaboratorsWithHttpInfo(owner, repo, page, limit);
        return resp.getData();
    }

    /**
     * List a repository&#39;s collaborators
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return ApiResponse&lt;List&lt;User&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<User>> repoListCollaboratorsWithHttpInfo(String owner, String repo, Integer page, Integer limit) throws ApiException {
        com.squareup.okhttp.Call call = repoListCollaboratorsValidateBeforeCall(owner, repo, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<User>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * List a repository&#39;s collaborators (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoListCollaboratorsAsync(String owner, String repo, Integer page, Integer limit, final ApiCallback<List<User>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoListCollaboratorsValidateBeforeCall(owner, repo, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<User>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoListGitHooks
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoListGitHooksCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/hooks/git"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoListGitHooksValidateBeforeCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoListGitHooks(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoListGitHooks(Async)");
        }
        

        com.squareup.okhttp.Call call = repoListGitHooksCall(owner, repo, progressListener, progressRequestListener);
        return call;

    }

    /**
     * List the Git hooks in a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @return List&lt;GitHook&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<GitHook> repoListGitHooks(String owner, String repo) throws ApiException {
        ApiResponse<List<GitHook>> resp = repoListGitHooksWithHttpInfo(owner, repo);
        return resp.getData();
    }

    /**
     * List the Git hooks in a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @return ApiResponse&lt;List&lt;GitHook&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<GitHook>> repoListGitHooksWithHttpInfo(String owner, String repo) throws ApiException {
        com.squareup.okhttp.Call call = repoListGitHooksValidateBeforeCall(owner, repo, null, null);
        Type localVarReturnType = new TypeToken<List<GitHook>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * List the Git hooks in a repository (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoListGitHooksAsync(String owner, String repo, final ApiCallback<List<GitHook>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoListGitHooksValidateBeforeCall(owner, repo, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<GitHook>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoListGitRefs
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param ref part or full name of the ref (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoListGitRefsCall(String owner, String repo, String ref, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/git/refs/{ref}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "ref" + "\\}", apiClient.escapeString(ref.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoListGitRefsValidateBeforeCall(String owner, String repo, String ref, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoListGitRefs(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoListGitRefs(Async)");
        }
        
        // verify the required parameter 'ref' is set
        if (ref == null) {
            throw new ApiException("Missing the required parameter 'ref' when calling repoListGitRefs(Async)");
        }
        

        com.squareup.okhttp.Call call = repoListGitRefsCall(owner, repo, ref, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get specified ref or filtered repository&#39;s refs
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param ref part or full name of the ref (required)
     * @return List&lt;Reference&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<Reference> repoListGitRefs(String owner, String repo, String ref) throws ApiException {
        ApiResponse<List<Reference>> resp = repoListGitRefsWithHttpInfo(owner, repo, ref);
        return resp.getData();
    }

    /**
     * Get specified ref or filtered repository&#39;s refs
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param ref part or full name of the ref (required)
     * @return ApiResponse&lt;List&lt;Reference&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<Reference>> repoListGitRefsWithHttpInfo(String owner, String repo, String ref) throws ApiException {
        com.squareup.okhttp.Call call = repoListGitRefsValidateBeforeCall(owner, repo, ref, null, null);
        Type localVarReturnType = new TypeToken<List<Reference>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get specified ref or filtered repository&#39;s refs (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param ref part or full name of the ref (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoListGitRefsAsync(String owner, String repo, String ref, final ApiCallback<List<Reference>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoListGitRefsValidateBeforeCall(owner, repo, ref, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Reference>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoListHooks
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoListHooksCall(String owner, String repo, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/hooks"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoListHooksValidateBeforeCall(String owner, String repo, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoListHooks(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoListHooks(Async)");
        }
        

        com.squareup.okhttp.Call call = repoListHooksCall(owner, repo, page, limit, progressListener, progressRequestListener);
        return call;

    }

    /**
     * List the hooks in a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return List&lt;Hook&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<Hook> repoListHooks(String owner, String repo, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<Hook>> resp = repoListHooksWithHttpInfo(owner, repo, page, limit);
        return resp.getData();
    }

    /**
     * List the hooks in a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return ApiResponse&lt;List&lt;Hook&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<Hook>> repoListHooksWithHttpInfo(String owner, String repo, Integer page, Integer limit) throws ApiException {
        com.squareup.okhttp.Call call = repoListHooksValidateBeforeCall(owner, repo, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<Hook>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * List the hooks in a repository (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoListHooksAsync(String owner, String repo, Integer page, Integer limit, final ApiCallback<List<Hook>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoListHooksValidateBeforeCall(owner, repo, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Hook>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoListKeys
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param keyId the key_id to search for (optional)
     * @param fingerprint fingerprint of the key (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoListKeysCall(String owner, String repo, Integer keyId, String fingerprint, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/keys"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (keyId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("key_id", keyId));
        if (fingerprint != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("fingerprint", fingerprint));
        if (page != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoListKeysValidateBeforeCall(String owner, String repo, Integer keyId, String fingerprint, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoListKeys(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoListKeys(Async)");
        }
        

        com.squareup.okhttp.Call call = repoListKeysCall(owner, repo, keyId, fingerprint, page, limit, progressListener, progressRequestListener);
        return call;

    }

    /**
     * List a repository&#39;s keys
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param keyId the key_id to search for (optional)
     * @param fingerprint fingerprint of the key (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return List&lt;DeployKey&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<DeployKey> repoListKeys(String owner, String repo, Integer keyId, String fingerprint, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<DeployKey>> resp = repoListKeysWithHttpInfo(owner, repo, keyId, fingerprint, page, limit);
        return resp.getData();
    }

    /**
     * List a repository&#39;s keys
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param keyId the key_id to search for (optional)
     * @param fingerprint fingerprint of the key (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return ApiResponse&lt;List&lt;DeployKey&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<DeployKey>> repoListKeysWithHttpInfo(String owner, String repo, Integer keyId, String fingerprint, Integer page, Integer limit) throws ApiException {
        com.squareup.okhttp.Call call = repoListKeysValidateBeforeCall(owner, repo, keyId, fingerprint, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<DeployKey>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * List a repository&#39;s keys (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param keyId the key_id to search for (optional)
     * @param fingerprint fingerprint of the key (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoListKeysAsync(String owner, String repo, Integer keyId, String fingerprint, Integer page, Integer limit, final ApiCallback<List<DeployKey>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoListKeysValidateBeforeCall(owner, repo, keyId, fingerprint, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<DeployKey>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoListPullRequests
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param state State of pull request: open or closed (optional) (optional)
     * @param sort Type of sort (optional)
     * @param milestone ID of the milestone (optional)
     * @param labels Label IDs (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoListPullRequestsCall(String owner, String repo, String state, String sort, Long milestone, List<Long> labels, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/pulls"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (state != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("state", state));
        if (sort != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("sort", sort));
        if (milestone != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("milestone", milestone));
        if (labels != null)
        localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("multi", "labels", labels));
        if (page != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoListPullRequestsValidateBeforeCall(String owner, String repo, String state, String sort, Long milestone, List<Long> labels, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoListPullRequests(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoListPullRequests(Async)");
        }
        

        com.squareup.okhttp.Call call = repoListPullRequestsCall(owner, repo, state, sort, milestone, labels, page, limit, progressListener, progressRequestListener);
        return call;

    }

    /**
     * List a repo&#39;s pull requests
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param state State of pull request: open or closed (optional) (optional)
     * @param sort Type of sort (optional)
     * @param milestone ID of the milestone (optional)
     * @param labels Label IDs (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return List&lt;PullRequest&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<PullRequest> repoListPullRequests(String owner, String repo, String state, String sort, Long milestone, List<Long> labels, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<PullRequest>> resp = repoListPullRequestsWithHttpInfo(owner, repo, state, sort, milestone, labels, page, limit);
        return resp.getData();
    }

    /**
     * List a repo&#39;s pull requests
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param state State of pull request: open or closed (optional) (optional)
     * @param sort Type of sort (optional)
     * @param milestone ID of the milestone (optional)
     * @param labels Label IDs (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return ApiResponse&lt;List&lt;PullRequest&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<PullRequest>> repoListPullRequestsWithHttpInfo(String owner, String repo, String state, String sort, Long milestone, List<Long> labels, Integer page, Integer limit) throws ApiException {
        com.squareup.okhttp.Call call = repoListPullRequestsValidateBeforeCall(owner, repo, state, sort, milestone, labels, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<PullRequest>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * List a repo&#39;s pull requests (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param state State of pull request: open or closed (optional) (optional)
     * @param sort Type of sort (optional)
     * @param milestone ID of the milestone (optional)
     * @param labels Label IDs (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoListPullRequestsAsync(String owner, String repo, String state, String sort, Long milestone, List<Long> labels, Integer page, Integer limit, final ApiCallback<List<PullRequest>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoListPullRequestsValidateBeforeCall(owner, repo, state, sort, milestone, labels, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<PullRequest>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoListPullReviews
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoListPullReviewsCall(String owner, String repo, Long index, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/pulls/{index}/reviews"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoListPullReviewsValidateBeforeCall(String owner, String repo, Long index, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoListPullReviews(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoListPullReviews(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling repoListPullReviews(Async)");
        }
        

        com.squareup.okhttp.Call call = repoListPullReviewsCall(owner, repo, index, page, limit, progressListener, progressRequestListener);
        return call;

    }

    /**
     * List all reviews for a pull request
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return List&lt;PullReview&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<PullReview> repoListPullReviews(String owner, String repo, Long index, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<PullReview>> resp = repoListPullReviewsWithHttpInfo(owner, repo, index, page, limit);
        return resp.getData();
    }

    /**
     * List all reviews for a pull request
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return ApiResponse&lt;List&lt;PullReview&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<PullReview>> repoListPullReviewsWithHttpInfo(String owner, String repo, Long index, Integer page, Integer limit) throws ApiException {
        com.squareup.okhttp.Call call = repoListPullReviewsValidateBeforeCall(owner, repo, index, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<PullReview>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * List all reviews for a pull request (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoListPullReviewsAsync(String owner, String repo, Long index, Integer page, Integer limit, final ApiCallback<List<PullReview>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoListPullReviewsValidateBeforeCall(owner, repo, index, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<PullReview>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoListPushMirrors
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoListPushMirrorsCall(String owner, String repo, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/push_mirrors"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoListPushMirrorsValidateBeforeCall(String owner, String repo, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoListPushMirrors(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoListPushMirrors(Async)");
        }
        

        com.squareup.okhttp.Call call = repoListPushMirrorsCall(owner, repo, page, limit, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get all push mirrors of the repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return List&lt;PushMirror&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<PushMirror> repoListPushMirrors(String owner, String repo, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<PushMirror>> resp = repoListPushMirrorsWithHttpInfo(owner, repo, page, limit);
        return resp.getData();
    }

    /**
     * Get all push mirrors of the repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return ApiResponse&lt;List&lt;PushMirror&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<PushMirror>> repoListPushMirrorsWithHttpInfo(String owner, String repo, Integer page, Integer limit) throws ApiException {
        com.squareup.okhttp.Call call = repoListPushMirrorsValidateBeforeCall(owner, repo, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<PushMirror>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get all push mirrors of the repository (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoListPushMirrorsAsync(String owner, String repo, Integer page, Integer limit, final ApiCallback<List<PushMirror>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoListPushMirrorsValidateBeforeCall(owner, repo, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<PushMirror>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoListReleaseAttachments
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the release (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoListReleaseAttachmentsCall(String owner, String repo, Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/releases/{id}/assets"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoListReleaseAttachmentsValidateBeforeCall(String owner, String repo, Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoListReleaseAttachments(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoListReleaseAttachments(Async)");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoListReleaseAttachments(Async)");
        }
        

        com.squareup.okhttp.Call call = repoListReleaseAttachmentsCall(owner, repo, id, progressListener, progressRequestListener);
        return call;

    }

    /**
     * List release&#39;s attachments
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the release (required)
     * @return List&lt;Attachment&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<Attachment> repoListReleaseAttachments(String owner, String repo, Long id) throws ApiException {
        ApiResponse<List<Attachment>> resp = repoListReleaseAttachmentsWithHttpInfo(owner, repo, id);
        return resp.getData();
    }

    /**
     * List release&#39;s attachments
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the release (required)
     * @return ApiResponse&lt;List&lt;Attachment&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<Attachment>> repoListReleaseAttachmentsWithHttpInfo(String owner, String repo, Long id) throws ApiException {
        com.squareup.okhttp.Call call = repoListReleaseAttachmentsValidateBeforeCall(owner, repo, id, null, null);
        Type localVarReturnType = new TypeToken<List<Attachment>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * List release&#39;s attachments (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the release (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoListReleaseAttachmentsAsync(String owner, String repo, Long id, final ApiCallback<List<Attachment>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoListReleaseAttachmentsValidateBeforeCall(owner, repo, id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Attachment>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoListReleases
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param draft filter (exclude / include) drafts, if you dont have repo write access none will show (optional)
     * @param preRelease filter (exclude / include) pre-releases (optional)
     * @param perPage page size of results, deprecated - use limit (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoListReleasesCall(String owner, String repo, Boolean draft, Boolean preRelease, Integer perPage, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/releases"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (draft != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("draft", draft));
        if (preRelease != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("pre-release", preRelease));
        if (perPage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("per_page", perPage));
        if (page != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoListReleasesValidateBeforeCall(String owner, String repo, Boolean draft, Boolean preRelease, Integer perPage, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoListReleases(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoListReleases(Async)");
        }
        

        com.squareup.okhttp.Call call = repoListReleasesCall(owner, repo, draft, preRelease, perPage, page, limit, progressListener, progressRequestListener);
        return call;

    }

    /**
     * List a repo&#39;s releases
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param draft filter (exclude / include) drafts, if you dont have repo write access none will show (optional)
     * @param preRelease filter (exclude / include) pre-releases (optional)
     * @param perPage page size of results, deprecated - use limit (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return List&lt;Release&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<Release> repoListReleases(String owner, String repo, Boolean draft, Boolean preRelease, Integer perPage, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<Release>> resp = repoListReleasesWithHttpInfo(owner, repo, draft, preRelease, perPage, page, limit);
        return resp.getData();
    }

    /**
     * List a repo&#39;s releases
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param draft filter (exclude / include) drafts, if you dont have repo write access none will show (optional)
     * @param preRelease filter (exclude / include) pre-releases (optional)
     * @param perPage page size of results, deprecated - use limit (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return ApiResponse&lt;List&lt;Release&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<Release>> repoListReleasesWithHttpInfo(String owner, String repo, Boolean draft, Boolean preRelease, Integer perPage, Integer page, Integer limit) throws ApiException {
        com.squareup.okhttp.Call call = repoListReleasesValidateBeforeCall(owner, repo, draft, preRelease, perPage, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<Release>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * List a repo&#39;s releases (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param draft filter (exclude / include) drafts, if you dont have repo write access none will show (optional)
     * @param preRelease filter (exclude / include) pre-releases (optional)
     * @param perPage page size of results, deprecated - use limit (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoListReleasesAsync(String owner, String repo, Boolean draft, Boolean preRelease, Integer perPage, Integer page, Integer limit, final ApiCallback<List<Release>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoListReleasesValidateBeforeCall(owner, repo, draft, preRelease, perPage, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Release>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoListStargazers
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoListStargazersCall(String owner, String repo, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/stargazers"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoListStargazersValidateBeforeCall(String owner, String repo, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoListStargazers(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoListStargazers(Async)");
        }
        

        com.squareup.okhttp.Call call = repoListStargazersCall(owner, repo, page, limit, progressListener, progressRequestListener);
        return call;

    }

    /**
     * List a repo&#39;s stargazers
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return List&lt;User&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<User> repoListStargazers(String owner, String repo, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<User>> resp = repoListStargazersWithHttpInfo(owner, repo, page, limit);
        return resp.getData();
    }

    /**
     * List a repo&#39;s stargazers
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return ApiResponse&lt;List&lt;User&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<User>> repoListStargazersWithHttpInfo(String owner, String repo, Integer page, Integer limit) throws ApiException {
        com.squareup.okhttp.Call call = repoListStargazersValidateBeforeCall(owner, repo, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<User>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * List a repo&#39;s stargazers (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoListStargazersAsync(String owner, String repo, Integer page, Integer limit, final ApiCallback<List<User>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoListStargazersValidateBeforeCall(owner, repo, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<User>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoListStatuses
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param sha sha of the commit (required)
     * @param sort type of sort (optional)
     * @param state type of state (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoListStatusesCall(String owner, String repo, String sha, String sort, String state, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/statuses/{sha}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "sha" + "\\}", apiClient.escapeString(sha.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (sort != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("sort", sort));
        if (state != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("state", state));
        if (page != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoListStatusesValidateBeforeCall(String owner, String repo, String sha, String sort, String state, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoListStatuses(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoListStatuses(Async)");
        }
        
        // verify the required parameter 'sha' is set
        if (sha == null) {
            throw new ApiException("Missing the required parameter 'sha' when calling repoListStatuses(Async)");
        }
        

        com.squareup.okhttp.Call call = repoListStatusesCall(owner, repo, sha, sort, state, page, limit, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get a commit&#39;s statuses
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param sha sha of the commit (required)
     * @param sort type of sort (optional)
     * @param state type of state (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return List&lt;CommitStatus&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<CommitStatus> repoListStatuses(String owner, String repo, String sha, String sort, String state, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<CommitStatus>> resp = repoListStatusesWithHttpInfo(owner, repo, sha, sort, state, page, limit);
        return resp.getData();
    }

    /**
     * Get a commit&#39;s statuses
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param sha sha of the commit (required)
     * @param sort type of sort (optional)
     * @param state type of state (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return ApiResponse&lt;List&lt;CommitStatus&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<CommitStatus>> repoListStatusesWithHttpInfo(String owner, String repo, String sha, String sort, String state, Integer page, Integer limit) throws ApiException {
        com.squareup.okhttp.Call call = repoListStatusesValidateBeforeCall(owner, repo, sha, sort, state, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<CommitStatus>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get a commit&#39;s statuses (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param sha sha of the commit (required)
     * @param sort type of sort (optional)
     * @param state type of state (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoListStatusesAsync(String owner, String repo, String sha, String sort, String state, Integer page, Integer limit, final ApiCallback<List<CommitStatus>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoListStatusesValidateBeforeCall(owner, repo, sha, sort, state, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<CommitStatus>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoListStatusesByRef
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param ref name of branch/tag/commit (required)
     * @param sort type of sort (optional)
     * @param state type of state (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoListStatusesByRefCall(String owner, String repo, String ref, String sort, String state, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/commits/{ref}/statuses"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "ref" + "\\}", apiClient.escapeString(ref.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (sort != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("sort", sort));
        if (state != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("state", state));
        if (page != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoListStatusesByRefValidateBeforeCall(String owner, String repo, String ref, String sort, String state, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoListStatusesByRef(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoListStatusesByRef(Async)");
        }
        
        // verify the required parameter 'ref' is set
        if (ref == null) {
            throw new ApiException("Missing the required parameter 'ref' when calling repoListStatusesByRef(Async)");
        }
        

        com.squareup.okhttp.Call call = repoListStatusesByRefCall(owner, repo, ref, sort, state, page, limit, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get a commit&#39;s statuses, by branch/tag/commit reference
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param ref name of branch/tag/commit (required)
     * @param sort type of sort (optional)
     * @param state type of state (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return List&lt;CommitStatus&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<CommitStatus> repoListStatusesByRef(String owner, String repo, String ref, String sort, String state, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<CommitStatus>> resp = repoListStatusesByRefWithHttpInfo(owner, repo, ref, sort, state, page, limit);
        return resp.getData();
    }

    /**
     * Get a commit&#39;s statuses, by branch/tag/commit reference
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param ref name of branch/tag/commit (required)
     * @param sort type of sort (optional)
     * @param state type of state (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return ApiResponse&lt;List&lt;CommitStatus&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<CommitStatus>> repoListStatusesByRefWithHttpInfo(String owner, String repo, String ref, String sort, String state, Integer page, Integer limit) throws ApiException {
        com.squareup.okhttp.Call call = repoListStatusesByRefValidateBeforeCall(owner, repo, ref, sort, state, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<CommitStatus>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get a commit&#39;s statuses, by branch/tag/commit reference (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param ref name of branch/tag/commit (required)
     * @param sort type of sort (optional)
     * @param state type of state (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoListStatusesByRefAsync(String owner, String repo, String ref, String sort, String state, Integer page, Integer limit, final ApiCallback<List<CommitStatus>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoListStatusesByRefValidateBeforeCall(owner, repo, ref, sort, state, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<CommitStatus>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoListSubscribers
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoListSubscribersCall(String owner, String repo, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/subscribers"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoListSubscribersValidateBeforeCall(String owner, String repo, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoListSubscribers(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoListSubscribers(Async)");
        }
        

        com.squareup.okhttp.Call call = repoListSubscribersCall(owner, repo, page, limit, progressListener, progressRequestListener);
        return call;

    }

    /**
     * List a repo&#39;s watchers
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return List&lt;User&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<User> repoListSubscribers(String owner, String repo, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<User>> resp = repoListSubscribersWithHttpInfo(owner, repo, page, limit);
        return resp.getData();
    }

    /**
     * List a repo&#39;s watchers
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return ApiResponse&lt;List&lt;User&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<User>> repoListSubscribersWithHttpInfo(String owner, String repo, Integer page, Integer limit) throws ApiException {
        com.squareup.okhttp.Call call = repoListSubscribersValidateBeforeCall(owner, repo, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<User>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * List a repo&#39;s watchers (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoListSubscribersAsync(String owner, String repo, Integer page, Integer limit, final ApiCallback<List<User>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoListSubscribersValidateBeforeCall(owner, repo, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<User>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoListTags
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results, default maximum page size is 50 (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoListTagsCall(String owner, String repo, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/tags"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoListTagsValidateBeforeCall(String owner, String repo, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoListTags(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoListTags(Async)");
        }
        

        com.squareup.okhttp.Call call = repoListTagsCall(owner, repo, page, limit, progressListener, progressRequestListener);
        return call;

    }

    /**
     * List a repository&#39;s tags
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results, default maximum page size is 50 (optional)
     * @return List&lt;Tag&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<Tag> repoListTags(String owner, String repo, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<Tag>> resp = repoListTagsWithHttpInfo(owner, repo, page, limit);
        return resp.getData();
    }

    /**
     * List a repository&#39;s tags
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results, default maximum page size is 50 (optional)
     * @return ApiResponse&lt;List&lt;Tag&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<Tag>> repoListTagsWithHttpInfo(String owner, String repo, Integer page, Integer limit) throws ApiException {
        com.squareup.okhttp.Call call = repoListTagsValidateBeforeCall(owner, repo, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<Tag>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * List a repository&#39;s tags (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results, default maximum page size is 50 (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoListTagsAsync(String owner, String repo, Integer page, Integer limit, final ApiCallback<List<Tag>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoListTagsValidateBeforeCall(owner, repo, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Tag>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoListTeams
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoListTeamsCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/teams"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoListTeamsValidateBeforeCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoListTeams(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoListTeams(Async)");
        }
        

        com.squareup.okhttp.Call call = repoListTeamsCall(owner, repo, progressListener, progressRequestListener);
        return call;

    }

    /**
     * List a repository&#39;s teams
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @return List&lt;Team&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<Team> repoListTeams(String owner, String repo) throws ApiException {
        ApiResponse<List<Team>> resp = repoListTeamsWithHttpInfo(owner, repo);
        return resp.getData();
    }

    /**
     * List a repository&#39;s teams
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @return ApiResponse&lt;List&lt;Team&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<Team>> repoListTeamsWithHttpInfo(String owner, String repo) throws ApiException {
        com.squareup.okhttp.Call call = repoListTeamsValidateBeforeCall(owner, repo, null, null);
        Type localVarReturnType = new TypeToken<List<Team>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * List a repository&#39;s teams (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoListTeamsAsync(String owner, String repo, final ApiCallback<List<Team>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoListTeamsValidateBeforeCall(owner, repo, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Team>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoListTopics
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoListTopicsCall(String owner, String repo, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/topics"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoListTopicsValidateBeforeCall(String owner, String repo, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoListTopics(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoListTopics(Async)");
        }
        

        com.squareup.okhttp.Call call = repoListTopicsCall(owner, repo, page, limit, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get list of topics that a repository has
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return TopicName
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public TopicName repoListTopics(String owner, String repo, Integer page, Integer limit) throws ApiException {
        ApiResponse<TopicName> resp = repoListTopicsWithHttpInfo(owner, repo, page, limit);
        return resp.getData();
    }

    /**
     * Get list of topics that a repository has
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return ApiResponse&lt;TopicName&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<TopicName> repoListTopicsWithHttpInfo(String owner, String repo, Integer page, Integer limit) throws ApiException {
        com.squareup.okhttp.Call call = repoListTopicsValidateBeforeCall(owner, repo, page, limit, null, null);
        Type localVarReturnType = new TypeToken<TopicName>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get list of topics that a repository has (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoListTopicsAsync(String owner, String repo, Integer page, Integer limit, final ApiCallback<TopicName> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoListTopicsValidateBeforeCall(owner, repo, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TopicName>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoMergePullRequest
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request to merge (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoMergePullRequestCall(String owner, String repo, Long index, MergePullRequestOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/pulls/{index}/merge"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoMergePullRequestValidateBeforeCall(String owner, String repo, Long index, MergePullRequestOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoMergePullRequest(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoMergePullRequest(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling repoMergePullRequest(Async)");
        }
        

        com.squareup.okhttp.Call call = repoMergePullRequestCall(owner, repo, index, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Merge a pull request
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request to merge (required)
     * @param body  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void repoMergePullRequest(String owner, String repo, Long index, MergePullRequestOption body) throws ApiException {
        repoMergePullRequestWithHttpInfo(owner, repo, index, body);
    }

    /**
     * Merge a pull request
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request to merge (required)
     * @param body  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> repoMergePullRequestWithHttpInfo(String owner, String repo, Long index, MergePullRequestOption body) throws ApiException {
        com.squareup.okhttp.Call call = repoMergePullRequestValidateBeforeCall(owner, repo, index, body, null, null);
        return apiClient.execute(call);
    }

    /**
     * Merge a pull request (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request to merge (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoMergePullRequestAsync(String owner, String repo, Long index, MergePullRequestOption body, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoMergePullRequestValidateBeforeCall(owner, repo, index, body, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for repoMigrate
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoMigrateCall(MigrateRepoOptions body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/migrate";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoMigrateValidateBeforeCall(MigrateRepoOptions body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        

        com.squareup.okhttp.Call call = repoMigrateCall(body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Migrate a remote git repository
     * 
     * @param body  (optional)
     * @return Repository
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Repository repoMigrate(MigrateRepoOptions body) throws ApiException {
        ApiResponse<Repository> resp = repoMigrateWithHttpInfo(body);
        return resp.getData();
    }

    /**
     * Migrate a remote git repository
     * 
     * @param body  (optional)
     * @return ApiResponse&lt;Repository&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Repository> repoMigrateWithHttpInfo(MigrateRepoOptions body) throws ApiException {
        com.squareup.okhttp.Call call = repoMigrateValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Migrate a remote git repository (asynchronously)
     * 
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoMigrateAsync(MigrateRepoOptions body, final ApiCallback<Repository> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoMigrateValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoMirrorSync
     * @param owner owner of the repo to sync (required)
     * @param repo name of the repo to sync (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoMirrorSyncCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/mirror-sync"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoMirrorSyncValidateBeforeCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoMirrorSync(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoMirrorSync(Async)");
        }
        

        com.squareup.okhttp.Call call = repoMirrorSyncCall(owner, repo, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Sync a mirrored repository
     * 
     * @param owner owner of the repo to sync (required)
     * @param repo name of the repo to sync (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void repoMirrorSync(String owner, String repo) throws ApiException {
        repoMirrorSyncWithHttpInfo(owner, repo);
    }

    /**
     * Sync a mirrored repository
     * 
     * @param owner owner of the repo to sync (required)
     * @param repo name of the repo to sync (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> repoMirrorSyncWithHttpInfo(String owner, String repo) throws ApiException {
        com.squareup.okhttp.Call call = repoMirrorSyncValidateBeforeCall(owner, repo, null, null);
        return apiClient.execute(call);
    }

    /**
     * Sync a mirrored repository (asynchronously)
     * 
     * @param owner owner of the repo to sync (required)
     * @param repo name of the repo to sync (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoMirrorSyncAsync(String owner, String repo, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoMirrorSyncValidateBeforeCall(owner, repo, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for repoPullRequestIsMerged
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoPullRequestIsMergedCall(String owner, String repo, Long index, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/pulls/{index}/merge"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoPullRequestIsMergedValidateBeforeCall(String owner, String repo, Long index, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoPullRequestIsMerged(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoPullRequestIsMerged(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling repoPullRequestIsMerged(Async)");
        }
        

        com.squareup.okhttp.Call call = repoPullRequestIsMergedCall(owner, repo, index, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Check if a pull request has been merged
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void repoPullRequestIsMerged(String owner, String repo, Long index) throws ApiException {
        repoPullRequestIsMergedWithHttpInfo(owner, repo, index);
    }

    /**
     * Check if a pull request has been merged
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> repoPullRequestIsMergedWithHttpInfo(String owner, String repo, Long index) throws ApiException {
        com.squareup.okhttp.Call call = repoPullRequestIsMergedValidateBeforeCall(owner, repo, index, null, null);
        return apiClient.execute(call);
    }

    /**
     * Check if a pull request has been merged (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoPullRequestIsMergedAsync(String owner, String repo, Long index, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoPullRequestIsMergedValidateBeforeCall(owner, repo, index, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for repoPushMirrorSync
     * @param owner owner of the repo to sync (required)
     * @param repo name of the repo to sync (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoPushMirrorSyncCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/push_mirrors-sync"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoPushMirrorSyncValidateBeforeCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoPushMirrorSync(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoPushMirrorSync(Async)");
        }
        

        com.squareup.okhttp.Call call = repoPushMirrorSyncCall(owner, repo, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Sync all push mirrored repository
     * 
     * @param owner owner of the repo to sync (required)
     * @param repo name of the repo to sync (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void repoPushMirrorSync(String owner, String repo) throws ApiException {
        repoPushMirrorSyncWithHttpInfo(owner, repo);
    }

    /**
     * Sync all push mirrored repository
     * 
     * @param owner owner of the repo to sync (required)
     * @param repo name of the repo to sync (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> repoPushMirrorSyncWithHttpInfo(String owner, String repo) throws ApiException {
        com.squareup.okhttp.Call call = repoPushMirrorSyncValidateBeforeCall(owner, repo, null, null);
        return apiClient.execute(call);
    }

    /**
     * Sync all push mirrored repository (asynchronously)
     * 
     * @param owner owner of the repo to sync (required)
     * @param repo name of the repo to sync (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoPushMirrorSyncAsync(String owner, String repo, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoPushMirrorSyncValidateBeforeCall(owner, repo, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for repoSearch
     * @param q keyword (optional)
     * @param topic Limit search to repositories with keyword as topic (optional)
     * @param includeDesc include search of keyword within repository description (optional)
     * @param uid search only for repos that the user with the given id owns or contributes to (optional)
     * @param priorityOwnerId repo owner to prioritize in the results (optional)
     * @param teamId search only for repos that belong to the given team id (optional)
     * @param starredBy search only for repos that the user with the given id has starred (optional)
     * @param _private include private repositories this user has access to (defaults to true) (optional)
     * @param isPrivate show only pubic, private or all repositories (defaults to all) (optional)
     * @param template include template repositories this user has access to (defaults to true) (optional)
     * @param archived show only archived, non-archived or all repositories (defaults to all) (optional)
     * @param mode type of repository to search for. Supported values are \&quot;fork\&quot;, \&quot;source\&quot;, \&quot;mirror\&quot; and \&quot;collaborative\&quot; (optional)
     * @param exclusive if &#x60;uid&#x60; is given, search only for repos that the user owns (optional)
     * @param sort sort repos by attribute. Supported values are \&quot;alpha\&quot;, \&quot;created\&quot;, \&quot;updated\&quot;, \&quot;size\&quot;, and \&quot;id\&quot;. Default is \&quot;alpha\&quot; (optional)
     * @param order sort order, either \&quot;asc\&quot; (ascending) or \&quot;desc\&quot; (descending). Default is \&quot;asc\&quot;, ignored if \&quot;sort\&quot; is not specified. (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoSearchCall(String q, Boolean topic, Boolean includeDesc, Long uid, Long priorityOwnerId, Long teamId, Long starredBy, Boolean _private, Boolean isPrivate, Boolean template, Boolean archived, String mode, Boolean exclusive, String sort, String order, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/search";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (q != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("q", q));
        if (topic != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("topic", topic));
        if (includeDesc != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("includeDesc", includeDesc));
        if (uid != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("uid", uid));
        if (priorityOwnerId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("priority_owner_id", priorityOwnerId));
        if (teamId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("team_id", teamId));
        if (starredBy != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("starredBy", starredBy));
        if (_private != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("private", _private));
        if (isPrivate != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("is_private", isPrivate));
        if (template != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("template", template));
        if (archived != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("archived", archived));
        if (mode != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("mode", mode));
        if (exclusive != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("exclusive", exclusive));
        if (sort != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("sort", sort));
        if (order != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("order", order));
        if (page != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoSearchValidateBeforeCall(String q, Boolean topic, Boolean includeDesc, Long uid, Long priorityOwnerId, Long teamId, Long starredBy, Boolean _private, Boolean isPrivate, Boolean template, Boolean archived, String mode, Boolean exclusive, String sort, String order, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        

        com.squareup.okhttp.Call call = repoSearchCall(q, topic, includeDesc, uid, priorityOwnerId, teamId, starredBy, _private, isPrivate, template, archived, mode, exclusive, sort, order, page, limit, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Search for repositories
     * 
     * @param q keyword (optional)
     * @param topic Limit search to repositories with keyword as topic (optional)
     * @param includeDesc include search of keyword within repository description (optional)
     * @param uid search only for repos that the user with the given id owns or contributes to (optional)
     * @param priorityOwnerId repo owner to prioritize in the results (optional)
     * @param teamId search only for repos that belong to the given team id (optional)
     * @param starredBy search only for repos that the user with the given id has starred (optional)
     * @param _private include private repositories this user has access to (defaults to true) (optional)
     * @param isPrivate show only pubic, private or all repositories (defaults to all) (optional)
     * @param template include template repositories this user has access to (defaults to true) (optional)
     * @param archived show only archived, non-archived or all repositories (defaults to all) (optional)
     * @param mode type of repository to search for. Supported values are \&quot;fork\&quot;, \&quot;source\&quot;, \&quot;mirror\&quot; and \&quot;collaborative\&quot; (optional)
     * @param exclusive if &#x60;uid&#x60; is given, search only for repos that the user owns (optional)
     * @param sort sort repos by attribute. Supported values are \&quot;alpha\&quot;, \&quot;created\&quot;, \&quot;updated\&quot;, \&quot;size\&quot;, and \&quot;id\&quot;. Default is \&quot;alpha\&quot; (optional)
     * @param order sort order, either \&quot;asc\&quot; (ascending) or \&quot;desc\&quot; (descending). Default is \&quot;asc\&quot;, ignored if \&quot;sort\&quot; is not specified. (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return SearchResults
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public SearchResults repoSearch(String q, Boolean topic, Boolean includeDesc, Long uid, Long priorityOwnerId, Long teamId, Long starredBy, Boolean _private, Boolean isPrivate, Boolean template, Boolean archived, String mode, Boolean exclusive, String sort, String order, Integer page, Integer limit) throws ApiException {
        ApiResponse<SearchResults> resp = repoSearchWithHttpInfo(q, topic, includeDesc, uid, priorityOwnerId, teamId, starredBy, _private, isPrivate, template, archived, mode, exclusive, sort, order, page, limit);
        return resp.getData();
    }

    /**
     * Search for repositories
     * 
     * @param q keyword (optional)
     * @param topic Limit search to repositories with keyword as topic (optional)
     * @param includeDesc include search of keyword within repository description (optional)
     * @param uid search only for repos that the user with the given id owns or contributes to (optional)
     * @param priorityOwnerId repo owner to prioritize in the results (optional)
     * @param teamId search only for repos that belong to the given team id (optional)
     * @param starredBy search only for repos that the user with the given id has starred (optional)
     * @param _private include private repositories this user has access to (defaults to true) (optional)
     * @param isPrivate show only pubic, private or all repositories (defaults to all) (optional)
     * @param template include template repositories this user has access to (defaults to true) (optional)
     * @param archived show only archived, non-archived or all repositories (defaults to all) (optional)
     * @param mode type of repository to search for. Supported values are \&quot;fork\&quot;, \&quot;source\&quot;, \&quot;mirror\&quot; and \&quot;collaborative\&quot; (optional)
     * @param exclusive if &#x60;uid&#x60; is given, search only for repos that the user owns (optional)
     * @param sort sort repos by attribute. Supported values are \&quot;alpha\&quot;, \&quot;created\&quot;, \&quot;updated\&quot;, \&quot;size\&quot;, and \&quot;id\&quot;. Default is \&quot;alpha\&quot; (optional)
     * @param order sort order, either \&quot;asc\&quot; (ascending) or \&quot;desc\&quot; (descending). Default is \&quot;asc\&quot;, ignored if \&quot;sort\&quot; is not specified. (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return ApiResponse&lt;SearchResults&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<SearchResults> repoSearchWithHttpInfo(String q, Boolean topic, Boolean includeDesc, Long uid, Long priorityOwnerId, Long teamId, Long starredBy, Boolean _private, Boolean isPrivate, Boolean template, Boolean archived, String mode, Boolean exclusive, String sort, String order, Integer page, Integer limit) throws ApiException {
        com.squareup.okhttp.Call call = repoSearchValidateBeforeCall(q, topic, includeDesc, uid, priorityOwnerId, teamId, starredBy, _private, isPrivate, template, archived, mode, exclusive, sort, order, page, limit, null, null);
        Type localVarReturnType = new TypeToken<SearchResults>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Search for repositories (asynchronously)
     * 
     * @param q keyword (optional)
     * @param topic Limit search to repositories with keyword as topic (optional)
     * @param includeDesc include search of keyword within repository description (optional)
     * @param uid search only for repos that the user with the given id owns or contributes to (optional)
     * @param priorityOwnerId repo owner to prioritize in the results (optional)
     * @param teamId search only for repos that belong to the given team id (optional)
     * @param starredBy search only for repos that the user with the given id has starred (optional)
     * @param _private include private repositories this user has access to (defaults to true) (optional)
     * @param isPrivate show only pubic, private or all repositories (defaults to all) (optional)
     * @param template include template repositories this user has access to (defaults to true) (optional)
     * @param archived show only archived, non-archived or all repositories (defaults to all) (optional)
     * @param mode type of repository to search for. Supported values are \&quot;fork\&quot;, \&quot;source\&quot;, \&quot;mirror\&quot; and \&quot;collaborative\&quot; (optional)
     * @param exclusive if &#x60;uid&#x60; is given, search only for repos that the user owns (optional)
     * @param sort sort repos by attribute. Supported values are \&quot;alpha\&quot;, \&quot;created\&quot;, \&quot;updated\&quot;, \&quot;size\&quot;, and \&quot;id\&quot;. Default is \&quot;alpha\&quot; (optional)
     * @param order sort order, either \&quot;asc\&quot; (ascending) or \&quot;desc\&quot; (descending). Default is \&quot;asc\&quot;, ignored if \&quot;sort\&quot; is not specified. (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoSearchAsync(String q, Boolean topic, Boolean includeDesc, Long uid, Long priorityOwnerId, Long teamId, Long starredBy, Boolean _private, Boolean isPrivate, Boolean template, Boolean archived, String mode, Boolean exclusive, String sort, String order, Integer page, Integer limit, final ApiCallback<SearchResults> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoSearchValidateBeforeCall(q, topic, includeDesc, uid, priorityOwnerId, teamId, starredBy, _private, isPrivate, template, archived, mode, exclusive, sort, order, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SearchResults>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoSigningKey
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoSigningKeyCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/signing-key.gpg"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoSigningKeyValidateBeforeCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoSigningKey(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoSigningKey(Async)");
        }
        

        com.squareup.okhttp.Call call = repoSigningKeyCall(owner, repo, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get signing-key.gpg for given repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @return String
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public String repoSigningKey(String owner, String repo) throws ApiException {
        ApiResponse<String> resp = repoSigningKeyWithHttpInfo(owner, repo);
        return resp.getData();
    }

    /**
     * Get signing-key.gpg for given repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @return ApiResponse&lt;String&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<String> repoSigningKeyWithHttpInfo(String owner, String repo) throws ApiException {
        com.squareup.okhttp.Call call = repoSigningKeyValidateBeforeCall(owner, repo, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get signing-key.gpg for given repository (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoSigningKeyAsync(String owner, String repo, final ApiCallback<String> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoSigningKeyValidateBeforeCall(owner, repo, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoSubmitPullReview
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request (required)
     * @param id id of the review (required)
     * @param body  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoSubmitPullReviewCall(String owner, String repo, Long index, Long id, SubmitPullReviewOptions body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/pulls/{index}/reviews/{id}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()))
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoSubmitPullReviewValidateBeforeCall(String owner, String repo, Long index, Long id, SubmitPullReviewOptions body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoSubmitPullReview(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoSubmitPullReview(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling repoSubmitPullReview(Async)");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoSubmitPullReview(Async)");
        }
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling repoSubmitPullReview(Async)");
        }
        

        com.squareup.okhttp.Call call = repoSubmitPullReviewCall(owner, repo, index, id, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Submit a pending review to an pull request
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request (required)
     * @param id id of the review (required)
     * @param body  (required)
     * @return PullReview
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public PullReview repoSubmitPullReview(String owner, String repo, Long index, Long id, SubmitPullReviewOptions body) throws ApiException {
        ApiResponse<PullReview> resp = repoSubmitPullReviewWithHttpInfo(owner, repo, index, id, body);
        return resp.getData();
    }

    /**
     * Submit a pending review to an pull request
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request (required)
     * @param id id of the review (required)
     * @param body  (required)
     * @return ApiResponse&lt;PullReview&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<PullReview> repoSubmitPullReviewWithHttpInfo(String owner, String repo, Long index, Long id, SubmitPullReviewOptions body) throws ApiException {
        com.squareup.okhttp.Call call = repoSubmitPullReviewValidateBeforeCall(owner, repo, index, id, body, null, null);
        Type localVarReturnType = new TypeToken<PullReview>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Submit a pending review to an pull request (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request (required)
     * @param id id of the review (required)
     * @param body  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoSubmitPullReviewAsync(String owner, String repo, Long index, Long id, SubmitPullReviewOptions body, final ApiCallback<PullReview> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoSubmitPullReviewValidateBeforeCall(owner, repo, index, id, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PullReview>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoTestHook
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the hook to test (required)
     * @param ref The name of the commit/branch/tag, indicates which commit will be loaded to the webhook payload. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoTestHookCall(String owner, String repo, Long id, String ref, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/hooks/{id}/tests"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (ref != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("ref", ref));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoTestHookValidateBeforeCall(String owner, String repo, Long id, String ref, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoTestHook(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoTestHook(Async)");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoTestHook(Async)");
        }
        

        com.squareup.okhttp.Call call = repoTestHookCall(owner, repo, id, ref, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Test a push webhook
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the hook to test (required)
     * @param ref The name of the commit/branch/tag, indicates which commit will be loaded to the webhook payload. (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void repoTestHook(String owner, String repo, Long id, String ref) throws ApiException {
        repoTestHookWithHttpInfo(owner, repo, id, ref);
    }

    /**
     * Test a push webhook
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the hook to test (required)
     * @param ref The name of the commit/branch/tag, indicates which commit will be loaded to the webhook payload. (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> repoTestHookWithHttpInfo(String owner, String repo, Long id, String ref) throws ApiException {
        com.squareup.okhttp.Call call = repoTestHookValidateBeforeCall(owner, repo, id, ref, null, null);
        return apiClient.execute(call);
    }

    /**
     * Test a push webhook (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the hook to test (required)
     * @param ref The name of the commit/branch/tag, indicates which commit will be loaded to the webhook payload. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoTestHookAsync(String owner, String repo, Long id, String ref, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoTestHookValidateBeforeCall(owner, repo, id, ref, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for repoTrackedTimes
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param user optional filter by user (available for issue managers) (optional)
     * @param since Only show times updated after the given time. This is a timestamp in RFC 3339 format (optional)
     * @param before Only show times updated before the given time. This is a timestamp in RFC 3339 format (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoTrackedTimesCall(String owner, String repo, String user, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/times"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (user != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("user", user));
        if (since != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("since", since));
        if (before != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("before", before));
        if (page != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoTrackedTimesValidateBeforeCall(String owner, String repo, String user, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoTrackedTimes(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoTrackedTimes(Async)");
        }
        

        com.squareup.okhttp.Call call = repoTrackedTimesCall(owner, repo, user, since, before, page, limit, progressListener, progressRequestListener);
        return call;

    }

    /**
     * List a repo&#39;s tracked times
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param user optional filter by user (available for issue managers) (optional)
     * @param since Only show times updated after the given time. This is a timestamp in RFC 3339 format (optional)
     * @param before Only show times updated before the given time. This is a timestamp in RFC 3339 format (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return List&lt;TrackedTime&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<TrackedTime> repoTrackedTimes(String owner, String repo, String user, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<TrackedTime>> resp = repoTrackedTimesWithHttpInfo(owner, repo, user, since, before, page, limit);
        return resp.getData();
    }

    /**
     * List a repo&#39;s tracked times
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param user optional filter by user (available for issue managers) (optional)
     * @param since Only show times updated after the given time. This is a timestamp in RFC 3339 format (optional)
     * @param before Only show times updated before the given time. This is a timestamp in RFC 3339 format (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return ApiResponse&lt;List&lt;TrackedTime&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<TrackedTime>> repoTrackedTimesWithHttpInfo(String owner, String repo, String user, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit) throws ApiException {
        com.squareup.okhttp.Call call = repoTrackedTimesValidateBeforeCall(owner, repo, user, since, before, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<TrackedTime>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * List a repo&#39;s tracked times (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param user optional filter by user (available for issue managers) (optional)
     * @param since Only show times updated after the given time. This is a timestamp in RFC 3339 format (optional)
     * @param before Only show times updated before the given time. This is a timestamp in RFC 3339 format (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoTrackedTimesAsync(String owner, String repo, String user, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit, final ApiCallback<List<TrackedTime>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoTrackedTimesValidateBeforeCall(owner, repo, user, since, before, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<TrackedTime>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoTransfer
     * @param owner owner of the repo to transfer (required)
     * @param repo name of the repo to transfer (required)
     * @param body Transfer Options (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoTransferCall(String owner, String repo, TransferRepoOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/transfer"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoTransferValidateBeforeCall(String owner, String repo, TransferRepoOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoTransfer(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoTransfer(Async)");
        }
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling repoTransfer(Async)");
        }
        

        com.squareup.okhttp.Call call = repoTransferCall(owner, repo, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Transfer a repo ownership
     * 
     * @param owner owner of the repo to transfer (required)
     * @param repo name of the repo to transfer (required)
     * @param body Transfer Options (required)
     * @return Repository
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Repository repoTransfer(String owner, String repo, TransferRepoOption body) throws ApiException {
        ApiResponse<Repository> resp = repoTransferWithHttpInfo(owner, repo, body);
        return resp.getData();
    }

    /**
     * Transfer a repo ownership
     * 
     * @param owner owner of the repo to transfer (required)
     * @param repo name of the repo to transfer (required)
     * @param body Transfer Options (required)
     * @return ApiResponse&lt;Repository&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Repository> repoTransferWithHttpInfo(String owner, String repo, TransferRepoOption body) throws ApiException {
        com.squareup.okhttp.Call call = repoTransferValidateBeforeCall(owner, repo, body, null, null);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Transfer a repo ownership (asynchronously)
     * 
     * @param owner owner of the repo to transfer (required)
     * @param repo name of the repo to transfer (required)
     * @param body Transfer Options (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoTransferAsync(String owner, String repo, TransferRepoOption body, final ApiCallback<Repository> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoTransferValidateBeforeCall(owner, repo, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoUnDismissPullReview
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request (required)
     * @param id id of the review (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoUnDismissPullReviewCall(String owner, String repo, Long index, Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/pulls/{index}/reviews/{id}/undismissals"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()))
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoUnDismissPullReviewValidateBeforeCall(String owner, String repo, Long index, Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoUnDismissPullReview(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoUnDismissPullReview(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling repoUnDismissPullReview(Async)");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling repoUnDismissPullReview(Async)");
        }
        

        com.squareup.okhttp.Call call = repoUnDismissPullReviewCall(owner, repo, index, id, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Cancel to dismiss a review for a pull request
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request (required)
     * @param id id of the review (required)
     * @return PullReview
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public PullReview repoUnDismissPullReview(String owner, String repo, Long index, Long id) throws ApiException {
        ApiResponse<PullReview> resp = repoUnDismissPullReviewWithHttpInfo(owner, repo, index, id);
        return resp.getData();
    }

    /**
     * Cancel to dismiss a review for a pull request
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request (required)
     * @param id id of the review (required)
     * @return ApiResponse&lt;PullReview&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<PullReview> repoUnDismissPullReviewWithHttpInfo(String owner, String repo, Long index, Long id) throws ApiException {
        com.squareup.okhttp.Call call = repoUnDismissPullReviewValidateBeforeCall(owner, repo, index, id, null, null);
        Type localVarReturnType = new TypeToken<PullReview>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Cancel to dismiss a review for a pull request (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request (required)
     * @param id id of the review (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoUnDismissPullReviewAsync(String owner, String repo, Long index, Long id, final ApiCallback<PullReview> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoUnDismissPullReviewValidateBeforeCall(owner, repo, index, id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PullReview>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoUpdateFile
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param filepath path of the file to update (required)
     * @param body  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoUpdateFileCall(String owner, String repo, String filepath, UpdateFileOptions body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/contents/{filepath}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "filepath" + "\\}", apiClient.escapeString(filepath.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoUpdateFileValidateBeforeCall(String owner, String repo, String filepath, UpdateFileOptions body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoUpdateFile(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoUpdateFile(Async)");
        }
        
        // verify the required parameter 'filepath' is set
        if (filepath == null) {
            throw new ApiException("Missing the required parameter 'filepath' when calling repoUpdateFile(Async)");
        }
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling repoUpdateFile(Async)");
        }
        

        com.squareup.okhttp.Call call = repoUpdateFileCall(owner, repo, filepath, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Update a file in a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param filepath path of the file to update (required)
     * @param body  (required)
     * @return FileResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public FileResponse repoUpdateFile(String owner, String repo, String filepath, UpdateFileOptions body) throws ApiException {
        ApiResponse<FileResponse> resp = repoUpdateFileWithHttpInfo(owner, repo, filepath, body);
        return resp.getData();
    }

    /**
     * Update a file in a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param filepath path of the file to update (required)
     * @param body  (required)
     * @return ApiResponse&lt;FileResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<FileResponse> repoUpdateFileWithHttpInfo(String owner, String repo, String filepath, UpdateFileOptions body) throws ApiException {
        com.squareup.okhttp.Call call = repoUpdateFileValidateBeforeCall(owner, repo, filepath, body, null, null);
        Type localVarReturnType = new TypeToken<FileResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Update a file in a repository (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param filepath path of the file to update (required)
     * @param body  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoUpdateFileAsync(String owner, String repo, String filepath, UpdateFileOptions body, final ApiCallback<FileResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoUpdateFileValidateBeforeCall(owner, repo, filepath, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FileResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for repoUpdatePullRequest
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request to get (required)
     * @param style how to update pull request (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoUpdatePullRequestCall(String owner, String repo, Long index, String style, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/pulls/{index}/update"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (style != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("style", style));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoUpdatePullRequestValidateBeforeCall(String owner, String repo, Long index, String style, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoUpdatePullRequest(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoUpdatePullRequest(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling repoUpdatePullRequest(Async)");
        }
        

        com.squareup.okhttp.Call call = repoUpdatePullRequestCall(owner, repo, index, style, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Merge PR&#39;s baseBranch into headBranch
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request to get (required)
     * @param style how to update pull request (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void repoUpdatePullRequest(String owner, String repo, Long index, String style) throws ApiException {
        repoUpdatePullRequestWithHttpInfo(owner, repo, index, style);
    }

    /**
     * Merge PR&#39;s baseBranch into headBranch
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request to get (required)
     * @param style how to update pull request (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> repoUpdatePullRequestWithHttpInfo(String owner, String repo, Long index, String style) throws ApiException {
        com.squareup.okhttp.Call call = repoUpdatePullRequestValidateBeforeCall(owner, repo, index, style, null, null);
        return apiClient.execute(call);
    }

    /**
     * Merge PR&#39;s baseBranch into headBranch (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the pull request to get (required)
     * @param style how to update pull request (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoUpdatePullRequestAsync(String owner, String repo, Long index, String style, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoUpdatePullRequestValidateBeforeCall(owner, repo, index, style, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for repoUpdateTopics
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call repoUpdateTopicsCall(String owner, String repo, RepoTopicOptions body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/topics"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call repoUpdateTopicsValidateBeforeCall(String owner, String repo, RepoTopicOptions body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling repoUpdateTopics(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling repoUpdateTopics(Async)");
        }
        

        com.squareup.okhttp.Call call = repoUpdateTopicsCall(owner, repo, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Replace list of topics for a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void repoUpdateTopics(String owner, String repo, RepoTopicOptions body) throws ApiException {
        repoUpdateTopicsWithHttpInfo(owner, repo, body);
    }

    /**
     * Replace list of topics for a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> repoUpdateTopicsWithHttpInfo(String owner, String repo, RepoTopicOptions body) throws ApiException {
        com.squareup.okhttp.Call call = repoUpdateTopicsValidateBeforeCall(owner, repo, body, null, null);
        return apiClient.execute(call);
    }

    /**
     * Replace list of topics for a repository (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call repoUpdateTopicsAsync(String owner, String repo, RepoTopicOptions body, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = repoUpdateTopicsValidateBeforeCall(owner, repo, body, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for topicSearch
     * @param q keywords to search (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call topicSearchCall(String q, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/topics/search";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (q != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("q", q));
        if (page != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call topicSearchValidateBeforeCall(String q, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'q' is set
        if (q == null) {
            throw new ApiException("Missing the required parameter 'q' when calling topicSearch(Async)");
        }
        

        com.squareup.okhttp.Call call = topicSearchCall(q, page, limit, progressListener, progressRequestListener);
        return call;

    }

    /**
     * search topics via keyword
     * 
     * @param q keywords to search (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return List&lt;TopicResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<TopicResponse> topicSearch(String q, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<TopicResponse>> resp = topicSearchWithHttpInfo(q, page, limit);
        return resp.getData();
    }

    /**
     * search topics via keyword
     * 
     * @param q keywords to search (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return ApiResponse&lt;List&lt;TopicResponse&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<TopicResponse>> topicSearchWithHttpInfo(String q, Integer page, Integer limit) throws ApiException {
        com.squareup.okhttp.Call call = topicSearchValidateBeforeCall(q, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<TopicResponse>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * search topics via keyword (asynchronously)
     * 
     * @param q keywords to search (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call topicSearchAsync(String q, Integer page, Integer limit, final ApiCallback<List<TopicResponse>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = topicSearchValidateBeforeCall(q, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<TopicResponse>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for userCurrentCheckSubscription
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call userCurrentCheckSubscriptionCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/subscription"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/html"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call userCurrentCheckSubscriptionValidateBeforeCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling userCurrentCheckSubscription(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling userCurrentCheckSubscription(Async)");
        }
        

        com.squareup.okhttp.Call call = userCurrentCheckSubscriptionCall(owner, repo, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Check if the current user is watching a repo
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @return WatchInfo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public WatchInfo userCurrentCheckSubscription(String owner, String repo) throws ApiException {
        ApiResponse<WatchInfo> resp = userCurrentCheckSubscriptionWithHttpInfo(owner, repo);
        return resp.getData();
    }

    /**
     * Check if the current user is watching a repo
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @return ApiResponse&lt;WatchInfo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<WatchInfo> userCurrentCheckSubscriptionWithHttpInfo(String owner, String repo) throws ApiException {
        com.squareup.okhttp.Call call = userCurrentCheckSubscriptionValidateBeforeCall(owner, repo, null, null);
        Type localVarReturnType = new TypeToken<WatchInfo>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Check if the current user is watching a repo (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call userCurrentCheckSubscriptionAsync(String owner, String repo, final ApiCallback<WatchInfo> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = userCurrentCheckSubscriptionValidateBeforeCall(owner, repo, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WatchInfo>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for userCurrentDeleteSubscription
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call userCurrentDeleteSubscriptionCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/subscription"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/html"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call userCurrentDeleteSubscriptionValidateBeforeCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling userCurrentDeleteSubscription(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling userCurrentDeleteSubscription(Async)");
        }
        

        com.squareup.okhttp.Call call = userCurrentDeleteSubscriptionCall(owner, repo, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Unwatch a repo
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void userCurrentDeleteSubscription(String owner, String repo) throws ApiException {
        userCurrentDeleteSubscriptionWithHttpInfo(owner, repo);
    }

    /**
     * Unwatch a repo
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> userCurrentDeleteSubscriptionWithHttpInfo(String owner, String repo) throws ApiException {
        com.squareup.okhttp.Call call = userCurrentDeleteSubscriptionValidateBeforeCall(owner, repo, null, null);
        return apiClient.execute(call);
    }

    /**
     * Unwatch a repo (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call userCurrentDeleteSubscriptionAsync(String owner, String repo, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = userCurrentDeleteSubscriptionValidateBeforeCall(owner, repo, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for userCurrentPutSubscription
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call userCurrentPutSubscriptionCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/subscription"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/html"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call userCurrentPutSubscriptionValidateBeforeCall(String owner, String repo, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling userCurrentPutSubscription(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling userCurrentPutSubscription(Async)");
        }
        

        com.squareup.okhttp.Call call = userCurrentPutSubscriptionCall(owner, repo, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Watch a repo
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @return WatchInfo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public WatchInfo userCurrentPutSubscription(String owner, String repo) throws ApiException {
        ApiResponse<WatchInfo> resp = userCurrentPutSubscriptionWithHttpInfo(owner, repo);
        return resp.getData();
    }

    /**
     * Watch a repo
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @return ApiResponse&lt;WatchInfo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<WatchInfo> userCurrentPutSubscriptionWithHttpInfo(String owner, String repo) throws ApiException {
        com.squareup.okhttp.Call call = userCurrentPutSubscriptionValidateBeforeCall(owner, repo, null, null);
        Type localVarReturnType = new TypeToken<WatchInfo>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Watch a repo (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call userCurrentPutSubscriptionAsync(String owner, String repo, final ApiCallback<WatchInfo> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = userCurrentPutSubscriptionValidateBeforeCall(owner, repo, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WatchInfo>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for userTrackedTimes
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param user username of user (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @deprecated
     */
    @Deprecated
    public com.squareup.okhttp.Call userTrackedTimesCall(String owner, String repo, String user, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/times/{user}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "user" + "\\}", apiClient.escapeString(user.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @Deprecated
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call userTrackedTimesValidateBeforeCall(String owner, String repo, String user, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling userTrackedTimes(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling userTrackedTimes(Async)");
        }
        
        // verify the required parameter 'user' is set
        if (user == null) {
            throw new ApiException("Missing the required parameter 'user' when calling userTrackedTimes(Async)");
        }
        

        com.squareup.okhttp.Call call = userTrackedTimesCall(owner, repo, user, progressListener, progressRequestListener);
        return call;

    }

    /**
     * List a user&#39;s tracked times in a repo
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param user username of user (required)
     * @return List&lt;TrackedTime&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @deprecated
     */
    @Deprecated
    public List<TrackedTime> userTrackedTimes(String owner, String repo, String user) throws ApiException {
        ApiResponse<List<TrackedTime>> resp = userTrackedTimesWithHttpInfo(owner, repo, user);
        return resp.getData();
    }

    /**
     * List a user&#39;s tracked times in a repo
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param user username of user (required)
     * @return ApiResponse&lt;List&lt;TrackedTime&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @deprecated
     */
    @Deprecated
    public ApiResponse<List<TrackedTime>> userTrackedTimesWithHttpInfo(String owner, String repo, String user) throws ApiException {
        com.squareup.okhttp.Call call = userTrackedTimesValidateBeforeCall(owner, repo, user, null, null);
        Type localVarReturnType = new TypeToken<List<TrackedTime>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * List a user&#39;s tracked times in a repo (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param user username of user (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @deprecated
     */
    @Deprecated
    public com.squareup.okhttp.Call userTrackedTimesAsync(String owner, String repo, String user, final ApiCallback<List<TrackedTime>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = userTrackedTimesValidateBeforeCall(owner, repo, user, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<TrackedTime>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
