/*
 * Gitea API.
 * This documentation describes the Gitea API.
 *
 * OpenAPI spec version: 1.18.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.gitea.api;

import io.gitea.ApiCallback;
import io.gitea.ApiClient;
import io.gitea.ApiException;
import io.gitea.ApiResponse;
import io.gitea.Configuration;
import io.gitea.Pair;
import io.gitea.ProgressRequestBody;
import io.gitea.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import io.gitea.model.NotificationCount;
import io.gitea.model.NotificationThread;
import org.threeten.bp.OffsetDateTime;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NotificationApi {
    private ApiClient apiClient;

    public NotificationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public NotificationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for notifyGetList
     * @param all If true, show notifications marked as read. Default value is false (optional)
     * @param statusTypes Show notifications with the provided status types. Options are: unread, read and/or pinned. Defaults to unread &amp; pinned. (optional)
     * @param subjectType filter notifications by subject type (optional)
     * @param since Only show notifications updated after the given time. This is a timestamp in RFC 3339 format (optional)
     * @param before Only show notifications updated before the given time. This is a timestamp in RFC 3339 format (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call notifyGetListCall(Boolean all, List<String> statusTypes, List<String> subjectType, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/notifications";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (all != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("all", all));
        if (statusTypes != null)
        localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("multi", "status-types", statusTypes));
        if (subjectType != null)
        localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("multi", "subject-type", subjectType));
        if (since != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("since", since));
        if (before != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("before", before));
        if (page != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call notifyGetListValidateBeforeCall(Boolean all, List<String> statusTypes, List<String> subjectType, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        

        com.squareup.okhttp.Call call = notifyGetListCall(all, statusTypes, subjectType, since, before, page, limit, progressListener, progressRequestListener);
        return call;

    }

    /**
     * List users&#39;s notification threads
     * 
     * @param all If true, show notifications marked as read. Default value is false (optional)
     * @param statusTypes Show notifications with the provided status types. Options are: unread, read and/or pinned. Defaults to unread &amp; pinned. (optional)
     * @param subjectType filter notifications by subject type (optional)
     * @param since Only show notifications updated after the given time. This is a timestamp in RFC 3339 format (optional)
     * @param before Only show notifications updated before the given time. This is a timestamp in RFC 3339 format (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return List&lt;NotificationThread&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<NotificationThread> notifyGetList(Boolean all, List<String> statusTypes, List<String> subjectType, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<NotificationThread>> resp = notifyGetListWithHttpInfo(all, statusTypes, subjectType, since, before, page, limit);
        return resp.getData();
    }

    /**
     * List users&#39;s notification threads
     * 
     * @param all If true, show notifications marked as read. Default value is false (optional)
     * @param statusTypes Show notifications with the provided status types. Options are: unread, read and/or pinned. Defaults to unread &amp; pinned. (optional)
     * @param subjectType filter notifications by subject type (optional)
     * @param since Only show notifications updated after the given time. This is a timestamp in RFC 3339 format (optional)
     * @param before Only show notifications updated before the given time. This is a timestamp in RFC 3339 format (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return ApiResponse&lt;List&lt;NotificationThread&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<NotificationThread>> notifyGetListWithHttpInfo(Boolean all, List<String> statusTypes, List<String> subjectType, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit) throws ApiException {
        com.squareup.okhttp.Call call = notifyGetListValidateBeforeCall(all, statusTypes, subjectType, since, before, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<NotificationThread>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * List users&#39;s notification threads (asynchronously)
     * 
     * @param all If true, show notifications marked as read. Default value is false (optional)
     * @param statusTypes Show notifications with the provided status types. Options are: unread, read and/or pinned. Defaults to unread &amp; pinned. (optional)
     * @param subjectType filter notifications by subject type (optional)
     * @param since Only show notifications updated after the given time. This is a timestamp in RFC 3339 format (optional)
     * @param before Only show notifications updated before the given time. This is a timestamp in RFC 3339 format (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call notifyGetListAsync(Boolean all, List<String> statusTypes, List<String> subjectType, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit, final ApiCallback<List<NotificationThread>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = notifyGetListValidateBeforeCall(all, statusTypes, subjectType, since, before, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<NotificationThread>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for notifyGetRepoList
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param all If true, show notifications marked as read. Default value is false (optional)
     * @param statusTypes Show notifications with the provided status types. Options are: unread, read and/or pinned. Defaults to unread &amp; pinned (optional)
     * @param subjectType filter notifications by subject type (optional)
     * @param since Only show notifications updated after the given time. This is a timestamp in RFC 3339 format (optional)
     * @param before Only show notifications updated before the given time. This is a timestamp in RFC 3339 format (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call notifyGetRepoListCall(String owner, String repo, Boolean all, List<String> statusTypes, List<String> subjectType, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/notifications"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (all != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("all", all));
        if (statusTypes != null)
        localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("multi", "status-types", statusTypes));
        if (subjectType != null)
        localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("multi", "subject-type", subjectType));
        if (since != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("since", since));
        if (before != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("before", before));
        if (page != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call notifyGetRepoListValidateBeforeCall(String owner, String repo, Boolean all, List<String> statusTypes, List<String> subjectType, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling notifyGetRepoList(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling notifyGetRepoList(Async)");
        }
        

        com.squareup.okhttp.Call call = notifyGetRepoListCall(owner, repo, all, statusTypes, subjectType, since, before, page, limit, progressListener, progressRequestListener);
        return call;

    }

    /**
     * List users&#39;s notification threads on a specific repo
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param all If true, show notifications marked as read. Default value is false (optional)
     * @param statusTypes Show notifications with the provided status types. Options are: unread, read and/or pinned. Defaults to unread &amp; pinned (optional)
     * @param subjectType filter notifications by subject type (optional)
     * @param since Only show notifications updated after the given time. This is a timestamp in RFC 3339 format (optional)
     * @param before Only show notifications updated before the given time. This is a timestamp in RFC 3339 format (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return List&lt;NotificationThread&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<NotificationThread> notifyGetRepoList(String owner, String repo, Boolean all, List<String> statusTypes, List<String> subjectType, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<NotificationThread>> resp = notifyGetRepoListWithHttpInfo(owner, repo, all, statusTypes, subjectType, since, before, page, limit);
        return resp.getData();
    }

    /**
     * List users&#39;s notification threads on a specific repo
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param all If true, show notifications marked as read. Default value is false (optional)
     * @param statusTypes Show notifications with the provided status types. Options are: unread, read and/or pinned. Defaults to unread &amp; pinned (optional)
     * @param subjectType filter notifications by subject type (optional)
     * @param since Only show notifications updated after the given time. This is a timestamp in RFC 3339 format (optional)
     * @param before Only show notifications updated before the given time. This is a timestamp in RFC 3339 format (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return ApiResponse&lt;List&lt;NotificationThread&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<NotificationThread>> notifyGetRepoListWithHttpInfo(String owner, String repo, Boolean all, List<String> statusTypes, List<String> subjectType, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit) throws ApiException {
        com.squareup.okhttp.Call call = notifyGetRepoListValidateBeforeCall(owner, repo, all, statusTypes, subjectType, since, before, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<NotificationThread>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * List users&#39;s notification threads on a specific repo (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param all If true, show notifications marked as read. Default value is false (optional)
     * @param statusTypes Show notifications with the provided status types. Options are: unread, read and/or pinned. Defaults to unread &amp; pinned (optional)
     * @param subjectType filter notifications by subject type (optional)
     * @param since Only show notifications updated after the given time. This is a timestamp in RFC 3339 format (optional)
     * @param before Only show notifications updated before the given time. This is a timestamp in RFC 3339 format (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call notifyGetRepoListAsync(String owner, String repo, Boolean all, List<String> statusTypes, List<String> subjectType, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit, final ApiCallback<List<NotificationThread>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = notifyGetRepoListValidateBeforeCall(owner, repo, all, statusTypes, subjectType, since, before, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<NotificationThread>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for notifyGetThread
     * @param id id of notification thread (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call notifyGetThreadCall(String id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/notifications/threads/{id}"
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call notifyGetThreadValidateBeforeCall(String id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling notifyGetThread(Async)");
        }
        

        com.squareup.okhttp.Call call = notifyGetThreadCall(id, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get notification thread by ID
     * 
     * @param id id of notification thread (required)
     * @return NotificationThread
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public NotificationThread notifyGetThread(String id) throws ApiException {
        ApiResponse<NotificationThread> resp = notifyGetThreadWithHttpInfo(id);
        return resp.getData();
    }

    /**
     * Get notification thread by ID
     * 
     * @param id id of notification thread (required)
     * @return ApiResponse&lt;NotificationThread&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<NotificationThread> notifyGetThreadWithHttpInfo(String id) throws ApiException {
        com.squareup.okhttp.Call call = notifyGetThreadValidateBeforeCall(id, null, null);
        Type localVarReturnType = new TypeToken<NotificationThread>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get notification thread by ID (asynchronously)
     * 
     * @param id id of notification thread (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call notifyGetThreadAsync(String id, final ApiCallback<NotificationThread> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = notifyGetThreadValidateBeforeCall(id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<NotificationThread>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for notifyNewAvailable
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call notifyNewAvailableCall(final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/notifications/new";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/html"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call notifyNewAvailableValidateBeforeCall(final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        

        com.squareup.okhttp.Call call = notifyNewAvailableCall(progressListener, progressRequestListener);
        return call;

    }

    /**
     * Check if unread notifications exist
     * 
     * @return NotificationCount
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public NotificationCount notifyNewAvailable() throws ApiException {
        ApiResponse<NotificationCount> resp = notifyNewAvailableWithHttpInfo();
        return resp.getData();
    }

    /**
     * Check if unread notifications exist
     * 
     * @return ApiResponse&lt;NotificationCount&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<NotificationCount> notifyNewAvailableWithHttpInfo() throws ApiException {
        com.squareup.okhttp.Call call = notifyNewAvailableValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<NotificationCount>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Check if unread notifications exist (asynchronously)
     * 
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call notifyNewAvailableAsync(final ApiCallback<NotificationCount> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = notifyNewAvailableValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<NotificationCount>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for notifyReadList
     * @param lastReadAt Describes the last point that notifications were checked. Anything updated since this time will not be updated. (optional)
     * @param all If true, mark all notifications on this repo. Default value is false (optional)
     * @param statusTypes Mark notifications with the provided status types. Options are: unread, read and/or pinned. Defaults to unread. (optional)
     * @param toStatus Status to mark notifications as, Defaults to read. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call notifyReadListCall(OffsetDateTime lastReadAt, String all, List<String> statusTypes, String toStatus, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/notifications";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (lastReadAt != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("last_read_at", lastReadAt));
        if (all != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("all", all));
        if (statusTypes != null)
        localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("multi", "status-types", statusTypes));
        if (toStatus != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("to-status", toStatus));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call notifyReadListValidateBeforeCall(OffsetDateTime lastReadAt, String all, List<String> statusTypes, String toStatus, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        

        com.squareup.okhttp.Call call = notifyReadListCall(lastReadAt, all, statusTypes, toStatus, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Mark notification threads as read, pinned or unread
     * 
     * @param lastReadAt Describes the last point that notifications were checked. Anything updated since this time will not be updated. (optional)
     * @param all If true, mark all notifications on this repo. Default value is false (optional)
     * @param statusTypes Mark notifications with the provided status types. Options are: unread, read and/or pinned. Defaults to unread. (optional)
     * @param toStatus Status to mark notifications as, Defaults to read. (optional)
     * @return List&lt;NotificationThread&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<NotificationThread> notifyReadList(OffsetDateTime lastReadAt, String all, List<String> statusTypes, String toStatus) throws ApiException {
        ApiResponse<List<NotificationThread>> resp = notifyReadListWithHttpInfo(lastReadAt, all, statusTypes, toStatus);
        return resp.getData();
    }

    /**
     * Mark notification threads as read, pinned or unread
     * 
     * @param lastReadAt Describes the last point that notifications were checked. Anything updated since this time will not be updated. (optional)
     * @param all If true, mark all notifications on this repo. Default value is false (optional)
     * @param statusTypes Mark notifications with the provided status types. Options are: unread, read and/or pinned. Defaults to unread. (optional)
     * @param toStatus Status to mark notifications as, Defaults to read. (optional)
     * @return ApiResponse&lt;List&lt;NotificationThread&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<NotificationThread>> notifyReadListWithHttpInfo(OffsetDateTime lastReadAt, String all, List<String> statusTypes, String toStatus) throws ApiException {
        com.squareup.okhttp.Call call = notifyReadListValidateBeforeCall(lastReadAt, all, statusTypes, toStatus, null, null);
        Type localVarReturnType = new TypeToken<List<NotificationThread>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Mark notification threads as read, pinned or unread (asynchronously)
     * 
     * @param lastReadAt Describes the last point that notifications were checked. Anything updated since this time will not be updated. (optional)
     * @param all If true, mark all notifications on this repo. Default value is false (optional)
     * @param statusTypes Mark notifications with the provided status types. Options are: unread, read and/or pinned. Defaults to unread. (optional)
     * @param toStatus Status to mark notifications as, Defaults to read. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call notifyReadListAsync(OffsetDateTime lastReadAt, String all, List<String> statusTypes, String toStatus, final ApiCallback<List<NotificationThread>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = notifyReadListValidateBeforeCall(lastReadAt, all, statusTypes, toStatus, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<NotificationThread>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for notifyReadRepoList
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param all If true, mark all notifications on this repo. Default value is false (optional)
     * @param statusTypes Mark notifications with the provided status types. Options are: unread, read and/or pinned. Defaults to unread. (optional)
     * @param toStatus Status to mark notifications as. Defaults to read. (optional)
     * @param lastReadAt Describes the last point that notifications were checked. Anything updated since this time will not be updated. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call notifyReadRepoListCall(String owner, String repo, String all, List<String> statusTypes, String toStatus, OffsetDateTime lastReadAt, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/notifications"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (all != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("all", all));
        if (statusTypes != null)
        localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("multi", "status-types", statusTypes));
        if (toStatus != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("to-status", toStatus));
        if (lastReadAt != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("last_read_at", lastReadAt));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call notifyReadRepoListValidateBeforeCall(String owner, String repo, String all, List<String> statusTypes, String toStatus, OffsetDateTime lastReadAt, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling notifyReadRepoList(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling notifyReadRepoList(Async)");
        }
        

        com.squareup.okhttp.Call call = notifyReadRepoListCall(owner, repo, all, statusTypes, toStatus, lastReadAt, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Mark notification threads as read, pinned or unread on a specific repo
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param all If true, mark all notifications on this repo. Default value is false (optional)
     * @param statusTypes Mark notifications with the provided status types. Options are: unread, read and/or pinned. Defaults to unread. (optional)
     * @param toStatus Status to mark notifications as. Defaults to read. (optional)
     * @param lastReadAt Describes the last point that notifications were checked. Anything updated since this time will not be updated. (optional)
     * @return List&lt;NotificationThread&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<NotificationThread> notifyReadRepoList(String owner, String repo, String all, List<String> statusTypes, String toStatus, OffsetDateTime lastReadAt) throws ApiException {
        ApiResponse<List<NotificationThread>> resp = notifyReadRepoListWithHttpInfo(owner, repo, all, statusTypes, toStatus, lastReadAt);
        return resp.getData();
    }

    /**
     * Mark notification threads as read, pinned or unread on a specific repo
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param all If true, mark all notifications on this repo. Default value is false (optional)
     * @param statusTypes Mark notifications with the provided status types. Options are: unread, read and/or pinned. Defaults to unread. (optional)
     * @param toStatus Status to mark notifications as. Defaults to read. (optional)
     * @param lastReadAt Describes the last point that notifications were checked. Anything updated since this time will not be updated. (optional)
     * @return ApiResponse&lt;List&lt;NotificationThread&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<NotificationThread>> notifyReadRepoListWithHttpInfo(String owner, String repo, String all, List<String> statusTypes, String toStatus, OffsetDateTime lastReadAt) throws ApiException {
        com.squareup.okhttp.Call call = notifyReadRepoListValidateBeforeCall(owner, repo, all, statusTypes, toStatus, lastReadAt, null, null);
        Type localVarReturnType = new TypeToken<List<NotificationThread>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Mark notification threads as read, pinned or unread on a specific repo (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param all If true, mark all notifications on this repo. Default value is false (optional)
     * @param statusTypes Mark notifications with the provided status types. Options are: unread, read and/or pinned. Defaults to unread. (optional)
     * @param toStatus Status to mark notifications as. Defaults to read. (optional)
     * @param lastReadAt Describes the last point that notifications were checked. Anything updated since this time will not be updated. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call notifyReadRepoListAsync(String owner, String repo, String all, List<String> statusTypes, String toStatus, OffsetDateTime lastReadAt, final ApiCallback<List<NotificationThread>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = notifyReadRepoListValidateBeforeCall(owner, repo, all, statusTypes, toStatus, lastReadAt, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<NotificationThread>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for notifyReadThread
     * @param id id of notification thread (required)
     * @param toStatus Status to mark notifications as (optional, default to read)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call notifyReadThreadCall(String id, String toStatus, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/notifications/threads/{id}"
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (toStatus != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("to-status", toStatus));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call notifyReadThreadValidateBeforeCall(String id, String toStatus, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling notifyReadThread(Async)");
        }
        

        com.squareup.okhttp.Call call = notifyReadThreadCall(id, toStatus, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Mark notification thread as read by ID
     * 
     * @param id id of notification thread (required)
     * @param toStatus Status to mark notifications as (optional, default to read)
     * @return NotificationThread
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public NotificationThread notifyReadThread(String id, String toStatus) throws ApiException {
        ApiResponse<NotificationThread> resp = notifyReadThreadWithHttpInfo(id, toStatus);
        return resp.getData();
    }

    /**
     * Mark notification thread as read by ID
     * 
     * @param id id of notification thread (required)
     * @param toStatus Status to mark notifications as (optional, default to read)
     * @return ApiResponse&lt;NotificationThread&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<NotificationThread> notifyReadThreadWithHttpInfo(String id, String toStatus) throws ApiException {
        com.squareup.okhttp.Call call = notifyReadThreadValidateBeforeCall(id, toStatus, null, null);
        Type localVarReturnType = new TypeToken<NotificationThread>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Mark notification thread as read by ID (asynchronously)
     * 
     * @param id id of notification thread (required)
     * @param toStatus Status to mark notifications as (optional, default to read)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call notifyReadThreadAsync(String id, String toStatus, final ApiCallback<NotificationThread> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = notifyReadThreadValidateBeforeCall(id, toStatus, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<NotificationThread>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
