/*
 * Gitea API.
 * This documentation describes the Gitea API.
 *
 * OpenAPI spec version: 1.18.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.gitea.api;

import io.gitea.ApiCallback;
import io.gitea.ApiClient;
import io.gitea.ApiException;
import io.gitea.ApiResponse;
import io.gitea.Configuration;
import io.gitea.Pair;
import io.gitea.ProgressRequestBody;
import io.gitea.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import io.gitea.model.AddTimeOption;
import io.gitea.model.Comment;
import io.gitea.model.CreateIssueCommentOption;
import io.gitea.model.CreateIssueOption;
import io.gitea.model.CreateLabelOption;
import io.gitea.model.CreateMilestoneOption;
import io.gitea.model.EditDeadlineOption;
import io.gitea.model.EditIssueCommentOption;
import io.gitea.model.EditIssueOption;
import io.gitea.model.EditLabelOption;
import io.gitea.model.EditMilestoneOption;
import io.gitea.model.EditReactionOption;
import io.gitea.model.Issue;
import io.gitea.model.IssueDeadline;
import io.gitea.model.IssueLabelsOption;
import io.gitea.model.Label;
import io.gitea.model.Milestone;
import org.threeten.bp.OffsetDateTime;
import io.gitea.model.Reaction;
import io.gitea.model.TimelineComment;
import io.gitea.model.TrackedTime;
import io.gitea.model.User;
import io.gitea.model.WatchInfo;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IssueApi {
    private ApiClient apiClient;

    public IssueApi() {
        this(Configuration.getDefaultApiClient());
    }

    public IssueApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for issueAddLabel
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issueAddLabelCall(String owner, String repo, Long index, IssueLabelsOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/labels"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueAddLabelValidateBeforeCall(String owner, String repo, Long index, IssueLabelsOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueAddLabel(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueAddLabel(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueAddLabel(Async)");
        }
        

        com.squareup.okhttp.Call call = issueAddLabelCall(owner, repo, index, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Add a label to an issue
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param body  (optional)
     * @return List&lt;Label&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<Label> issueAddLabel(String owner, String repo, Long index, IssueLabelsOption body) throws ApiException {
        ApiResponse<List<Label>> resp = issueAddLabelWithHttpInfo(owner, repo, index, body);
        return resp.getData();
    }

    /**
     * Add a label to an issue
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param body  (optional)
     * @return ApiResponse&lt;List&lt;Label&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<Label>> issueAddLabelWithHttpInfo(String owner, String repo, Long index, IssueLabelsOption body) throws ApiException {
        com.squareup.okhttp.Call call = issueAddLabelValidateBeforeCall(owner, repo, index, body, null, null);
        Type localVarReturnType = new TypeToken<List<Label>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Add a label to an issue (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issueAddLabelAsync(String owner, String repo, Long index, IssueLabelsOption body, final ApiCallback<List<Label>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueAddLabelValidateBeforeCall(owner, repo, index, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Label>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for issueAddSubscription
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param user user to subscribe (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issueAddSubscriptionCall(String owner, String repo, Long index, String user, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/subscriptions/{user}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()))
            .replaceAll("\\{" + "user" + "\\}", apiClient.escapeString(user.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueAddSubscriptionValidateBeforeCall(String owner, String repo, Long index, String user, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueAddSubscription(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueAddSubscription(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueAddSubscription(Async)");
        }
        
        // verify the required parameter 'user' is set
        if (user == null) {
            throw new ApiException("Missing the required parameter 'user' when calling issueAddSubscription(Async)");
        }
        

        com.squareup.okhttp.Call call = issueAddSubscriptionCall(owner, repo, index, user, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Subscribe user to issue
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param user user to subscribe (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void issueAddSubscription(String owner, String repo, Long index, String user) throws ApiException {
        issueAddSubscriptionWithHttpInfo(owner, repo, index, user);
    }

    /**
     * Subscribe user to issue
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param user user to subscribe (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> issueAddSubscriptionWithHttpInfo(String owner, String repo, Long index, String user) throws ApiException {
        com.squareup.okhttp.Call call = issueAddSubscriptionValidateBeforeCall(owner, repo, index, user, null, null);
        return apiClient.execute(call);
    }

    /**
     * Subscribe user to issue (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param user user to subscribe (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issueAddSubscriptionAsync(String owner, String repo, Long index, String user, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueAddSubscriptionValidateBeforeCall(owner, repo, index, user, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for issueAddTime
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issueAddTimeCall(String owner, String repo, Long index, AddTimeOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/times"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueAddTimeValidateBeforeCall(String owner, String repo, Long index, AddTimeOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueAddTime(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueAddTime(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueAddTime(Async)");
        }
        

        com.squareup.okhttp.Call call = issueAddTimeCall(owner, repo, index, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Add tracked time to a issue
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param body  (optional)
     * @return TrackedTime
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public TrackedTime issueAddTime(String owner, String repo, Long index, AddTimeOption body) throws ApiException {
        ApiResponse<TrackedTime> resp = issueAddTimeWithHttpInfo(owner, repo, index, body);
        return resp.getData();
    }

    /**
     * Add tracked time to a issue
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param body  (optional)
     * @return ApiResponse&lt;TrackedTime&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<TrackedTime> issueAddTimeWithHttpInfo(String owner, String repo, Long index, AddTimeOption body) throws ApiException {
        com.squareup.okhttp.Call call = issueAddTimeValidateBeforeCall(owner, repo, index, body, null, null);
        Type localVarReturnType = new TypeToken<TrackedTime>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Add tracked time to a issue (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issueAddTimeAsync(String owner, String repo, Long index, AddTimeOption body, final ApiCallback<TrackedTime> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueAddTimeValidateBeforeCall(owner, repo, index, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TrackedTime>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for issueCheckSubscription
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issueCheckSubscriptionCall(String owner, String repo, Long index, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/subscriptions/check"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueCheckSubscriptionValidateBeforeCall(String owner, String repo, Long index, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueCheckSubscription(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueCheckSubscription(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueCheckSubscription(Async)");
        }
        

        com.squareup.okhttp.Call call = issueCheckSubscriptionCall(owner, repo, index, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Check if user is subscribed to an issue
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @return WatchInfo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public WatchInfo issueCheckSubscription(String owner, String repo, Long index) throws ApiException {
        ApiResponse<WatchInfo> resp = issueCheckSubscriptionWithHttpInfo(owner, repo, index);
        return resp.getData();
    }

    /**
     * Check if user is subscribed to an issue
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @return ApiResponse&lt;WatchInfo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<WatchInfo> issueCheckSubscriptionWithHttpInfo(String owner, String repo, Long index) throws ApiException {
        com.squareup.okhttp.Call call = issueCheckSubscriptionValidateBeforeCall(owner, repo, index, null, null);
        Type localVarReturnType = new TypeToken<WatchInfo>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Check if user is subscribed to an issue (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issueCheckSubscriptionAsync(String owner, String repo, Long index, final ApiCallback<WatchInfo> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueCheckSubscriptionValidateBeforeCall(owner, repo, index, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WatchInfo>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for issueClearLabels
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issueClearLabelsCall(String owner, String repo, Long index, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/labels"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueClearLabelsValidateBeforeCall(String owner, String repo, Long index, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueClearLabels(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueClearLabels(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueClearLabels(Async)");
        }
        

        com.squareup.okhttp.Call call = issueClearLabelsCall(owner, repo, index, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Remove all labels from an issue
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void issueClearLabels(String owner, String repo, Long index) throws ApiException {
        issueClearLabelsWithHttpInfo(owner, repo, index);
    }

    /**
     * Remove all labels from an issue
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> issueClearLabelsWithHttpInfo(String owner, String repo, Long index) throws ApiException {
        com.squareup.okhttp.Call call = issueClearLabelsValidateBeforeCall(owner, repo, index, null, null);
        return apiClient.execute(call);
    }

    /**
     * Remove all labels from an issue (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issueClearLabelsAsync(String owner, String repo, Long index, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueClearLabelsValidateBeforeCall(owner, repo, index, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for issueCreateComment
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issueCreateCommentCall(String owner, String repo, Long index, CreateIssueCommentOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/comments"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueCreateCommentValidateBeforeCall(String owner, String repo, Long index, CreateIssueCommentOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueCreateComment(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueCreateComment(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueCreateComment(Async)");
        }
        

        com.squareup.okhttp.Call call = issueCreateCommentCall(owner, repo, index, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Add a comment to an issue
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param body  (optional)
     * @return Comment
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Comment issueCreateComment(String owner, String repo, Long index, CreateIssueCommentOption body) throws ApiException {
        ApiResponse<Comment> resp = issueCreateCommentWithHttpInfo(owner, repo, index, body);
        return resp.getData();
    }

    /**
     * Add a comment to an issue
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param body  (optional)
     * @return ApiResponse&lt;Comment&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Comment> issueCreateCommentWithHttpInfo(String owner, String repo, Long index, CreateIssueCommentOption body) throws ApiException {
        com.squareup.okhttp.Call call = issueCreateCommentValidateBeforeCall(owner, repo, index, body, null, null);
        Type localVarReturnType = new TypeToken<Comment>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Add a comment to an issue (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issueCreateCommentAsync(String owner, String repo, Long index, CreateIssueCommentOption body, final ApiCallback<Comment> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueCreateCommentValidateBeforeCall(owner, repo, index, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Comment>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for issueCreateIssue
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issueCreateIssueCall(String owner, String repo, CreateIssueOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/issues"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueCreateIssueValidateBeforeCall(String owner, String repo, CreateIssueOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueCreateIssue(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueCreateIssue(Async)");
        }
        

        com.squareup.okhttp.Call call = issueCreateIssueCall(owner, repo, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Create an issue. If using deadline only the date will be taken into account, and time of day ignored.
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @return Issue
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Issue issueCreateIssue(String owner, String repo, CreateIssueOption body) throws ApiException {
        ApiResponse<Issue> resp = issueCreateIssueWithHttpInfo(owner, repo, body);
        return resp.getData();
    }

    /**
     * Create an issue. If using deadline only the date will be taken into account, and time of day ignored.
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @return ApiResponse&lt;Issue&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Issue> issueCreateIssueWithHttpInfo(String owner, String repo, CreateIssueOption body) throws ApiException {
        com.squareup.okhttp.Call call = issueCreateIssueValidateBeforeCall(owner, repo, body, null, null);
        Type localVarReturnType = new TypeToken<Issue>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Create an issue. If using deadline only the date will be taken into account, and time of day ignored. (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issueCreateIssueAsync(String owner, String repo, CreateIssueOption body, final ApiCallback<Issue> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueCreateIssueValidateBeforeCall(owner, repo, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Issue>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for issueCreateLabel
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issueCreateLabelCall(String owner, String repo, CreateLabelOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/labels"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueCreateLabelValidateBeforeCall(String owner, String repo, CreateLabelOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueCreateLabel(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueCreateLabel(Async)");
        }
        

        com.squareup.okhttp.Call call = issueCreateLabelCall(owner, repo, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Create a label
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @return Label
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Label issueCreateLabel(String owner, String repo, CreateLabelOption body) throws ApiException {
        ApiResponse<Label> resp = issueCreateLabelWithHttpInfo(owner, repo, body);
        return resp.getData();
    }

    /**
     * Create a label
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @return ApiResponse&lt;Label&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Label> issueCreateLabelWithHttpInfo(String owner, String repo, CreateLabelOption body) throws ApiException {
        com.squareup.okhttp.Call call = issueCreateLabelValidateBeforeCall(owner, repo, body, null, null);
        Type localVarReturnType = new TypeToken<Label>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Create a label (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issueCreateLabelAsync(String owner, String repo, CreateLabelOption body, final ApiCallback<Label> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueCreateLabelValidateBeforeCall(owner, repo, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Label>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for issueCreateMilestone
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issueCreateMilestoneCall(String owner, String repo, CreateMilestoneOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/milestones"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueCreateMilestoneValidateBeforeCall(String owner, String repo, CreateMilestoneOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueCreateMilestone(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueCreateMilestone(Async)");
        }
        

        com.squareup.okhttp.Call call = issueCreateMilestoneCall(owner, repo, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Create a milestone
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @return Milestone
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Milestone issueCreateMilestone(String owner, String repo, CreateMilestoneOption body) throws ApiException {
        ApiResponse<Milestone> resp = issueCreateMilestoneWithHttpInfo(owner, repo, body);
        return resp.getData();
    }

    /**
     * Create a milestone
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @return ApiResponse&lt;Milestone&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Milestone> issueCreateMilestoneWithHttpInfo(String owner, String repo, CreateMilestoneOption body) throws ApiException {
        com.squareup.okhttp.Call call = issueCreateMilestoneValidateBeforeCall(owner, repo, body, null, null);
        Type localVarReturnType = new TypeToken<Milestone>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Create a milestone (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issueCreateMilestoneAsync(String owner, String repo, CreateMilestoneOption body, final ApiCallback<Milestone> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueCreateMilestoneValidateBeforeCall(owner, repo, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Milestone>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for issueDelete
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of issue to delete (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issueDeleteCall(String owner, String repo, Long index, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/html"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueDeleteValidateBeforeCall(String owner, String repo, Long index, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueDelete(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueDelete(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueDelete(Async)");
        }
        

        com.squareup.okhttp.Call call = issueDeleteCall(owner, repo, index, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete an issue
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of issue to delete (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void issueDelete(String owner, String repo, Long index) throws ApiException {
        issueDeleteWithHttpInfo(owner, repo, index);
    }

    /**
     * Delete an issue
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of issue to delete (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> issueDeleteWithHttpInfo(String owner, String repo, Long index) throws ApiException {
        com.squareup.okhttp.Call call = issueDeleteValidateBeforeCall(owner, repo, index, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete an issue (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of issue to delete (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issueDeleteAsync(String owner, String repo, Long index, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueDeleteValidateBeforeCall(owner, repo, index, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for issueDeleteComment
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of comment to delete (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issueDeleteCommentCall(String owner, String repo, Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/issues/comments/{id}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/html"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueDeleteCommentValidateBeforeCall(String owner, String repo, Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueDeleteComment(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueDeleteComment(Async)");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling issueDeleteComment(Async)");
        }
        

        com.squareup.okhttp.Call call = issueDeleteCommentCall(owner, repo, id, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete a comment
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of comment to delete (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void issueDeleteComment(String owner, String repo, Long id) throws ApiException {
        issueDeleteCommentWithHttpInfo(owner, repo, id);
    }

    /**
     * Delete a comment
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of comment to delete (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> issueDeleteCommentWithHttpInfo(String owner, String repo, Long id) throws ApiException {
        com.squareup.okhttp.Call call = issueDeleteCommentValidateBeforeCall(owner, repo, id, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete a comment (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of comment to delete (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issueDeleteCommentAsync(String owner, String repo, Long id, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueDeleteCommentValidateBeforeCall(owner, repo, id, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for issueDeleteCommentDeprecated
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index this parameter is ignored (required)
     * @param id id of comment to delete (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @deprecated
     */
    @Deprecated
    public com.squareup.okhttp.Call issueDeleteCommentDeprecatedCall(String owner, String repo, Integer index, Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/comments/{id}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()))
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/html"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @Deprecated
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueDeleteCommentDeprecatedValidateBeforeCall(String owner, String repo, Integer index, Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueDeleteCommentDeprecated(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueDeleteCommentDeprecated(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueDeleteCommentDeprecated(Async)");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling issueDeleteCommentDeprecated(Async)");
        }
        

        com.squareup.okhttp.Call call = issueDeleteCommentDeprecatedCall(owner, repo, index, id, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete a comment
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index this parameter is ignored (required)
     * @param id id of comment to delete (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @deprecated
     */
    @Deprecated
    public void issueDeleteCommentDeprecated(String owner, String repo, Integer index, Long id) throws ApiException {
        issueDeleteCommentDeprecatedWithHttpInfo(owner, repo, index, id);
    }

    /**
     * Delete a comment
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index this parameter is ignored (required)
     * @param id id of comment to delete (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @deprecated
     */
    @Deprecated
    public ApiResponse<Void> issueDeleteCommentDeprecatedWithHttpInfo(String owner, String repo, Integer index, Long id) throws ApiException {
        com.squareup.okhttp.Call call = issueDeleteCommentDeprecatedValidateBeforeCall(owner, repo, index, id, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete a comment (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index this parameter is ignored (required)
     * @param id id of comment to delete (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @deprecated
     */
    @Deprecated
    public com.squareup.okhttp.Call issueDeleteCommentDeprecatedAsync(String owner, String repo, Integer index, Long id, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueDeleteCommentDeprecatedValidateBeforeCall(owner, repo, index, id, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for issueDeleteCommentReaction
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the comment to edit (required)
     * @param content  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issueDeleteCommentReactionCall(String owner, String repo, Long id, EditReactionOption content, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = content;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/issues/comments/{id}/reactions"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueDeleteCommentReactionValidateBeforeCall(String owner, String repo, Long id, EditReactionOption content, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueDeleteCommentReaction(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueDeleteCommentReaction(Async)");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling issueDeleteCommentReaction(Async)");
        }
        

        com.squareup.okhttp.Call call = issueDeleteCommentReactionCall(owner, repo, id, content, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Remove a reaction from a comment of an issue
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the comment to edit (required)
     * @param content  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void issueDeleteCommentReaction(String owner, String repo, Long id, EditReactionOption content) throws ApiException {
        issueDeleteCommentReactionWithHttpInfo(owner, repo, id, content);
    }

    /**
     * Remove a reaction from a comment of an issue
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the comment to edit (required)
     * @param content  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> issueDeleteCommentReactionWithHttpInfo(String owner, String repo, Long id, EditReactionOption content) throws ApiException {
        com.squareup.okhttp.Call call = issueDeleteCommentReactionValidateBeforeCall(owner, repo, id, content, null, null);
        return apiClient.execute(call);
    }

    /**
     * Remove a reaction from a comment of an issue (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the comment to edit (required)
     * @param content  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issueDeleteCommentReactionAsync(String owner, String repo, Long id, EditReactionOption content, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueDeleteCommentReactionValidateBeforeCall(owner, repo, id, content, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for issueDeleteIssueReaction
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param content  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issueDeleteIssueReactionCall(String owner, String repo, Long index, EditReactionOption content, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = content;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/reactions"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueDeleteIssueReactionValidateBeforeCall(String owner, String repo, Long index, EditReactionOption content, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueDeleteIssueReaction(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueDeleteIssueReaction(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueDeleteIssueReaction(Async)");
        }
        

        com.squareup.okhttp.Call call = issueDeleteIssueReactionCall(owner, repo, index, content, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Remove a reaction from an issue
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param content  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void issueDeleteIssueReaction(String owner, String repo, Long index, EditReactionOption content) throws ApiException {
        issueDeleteIssueReactionWithHttpInfo(owner, repo, index, content);
    }

    /**
     * Remove a reaction from an issue
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param content  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> issueDeleteIssueReactionWithHttpInfo(String owner, String repo, Long index, EditReactionOption content) throws ApiException {
        com.squareup.okhttp.Call call = issueDeleteIssueReactionValidateBeforeCall(owner, repo, index, content, null, null);
        return apiClient.execute(call);
    }

    /**
     * Remove a reaction from an issue (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param content  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issueDeleteIssueReactionAsync(String owner, String repo, Long index, EditReactionOption content, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueDeleteIssueReactionValidateBeforeCall(owner, repo, index, content, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for issueDeleteLabel
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the label to delete (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issueDeleteLabelCall(String owner, String repo, Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/labels/{id}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/html"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueDeleteLabelValidateBeforeCall(String owner, String repo, Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueDeleteLabel(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueDeleteLabel(Async)");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling issueDeleteLabel(Async)");
        }
        

        com.squareup.okhttp.Call call = issueDeleteLabelCall(owner, repo, id, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete a label
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the label to delete (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void issueDeleteLabel(String owner, String repo, Long id) throws ApiException {
        issueDeleteLabelWithHttpInfo(owner, repo, id);
    }

    /**
     * Delete a label
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the label to delete (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> issueDeleteLabelWithHttpInfo(String owner, String repo, Long id) throws ApiException {
        com.squareup.okhttp.Call call = issueDeleteLabelValidateBeforeCall(owner, repo, id, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete a label (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the label to delete (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issueDeleteLabelAsync(String owner, String repo, Long id, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueDeleteLabelValidateBeforeCall(owner, repo, id, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for issueDeleteMilestone
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id the milestone to delete, identified by ID and if not available by name (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issueDeleteMilestoneCall(String owner, String repo, String id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/milestones/{id}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/html"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueDeleteMilestoneValidateBeforeCall(String owner, String repo, String id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueDeleteMilestone(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueDeleteMilestone(Async)");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling issueDeleteMilestone(Async)");
        }
        

        com.squareup.okhttp.Call call = issueDeleteMilestoneCall(owner, repo, id, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete a milestone
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id the milestone to delete, identified by ID and if not available by name (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void issueDeleteMilestone(String owner, String repo, String id) throws ApiException {
        issueDeleteMilestoneWithHttpInfo(owner, repo, id);
    }

    /**
     * Delete a milestone
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id the milestone to delete, identified by ID and if not available by name (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> issueDeleteMilestoneWithHttpInfo(String owner, String repo, String id) throws ApiException {
        com.squareup.okhttp.Call call = issueDeleteMilestoneValidateBeforeCall(owner, repo, id, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete a milestone (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id the milestone to delete, identified by ID and if not available by name (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issueDeleteMilestoneAsync(String owner, String repo, String id, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueDeleteMilestoneValidateBeforeCall(owner, repo, id, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for issueDeleteStopWatch
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue to stop the stopwatch on (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issueDeleteStopWatchCall(String owner, String repo, Long index, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/stopwatch/delete"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueDeleteStopWatchValidateBeforeCall(String owner, String repo, Long index, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueDeleteStopWatch(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueDeleteStopWatch(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueDeleteStopWatch(Async)");
        }
        

        com.squareup.okhttp.Call call = issueDeleteStopWatchCall(owner, repo, index, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete an issue&#39;s existing stopwatch.
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue to stop the stopwatch on (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void issueDeleteStopWatch(String owner, String repo, Long index) throws ApiException {
        issueDeleteStopWatchWithHttpInfo(owner, repo, index);
    }

    /**
     * Delete an issue&#39;s existing stopwatch.
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue to stop the stopwatch on (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> issueDeleteStopWatchWithHttpInfo(String owner, String repo, Long index) throws ApiException {
        com.squareup.okhttp.Call call = issueDeleteStopWatchValidateBeforeCall(owner, repo, index, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete an issue&#39;s existing stopwatch. (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue to stop the stopwatch on (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issueDeleteStopWatchAsync(String owner, String repo, Long index, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueDeleteStopWatchValidateBeforeCall(owner, repo, index, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for issueDeleteSubscription
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param user user witch unsubscribe (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issueDeleteSubscriptionCall(String owner, String repo, Long index, String user, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/subscriptions/{user}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()))
            .replaceAll("\\{" + "user" + "\\}", apiClient.escapeString(user.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueDeleteSubscriptionValidateBeforeCall(String owner, String repo, Long index, String user, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueDeleteSubscription(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueDeleteSubscription(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueDeleteSubscription(Async)");
        }
        
        // verify the required parameter 'user' is set
        if (user == null) {
            throw new ApiException("Missing the required parameter 'user' when calling issueDeleteSubscription(Async)");
        }
        

        com.squareup.okhttp.Call call = issueDeleteSubscriptionCall(owner, repo, index, user, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Unsubscribe user from issue
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param user user witch unsubscribe (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void issueDeleteSubscription(String owner, String repo, Long index, String user) throws ApiException {
        issueDeleteSubscriptionWithHttpInfo(owner, repo, index, user);
    }

    /**
     * Unsubscribe user from issue
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param user user witch unsubscribe (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> issueDeleteSubscriptionWithHttpInfo(String owner, String repo, Long index, String user) throws ApiException {
        com.squareup.okhttp.Call call = issueDeleteSubscriptionValidateBeforeCall(owner, repo, index, user, null, null);
        return apiClient.execute(call);
    }

    /**
     * Unsubscribe user from issue (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param user user witch unsubscribe (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issueDeleteSubscriptionAsync(String owner, String repo, Long index, String user, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueDeleteSubscriptionValidateBeforeCall(owner, repo, index, user, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for issueDeleteTime
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param id id of time to delete (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issueDeleteTimeCall(String owner, String repo, Long index, Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/times/{id}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()))
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueDeleteTimeValidateBeforeCall(String owner, String repo, Long index, Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueDeleteTime(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueDeleteTime(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueDeleteTime(Async)");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling issueDeleteTime(Async)");
        }
        

        com.squareup.okhttp.Call call = issueDeleteTimeCall(owner, repo, index, id, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete specific tracked time
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param id id of time to delete (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void issueDeleteTime(String owner, String repo, Long index, Long id) throws ApiException {
        issueDeleteTimeWithHttpInfo(owner, repo, index, id);
    }

    /**
     * Delete specific tracked time
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param id id of time to delete (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> issueDeleteTimeWithHttpInfo(String owner, String repo, Long index, Long id) throws ApiException {
        com.squareup.okhttp.Call call = issueDeleteTimeValidateBeforeCall(owner, repo, index, id, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete specific tracked time (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param id id of time to delete (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issueDeleteTimeAsync(String owner, String repo, Long index, Long id, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueDeleteTimeValidateBeforeCall(owner, repo, index, id, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for issueEditComment
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the comment to edit (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issueEditCommentCall(String owner, String repo, Long id, EditIssueCommentOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/issues/comments/{id}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueEditCommentValidateBeforeCall(String owner, String repo, Long id, EditIssueCommentOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueEditComment(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueEditComment(Async)");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling issueEditComment(Async)");
        }
        

        com.squareup.okhttp.Call call = issueEditCommentCall(owner, repo, id, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Edit a comment
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the comment to edit (required)
     * @param body  (optional)
     * @return Comment
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Comment issueEditComment(String owner, String repo, Long id, EditIssueCommentOption body) throws ApiException {
        ApiResponse<Comment> resp = issueEditCommentWithHttpInfo(owner, repo, id, body);
        return resp.getData();
    }

    /**
     * Edit a comment
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the comment to edit (required)
     * @param body  (optional)
     * @return ApiResponse&lt;Comment&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Comment> issueEditCommentWithHttpInfo(String owner, String repo, Long id, EditIssueCommentOption body) throws ApiException {
        com.squareup.okhttp.Call call = issueEditCommentValidateBeforeCall(owner, repo, id, body, null, null);
        Type localVarReturnType = new TypeToken<Comment>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Edit a comment (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the comment to edit (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issueEditCommentAsync(String owner, String repo, Long id, EditIssueCommentOption body, final ApiCallback<Comment> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueEditCommentValidateBeforeCall(owner, repo, id, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Comment>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for issueEditCommentDeprecated
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index this parameter is ignored (required)
     * @param id id of the comment to edit (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @deprecated
     */
    @Deprecated
    public com.squareup.okhttp.Call issueEditCommentDeprecatedCall(String owner, String repo, Integer index, Long id, EditIssueCommentOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/comments/{id}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()))
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @Deprecated
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueEditCommentDeprecatedValidateBeforeCall(String owner, String repo, Integer index, Long id, EditIssueCommentOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueEditCommentDeprecated(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueEditCommentDeprecated(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueEditCommentDeprecated(Async)");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling issueEditCommentDeprecated(Async)");
        }
        

        com.squareup.okhttp.Call call = issueEditCommentDeprecatedCall(owner, repo, index, id, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Edit a comment
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index this parameter is ignored (required)
     * @param id id of the comment to edit (required)
     * @param body  (optional)
     * @return Comment
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @deprecated
     */
    @Deprecated
    public Comment issueEditCommentDeprecated(String owner, String repo, Integer index, Long id, EditIssueCommentOption body) throws ApiException {
        ApiResponse<Comment> resp = issueEditCommentDeprecatedWithHttpInfo(owner, repo, index, id, body);
        return resp.getData();
    }

    /**
     * Edit a comment
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index this parameter is ignored (required)
     * @param id id of the comment to edit (required)
     * @param body  (optional)
     * @return ApiResponse&lt;Comment&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @deprecated
     */
    @Deprecated
    public ApiResponse<Comment> issueEditCommentDeprecatedWithHttpInfo(String owner, String repo, Integer index, Long id, EditIssueCommentOption body) throws ApiException {
        com.squareup.okhttp.Call call = issueEditCommentDeprecatedValidateBeforeCall(owner, repo, index, id, body, null, null);
        Type localVarReturnType = new TypeToken<Comment>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Edit a comment (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index this parameter is ignored (required)
     * @param id id of the comment to edit (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @deprecated
     */
    @Deprecated
    public com.squareup.okhttp.Call issueEditCommentDeprecatedAsync(String owner, String repo, Integer index, Long id, EditIssueCommentOption body, final ApiCallback<Comment> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueEditCommentDeprecatedValidateBeforeCall(owner, repo, index, id, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Comment>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for issueEditIssue
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue to edit (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issueEditIssueCall(String owner, String repo, Long index, EditIssueOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueEditIssueValidateBeforeCall(String owner, String repo, Long index, EditIssueOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueEditIssue(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueEditIssue(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueEditIssue(Async)");
        }
        

        com.squareup.okhttp.Call call = issueEditIssueCall(owner, repo, index, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Edit an issue. If using deadline only the date will be taken into account, and time of day ignored.
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue to edit (required)
     * @param body  (optional)
     * @return Issue
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Issue issueEditIssue(String owner, String repo, Long index, EditIssueOption body) throws ApiException {
        ApiResponse<Issue> resp = issueEditIssueWithHttpInfo(owner, repo, index, body);
        return resp.getData();
    }

    /**
     * Edit an issue. If using deadline only the date will be taken into account, and time of day ignored.
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue to edit (required)
     * @param body  (optional)
     * @return ApiResponse&lt;Issue&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Issue> issueEditIssueWithHttpInfo(String owner, String repo, Long index, EditIssueOption body) throws ApiException {
        com.squareup.okhttp.Call call = issueEditIssueValidateBeforeCall(owner, repo, index, body, null, null);
        Type localVarReturnType = new TypeToken<Issue>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Edit an issue. If using deadline only the date will be taken into account, and time of day ignored. (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue to edit (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issueEditIssueAsync(String owner, String repo, Long index, EditIssueOption body, final ApiCallback<Issue> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueEditIssueValidateBeforeCall(owner, repo, index, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Issue>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for issueEditIssueDeadline
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue to create or update a deadline on (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issueEditIssueDeadlineCall(String owner, String repo, Long index, EditDeadlineOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/deadline"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueEditIssueDeadlineValidateBeforeCall(String owner, String repo, Long index, EditDeadlineOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueEditIssueDeadline(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueEditIssueDeadline(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueEditIssueDeadline(Async)");
        }
        

        com.squareup.okhttp.Call call = issueEditIssueDeadlineCall(owner, repo, index, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Set an issue deadline. If set to null, the deadline is deleted. If using deadline only the date will be taken into account, and time of day ignored.
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue to create or update a deadline on (required)
     * @param body  (optional)
     * @return IssueDeadline
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public IssueDeadline issueEditIssueDeadline(String owner, String repo, Long index, EditDeadlineOption body) throws ApiException {
        ApiResponse<IssueDeadline> resp = issueEditIssueDeadlineWithHttpInfo(owner, repo, index, body);
        return resp.getData();
    }

    /**
     * Set an issue deadline. If set to null, the deadline is deleted. If using deadline only the date will be taken into account, and time of day ignored.
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue to create or update a deadline on (required)
     * @param body  (optional)
     * @return ApiResponse&lt;IssueDeadline&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<IssueDeadline> issueEditIssueDeadlineWithHttpInfo(String owner, String repo, Long index, EditDeadlineOption body) throws ApiException {
        com.squareup.okhttp.Call call = issueEditIssueDeadlineValidateBeforeCall(owner, repo, index, body, null, null);
        Type localVarReturnType = new TypeToken<IssueDeadline>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Set an issue deadline. If set to null, the deadline is deleted. If using deadline only the date will be taken into account, and time of day ignored. (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue to create or update a deadline on (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issueEditIssueDeadlineAsync(String owner, String repo, Long index, EditDeadlineOption body, final ApiCallback<IssueDeadline> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueEditIssueDeadlineValidateBeforeCall(owner, repo, index, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<IssueDeadline>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for issueEditLabel
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the label to edit (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issueEditLabelCall(String owner, String repo, Long id, EditLabelOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/labels/{id}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueEditLabelValidateBeforeCall(String owner, String repo, Long id, EditLabelOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueEditLabel(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueEditLabel(Async)");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling issueEditLabel(Async)");
        }
        

        com.squareup.okhttp.Call call = issueEditLabelCall(owner, repo, id, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Update a label
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the label to edit (required)
     * @param body  (optional)
     * @return Label
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Label issueEditLabel(String owner, String repo, Long id, EditLabelOption body) throws ApiException {
        ApiResponse<Label> resp = issueEditLabelWithHttpInfo(owner, repo, id, body);
        return resp.getData();
    }

    /**
     * Update a label
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the label to edit (required)
     * @param body  (optional)
     * @return ApiResponse&lt;Label&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Label> issueEditLabelWithHttpInfo(String owner, String repo, Long id, EditLabelOption body) throws ApiException {
        com.squareup.okhttp.Call call = issueEditLabelValidateBeforeCall(owner, repo, id, body, null, null);
        Type localVarReturnType = new TypeToken<Label>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Update a label (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the label to edit (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issueEditLabelAsync(String owner, String repo, Long id, EditLabelOption body, final ApiCallback<Label> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueEditLabelValidateBeforeCall(owner, repo, id, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Label>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for issueEditMilestone
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id the milestone to edit, identified by ID and if not available by name (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issueEditMilestoneCall(String owner, String repo, String id, EditMilestoneOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/milestones/{id}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueEditMilestoneValidateBeforeCall(String owner, String repo, String id, EditMilestoneOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueEditMilestone(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueEditMilestone(Async)");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling issueEditMilestone(Async)");
        }
        

        com.squareup.okhttp.Call call = issueEditMilestoneCall(owner, repo, id, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Update a milestone
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id the milestone to edit, identified by ID and if not available by name (required)
     * @param body  (optional)
     * @return Milestone
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Milestone issueEditMilestone(String owner, String repo, String id, EditMilestoneOption body) throws ApiException {
        ApiResponse<Milestone> resp = issueEditMilestoneWithHttpInfo(owner, repo, id, body);
        return resp.getData();
    }

    /**
     * Update a milestone
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id the milestone to edit, identified by ID and if not available by name (required)
     * @param body  (optional)
     * @return ApiResponse&lt;Milestone&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Milestone> issueEditMilestoneWithHttpInfo(String owner, String repo, String id, EditMilestoneOption body) throws ApiException {
        com.squareup.okhttp.Call call = issueEditMilestoneValidateBeforeCall(owner, repo, id, body, null, null);
        Type localVarReturnType = new TypeToken<Milestone>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Update a milestone (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id the milestone to edit, identified by ID and if not available by name (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issueEditMilestoneAsync(String owner, String repo, String id, EditMilestoneOption body, final ApiCallback<Milestone> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueEditMilestoneValidateBeforeCall(owner, repo, id, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Milestone>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for issueGetComment
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the comment (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issueGetCommentCall(String owner, String repo, Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/issues/comments/{id}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueGetCommentValidateBeforeCall(String owner, String repo, Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueGetComment(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueGetComment(Async)");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling issueGetComment(Async)");
        }
        

        com.squareup.okhttp.Call call = issueGetCommentCall(owner, repo, id, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get a comment
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the comment (required)
     * @return Comment
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Comment issueGetComment(String owner, String repo, Long id) throws ApiException {
        ApiResponse<Comment> resp = issueGetCommentWithHttpInfo(owner, repo, id);
        return resp.getData();
    }

    /**
     * Get a comment
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the comment (required)
     * @return ApiResponse&lt;Comment&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Comment> issueGetCommentWithHttpInfo(String owner, String repo, Long id) throws ApiException {
        com.squareup.okhttp.Call call = issueGetCommentValidateBeforeCall(owner, repo, id, null, null);
        Type localVarReturnType = new TypeToken<Comment>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get a comment (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the comment (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issueGetCommentAsync(String owner, String repo, Long id, final ApiCallback<Comment> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueGetCommentValidateBeforeCall(owner, repo, id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Comment>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for issueGetCommentReactions
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the comment to edit (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issueGetCommentReactionsCall(String owner, String repo, Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/issues/comments/{id}/reactions"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueGetCommentReactionsValidateBeforeCall(String owner, String repo, Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueGetCommentReactions(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueGetCommentReactions(Async)");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling issueGetCommentReactions(Async)");
        }
        

        com.squareup.okhttp.Call call = issueGetCommentReactionsCall(owner, repo, id, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get a list of reactions from a comment of an issue
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the comment to edit (required)
     * @return List&lt;Reaction&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<Reaction> issueGetCommentReactions(String owner, String repo, Long id) throws ApiException {
        ApiResponse<List<Reaction>> resp = issueGetCommentReactionsWithHttpInfo(owner, repo, id);
        return resp.getData();
    }

    /**
     * Get a list of reactions from a comment of an issue
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the comment to edit (required)
     * @return ApiResponse&lt;List&lt;Reaction&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<Reaction>> issueGetCommentReactionsWithHttpInfo(String owner, String repo, Long id) throws ApiException {
        com.squareup.okhttp.Call call = issueGetCommentReactionsValidateBeforeCall(owner, repo, id, null, null);
        Type localVarReturnType = new TypeToken<List<Reaction>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get a list of reactions from a comment of an issue (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the comment to edit (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issueGetCommentReactionsAsync(String owner, String repo, Long id, final ApiCallback<List<Reaction>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueGetCommentReactionsValidateBeforeCall(owner, repo, id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Reaction>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for issueGetComments
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param since if provided, only comments updated since the specified time are returned. (optional)
     * @param before if provided, only comments updated before the provided time are returned. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issueGetCommentsCall(String owner, String repo, Long index, OffsetDateTime since, OffsetDateTime before, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/comments"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (since != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("since", since));
        if (before != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("before", before));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueGetCommentsValidateBeforeCall(String owner, String repo, Long index, OffsetDateTime since, OffsetDateTime before, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueGetComments(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueGetComments(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueGetComments(Async)");
        }
        

        com.squareup.okhttp.Call call = issueGetCommentsCall(owner, repo, index, since, before, progressListener, progressRequestListener);
        return call;

    }

    /**
     * List all comments on an issue
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param since if provided, only comments updated since the specified time are returned. (optional)
     * @param before if provided, only comments updated before the provided time are returned. (optional)
     * @return List&lt;Comment&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<Comment> issueGetComments(String owner, String repo, Long index, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        ApiResponse<List<Comment>> resp = issueGetCommentsWithHttpInfo(owner, repo, index, since, before);
        return resp.getData();
    }

    /**
     * List all comments on an issue
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param since if provided, only comments updated since the specified time are returned. (optional)
     * @param before if provided, only comments updated before the provided time are returned. (optional)
     * @return ApiResponse&lt;List&lt;Comment&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<Comment>> issueGetCommentsWithHttpInfo(String owner, String repo, Long index, OffsetDateTime since, OffsetDateTime before) throws ApiException {
        com.squareup.okhttp.Call call = issueGetCommentsValidateBeforeCall(owner, repo, index, since, before, null, null);
        Type localVarReturnType = new TypeToken<List<Comment>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * List all comments on an issue (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param since if provided, only comments updated since the specified time are returned. (optional)
     * @param before if provided, only comments updated before the provided time are returned. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issueGetCommentsAsync(String owner, String repo, Long index, OffsetDateTime since, OffsetDateTime before, final ApiCallback<List<Comment>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueGetCommentsValidateBeforeCall(owner, repo, index, since, before, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Comment>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for issueGetCommentsAndTimeline
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param since if provided, only comments updated since the specified time are returned. (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param before if provided, only comments updated before the provided time are returned. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issueGetCommentsAndTimelineCall(String owner, String repo, Long index, OffsetDateTime since, Integer page, Integer limit, OffsetDateTime before, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/timeline"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (since != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("since", since));
        if (page != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
        if (before != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("before", before));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueGetCommentsAndTimelineValidateBeforeCall(String owner, String repo, Long index, OffsetDateTime since, Integer page, Integer limit, OffsetDateTime before, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueGetCommentsAndTimeline(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueGetCommentsAndTimeline(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueGetCommentsAndTimeline(Async)");
        }
        

        com.squareup.okhttp.Call call = issueGetCommentsAndTimelineCall(owner, repo, index, since, page, limit, before, progressListener, progressRequestListener);
        return call;

    }

    /**
     * List all comments and events on an issue
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param since if provided, only comments updated since the specified time are returned. (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param before if provided, only comments updated before the provided time are returned. (optional)
     * @return List&lt;TimelineComment&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<TimelineComment> issueGetCommentsAndTimeline(String owner, String repo, Long index, OffsetDateTime since, Integer page, Integer limit, OffsetDateTime before) throws ApiException {
        ApiResponse<List<TimelineComment>> resp = issueGetCommentsAndTimelineWithHttpInfo(owner, repo, index, since, page, limit, before);
        return resp.getData();
    }

    /**
     * List all comments and events on an issue
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param since if provided, only comments updated since the specified time are returned. (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param before if provided, only comments updated before the provided time are returned. (optional)
     * @return ApiResponse&lt;List&lt;TimelineComment&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<TimelineComment>> issueGetCommentsAndTimelineWithHttpInfo(String owner, String repo, Long index, OffsetDateTime since, Integer page, Integer limit, OffsetDateTime before) throws ApiException {
        com.squareup.okhttp.Call call = issueGetCommentsAndTimelineValidateBeforeCall(owner, repo, index, since, page, limit, before, null, null);
        Type localVarReturnType = new TypeToken<List<TimelineComment>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * List all comments and events on an issue (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param since if provided, only comments updated since the specified time are returned. (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param before if provided, only comments updated before the provided time are returned. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issueGetCommentsAndTimelineAsync(String owner, String repo, Long index, OffsetDateTime since, Integer page, Integer limit, OffsetDateTime before, final ApiCallback<List<TimelineComment>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueGetCommentsAndTimelineValidateBeforeCall(owner, repo, index, since, page, limit, before, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<TimelineComment>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for issueGetIssue
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue to get (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issueGetIssueCall(String owner, String repo, Long index, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueGetIssueValidateBeforeCall(String owner, String repo, Long index, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueGetIssue(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueGetIssue(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueGetIssue(Async)");
        }
        

        com.squareup.okhttp.Call call = issueGetIssueCall(owner, repo, index, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get an issue
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue to get (required)
     * @return Issue
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Issue issueGetIssue(String owner, String repo, Long index) throws ApiException {
        ApiResponse<Issue> resp = issueGetIssueWithHttpInfo(owner, repo, index);
        return resp.getData();
    }

    /**
     * Get an issue
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue to get (required)
     * @return ApiResponse&lt;Issue&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Issue> issueGetIssueWithHttpInfo(String owner, String repo, Long index) throws ApiException {
        com.squareup.okhttp.Call call = issueGetIssueValidateBeforeCall(owner, repo, index, null, null);
        Type localVarReturnType = new TypeToken<Issue>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get an issue (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue to get (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issueGetIssueAsync(String owner, String repo, Long index, final ApiCallback<Issue> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueGetIssueValidateBeforeCall(owner, repo, index, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Issue>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for issueGetIssueReactions
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issueGetIssueReactionsCall(String owner, String repo, Long index, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/reactions"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueGetIssueReactionsValidateBeforeCall(String owner, String repo, Long index, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueGetIssueReactions(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueGetIssueReactions(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueGetIssueReactions(Async)");
        }
        

        com.squareup.okhttp.Call call = issueGetIssueReactionsCall(owner, repo, index, page, limit, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get a list reactions of an issue
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return List&lt;Reaction&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<Reaction> issueGetIssueReactions(String owner, String repo, Long index, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<Reaction>> resp = issueGetIssueReactionsWithHttpInfo(owner, repo, index, page, limit);
        return resp.getData();
    }

    /**
     * Get a list reactions of an issue
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return ApiResponse&lt;List&lt;Reaction&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<Reaction>> issueGetIssueReactionsWithHttpInfo(String owner, String repo, Long index, Integer page, Integer limit) throws ApiException {
        com.squareup.okhttp.Call call = issueGetIssueReactionsValidateBeforeCall(owner, repo, index, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<Reaction>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get a list reactions of an issue (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issueGetIssueReactionsAsync(String owner, String repo, Long index, Integer page, Integer limit, final ApiCallback<List<Reaction>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueGetIssueReactionsValidateBeforeCall(owner, repo, index, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Reaction>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for issueGetLabel
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the label to get (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issueGetLabelCall(String owner, String repo, Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/labels/{id}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueGetLabelValidateBeforeCall(String owner, String repo, Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueGetLabel(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueGetLabel(Async)");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling issueGetLabel(Async)");
        }
        

        com.squareup.okhttp.Call call = issueGetLabelCall(owner, repo, id, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get a single label
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the label to get (required)
     * @return Label
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Label issueGetLabel(String owner, String repo, Long id) throws ApiException {
        ApiResponse<Label> resp = issueGetLabelWithHttpInfo(owner, repo, id);
        return resp.getData();
    }

    /**
     * Get a single label
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the label to get (required)
     * @return ApiResponse&lt;Label&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Label> issueGetLabelWithHttpInfo(String owner, String repo, Long id) throws ApiException {
        com.squareup.okhttp.Call call = issueGetLabelValidateBeforeCall(owner, repo, id, null, null);
        Type localVarReturnType = new TypeToken<Label>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get a single label (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the label to get (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issueGetLabelAsync(String owner, String repo, Long id, final ApiCallback<Label> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueGetLabelValidateBeforeCall(owner, repo, id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Label>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for issueGetLabels
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issueGetLabelsCall(String owner, String repo, Long index, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/labels"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueGetLabelsValidateBeforeCall(String owner, String repo, Long index, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueGetLabels(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueGetLabels(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueGetLabels(Async)");
        }
        

        com.squareup.okhttp.Call call = issueGetLabelsCall(owner, repo, index, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get an issue&#39;s labels
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @return List&lt;Label&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<Label> issueGetLabels(String owner, String repo, Long index) throws ApiException {
        ApiResponse<List<Label>> resp = issueGetLabelsWithHttpInfo(owner, repo, index);
        return resp.getData();
    }

    /**
     * Get an issue&#39;s labels
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @return ApiResponse&lt;List&lt;Label&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<Label>> issueGetLabelsWithHttpInfo(String owner, String repo, Long index) throws ApiException {
        com.squareup.okhttp.Call call = issueGetLabelsValidateBeforeCall(owner, repo, index, null, null);
        Type localVarReturnType = new TypeToken<List<Label>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get an issue&#39;s labels (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issueGetLabelsAsync(String owner, String repo, Long index, final ApiCallback<List<Label>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueGetLabelsValidateBeforeCall(owner, repo, index, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Label>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for issueGetMilestone
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id the milestone to get, identified by ID and if not available by name (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issueGetMilestoneCall(String owner, String repo, String id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/milestones/{id}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueGetMilestoneValidateBeforeCall(String owner, String repo, String id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueGetMilestone(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueGetMilestone(Async)");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling issueGetMilestone(Async)");
        }
        

        com.squareup.okhttp.Call call = issueGetMilestoneCall(owner, repo, id, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get a milestone
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id the milestone to get, identified by ID and if not available by name (required)
     * @return Milestone
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Milestone issueGetMilestone(String owner, String repo, String id) throws ApiException {
        ApiResponse<Milestone> resp = issueGetMilestoneWithHttpInfo(owner, repo, id);
        return resp.getData();
    }

    /**
     * Get a milestone
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id the milestone to get, identified by ID and if not available by name (required)
     * @return ApiResponse&lt;Milestone&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Milestone> issueGetMilestoneWithHttpInfo(String owner, String repo, String id) throws ApiException {
        com.squareup.okhttp.Call call = issueGetMilestoneValidateBeforeCall(owner, repo, id, null, null);
        Type localVarReturnType = new TypeToken<Milestone>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get a milestone (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id the milestone to get, identified by ID and if not available by name (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issueGetMilestoneAsync(String owner, String repo, String id, final ApiCallback<Milestone> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueGetMilestoneValidateBeforeCall(owner, repo, id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Milestone>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for issueGetMilestonesList
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param state Milestone state, Recognized values are open, closed and all. Defaults to \&quot;open\&quot; (optional)
     * @param name filter by milestone name (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issueGetMilestonesListCall(String owner, String repo, String state, String name, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/milestones"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (state != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("state", state));
        if (name != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("name", name));
        if (page != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueGetMilestonesListValidateBeforeCall(String owner, String repo, String state, String name, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueGetMilestonesList(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueGetMilestonesList(Async)");
        }
        

        com.squareup.okhttp.Call call = issueGetMilestonesListCall(owner, repo, state, name, page, limit, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get all of a repository&#39;s opened milestones
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param state Milestone state, Recognized values are open, closed and all. Defaults to \&quot;open\&quot; (optional)
     * @param name filter by milestone name (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return List&lt;Milestone&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<Milestone> issueGetMilestonesList(String owner, String repo, String state, String name, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<Milestone>> resp = issueGetMilestonesListWithHttpInfo(owner, repo, state, name, page, limit);
        return resp.getData();
    }

    /**
     * Get all of a repository&#39;s opened milestones
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param state Milestone state, Recognized values are open, closed and all. Defaults to \&quot;open\&quot; (optional)
     * @param name filter by milestone name (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return ApiResponse&lt;List&lt;Milestone&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<Milestone>> issueGetMilestonesListWithHttpInfo(String owner, String repo, String state, String name, Integer page, Integer limit) throws ApiException {
        com.squareup.okhttp.Call call = issueGetMilestonesListValidateBeforeCall(owner, repo, state, name, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<Milestone>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get all of a repository&#39;s opened milestones (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param state Milestone state, Recognized values are open, closed and all. Defaults to \&quot;open\&quot; (optional)
     * @param name filter by milestone name (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issueGetMilestonesListAsync(String owner, String repo, String state, String name, Integer page, Integer limit, final ApiCallback<List<Milestone>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueGetMilestonesListValidateBeforeCall(owner, repo, state, name, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Milestone>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for issueGetRepoComments
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param since if provided, only comments updated since the provided time are returned. (optional)
     * @param before if provided, only comments updated before the provided time are returned. (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issueGetRepoCommentsCall(String owner, String repo, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/issues/comments"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (since != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("since", since));
        if (before != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("before", before));
        if (page != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueGetRepoCommentsValidateBeforeCall(String owner, String repo, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueGetRepoComments(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueGetRepoComments(Async)");
        }
        

        com.squareup.okhttp.Call call = issueGetRepoCommentsCall(owner, repo, since, before, page, limit, progressListener, progressRequestListener);
        return call;

    }

    /**
     * List all comments in a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param since if provided, only comments updated since the provided time are returned. (optional)
     * @param before if provided, only comments updated before the provided time are returned. (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return List&lt;Comment&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<Comment> issueGetRepoComments(String owner, String repo, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<Comment>> resp = issueGetRepoCommentsWithHttpInfo(owner, repo, since, before, page, limit);
        return resp.getData();
    }

    /**
     * List all comments in a repository
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param since if provided, only comments updated since the provided time are returned. (optional)
     * @param before if provided, only comments updated before the provided time are returned. (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return ApiResponse&lt;List&lt;Comment&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<Comment>> issueGetRepoCommentsWithHttpInfo(String owner, String repo, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit) throws ApiException {
        com.squareup.okhttp.Call call = issueGetRepoCommentsValidateBeforeCall(owner, repo, since, before, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<Comment>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * List all comments in a repository (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param since if provided, only comments updated since the provided time are returned. (optional)
     * @param before if provided, only comments updated before the provided time are returned. (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issueGetRepoCommentsAsync(String owner, String repo, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit, final ApiCallback<List<Comment>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueGetRepoCommentsValidateBeforeCall(owner, repo, since, before, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Comment>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for issueListIssues
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param state whether issue is open or closed (optional)
     * @param labels comma separated list of labels. Fetch only issues that have any of this labels. Non existent labels are discarded (optional)
     * @param q search string (optional)
     * @param type filter by type (issues / pulls) if set (optional)
     * @param milestones comma separated list of milestone names or ids. It uses names and fall back to ids. Fetch only issues that have any of this milestones. Non existent milestones are discarded (optional)
     * @param since Only show items updated after the given time. This is a timestamp in RFC 3339 format (optional)
     * @param before Only show items updated before the given time. This is a timestamp in RFC 3339 format (optional)
     * @param createdBy Only show items which were created by the the given user (optional)
     * @param assignedBy Only show items for which the given user is assigned (optional)
     * @param mentionedBy Only show items in which the given user was mentioned (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issueListIssuesCall(String owner, String repo, String state, String labels, String q, String type, String milestones, OffsetDateTime since, OffsetDateTime before, String createdBy, String assignedBy, String mentionedBy, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/issues"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (state != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("state", state));
        if (labels != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("labels", labels));
        if (q != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("q", q));
        if (type != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("type", type));
        if (milestones != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("milestones", milestones));
        if (since != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("since", since));
        if (before != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("before", before));
        if (createdBy != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("created_by", createdBy));
        if (assignedBy != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("assigned_by", assignedBy));
        if (mentionedBy != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("mentioned_by", mentionedBy));
        if (page != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueListIssuesValidateBeforeCall(String owner, String repo, String state, String labels, String q, String type, String milestones, OffsetDateTime since, OffsetDateTime before, String createdBy, String assignedBy, String mentionedBy, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueListIssues(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueListIssues(Async)");
        }
        

        com.squareup.okhttp.Call call = issueListIssuesCall(owner, repo, state, labels, q, type, milestones, since, before, createdBy, assignedBy, mentionedBy, page, limit, progressListener, progressRequestListener);
        return call;

    }

    /**
     * List a repository&#39;s issues
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param state whether issue is open or closed (optional)
     * @param labels comma separated list of labels. Fetch only issues that have any of this labels. Non existent labels are discarded (optional)
     * @param q search string (optional)
     * @param type filter by type (issues / pulls) if set (optional)
     * @param milestones comma separated list of milestone names or ids. It uses names and fall back to ids. Fetch only issues that have any of this milestones. Non existent milestones are discarded (optional)
     * @param since Only show items updated after the given time. This is a timestamp in RFC 3339 format (optional)
     * @param before Only show items updated before the given time. This is a timestamp in RFC 3339 format (optional)
     * @param createdBy Only show items which were created by the the given user (optional)
     * @param assignedBy Only show items for which the given user is assigned (optional)
     * @param mentionedBy Only show items in which the given user was mentioned (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return List&lt;Issue&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<Issue> issueListIssues(String owner, String repo, String state, String labels, String q, String type, String milestones, OffsetDateTime since, OffsetDateTime before, String createdBy, String assignedBy, String mentionedBy, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<Issue>> resp = issueListIssuesWithHttpInfo(owner, repo, state, labels, q, type, milestones, since, before, createdBy, assignedBy, mentionedBy, page, limit);
        return resp.getData();
    }

    /**
     * List a repository&#39;s issues
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param state whether issue is open or closed (optional)
     * @param labels comma separated list of labels. Fetch only issues that have any of this labels. Non existent labels are discarded (optional)
     * @param q search string (optional)
     * @param type filter by type (issues / pulls) if set (optional)
     * @param milestones comma separated list of milestone names or ids. It uses names and fall back to ids. Fetch only issues that have any of this milestones. Non existent milestones are discarded (optional)
     * @param since Only show items updated after the given time. This is a timestamp in RFC 3339 format (optional)
     * @param before Only show items updated before the given time. This is a timestamp in RFC 3339 format (optional)
     * @param createdBy Only show items which were created by the the given user (optional)
     * @param assignedBy Only show items for which the given user is assigned (optional)
     * @param mentionedBy Only show items in which the given user was mentioned (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return ApiResponse&lt;List&lt;Issue&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<Issue>> issueListIssuesWithHttpInfo(String owner, String repo, String state, String labels, String q, String type, String milestones, OffsetDateTime since, OffsetDateTime before, String createdBy, String assignedBy, String mentionedBy, Integer page, Integer limit) throws ApiException {
        com.squareup.okhttp.Call call = issueListIssuesValidateBeforeCall(owner, repo, state, labels, q, type, milestones, since, before, createdBy, assignedBy, mentionedBy, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<Issue>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * List a repository&#39;s issues (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param state whether issue is open or closed (optional)
     * @param labels comma separated list of labels. Fetch only issues that have any of this labels. Non existent labels are discarded (optional)
     * @param q search string (optional)
     * @param type filter by type (issues / pulls) if set (optional)
     * @param milestones comma separated list of milestone names or ids. It uses names and fall back to ids. Fetch only issues that have any of this milestones. Non existent milestones are discarded (optional)
     * @param since Only show items updated after the given time. This is a timestamp in RFC 3339 format (optional)
     * @param before Only show items updated before the given time. This is a timestamp in RFC 3339 format (optional)
     * @param createdBy Only show items which were created by the the given user (optional)
     * @param assignedBy Only show items for which the given user is assigned (optional)
     * @param mentionedBy Only show items in which the given user was mentioned (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issueListIssuesAsync(String owner, String repo, String state, String labels, String q, String type, String milestones, OffsetDateTime since, OffsetDateTime before, String createdBy, String assignedBy, String mentionedBy, Integer page, Integer limit, final ApiCallback<List<Issue>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueListIssuesValidateBeforeCall(owner, repo, state, labels, q, type, milestones, since, before, createdBy, assignedBy, mentionedBy, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Issue>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for issueListLabels
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issueListLabelsCall(String owner, String repo, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/labels"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueListLabelsValidateBeforeCall(String owner, String repo, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueListLabels(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueListLabels(Async)");
        }
        

        com.squareup.okhttp.Call call = issueListLabelsCall(owner, repo, page, limit, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get all of a repository&#39;s labels
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return List&lt;Label&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<Label> issueListLabels(String owner, String repo, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<Label>> resp = issueListLabelsWithHttpInfo(owner, repo, page, limit);
        return resp.getData();
    }

    /**
     * Get all of a repository&#39;s labels
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return ApiResponse&lt;List&lt;Label&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<Label>> issueListLabelsWithHttpInfo(String owner, String repo, Integer page, Integer limit) throws ApiException {
        com.squareup.okhttp.Call call = issueListLabelsValidateBeforeCall(owner, repo, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<Label>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get all of a repository&#39;s labels (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issueListLabelsAsync(String owner, String repo, Integer page, Integer limit, final ApiCallback<List<Label>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueListLabelsValidateBeforeCall(owner, repo, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Label>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for issuePostCommentReaction
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the comment to edit (required)
     * @param content  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issuePostCommentReactionCall(String owner, String repo, Long id, EditReactionOption content, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = content;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/issues/comments/{id}/reactions"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issuePostCommentReactionValidateBeforeCall(String owner, String repo, Long id, EditReactionOption content, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issuePostCommentReaction(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issuePostCommentReaction(Async)");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling issuePostCommentReaction(Async)");
        }
        

        com.squareup.okhttp.Call call = issuePostCommentReactionCall(owner, repo, id, content, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Add a reaction to a comment of an issue
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the comment to edit (required)
     * @param content  (optional)
     * @return Reaction
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Reaction issuePostCommentReaction(String owner, String repo, Long id, EditReactionOption content) throws ApiException {
        ApiResponse<Reaction> resp = issuePostCommentReactionWithHttpInfo(owner, repo, id, content);
        return resp.getData();
    }

    /**
     * Add a reaction to a comment of an issue
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the comment to edit (required)
     * @param content  (optional)
     * @return ApiResponse&lt;Reaction&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Reaction> issuePostCommentReactionWithHttpInfo(String owner, String repo, Long id, EditReactionOption content) throws ApiException {
        com.squareup.okhttp.Call call = issuePostCommentReactionValidateBeforeCall(owner, repo, id, content, null, null);
        Type localVarReturnType = new TypeToken<Reaction>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Add a reaction to a comment of an issue (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param id id of the comment to edit (required)
     * @param content  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issuePostCommentReactionAsync(String owner, String repo, Long id, EditReactionOption content, final ApiCallback<Reaction> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issuePostCommentReactionValidateBeforeCall(owner, repo, id, content, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Reaction>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for issuePostIssueReaction
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param content  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issuePostIssueReactionCall(String owner, String repo, Long index, EditReactionOption content, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = content;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/reactions"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issuePostIssueReactionValidateBeforeCall(String owner, String repo, Long index, EditReactionOption content, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issuePostIssueReaction(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issuePostIssueReaction(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issuePostIssueReaction(Async)");
        }
        

        com.squareup.okhttp.Call call = issuePostIssueReactionCall(owner, repo, index, content, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Add a reaction to an issue
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param content  (optional)
     * @return Reaction
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Reaction issuePostIssueReaction(String owner, String repo, Long index, EditReactionOption content) throws ApiException {
        ApiResponse<Reaction> resp = issuePostIssueReactionWithHttpInfo(owner, repo, index, content);
        return resp.getData();
    }

    /**
     * Add a reaction to an issue
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param content  (optional)
     * @return ApiResponse&lt;Reaction&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Reaction> issuePostIssueReactionWithHttpInfo(String owner, String repo, Long index, EditReactionOption content) throws ApiException {
        com.squareup.okhttp.Call call = issuePostIssueReactionValidateBeforeCall(owner, repo, index, content, null, null);
        Type localVarReturnType = new TypeToken<Reaction>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Add a reaction to an issue (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param content  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issuePostIssueReactionAsync(String owner, String repo, Long index, EditReactionOption content, final ApiCallback<Reaction> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issuePostIssueReactionValidateBeforeCall(owner, repo, index, content, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Reaction>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for issueRemoveLabel
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param id id of the label to remove (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issueRemoveLabelCall(String owner, String repo, Long index, Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/labels/{id}"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()))
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueRemoveLabelValidateBeforeCall(String owner, String repo, Long index, Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueRemoveLabel(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueRemoveLabel(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueRemoveLabel(Async)");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling issueRemoveLabel(Async)");
        }
        

        com.squareup.okhttp.Call call = issueRemoveLabelCall(owner, repo, index, id, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Remove a label from an issue
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param id id of the label to remove (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void issueRemoveLabel(String owner, String repo, Long index, Long id) throws ApiException {
        issueRemoveLabelWithHttpInfo(owner, repo, index, id);
    }

    /**
     * Remove a label from an issue
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param id id of the label to remove (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> issueRemoveLabelWithHttpInfo(String owner, String repo, Long index, Long id) throws ApiException {
        com.squareup.okhttp.Call call = issueRemoveLabelValidateBeforeCall(owner, repo, index, id, null, null);
        return apiClient.execute(call);
    }

    /**
     * Remove a label from an issue (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param id id of the label to remove (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issueRemoveLabelAsync(String owner, String repo, Long index, Long id, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueRemoveLabelValidateBeforeCall(owner, repo, index, id, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for issueReplaceLabels
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issueReplaceLabelsCall(String owner, String repo, Long index, IssueLabelsOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/labels"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueReplaceLabelsValidateBeforeCall(String owner, String repo, Long index, IssueLabelsOption body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueReplaceLabels(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueReplaceLabels(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueReplaceLabels(Async)");
        }
        

        com.squareup.okhttp.Call call = issueReplaceLabelsCall(owner, repo, index, body, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Replace an issue&#39;s labels
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param body  (optional)
     * @return List&lt;Label&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<Label> issueReplaceLabels(String owner, String repo, Long index, IssueLabelsOption body) throws ApiException {
        ApiResponse<List<Label>> resp = issueReplaceLabelsWithHttpInfo(owner, repo, index, body);
        return resp.getData();
    }

    /**
     * Replace an issue&#39;s labels
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param body  (optional)
     * @return ApiResponse&lt;List&lt;Label&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<Label>> issueReplaceLabelsWithHttpInfo(String owner, String repo, Long index, IssueLabelsOption body) throws ApiException {
        com.squareup.okhttp.Call call = issueReplaceLabelsValidateBeforeCall(owner, repo, index, body, null, null);
        Type localVarReturnType = new TypeToken<List<Label>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Replace an issue&#39;s labels (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issueReplaceLabelsAsync(String owner, String repo, Long index, IssueLabelsOption body, final ApiCallback<List<Label>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueReplaceLabelsValidateBeforeCall(owner, repo, index, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Label>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for issueResetTime
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue to add tracked time to (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issueResetTimeCall(String owner, String repo, Long index, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/times"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueResetTimeValidateBeforeCall(String owner, String repo, Long index, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueResetTime(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueResetTime(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueResetTime(Async)");
        }
        

        com.squareup.okhttp.Call call = issueResetTimeCall(owner, repo, index, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Reset a tracked time of an issue
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue to add tracked time to (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void issueResetTime(String owner, String repo, Long index) throws ApiException {
        issueResetTimeWithHttpInfo(owner, repo, index);
    }

    /**
     * Reset a tracked time of an issue
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue to add tracked time to (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> issueResetTimeWithHttpInfo(String owner, String repo, Long index) throws ApiException {
        com.squareup.okhttp.Call call = issueResetTimeValidateBeforeCall(owner, repo, index, null, null);
        return apiClient.execute(call);
    }

    /**
     * Reset a tracked time of an issue (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue to add tracked time to (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issueResetTimeAsync(String owner, String repo, Long index, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueResetTimeValidateBeforeCall(owner, repo, index, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for issueSearchIssues
     * @param state whether issue is open or closed (optional)
     * @param labels comma separated list of labels. Fetch only issues that have any of this labels. Non existent labels are discarded (optional)
     * @param milestones comma separated list of milestone names. Fetch only issues that have any of this milestones. Non existent are discarded (optional)
     * @param q search string (optional)
     * @param priorityRepoId repository to prioritize in the results (optional)
     * @param type filter by type (issues / pulls) if set (optional)
     * @param since Only show notifications updated after the given time. This is a timestamp in RFC 3339 format (optional)
     * @param before Only show notifications updated before the given time. This is a timestamp in RFC 3339 format (optional)
     * @param assigned filter (issues / pulls) assigned to you, default is false (optional)
     * @param created filter (issues / pulls) created by you, default is false (optional)
     * @param mentioned filter (issues / pulls) mentioning you, default is false (optional)
     * @param reviewRequested filter pulls requesting your review, default is false (optional)
     * @param owner filter by owner (optional)
     * @param team filter by team (requires organization owner parameter to be provided) (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issueSearchIssuesCall(String state, String labels, String milestones, String q, Long priorityRepoId, String type, OffsetDateTime since, OffsetDateTime before, Boolean assigned, Boolean created, Boolean mentioned, Boolean reviewRequested, String owner, String team, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/issues/search";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (state != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("state", state));
        if (labels != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("labels", labels));
        if (milestones != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("milestones", milestones));
        if (q != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("q", q));
        if (priorityRepoId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("priority_repo_id", priorityRepoId));
        if (type != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("type", type));
        if (since != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("since", since));
        if (before != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("before", before));
        if (assigned != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("assigned", assigned));
        if (created != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("created", created));
        if (mentioned != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("mentioned", mentioned));
        if (reviewRequested != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("review_requested", reviewRequested));
        if (owner != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("owner", owner));
        if (team != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("team", team));
        if (page != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueSearchIssuesValidateBeforeCall(String state, String labels, String milestones, String q, Long priorityRepoId, String type, OffsetDateTime since, OffsetDateTime before, Boolean assigned, Boolean created, Boolean mentioned, Boolean reviewRequested, String owner, String team, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        

        com.squareup.okhttp.Call call = issueSearchIssuesCall(state, labels, milestones, q, priorityRepoId, type, since, before, assigned, created, mentioned, reviewRequested, owner, team, page, limit, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Search for issues across the repositories that the user has access to
     * 
     * @param state whether issue is open or closed (optional)
     * @param labels comma separated list of labels. Fetch only issues that have any of this labels. Non existent labels are discarded (optional)
     * @param milestones comma separated list of milestone names. Fetch only issues that have any of this milestones. Non existent are discarded (optional)
     * @param q search string (optional)
     * @param priorityRepoId repository to prioritize in the results (optional)
     * @param type filter by type (issues / pulls) if set (optional)
     * @param since Only show notifications updated after the given time. This is a timestamp in RFC 3339 format (optional)
     * @param before Only show notifications updated before the given time. This is a timestamp in RFC 3339 format (optional)
     * @param assigned filter (issues / pulls) assigned to you, default is false (optional)
     * @param created filter (issues / pulls) created by you, default is false (optional)
     * @param mentioned filter (issues / pulls) mentioning you, default is false (optional)
     * @param reviewRequested filter pulls requesting your review, default is false (optional)
     * @param owner filter by owner (optional)
     * @param team filter by team (requires organization owner parameter to be provided) (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return List&lt;Issue&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<Issue> issueSearchIssues(String state, String labels, String milestones, String q, Long priorityRepoId, String type, OffsetDateTime since, OffsetDateTime before, Boolean assigned, Boolean created, Boolean mentioned, Boolean reviewRequested, String owner, String team, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<Issue>> resp = issueSearchIssuesWithHttpInfo(state, labels, milestones, q, priorityRepoId, type, since, before, assigned, created, mentioned, reviewRequested, owner, team, page, limit);
        return resp.getData();
    }

    /**
     * Search for issues across the repositories that the user has access to
     * 
     * @param state whether issue is open or closed (optional)
     * @param labels comma separated list of labels. Fetch only issues that have any of this labels. Non existent labels are discarded (optional)
     * @param milestones comma separated list of milestone names. Fetch only issues that have any of this milestones. Non existent are discarded (optional)
     * @param q search string (optional)
     * @param priorityRepoId repository to prioritize in the results (optional)
     * @param type filter by type (issues / pulls) if set (optional)
     * @param since Only show notifications updated after the given time. This is a timestamp in RFC 3339 format (optional)
     * @param before Only show notifications updated before the given time. This is a timestamp in RFC 3339 format (optional)
     * @param assigned filter (issues / pulls) assigned to you, default is false (optional)
     * @param created filter (issues / pulls) created by you, default is false (optional)
     * @param mentioned filter (issues / pulls) mentioning you, default is false (optional)
     * @param reviewRequested filter pulls requesting your review, default is false (optional)
     * @param owner filter by owner (optional)
     * @param team filter by team (requires organization owner parameter to be provided) (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return ApiResponse&lt;List&lt;Issue&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<Issue>> issueSearchIssuesWithHttpInfo(String state, String labels, String milestones, String q, Long priorityRepoId, String type, OffsetDateTime since, OffsetDateTime before, Boolean assigned, Boolean created, Boolean mentioned, Boolean reviewRequested, String owner, String team, Integer page, Integer limit) throws ApiException {
        com.squareup.okhttp.Call call = issueSearchIssuesValidateBeforeCall(state, labels, milestones, q, priorityRepoId, type, since, before, assigned, created, mentioned, reviewRequested, owner, team, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<Issue>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Search for issues across the repositories that the user has access to (asynchronously)
     * 
     * @param state whether issue is open or closed (optional)
     * @param labels comma separated list of labels. Fetch only issues that have any of this labels. Non existent labels are discarded (optional)
     * @param milestones comma separated list of milestone names. Fetch only issues that have any of this milestones. Non existent are discarded (optional)
     * @param q search string (optional)
     * @param priorityRepoId repository to prioritize in the results (optional)
     * @param type filter by type (issues / pulls) if set (optional)
     * @param since Only show notifications updated after the given time. This is a timestamp in RFC 3339 format (optional)
     * @param before Only show notifications updated before the given time. This is a timestamp in RFC 3339 format (optional)
     * @param assigned filter (issues / pulls) assigned to you, default is false (optional)
     * @param created filter (issues / pulls) created by you, default is false (optional)
     * @param mentioned filter (issues / pulls) mentioning you, default is false (optional)
     * @param reviewRequested filter pulls requesting your review, default is false (optional)
     * @param owner filter by owner (optional)
     * @param team filter by team (requires organization owner parameter to be provided) (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issueSearchIssuesAsync(String state, String labels, String milestones, String q, Long priorityRepoId, String type, OffsetDateTime since, OffsetDateTime before, Boolean assigned, Boolean created, Boolean mentioned, Boolean reviewRequested, String owner, String team, Integer page, Integer limit, final ApiCallback<List<Issue>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueSearchIssuesValidateBeforeCall(state, labels, milestones, q, priorityRepoId, type, since, before, assigned, created, mentioned, reviewRequested, owner, team, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Issue>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for issueStartStopWatch
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue to create the stopwatch on (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issueStartStopWatchCall(String owner, String repo, Long index, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/stopwatch/start"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueStartStopWatchValidateBeforeCall(String owner, String repo, Long index, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueStartStopWatch(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueStartStopWatch(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueStartStopWatch(Async)");
        }
        

        com.squareup.okhttp.Call call = issueStartStopWatchCall(owner, repo, index, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Start stopwatch on an issue.
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue to create the stopwatch on (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void issueStartStopWatch(String owner, String repo, Long index) throws ApiException {
        issueStartStopWatchWithHttpInfo(owner, repo, index);
    }

    /**
     * Start stopwatch on an issue.
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue to create the stopwatch on (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> issueStartStopWatchWithHttpInfo(String owner, String repo, Long index) throws ApiException {
        com.squareup.okhttp.Call call = issueStartStopWatchValidateBeforeCall(owner, repo, index, null, null);
        return apiClient.execute(call);
    }

    /**
     * Start stopwatch on an issue. (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue to create the stopwatch on (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issueStartStopWatchAsync(String owner, String repo, Long index, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueStartStopWatchValidateBeforeCall(owner, repo, index, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for issueStopStopWatch
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue to stop the stopwatch on (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issueStopStopWatchCall(String owner, String repo, Long index, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/stopwatch/stop"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueStopStopWatchValidateBeforeCall(String owner, String repo, Long index, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueStopStopWatch(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueStopStopWatch(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueStopStopWatch(Async)");
        }
        

        com.squareup.okhttp.Call call = issueStopStopWatchCall(owner, repo, index, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Stop an issue&#39;s existing stopwatch.
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue to stop the stopwatch on (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void issueStopStopWatch(String owner, String repo, Long index) throws ApiException {
        issueStopStopWatchWithHttpInfo(owner, repo, index);
    }

    /**
     * Stop an issue&#39;s existing stopwatch.
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue to stop the stopwatch on (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> issueStopStopWatchWithHttpInfo(String owner, String repo, Long index) throws ApiException {
        com.squareup.okhttp.Call call = issueStopStopWatchValidateBeforeCall(owner, repo, index, null, null);
        return apiClient.execute(call);
    }

    /**
     * Stop an issue&#39;s existing stopwatch. (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue to stop the stopwatch on (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issueStopStopWatchAsync(String owner, String repo, Long index, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueStopStopWatchValidateBeforeCall(owner, repo, index, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for issueSubscriptions
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issueSubscriptionsCall(String owner, String repo, Long index, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/subscriptions"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueSubscriptionsValidateBeforeCall(String owner, String repo, Long index, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueSubscriptions(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueSubscriptions(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueSubscriptions(Async)");
        }
        

        com.squareup.okhttp.Call call = issueSubscriptionsCall(owner, repo, index, page, limit, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get users who subscribed on an issue.
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return List&lt;User&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<User> issueSubscriptions(String owner, String repo, Long index, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<User>> resp = issueSubscriptionsWithHttpInfo(owner, repo, index, page, limit);
        return resp.getData();
    }

    /**
     * Get users who subscribed on an issue.
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return ApiResponse&lt;List&lt;User&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<User>> issueSubscriptionsWithHttpInfo(String owner, String repo, Long index, Integer page, Integer limit) throws ApiException {
        com.squareup.okhttp.Call call = issueSubscriptionsValidateBeforeCall(owner, repo, index, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<User>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get users who subscribed on an issue. (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issueSubscriptionsAsync(String owner, String repo, Long index, Integer page, Integer limit, final ApiCallback<List<User>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueSubscriptionsValidateBeforeCall(owner, repo, index, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<User>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for issueTrackedTimes
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param user optional filter by user (available for issue managers) (optional)
     * @param since Only show times updated after the given time. This is a timestamp in RFC 3339 format (optional)
     * @param before Only show times updated before the given time. This is a timestamp in RFC 3339 format (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call issueTrackedTimesCall(String owner, String repo, Long index, String user, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repos/{owner}/{repo}/issues/{index}/times"
            .replaceAll("\\{" + "owner" + "\\}", apiClient.escapeString(owner.toString()))
            .replaceAll("\\{" + "repo" + "\\}", apiClient.escapeString(repo.toString()))
            .replaceAll("\\{" + "index" + "\\}", apiClient.escapeString(index.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (user != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("user", user));
        if (since != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("since", since));
        if (before != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("before", before));
        if (page != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json", "text/plain"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "AccessToken", "AuthorizationHeaderToken", "BasicAuth", "SudoHeader", "SudoParam", "TOTPHeader", "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call issueTrackedTimesValidateBeforeCall(String owner, String repo, Long index, String user, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'owner' is set
        if (owner == null) {
            throw new ApiException("Missing the required parameter 'owner' when calling issueTrackedTimes(Async)");
        }
        
        // verify the required parameter 'repo' is set
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling issueTrackedTimes(Async)");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling issueTrackedTimes(Async)");
        }
        

        com.squareup.okhttp.Call call = issueTrackedTimesCall(owner, repo, index, user, since, before, page, limit, progressListener, progressRequestListener);
        return call;

    }

    /**
     * List an issue&#39;s tracked times
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param user optional filter by user (available for issue managers) (optional)
     * @param since Only show times updated after the given time. This is a timestamp in RFC 3339 format (optional)
     * @param before Only show times updated before the given time. This is a timestamp in RFC 3339 format (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return List&lt;TrackedTime&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<TrackedTime> issueTrackedTimes(String owner, String repo, Long index, String user, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit) throws ApiException {
        ApiResponse<List<TrackedTime>> resp = issueTrackedTimesWithHttpInfo(owner, repo, index, user, since, before, page, limit);
        return resp.getData();
    }

    /**
     * List an issue&#39;s tracked times
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param user optional filter by user (available for issue managers) (optional)
     * @param since Only show times updated after the given time. This is a timestamp in RFC 3339 format (optional)
     * @param before Only show times updated before the given time. This is a timestamp in RFC 3339 format (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @return ApiResponse&lt;List&lt;TrackedTime&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<TrackedTime>> issueTrackedTimesWithHttpInfo(String owner, String repo, Long index, String user, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit) throws ApiException {
        com.squareup.okhttp.Call call = issueTrackedTimesValidateBeforeCall(owner, repo, index, user, since, before, page, limit, null, null);
        Type localVarReturnType = new TypeToken<List<TrackedTime>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * List an issue&#39;s tracked times (asynchronously)
     * 
     * @param owner owner of the repo (required)
     * @param repo name of the repo (required)
     * @param index index of the issue (required)
     * @param user optional filter by user (available for issue managers) (optional)
     * @param since Only show times updated after the given time. This is a timestamp in RFC 3339 format (optional)
     * @param before Only show times updated before the given time. This is a timestamp in RFC 3339 format (optional)
     * @param page page number of results to return (1-based) (optional)
     * @param limit page size of results (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call issueTrackedTimesAsync(String owner, String repo, Long index, String user, OffsetDateTime since, OffsetDateTime before, Integer page, Integer limit, final ApiCallback<List<TrackedTime>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = issueTrackedTimesValidateBeforeCall(owner, repo, index, user, since, before, page, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<TrackedTime>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
