/*
 * Decompiled with CFR 0.152.
 */
package com.github.zeldigas.spring.env;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigSyntax;
import com.typesafe.config.ConfigValue;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;

public class HoconPropertySourceLoader
implements PropertySourceLoader {
    public String[] getFileExtensions() {
        return new String[]{"conf"};
    }

    public List<PropertySource<?>> load(String name, Resource resource) throws IOException {
        ArrayList propertySources = new ArrayList();
        Config config = ConfigFactory.parseReader((Reader)new InputStreamReader(resource.getInputStream()), (ConfigParseOptions)ConfigParseOptions.defaults().setSyntax(ConfigSyntax.CONF)).resolve();
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        this.toFlatMap(properties, config);
        propertySources.add((PropertySource<?>)new MapPropertySource(name, properties));
        return propertySources;
    }

    private void toFlatMap(LinkedHashMap<String, Object> properties, Config config) {
        this.toFlatMap(properties, "", config);
    }

    private void toFlatMap(Map<String, Object> properties, String key, Config config) {
        String prefix = "".equals(key) ? "" : key + ".";
        for (Map.Entry entry : config.entrySet()) {
            String propertyKey = prefix + (String)entry.getKey();
            ConfigValue value = (ConfigValue)entry.getValue();
            this.addConfigValue(properties, propertyKey, value);
        }
    }

    private void addConfigValue(Map<String, Object> properties, String key, ConfigValue value) {
        if (value instanceof ConfigList) {
            this.processListValues(properties, key, (ConfigList)value);
        } else if (value instanceof ConfigObject) {
            this.processObjectValues(properties, key, (ConfigObject)value);
        } else {
            this.addScalarValue(properties, key, value);
        }
    }

    private void processListValues(Map<String, Object> properties, String key, ConfigList value) {
        int i = 0;
        for (ConfigValue element : value) {
            this.addConfigValue(properties, String.format("%s[%d]", key, i++), element);
        }
    }

    private void processObjectValues(Map<String, Object> properties, String key, ConfigObject value) {
        this.toFlatMap(properties, key, value.toConfig());
    }

    private void addScalarValue(Map<String, Object> properties, String key, ConfigValue value) {
        properties.put(key, value.unwrapped());
    }
}

