/*
 * Decompiled with CFR 0.152.
 */
package com.github.zaplatynski.testing;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.runners.model.RunnerScheduler;

public class ThreadPoolScheduler
implements RunnerScheduler {
    private final ExecutorService executor;

    public ThreadPoolScheduler() {
        this(System.getProperty("junit.parallel.threads", String.valueOf(Runtime.getRuntime().availableProcessors())));
    }

    public ThreadPoolScheduler(String numThreads) {
        int numberOfThreads = Integer.valueOf(numThreads);
        this.executor = Executors.newFixedThreadPool(numberOfThreads);
    }

    public void schedule(Runnable childStatement) {
        this.executor.submit(childStatement);
    }

    public void finished() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(10L, TimeUnit.MINUTES);
        }
        catch (InterruptedException exc) {
            throw new RuntimeException(exc);
        }
    }
}

