/*
 * Decompiled with CFR 0.152.
 */
package com.github.zaplatynski.testing;

import com.github.zaplatynski.testing.FrameworkMethodComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import org.junit.Test;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

public class MethodOrderRandomizer {
    private final TestClass testClass;
    private final int times;
    private final FrameworkMethodComparator methodComparator;
    private final Random random;

    public MethodOrderRandomizer(TestClass testClass, int times, long seed) {
        this.testClass = Objects.requireNonNull(testClass, "TestClass is null");
        this.times = times;
        this.random = new Random(seed);
        this.methodComparator = new FrameworkMethodComparator();
    }

    public List<FrameworkMethod> computeTestMethods() {
        List methods = this.testClass.getAnnotatedMethods(Test.class);
        return this.computeTestMethods(methods);
    }

    public List<FrameworkMethod> computeTestMethods(List<FrameworkMethod> methods) {
        Objects.requireNonNull(methods, "List of methods is null!");
        ArrayList<FrameworkMethod> randomizedMethods = new ArrayList<FrameworkMethod>(methods.size() * this.times);
        for (int i = 0; i < this.times; ++i) {
            randomizedMethods.addAll(methods);
        }
        Collections.sort(randomizedMethods, this.methodComparator);
        Collections.shuffle(randomizedMethods, this.random);
        return randomizedMethods;
    }
}

