/*
 * Decompiled with CFR 0.152.
 */
package com.github.zaplatynski.testing;

import com.github.zaplatynski.testing.MethodOrderRandomizer;
import com.github.zaplatynski.testing.RandomRunnerParameters;
import com.github.zaplatynski.testing.ThreadPoolScheduler;
import java.util.List;
import java.util.Objects;
import org.junit.experimental.theories.Theories;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;

public class JUnitTheoriesRandomRunner
extends Theories {
    private MethodOrderRandomizer randomizer;

    public JUnitTheoriesRandomRunner(Class<?> klass) throws InitializationError {
        super(Objects.requireNonNull(klass, "Class is null!"));
    }

    protected List<FrameworkMethod> computeTestMethods() {
        List frameworkMethods = super.computeTestMethods();
        if (this.randomizer == null) {
            long seed = Long.valueOf(System.getProperty("junit.random.seed", String.valueOf(System.nanoTime())));
            int times = 1;
            if (this.getTestClass().getAnnotation(RandomRunnerParameters.class) != null) {
                RandomRunnerParameters config = (RandomRunnerParameters)this.getTestClass().getAnnotation(RandomRunnerParameters.class);
                if (config.parallel()) {
                    this.setScheduler(new ThreadPoolScheduler());
                }
                if (config.seed() > 0L) {
                    seed = config.seed();
                }
                times = config.times();
            }
            this.randomizer = new MethodOrderRandomizer(this.getTestClass(), times, seed);
        }
        return this.randomizer.computeTestMethods(frameworkMethods);
    }
}

