/*
 * Decompiled with CFR 0.152.
 */
package com.github.zaplatynski.testing;

import com.github.zaplatynski.testing.MethodOrderRandomizer;
import com.github.zaplatynski.testing.RandomRunnerParameters;
import com.github.zaplatynski.testing.ThreadPoolScheduler;
import java.util.List;
import java.util.Objects;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;

public class JUnitTestRandomRunner
extends BlockJUnit4ClassRunner {
    private MethodOrderRandomizer randomizer;

    public JUnitTestRandomRunner(Class<?> klass) throws InitializationError {
        super(Objects.requireNonNull(klass, "Class is null!"));
    }

    protected List<FrameworkMethod> computeTestMethods() {
        if (this.randomizer == null) {
            int times = 1;
            long seed = Long.valueOf(System.getProperty("junit.random.seed", String.valueOf(System.nanoTime())));
            if (this.getTestClass().getAnnotation(RandomRunnerParameters.class) != null) {
                RandomRunnerParameters config = (RandomRunnerParameters)this.getTestClass().getAnnotation(RandomRunnerParameters.class);
                if (config.parallel()) {
                    System.out.println("run parallel");
                    this.setScheduler(new ThreadPoolScheduler());
                }
                if (config.seed() > 0L) {
                    seed = config.seed();
                }
                times = config.times();
            }
            this.randomizer = new MethodOrderRandomizer(this.getTestClass(), times, seed);
        }
        return this.randomizer.computeTestMethods();
    }
}

