/*
 * Decompiled with CFR 0.152.
 */
package com.seven.cow.servlet.validator.aop;

import com.seven.cow.servlet.validator.annotations.Validated;
import com.seven.cow.servlet.validator.annotations.Validators;
import com.seven.cow.servlet.validator.exception.ValidationException;
import com.seven.cow.servlet.validator.util.ValidatorUtils;
import com.seven.cow.spring.boot.autoconfigure.annotations.InheritedBean;
import com.seven.cow.spring.boot.autoconfigure.entity.Error;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=-1000)
@InheritedBean
public class ValidatorAspect {
    @Pointcut(value="@annotation(com.seven.cow.servlet.validator.annotations.Validators) ")
    public void getValidatorPoint() {
    }

    @Around(value="getValidatorPoint()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Object[] args = point.getArgs();
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Method method = methodSignature.getMethod();
        Validators validators = method.getAnnotation(Validators.class);
        if (null != validators) {
            Validated[] validates;
            for (final Validated validated : validates = validators.value()) {
                try {
                    Boolean flag = ValidatorUtils.valid(validated.expression(), method, args, Boolean.class);
                    if (!Boolean.FALSE.equals(flag)) continue;
                    throw new ValidationException(() -> new Error(){

                        public String getErrorCode() {
                            return validated.code();
                        }

                        public String getErrorMsg() {
                            return validated.message();
                        }
                    });
                }
                catch (Exception ex) {
                    if (ex instanceof ValidationException) {
                        throw ex;
                    }
                    throw new ValidationException(validated.message(), (Throwable)ex);
                }
            }
        }
        return point.proceed();
    }
}

