/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.turbocharger.webmvc.util;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import jakarta.servlet.http.HttpSession;
import java.util.Objects;
import org.springframework.lang.Nullable;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public final class ServletUtils {
    private ServletUtils() {
    }

    @Nullable
    public static HttpServletRequest getRequest() {
        try {
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
            return attributes.getRequest();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static HttpServletRequest getRequiredRequest() {
        HttpServletRequest request = ServletUtils.getRequest();
        return Objects.requireNonNull(request);
    }

    public static HttpServletRequest getUnwrappedRequest() {
        HttpServletRequest request = ServletUtils.getRequiredRequest();
        while (request instanceof HttpServletRequestWrapper) {
            HttpServletRequestWrapper wrapper = (HttpServletRequestWrapper)request;
            request = (HttpServletRequest)wrapper.getRequest();
        }
        return request;
    }

    @Nullable
    public static HttpServletResponse getResponse() {
        try {
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
            return attributes.getResponse();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static HttpServletResponse getRequiredResponse() {
        HttpServletResponse response = ServletUtils.getResponse();
        return Objects.requireNonNull(response);
    }

    public static HttpServletResponse getUnwrappedResponse() {
        HttpServletResponse response = ServletUtils.getRequiredResponse();
        while (response instanceof HttpServletResponseWrapper) {
            HttpServletResponseWrapper wrapper = (HttpServletResponseWrapper)response;
            response = (HttpServletResponse)wrapper.getResponse();
        }
        return response;
    }

    public static HttpSession getSession() {
        return ServletUtils.getSession(true);
    }

    public static HttpSession getSession(boolean create) {
        return ServletUtils.getRequiredRequest().getSession(create);
    }

    public static String getSessionId() {
        return ServletUtils.getSession().getId();
    }

    public static ServletContext getServletContext() {
        return ServletUtils.getRequiredRequest().getServletContext();
    }
}

