/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.turbocharger.webmvc.util;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;
import org.springframework.lang.Nullable;
import org.springframework.web.context.request.NativeWebRequest;

public final class RemoteAddressUtils {
    private RemoteAddressUtils() {
    }

    @Nullable
    public static String getIpAddress(HttpServletRequest request) {
        String ip;
        block6: {
            block5: {
                ip = request.getHeader("X-Forwarded-For");
                if (ip != null && !ip.isEmpty() && !"unknown".equalsIgnoreCase(ip)) break block5;
                ip = request.getHeader("Proxy-Client-IP");
                if (ip == null || ip.isEmpty() || "unknown".equalsIgnoreCase(ip)) {
                    ip = request.getHeader("WL-Proxy-Client-IP");
                }
                if (ip == null || ip.isEmpty() || "unknown".equalsIgnoreCase(ip)) {
                    ip = request.getHeader("HTTP_CLIENT_IP");
                }
                if (ip == null || ip.isEmpty() || "unknown".equalsIgnoreCase(ip)) {
                    ip = request.getHeader("HTTP_X_FORWARDED_FOR");
                }
                if (ip != null && !ip.isEmpty() && !"unknown".equalsIgnoreCase(ip)) break block6;
                ip = request.getRemoteAddr();
                break block6;
            }
            if (ip.length() > 15) {
                String[] ips;
                for (String strIp : ips = ip.split(",")) {
                    if ("unknown".equalsIgnoreCase(strIp)) continue;
                    ip = strIp;
                    break;
                }
            }
        }
        return ip;
    }

    public static String getRequiredIpAddress(HttpServletRequest request) {
        String ip = RemoteAddressUtils.getIpAddress(request);
        return Objects.requireNonNull(ip);
    }

    @Nullable
    public static String getIpAddress(NativeWebRequest request) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request.getNativeRequest(HttpServletRequest.class);
        return RemoteAddressUtils.getIpAddress(httpServletRequest);
    }

    public static String getRequiredIpAddress(NativeWebRequest request) {
        String ip = RemoteAddressUtils.getIpAddress(request);
        return Objects.requireNonNull(ip);
    }
}

