/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.turbocharger.webmvc.support.response;

import com.github.yingzhuo.turbocharger.util.io.ImageUtils;
import java.awt.image.BufferedImage;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.util.MultiValueMap;

public final class ImageResponseEntity
extends ResponseEntity<byte[]> {
    private ImageResponseEntity(byte[] body, MultiValueMap<String, String> headers, HttpStatus status) {
        super((Object)body, headers, (HttpStatusCode)status);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private HttpStatus status = HttpStatus.OK;
        private String format = "png";
        @Nullable
        private BufferedImage image;

        private Builder() {
        }

        public Builder status(HttpStatus status) {
            this.status = status;
            return this;
        }

        public Builder image(BufferedImage image) {
            this.image = image;
            return this;
        }

        public Builder format(String format) {
            this.format = format;
            return this;
        }

        public ImageResponseEntity build() {
            byte[] bytes = ImageUtils.toByteArray((BufferedImage)this.image, (String)this.format);
            int size = bytes.length;
            HttpHeaders headers = new HttpHeaders();
            headers.add((Object)"Content-Type", (Object)("image/" + this.format));
            headers.add((Object)"Content-Length", (Object)String.valueOf(size));
            return new ImageResponseEntity(bytes, (MultiValueMap<String, String>)headers, this.status);
        }
    }
}

