/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.turbocharger.webmvc.support.response;

import com.github.yingzhuo.turbocharger.util.io.CloseUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StreamUtils;

public class AttachmentResponseEntity
extends ResponseEntity<byte[]> {
    private AttachmentResponseEntity(byte[] body, MultiValueMap<String, String> headers, HttpStatus status) {
        super((Object)body, headers, (HttpStatusCode)status);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private HttpStatus status = HttpStatus.OK;
        private MediaType mediaType = MediaType.APPLICATION_OCTET_STREAM;
        @Nullable
        private byte[] content;
        @Nullable
        private String attachmentName;

        private Builder() {
        }

        public Builder status(HttpStatus status) {
            this.status = status;
            return this;
        }

        public Builder mediaType(MediaType mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        public Builder content(byte[] bytes) {
            this.content = bytes;
            return this;
        }

        public Builder content(Resource resource) {
            try {
                this.content = StreamUtils.copyToByteArray((InputStream)resource.getInputStream());
                Builder builder = this;
                return builder;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                CloseUtils.closeQuietly((Resource)resource);
            }
        }

        public Builder content(File file) {
            return this.content((Resource)new FileSystemResource(file));
        }

        public Builder content(Path path) {
            return this.content((Resource)new FileSystemResource(path));
        }

        public Builder attachmentName(String name) {
            this.attachmentName = name;
            return this;
        }

        public AttachmentResponseEntity build() {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentDisposition(ContentDisposition.attachment().filename(new String(this.attachmentName.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1)).build());
            headers.add("Content-Type", this.mediaType.toString());
            headers.add("Content-Length", String.valueOf(this.content.length));
            return new AttachmentResponseEntity(this.content, (MultiValueMap<String, String>)headers, this.status);
        }
    }
}

