/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.turbocharger.webmvc.support.argument;

import com.github.yingzhuo.turbocharger.webmvc.support.argument.RemoteAddress;
import com.github.yingzhuo.turbocharger.webmvc.util.RemoteAddressUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Optional;
import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class RemoteAddressHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(RemoteAddress.class) && parameter.getParameterType() == String.class;
    }

    @Nullable
    public Object resolveArgument(MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, NativeWebRequest webRequest, @Nullable WebDataBinderFactory binderFactory) {
        try {
            return this.doResolveArgument(parameter, webRequest);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public Object doResolveArgument(MethodParameter parameter, NativeWebRequest webRequest) {
        HttpServletRequest request = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        String ip = null;
        if (request != null && !StringUtils.hasText((String)(ip = RemoteAddressUtils.getIpAddress(request)))) {
            ip = null;
        }
        if (parameter.getParameterType() == String.class) {
            return ip;
        }
        if (parameter.getParameterType() == Optional.class) {
            return Optional.ofNullable(ip);
        }
        return null;
    }
}

