/*
 *
 * Copyright 2022-2025 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package com.github.yingzhuo.turbocharger.webmvc.databinding;

import com.github.yingzhuo.turbocharger.databinding.DirectMessageCodesResolver;
import com.github.yingzhuo.turbocharger.databinding.SmartBindingErrorProcessor;
import com.github.yingzhuo.turbocharger.webmvc.autoconfiguration.WebMvcAutoConfiguration;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.InitBinder;

/**
 * @author 应卓
 * @see WebMvcAutoConfiguration
 * @since 3.3.1
 */
@ControllerAdvice
public class DataBinderInitializingAdvice {

	@InitBinder
	public void init(WebDataBinder dataBinder) {
		dataBinder.setMessageCodesResolver(DirectMessageCodesResolver.getInstance());
		dataBinder.setBindingErrorProcessor(SmartBindingErrorProcessor.getInstance());
	}

}
