/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.webcli.cli;

import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.lang.Nullable;
import spring.turbo.util.crypto.keystore.KeyStoreFormat;

public class Apache5ClientHttpRequestFactoryBean
implements FactoryBean<ClientHttpRequestFactory>,
InitializingBean {
    private static final String HTTPS = URIScheme.HTTPS.getId();
    private static final String HTTP = URIScheme.HTTP.getId();
    @Nullable
    private Resource clientSideCertificate;
    @Nullable
    private KeyStoreFormat clientSideCertificateFormat = KeyStoreFormat.PKCS12;
    @Nullable
    private String clientSideCertificatePassword;
    @Nullable
    private Duration connectTimeout;
    @Nullable
    private Duration requestTimeout;
    private HttpComponentsClientHttpRequestFactory factory = null;

    public ClientHttpRequestFactory getObject() {
        return this.factory;
    }

    public Class<?> getObjectType() {
        return ClientHttpRequestFactory.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        SSLContext sslContext = this.createSSLContext(this.clientSideCertificate, this.clientSideCertificateFormat, this.clientSideCertificatePassword);
        Registry socketRegistry = RegistryBuilder.create().register(HTTPS, (Object)new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).register(HTTP, (Object)new PlainConnectionSocketFactory()).build();
        CloseableHttpClient httpClient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager(socketRegistry)).setConnectionManagerShared(true).build();
        this.factory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
        Optional.ofNullable(this.requestTimeout).ifPresent(d -> this.factory.setConnectionRequestTimeout(d));
        Optional.ofNullable(this.connectTimeout).ifPresent(d -> this.factory.setConnectTimeout(d));
    }

    private SSLContext createSSLContext(@Nullable Resource clientSideCertificate, @Nullable KeyStoreFormat clientSideCertificateFormat, @Nullable String clientSideCertificatePassword) throws Exception {
        KeyStore keyStore = null;
        if (clientSideCertificate != null && clientSideCertificatePassword != null) {
            String ksf = Optional.ofNullable(clientSideCertificateFormat).map(KeyStoreFormat::getValue).orElseGet(KeyStore::getDefaultType);
            keyStore = KeyStore.getInstance(ksf);
            keyStore.load(clientSideCertificate.getInputStream(), clientSideCertificatePassword.toCharArray());
        }
        SSLContextBuilder contextBuilder = SSLContextBuilder.create().loadTrustMaterial((TrustStrategy)new TrustEverythingTrustStrategy());
        if (keyStore != null) {
            contextBuilder.loadKeyMaterial(keyStore, clientSideCertificatePassword.toCharArray());
        }
        return contextBuilder.build();
    }

    public void setClientSideCertificate(@Nullable Resource clientSideCertificate) {
        this.clientSideCertificate = clientSideCertificate;
    }

    public void setClientSideCertificateFormat(@Nullable KeyStoreFormat clientSideCertificateFormat) {
        this.clientSideCertificateFormat = clientSideCertificateFormat;
    }

    public void setClientSideCertificatePassword(@Nullable String clientSideCertificatePassword) {
        this.clientSideCertificatePassword = clientSideCertificatePassword;
    }

    public void setRequestTimeout(@Nullable Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public void setConnectTimeout(@Nullable Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    private static class TrustEverythingTrustStrategy
    implements TrustStrategy {
        private TrustEverythingTrustStrategy() {
        }

        public boolean isTrusted(X509Certificate[] chain, String authType) {
            return true;
        }
    }
}

