/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.webcli.annotation;

import java.util.Iterator;
import org.springframework.core.env.Environment;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.support.RestClientAdapter;
import org.springframework.web.service.invoker.HttpExchangeAdapter;
import org.springframework.web.service.invoker.HttpServiceArgumentResolver;
import org.springframework.web.service.invoker.HttpServiceProxyFactory;
import spring.turbo.bean.classpath.ClassDefinition;
import spring.turbo.module.webcli.annotation.ArgumentResolversSupplier;
import spring.turbo.module.webcli.annotation.RestClientSupplier;
import spring.turbo.util.function.GenericGenerator;

class RestClientInterfaceGen
implements GenericGenerator {
    private final ClassDefinition classDef;
    private final Environment environment;
    private final RestClientSupplier restClientSupplier;
    private final ArgumentResolversSupplier globalArgumentResolversSupplier;
    private final ArgumentResolversSupplier argumentResolversSupplier;

    public RestClientInterfaceGen(ClassDefinition classDef, Environment environment, RestClientSupplier restClientSupplier, ArgumentResolversSupplier globalArgumentResolversSupplier, ArgumentResolversSupplier argumentResolversSupplier) {
        this.classDef = classDef;
        this.environment = environment;
        this.restClientSupplier = restClientSupplier;
        this.globalArgumentResolversSupplier = globalArgumentResolversSupplier;
        this.argumentResolversSupplier = argumentResolversSupplier;
    }

    public Object generate() {
        Object globalArgumentResolvers;
        RestClient restClient = this.restClientSupplier.get();
        RestClientAdapter adapter = RestClientAdapter.create((RestClient)restClient);
        HttpServiceProxyFactory.Builder factoryBuilder = HttpServiceProxyFactory.builderFor((HttpExchangeAdapter)adapter).embeddedValueResolver(arg_0 -> ((Environment)this.environment).resolvePlaceholders(arg_0));
        Object argumentResolvers = this.argumentResolversSupplier.get();
        if (argumentResolvers != null) {
            Iterator iterator = argumentResolvers.iterator();
            while (iterator.hasNext()) {
                HttpServiceArgumentResolver argumentResolver = (HttpServiceArgumentResolver)iterator.next();
                if (argumentResolver == null) continue;
                factoryBuilder.customArgumentResolver(argumentResolver);
            }
        }
        if ((globalArgumentResolvers = this.globalArgumentResolversSupplier.get()) != null) {
            Iterator iterator = globalArgumentResolvers.iterator();
            while (iterator.hasNext()) {
                HttpServiceArgumentResolver globalArgumentResolver = (HttpServiceArgumentResolver)iterator.next();
                if (globalArgumentResolver == null) continue;
                factoryBuilder.customArgumentResolver(globalArgumentResolver);
            }
        }
        return factoryBuilder.build().createClient(this.classDef.getBeanClass());
    }
}

