/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.webcli.annotation;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.AutowireCandidateQualifier;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.TypeFilter;
import spring.turbo.bean.classpath.ClassDefinition;
import spring.turbo.bean.classpath.ClassPathScanner;
import spring.turbo.bean.classpath.PackageSet;
import spring.turbo.bean.classpath.TypeFilterFactories;
import spring.turbo.module.webcli.annotation.ArgumentResolversSupplier;
import spring.turbo.module.webcli.annotation.EnableRestClientInterfaces;
import spring.turbo.module.webcli.annotation.RestClientInterface;
import spring.turbo.module.webcli.annotation.RestClientInterfaceGen;
import spring.turbo.module.webcli.annotation.RestClientSupplier;
import spring.turbo.util.ClassUtils;
import spring.turbo.util.StringUtils;
import spring.turbo.util.reflection.InstanceUtils;

class EnableRestClientInterfacesConfiguration
implements ImportBeanDefinitionRegistrar {
    private static final Class<EnableRestClientInterfaces> IMPORTING_ANNOTATION_CLASS = EnableRestClientInterfaces.class;
    private final ClassLoader classLoader;
    private final Environment environment;
    private final ResourceLoader resourceLoader;

    public EnableRestClientInterfacesConfiguration(ClassLoader classLoader, Environment environment, ResourceLoader resourceLoader) {
        this.classLoader = classLoader;
        this.environment = environment;
        this.resourceLoader = resourceLoader;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry, BeanNameGenerator ng) {
        List classDefs;
        AnnotationAttributes importingAnnotationAttributes = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(IMPORTING_ANNOTATION_CLASS.getName(), false));
        if (importingAnnotationAttributes == null) {
            return;
        }
        PackageSet packageSet = PackageSet.newInstance().acceptPackages(importingAnnotationAttributes.getStringArray("basePackages")).acceptBaseClasses(importingAnnotationAttributes.getClassArray("basePackageClasses"));
        if (packageSet.isEmpty()) {
            packageSet.acceptPackages(new String[]{ClassUtils.getPackageName((String)importingClassMetadata.getClassName())});
        }
        if (!(classDefs = ClassPathScanner.builder().classLoader(this.classLoader).resourceLoader(this.resourceLoader).environment(this.environment).includeFilter(new TypeFilter[]{TypeFilterFactories.all((TypeFilter[])new TypeFilter[]{TypeFilterFactories.isInterface(), TypeFilterFactories.isNotPackageInfo(), TypeFilterFactories.hasAnnotation(RestClientInterface.class)})}).build().scan(packageSet)).isEmpty()) {
            Class globalArgumentResolversSupplierClass = importingAnnotationAttributes.getClass("globalArgumentResolversSupplier");
            ArgumentResolversSupplier globalArgumentResolversSupplier = (ArgumentResolversSupplier)InstanceUtils.newInstanceElseThrow((Class)globalArgumentResolversSupplierClass);
            for (ClassDefinition classDef : classDefs) {
                this.registerOne(registry, ng, classDef, globalArgumentResolversSupplier);
            }
        }
    }

    private void registerOne(BeanDefinitionRegistry registry, BeanNameGenerator nameGen, ClassDefinition classDef, ArgumentResolversSupplier globalArgumentResolversSupplier) {
        RestClientInterface metaAnnotation = (RestClientInterface)classDef.getRequiredAnnotation(RestClientInterface.class);
        RestClientSupplier clientSupplier = (RestClientSupplier)InstanceUtils.newInstanceElseThrow(metaAnnotation.clientSupplier());
        ArgumentResolversSupplier argumentResolversSupplier = (ArgumentResolversSupplier)InstanceUtils.newInstanceElseThrow(metaAnnotation.argumentResolversSupplier());
        RestClientInterfaceGen interfaceGen = new RestClientInterfaceGen(classDef, this.environment, clientSupplier, globalArgumentResolversSupplier, argumentResolversSupplier);
        Class beanType = classDef.getBeanClass();
        AbstractBeanDefinition clientBeanDefinition = BeanDefinitionBuilder.genericBeanDefinition((Class)beanType, (Supplier)((Object)interfaceGen)).setPrimary(metaAnnotation.primary()).setLazyInit(classDef.isLazyInit()).setAbstract(false).setRole(classDef.getRole()).getBeanDefinition();
        this.addQualifiers(clientBeanDefinition, metaAnnotation.qualifiers());
        String beanName = metaAnnotation.value();
        if (beanName.isBlank()) {
            beanName = nameGen.generateBeanName((BeanDefinition)clientBeanDefinition, registry);
        }
        registry.registerBeanDefinition(beanName, (BeanDefinition)clientBeanDefinition);
    }

    private void addQualifiers(AbstractBeanDefinition beanDefinition, String ... qualifiers) {
        for (String qualifier : qualifiers) {
            if (!StringUtils.isNotBlank((String)qualifier)) continue;
            beanDefinition.addQualifier(new AutowireCandidateQualifier(Qualifier.class, (Object)qualifier));
        }
    }
}

