/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.webcli.cli;

import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.lang.Nullable;
import spring.turbo.util.crypto.keystore.KeyStoreFormat;

public class Apache5ClientHttpRequestFactoryBean
implements FactoryBean<ClientHttpRequestFactory>,
InitializingBean {
    private static final String HTTPS = URIScheme.HTTPS.getId();
    private static final String HTTP = URIScheme.HTTP.getId();
    @Nullable
    private Resource clientSideCertificate;
    @Nullable
    private KeyStoreFormat clientSideCertificateFormat = KeyStoreFormat.PKCS12;
    @Nullable
    private String clientSideCertificatePassword;
    @Nullable
    private Duration connectTimeout;
    @Nullable
    private Duration requestTimeout;
    private HttpComponentsClientHttpRequestFactory factory = null;

    public ClientHttpRequestFactory getObject() {
        return this.factory;
    }

    public Class<?> getObjectType() {
        return ClientHttpRequestFactory.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        SSLContext sSLContext = this.createSSLContext(this.clientSideCertificate, this.clientSideCertificateFormat, this.clientSideCertificatePassword);
        Registry registry = RegistryBuilder.create().register(HTTPS, (Object)new SSLConnectionSocketFactory(sSLContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).register(HTTP, (Object)new PlainConnectionSocketFactory()).build();
        CloseableHttpClient closeableHttpClient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager(registry)).setConnectionManagerShared(true).build();
        this.factory = new HttpComponentsClientHttpRequestFactory((HttpClient)closeableHttpClient);
        Optional.ofNullable(this.requestTimeout).ifPresent(duration -> this.factory.setConnectionRequestTimeout(duration));
        Optional.ofNullable(this.connectTimeout).ifPresent(duration -> this.factory.setConnectTimeout(duration));
    }

    private SSLContext createSSLContext(@Nullable Resource resource, @Nullable KeyStoreFormat keyStoreFormat, @Nullable String string) throws Exception {
        Object object;
        KeyStore keyStore = null;
        if (resource != null && string != null) {
            object = Optional.ofNullable(keyStoreFormat).map(KeyStoreFormat::getValue).orElseGet(KeyStore::getDefaultType);
            keyStore = KeyStore.getInstance((String)object);
            keyStore.load(resource.getInputStream(), string.toCharArray());
        }
        object = SSLContextBuilder.create().loadTrustMaterial((TrustStrategy)new TrustEverythingTrustStrategy());
        if (keyStore != null) {
            object.loadKeyMaterial(keyStore, string.toCharArray());
        }
        return object.build();
    }

    public void setClientSideCertificate(@Nullable Resource resource) {
        this.clientSideCertificate = resource;
    }

    public void setClientSideCertificateFormat(@Nullable KeyStoreFormat keyStoreFormat) {
        this.clientSideCertificateFormat = keyStoreFormat;
    }

    public void setClientSideCertificatePassword(@Nullable String string) {
        this.clientSideCertificatePassword = string;
    }

    public void setRequestTimeout(@Nullable Duration duration) {
        this.requestTimeout = duration;
    }

    public void setConnectTimeout(@Nullable Duration duration) {
        this.connectTimeout = duration;
    }

    private static class TrustEverythingTrustStrategy
    implements TrustStrategy {
        private TrustEverythingTrustStrategy() {
        }

        public boolean isTrusted(X509Certificate[] x509CertificateArray, String string) {
            return true;
        }
    }
}

