/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.webcli.annotation;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.AutowireCandidateQualifier;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.TypeFilter;
import spring.turbo.bean.classpath.ClassDefinition;
import spring.turbo.bean.classpath.ClassPathScanner;
import spring.turbo.bean.classpath.PackageSet;
import spring.turbo.bean.classpath.TypeFilterFactories;
import spring.turbo.module.webcli.annotation.ArgumentResolversSupplier;
import spring.turbo.module.webcli.annotation.EnableRestClientInterfaces;
import spring.turbo.module.webcli.annotation.RestClientInterface;
import spring.turbo.module.webcli.annotation.RestClientInterfaceGen;
import spring.turbo.module.webcli.annotation.RestClientSupplier;
import spring.turbo.util.ClassUtils;
import spring.turbo.util.StringUtils;
import spring.turbo.util.reflection.InstanceUtils;

class EnableRestClientInterfacesConfiguration
implements ImportBeanDefinitionRegistrar {
    private static final Class<EnableRestClientInterfaces> IMPORTING_ANNOTATION_CLASS = EnableRestClientInterfaces.class;
    private final ClassLoader classLoader;
    private final Environment environment;
    private final ResourceLoader resourceLoader;

    public EnableRestClientInterfacesConfiguration(ClassLoader classLoader, Environment environment, ResourceLoader resourceLoader) {
        this.classLoader = classLoader;
        this.environment = environment;
        this.resourceLoader = resourceLoader;
    }

    public void registerBeanDefinitions(AnnotationMetadata annotationMetadata, BeanDefinitionRegistry beanDefinitionRegistry, BeanNameGenerator beanNameGenerator) {
        List list;
        AnnotationAttributes annotationAttributes = AnnotationAttributes.fromMap((Map)annotationMetadata.getAnnotationAttributes(IMPORTING_ANNOTATION_CLASS.getName(), false));
        if (annotationAttributes == null) {
            return;
        }
        PackageSet packageSet = PackageSet.newInstance().acceptPackages(annotationAttributes.getStringArray("basePackages")).acceptBaseClasses(annotationAttributes.getClassArray("basePackageClasses"));
        if (packageSet.isEmpty()) {
            packageSet.acceptPackages(new String[]{ClassUtils.getPackageName((String)annotationMetadata.getClassName())});
        }
        if (!(list = ClassPathScanner.builder().classLoader(this.classLoader).resourceLoader(this.resourceLoader).environment(this.environment).includeFilter(new TypeFilter[]{TypeFilterFactories.all((TypeFilter[])new TypeFilter[]{TypeFilterFactories.isInterface(), TypeFilterFactories.isNotPackageInfo(), TypeFilterFactories.hasAnnotation(RestClientInterface.class)})}).build().scan(packageSet)).isEmpty()) {
            Class clazz = annotationAttributes.getClass("globalArgumentResolversSupplier");
            ArgumentResolversSupplier argumentResolversSupplier = (ArgumentResolversSupplier)InstanceUtils.newInstanceElseThrow((Class)clazz);
            for (ClassDefinition classDefinition : list) {
                this.registerOne(beanDefinitionRegistry, beanNameGenerator, classDefinition, argumentResolversSupplier);
            }
        }
    }

    private void registerOne(BeanDefinitionRegistry beanDefinitionRegistry, BeanNameGenerator beanNameGenerator, ClassDefinition classDefinition, ArgumentResolversSupplier argumentResolversSupplier) {
        RestClientInterface restClientInterface = (RestClientInterface)classDefinition.getRequiredAnnotation(RestClientInterface.class);
        RestClientSupplier restClientSupplier = (RestClientSupplier)InstanceUtils.newInstanceElseThrow(restClientInterface.clientSupplier());
        ArgumentResolversSupplier argumentResolversSupplier2 = (ArgumentResolversSupplier)InstanceUtils.newInstanceElseThrow(restClientInterface.argumentResolversSupplier());
        RestClientInterfaceGen restClientInterfaceGen = new RestClientInterfaceGen(classDefinition, this.environment, restClientSupplier, argumentResolversSupplier, argumentResolversSupplier2);
        Class clazz = classDefinition.getBeanClass();
        AbstractBeanDefinition abstractBeanDefinition = BeanDefinitionBuilder.genericBeanDefinition((Class)clazz, (Supplier)((Object)restClientInterfaceGen)).setPrimary(restClientInterface.primary()).setLazyInit(classDefinition.isLazyInit()).setAbstract(false).setRole(classDefinition.getRole()).getBeanDefinition();
        this.addQualifiers(abstractBeanDefinition, restClientInterface.qualifiers());
        String string = restClientInterface.value();
        if (string.isBlank()) {
            string = beanNameGenerator.generateBeanName((BeanDefinition)abstractBeanDefinition, beanDefinitionRegistry);
        }
        beanDefinitionRegistry.registerBeanDefinition(string, (BeanDefinition)abstractBeanDefinition);
    }

    private void addQualifiers(AbstractBeanDefinition abstractBeanDefinition, String ... stringArray) {
        for (String string : stringArray) {
            if (!StringUtils.isNotBlank((String)string)) continue;
            abstractBeanDefinition.addQualifier(new AutowireCandidateQualifier(Qualifier.class, (Object)string));
        }
    }
}

