/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *    ____             _            _____           _
 *   / ___| _ __  _ __(_)_ __   __ |_   _|   _ _ __| |__   ___
 *   \___ \| '_ \| '__| | '_ \ / _` || || | | | '__| '_ \ / _ \
 *    ___) | |_) | |  | | | | | (_| || || |_| | |  | |_) | (_) |
 *   |____/| .__/|_|  |_|_| |_|\__, ||_| \__,_|_|  |_.__/ \___/
 *         |_|                 |___/   https://github.com/yingzhuo/spring-turbo
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
package spring.turbo.module.security.token;

import org.springframework.http.HttpHeaders;

/**
 * HTTP Bearer 令牌解析器
 *
 * @author 应卓
 *
 * @see HeaderTokenResolver
 * @see BasicTokenResolver
 * @see HttpHeaders#AUTHORIZATION
 *
 * @since 1.0.5
 */
public final class BearerTokenResolver extends HeaderTokenResolver {

    private static final String PREFIX = "Bearer ";

    /**
     * 构造方法
     */
    public BearerTokenResolver() {
        super(HttpHeaders.AUTHORIZATION, PREFIX);
    }

}
