/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *    ____             _            _____           _
 *   / ___| _ __  _ __(_)_ __   __ |_   _|   _ _ __| |__   ___
 *   \___ \| '_ \| '__| | '_ \ / _` || || | | | '__| '_ \ / _ \
 *    ___) | |_) | |  | | | | | (_| || || |_| | |  | |_) | (_) |
 *   |____/| .__/|_|  |_|_| |_|\__, ||_| \__,_|_|  |_.__/ \___/
 *         |_|                 |___/   https://github.com/yingzhuo/spring-turbo
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
package spring.turbo.module.security.filter;

import jakarta.servlet.Filter;
import spring.turbo.module.security.FilterConfiguration;

/**
 * @author 应卓
 *
 * @since 1.2.3
 */
public interface BasicAuthenticationFilterFactory extends FilterConfiguration<BasicAuthenticationFilter> {

    @Override
    public default Class<? extends Filter> positionInChain() {
        return org.springframework.security.web.authentication.www.BasicAuthenticationFilter.class;
    }

    @Override
    public default Position position() {
        return Position.REPLACE;
    }

}
