/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.security.util;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.security.web.servlet.util.matcher.MvcRequestMatcher;
import org.springframework.security.web.util.matcher.AndRequestMatcher;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.DispatcherTypeRequestMatcher;
import org.springframework.security.web.util.matcher.IpAddressMatcher;
import org.springframework.security.web.util.matcher.MediaTypeRequestMatcher;
import org.springframework.security.web.util.matcher.NegatedRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RegexRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.servlet.handler.HandlerMappingIntrospector;
import spring.turbo.util.ArrayUtils;
import spring.turbo.util.Asserts;

public final class RequestMatcherFactories {
    private RequestMatcherFactories() {
    }

    public static RequestMatcher or(RequestMatcher ... requestMatcherArray) {
        Asserts.notNull((Object)requestMatcherArray);
        Asserts.notEmpty((Object[])requestMatcherArray);
        Asserts.noNullElements((Object[])requestMatcherArray);
        return new OrRequestMatcher(requestMatcherArray);
    }

    public static RequestMatcher and(RequestMatcher ... requestMatcherArray) {
        Asserts.notNull((Object)requestMatcherArray);
        Asserts.notEmpty((Object[])requestMatcherArray);
        Asserts.noNullElements((Object[])requestMatcherArray);
        return new AndRequestMatcher(requestMatcherArray);
    }

    public static RequestMatcher not(RequestMatcher requestMatcher) {
        Asserts.notNull((Object)requestMatcher);
        return new NegatedRequestMatcher(requestMatcher);
    }

    public static RequestMatcher alwaysTrue() {
        return AnyRequestMatcher.INSTANCE;
    }

    public static RequestMatcher alwaysFalse() {
        return httpServletRequest -> false;
    }

    public static RequestMatcher fromPredicate(Predicate<HttpServletRequest> predicate) {
        Asserts.notNull(predicate);
        return predicate::test;
    }

    public static RequestMatcher antPaths(HttpMethod httpMethod, String ... stringArray) {
        return RequestMatcherFactories.antPaths(httpMethod, false, stringArray);
    }

    public static RequestMatcher antPaths(HttpMethod httpMethod, boolean bl, String ... stringArray) {
        Asserts.notNull((Object)stringArray);
        Asserts.notEmpty((Object[])stringArray);
        Asserts.noNullElements((Object[])stringArray);
        if (ArrayUtils.length((Object[])stringArray) == 1) {
            return new AntPathRequestMatcher(stringArray[0], httpMethod.name(), bl);
        }
        ArrayList<AntPathRequestMatcher> arrayList = new ArrayList<AntPathRequestMatcher>();
        for (String string : stringArray) {
            arrayList.add(new AntPathRequestMatcher(string, httpMethod.name(), bl));
        }
        return new OrRequestMatcher(arrayList.toArray(new RequestMatcher[0]));
    }

    public static RequestMatcher mvcPatterns(HandlerMappingIntrospector handlerMappingIntrospector, String ... stringArray) {
        Asserts.notNull((Object)handlerMappingIntrospector);
        Asserts.notNull((Object)stringArray);
        Asserts.notEmpty((Object[])stringArray);
        Asserts.noNullElements((Object[])stringArray);
        if (ArrayUtils.length((Object[])stringArray) == 1) {
            return new MvcRequestMatcher.Builder(handlerMappingIntrospector).pattern(stringArray[0]);
        }
        ArrayList<MvcRequestMatcher> arrayList = new ArrayList<MvcRequestMatcher>();
        for (String string : stringArray) {
            arrayList.add(new MvcRequestMatcher.Builder(handlerMappingIntrospector).pattern(string));
        }
        return new OrRequestMatcher(arrayList.toArray(new RequestMatcher[0]));
    }

    public static RequestMatcher mvcPatterns(HandlerMappingIntrospector handlerMappingIntrospector, HttpMethod httpMethod, String ... stringArray) {
        Asserts.notNull((Object)handlerMappingIntrospector);
        Asserts.notNull((Object)httpMethod);
        Asserts.notNull((Object)stringArray);
        Asserts.notEmpty((Object[])stringArray);
        Asserts.noNullElements((Object[])stringArray);
        if (ArrayUtils.length((Object[])stringArray) == 1) {
            return new MvcRequestMatcher.Builder(handlerMappingIntrospector).pattern(httpMethod, stringArray[0]);
        }
        ArrayList<MvcRequestMatcher> arrayList = new ArrayList<MvcRequestMatcher>();
        for (String string : stringArray) {
            arrayList.add(new MvcRequestMatcher.Builder(handlerMappingIntrospector).pattern(httpMethod, string));
        }
        return new OrRequestMatcher(arrayList.toArray(new RequestMatcher[0]));
    }

    public static RequestMatcher regexPatterns(String ... stringArray) {
        Asserts.notNull((Object)stringArray);
        Asserts.notEmpty((Object[])stringArray);
        Asserts.noNullElements((Object[])stringArray);
        if (ArrayUtils.length((Object[])stringArray) == 1) {
            return RegexRequestMatcher.regexMatcher((String)stringArray[0]);
        }
        ArrayList<RegexRequestMatcher> arrayList = new ArrayList<RegexRequestMatcher>();
        for (String string : stringArray) {
            arrayList.add(RegexRequestMatcher.regexMatcher((String)string));
        }
        return new OrRequestMatcher(arrayList.toArray(new RequestMatcher[0]));
    }

    public static RequestMatcher regexPatterns(HttpMethod httpMethod, String ... stringArray) {
        return RequestMatcherFactories.regexPatterns(httpMethod, false, stringArray);
    }

    public static RequestMatcher regexPatterns(HttpMethod httpMethod, boolean bl, String ... stringArray) {
        Asserts.notNull((Object)httpMethod);
        Asserts.notNull((Object)stringArray);
        Asserts.notEmpty((Object[])stringArray);
        Asserts.noNullElements((Object[])stringArray);
        if (ArrayUtils.length((Object[])stringArray) == 1) {
            return new RegexRequestMatcher(stringArray[0], httpMethod.name(), bl);
        }
        ArrayList<RegexRequestMatcher> arrayList = new ArrayList<RegexRequestMatcher>();
        for (String string : stringArray) {
            arrayList.add(new RegexRequestMatcher(string, httpMethod.name(), bl));
        }
        return new OrRequestMatcher(arrayList.toArray(new RequestMatcher[0]));
    }

    public static RequestMatcher ipAddress(String string) {
        Asserts.hasText((String)string);
        return new IpAddressMatcher(string);
    }

    public static RequestMatcher mediaType(MediaType ... mediaTypeArray) {
        Asserts.notNull((Object)mediaTypeArray);
        Asserts.noNullElements((Object[])mediaTypeArray);
        return new MediaTypeRequestMatcher(mediaTypeArray);
    }

    public static RequestMatcher dispatcherType(DispatcherType dispatcherType) {
        Asserts.notNull((Object)dispatcherType);
        return new DispatcherTypeRequestMatcher(dispatcherType);
    }

    public static RequestMatcher dispatcherType(DispatcherType dispatcherType, HttpMethod httpMethod) {
        Asserts.notNull((Object)dispatcherType);
        Asserts.notNull((Object)httpMethod);
        return new DispatcherTypeRequestMatcher(dispatcherType, httpMethod);
    }

    public static RequestMatcher header(String string, String string2) {
        Asserts.hasText((String)string);
        Asserts.hasText((String)string2);
        return httpServletRequest -> {
            String string3 = httpServletRequest.getHeader(string);
            if (string3 == null) {
                return false;
            }
            return Pattern.matches(string2, string3);
        };
    }

    public static RequestMatcher query(String string, String string2) {
        Asserts.hasText((String)string);
        Asserts.hasText((String)string2);
        return httpServletRequest -> {
            String string3 = httpServletRequest.getParameter(string);
            if (string3 == null) {
                return false;
            }
            return Pattern.matches(string2, string3);
        };
    }

    public static RequestMatcher isSecure() {
        return ServletRequest::isSecure;
    }

    public static RequestMatcher isNotSecure() {
        return httpServletRequest -> !httpServletRequest.isSecure();
    }

    public static RequestMatcher defaultKubernetesProps(HandlerMappingIntrospector handlerMappingIntrospector) {
        return RequestMatcherFactories.kubernetesProps(handlerMappingIntrospector, HttpMethod.GET, "/actuator", "/actuator/*", "/actuator/*/*");
    }

    public static RequestMatcher kubernetesProps(HandlerMappingIntrospector handlerMappingIntrospector, HttpMethod httpMethod, String ... stringArray) {
        return RequestMatcherFactories.and(RequestMatcherFactories.mvcPatterns(handlerMappingIntrospector, httpMethod, stringArray), RequestMatcherFactories.header("User-Agent", "^.*kube-probe/.*$"));
    }
}

