/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.security.util;

import java.util.Objects;
import org.springframework.lang.Nullable;
import org.springframework.security.access.hierarchicalroles.NullRoleHierarchy;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.authorization.AuthorityAuthorizationManager;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.core.Authentication;

public final class AuthorizationManagerFactories {
    private static final RoleHierarchy DEFAULT_ROLE_HIERARCHY = new NullRoleHierarchy();
    private static final AuthenticationTrustResolver DEFAULT_AUTHENTICATION_TRUST_RESOLVER = new AuthenticationTrustResolverImpl();

    private AuthorizationManagerFactories() {
    }

    public static <T> AuthorizationManager<T> permitAll() {
        return (supplier, object) -> new AuthorizationDecision(true);
    }

    public static <T> AuthorizationManager<T> denyAll() {
        return (supplier, object) -> new AuthorizationDecision(false);
    }

    public static <T> AuthorizationManager<T> authenticated() {
        return AuthorizationManagerFactories.authenticated(null);
    }

    public static <T> AuthorizationManager<T> authenticated(@Nullable AuthenticationTrustResolver authenticationTrustResolver) {
        AuthenticationTrustResolver authenticationTrustResolver2 = AuthorizationManagerFactories.enforceAuthenticationTrustResolver(authenticationTrustResolver);
        return (supplier, object) -> {
            Authentication authentication = (Authentication)supplier.get();
            return new AuthorizationDecision(authentication != null && authentication.isAuthenticated() && !authenticationTrustResolver2.isAnonymous(authentication));
        };
    }

    public static <T> AuthorizationManager<T> fullyAuthenticated() {
        return AuthorizationManagerFactories.fullyAuthenticated(null);
    }

    public static <T> AuthorizationManager<T> fullyAuthenticated(@Nullable AuthenticationTrustResolver authenticationTrustResolver) {
        AuthenticationTrustResolver authenticationTrustResolver2 = AuthorizationManagerFactories.enforceAuthenticationTrustResolver(authenticationTrustResolver);
        return (supplier, object) -> {
            Authentication authentication = (Authentication)supplier.get();
            return new AuthorizationDecision(authentication != null && !authenticationTrustResolver2.isAnonymous(authentication) && authentication.isAuthenticated() && !authenticationTrustResolver2.isRememberMe(authentication));
        };
    }

    public static <T> AuthorizationManager<T> anonymous() {
        return AuthorizationManagerFactories.anonymous(null);
    }

    public static <T> AuthorizationManager<T> anonymous(@Nullable AuthenticationTrustResolver authenticationTrustResolver) {
        AuthenticationTrustResolver authenticationTrustResolver2 = AuthorizationManagerFactories.enforceAuthenticationTrustResolver(authenticationTrustResolver);
        return (supplier, object) -> {
            Authentication authentication = (Authentication)supplier.get();
            return new AuthorizationDecision(authentication != null && authenticationTrustResolver2.isAnonymous(authentication));
        };
    }

    public static <T> AuthorizationManager<T> rememberMe() {
        return AuthorizationManagerFactories.rememberMe(null);
    }

    public static <T> AuthorizationManager<T> rememberMe(@Nullable AuthenticationTrustResolver authenticationTrustResolver) {
        AuthenticationTrustResolver authenticationTrustResolver2 = AuthorizationManagerFactories.enforceAuthenticationTrustResolver(authenticationTrustResolver);
        return (supplier, object) -> {
            Authentication authentication = (Authentication)supplier.get();
            return new AuthorizationDecision(authentication != null && authenticationTrustResolver2.isRememberMe(authentication));
        };
    }

    public static <T> AuthorizationManager<T> hasRole(String string) {
        return AuthorizationManagerFactories.hasRole(null, string);
    }

    public static <T> AuthorizationManager<T> hasRole(@Nullable RoleHierarchy roleHierarchy, String string) {
        roleHierarchy = AuthorizationManagerFactories.enforceRoleHierarchy(roleHierarchy);
        AuthorityAuthorizationManager authorityAuthorizationManager = AuthorityAuthorizationManager.hasRole((String)string);
        authorityAuthorizationManager.setRoleHierarchy(roleHierarchy);
        return authorityAuthorizationManager;
    }

    public static <T> AuthorizationManager<T> hasAuthority(String string) {
        return AuthorityAuthorizationManager.hasAuthority((String)string);
    }

    public static <T> AuthorizationManager<T> hasAnyRole(String ... stringArray) {
        return AuthorizationManagerFactories.hasAnyRole(null, stringArray);
    }

    public static <T> AuthorizationManager<T> hasAnyRole(@Nullable RoleHierarchy roleHierarchy, String ... stringArray) {
        roleHierarchy = AuthorizationManagerFactories.enforceRoleHierarchy(roleHierarchy);
        AuthorityAuthorizationManager authorityAuthorizationManager = AuthorityAuthorizationManager.hasAnyRole((String[])stringArray);
        authorityAuthorizationManager.setRoleHierarchy(roleHierarchy);
        return authorityAuthorizationManager;
    }

    public static <T> AuthorizationManager<T> hasAnyAuthority(String ... stringArray) {
        return AuthorityAuthorizationManager.hasAnyAuthority((String[])stringArray);
    }

    private static AuthenticationTrustResolver enforceAuthenticationTrustResolver(@Nullable AuthenticationTrustResolver authenticationTrustResolver) {
        return Objects.requireNonNullElse(authenticationTrustResolver, DEFAULT_AUTHENTICATION_TRUST_RESOLVER);
    }

    private static RoleHierarchy enforceRoleHierarchy(@Nullable RoleHierarchy roleHierarchy) {
        return Objects.requireNonNullElse(roleHierarchy, DEFAULT_ROLE_HIERARCHY);
    }
}

