/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.security.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.lang.Nullable;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import spring.turbo.util.CollectionUtils;
import spring.turbo.util.StringUtils;

public final class AuthorityUtils {
    private static final List<GrantedAuthority> NO_AUTHORITIES = Collections.emptyList();

    private AuthorityUtils() {
    }

    public static List<GrantedAuthority> noAuthorities() {
        return NO_AUTHORITIES;
    }

    public static List<GrantedAuthority> getAuthorities(@Nullable UserDetails userDetails) {
        if (userDetails == null) {
            return NO_AUTHORITIES;
        }
        Collection collection = userDetails.getAuthorities();
        if (CollectionUtils.isEmpty((Collection)collection)) {
            return NO_AUTHORITIES;
        }
        return collection.stream().filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
    }

    public static List<GrantedAuthority> createAuthorityList(String ... stringArray) {
        ArrayList<SimpleGrantedAuthority> arrayList = new ArrayList<SimpleGrantedAuthority>();
        if (stringArray != null) {
            for (String string : stringArray) {
                if (string == null) continue;
                arrayList.add(new SimpleGrantedAuthority(string));
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static List<GrantedAuthority> commaSeparatedStringToAuthorityList(@Nullable String string) {
        if (StringUtils.isBlank((String)string)) {
            return NO_AUTHORITIES;
        }
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2 == null) continue;
            stringArray[i] = string2.trim();
        }
        return AuthorityUtils.createAuthorityList(stringArray);
    }
}

