/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.security.user;

import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import java.util.function.Function;
import org.springframework.lang.Nullable;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.User;
import spring.turbo.bean.Attributes;
import spring.turbo.module.security.user.UserDetailsPlus;
import spring.turbo.module.security.user.UserDetailsPlusImpl;
import spring.turbo.module.security.util.AuthorityUtils;

public final class UserDetailsPlusBuilder {
    private static final String DEFAULT_PASSWORD = "<NO PASSWORD>";
    private final User.UserBuilder userBuilder = User.builder();
    private Attributes attributes = Attributes.newInstance();
    private boolean passwordFlag = false;
    @Nullable
    private Object id;
    @Nullable
    private String nickname;
    @Nullable
    private Object gender;
    @Nullable
    private Object avatar;
    @Nullable
    private Object nativeUser;
    @Nullable
    private String email;
    @Nullable
    private String phoneNumber;
    @Nullable
    private Date dateOfBirth;
    @Nullable
    private String biography;
    @Nullable
    private String nationality;
    @Nullable
    private String location;
    @Nullable
    private String url;

    UserDetailsPlusBuilder() {
    }

    public UserDetailsPlusBuilder username(String string) {
        this.userBuilder.username(string);
        return this;
    }

    public UserDetailsPlusBuilder password(String string) {
        this.passwordFlag = true;
        this.userBuilder.password(string);
        return this;
    }

    public UserDetailsPlusBuilder passwordEncoder(Function<String, String> function) {
        this.userBuilder.passwordEncoder(function);
        return this;
    }

    public UserDetailsPlusBuilder roles(String ... stringArray) {
        this.userBuilder.roles(stringArray);
        return this;
    }

    public UserDetailsPlusBuilder authorities(GrantedAuthority ... grantedAuthorityArray) {
        this.userBuilder.authorities(grantedAuthorityArray);
        return this;
    }

    public UserDetailsPlusBuilder authorities(Collection<? extends GrantedAuthority> collection) {
        this.userBuilder.authorities(collection);
        return this;
    }

    public UserDetailsPlusBuilder authorities(String ... stringArray) {
        this.userBuilder.authorities(stringArray);
        return this;
    }

    public UserDetailsPlusBuilder authoritiesWithCommaSeparatedString(String string) {
        return this.authorities(AuthorityUtils.commaSeparatedStringToAuthorityList(string));
    }

    public UserDetailsPlusBuilder accountExpired(boolean bl) {
        this.userBuilder.accountExpired(bl);
        return this;
    }

    public UserDetailsPlusBuilder accountLocked(boolean bl) {
        this.userBuilder.accountLocked(bl);
        return this;
    }

    public UserDetailsPlusBuilder credentialsExpired(boolean bl) {
        this.userBuilder.credentialsExpired(bl);
        return this;
    }

    public UserDetailsPlusBuilder disabled(boolean bl) {
        this.userBuilder.disabled(bl);
        return this;
    }

    public UserDetailsPlusBuilder id(Object object) {
        this.id = object;
        return this;
    }

    public UserDetailsPlusBuilder nickname(String string) {
        this.nickname = string;
        return this;
    }

    public UserDetailsPlusBuilder gender(Object object) {
        this.gender = object;
        return this;
    }

    public UserDetailsPlusBuilder avatar(Object object) {
        this.avatar = object;
        return this;
    }

    public UserDetailsPlusBuilder nativeUser(Object object) {
        this.nativeUser = object;
        return this;
    }

    public UserDetailsPlusBuilder email(String string) {
        this.email = string;
        return this;
    }

    public UserDetailsPlusBuilder phoneNumber(String string) {
        this.phoneNumber = string;
        return this;
    }

    public UserDetailsPlusBuilder dateOfBirth(Date date) {
        this.dateOfBirth = date;
        return this;
    }

    public UserDetailsPlusBuilder biography(String string) {
        this.biography = string;
        return this;
    }

    public UserDetailsPlusBuilder nationality(String string) {
        this.nationality = string;
        return this;
    }

    public UserDetailsPlusBuilder location(String string) {
        this.location = string;
        return this;
    }

    public UserDetailsPlusBuilder url(String string) {
        this.url = string;
        return this;
    }

    public UserDetailsPlusBuilder putAttribute(String string, Object object) {
        this.attributes.add((Object)string, object);
        return this;
    }

    public UserDetailsPlusBuilder setAttributes(@Nullable Attributes attributes) {
        this.attributes = Optional.ofNullable(attributes).orElseGet(Attributes::new);
        return this;
    }

    public UserDetailsPlus build() {
        if (!this.passwordFlag) {
            this.userBuilder.password(DEFAULT_PASSWORD);
        }
        return new UserDetailsPlusImpl(this.userBuilder.build(), this.id, this.nickname, this.gender, this.avatar, this.nativeUser, this.email, this.phoneNumber, this.dateOfBirth, this.biography, this.nationality, this.location, this.url, this.attributes);
    }
}

