/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.security.token.blacklist;

import java.time.Duration;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.lang.Nullable;
import spring.turbo.module.security.exception.BlacklistTokenException;
import spring.turbo.module.security.token.Token;
import spring.turbo.module.security.token.blacklist.TokenBlacklistManager;
import spring.turbo.util.Asserts;
import spring.turbo.util.StringFormatter;

public class RedisTokenBlacklistManager
implements TokenBlacklistManager {
    private final StringRedisTemplate redisTemplate;
    @Nullable
    private final Duration ttl;
    private String keyPrefix = "";
    private String keySuffix = "";

    public RedisTokenBlacklistManager(StringRedisTemplate stringRedisTemplate, @Nullable Duration duration) {
        Asserts.notNull((Object)stringRedisTemplate);
        this.redisTemplate = stringRedisTemplate;
        this.ttl = duration;
    }

    @Override
    public void save(Token token) {
        Asserts.notNull((Object)token);
        String string = this.getKey(token);
        String string2 = this.getValue(token);
        if (this.ttl == null) {
            this.redisTemplate.opsForValue().set((Object)string, (Object)string2);
        } else {
            this.redisTemplate.opsForValue().set((Object)string, (Object)string2, this.ttl);
        }
    }

    @Override
    public void verify(Token token) throws BlacklistTokenException {
        Asserts.notNull((Object)token);
        String string = this.getKey(token);
        if (this.redisTemplate.opsForValue().get((Object)string) != null) {
            String string2 = StringFormatter.format((String)"token \"{}\" is blacklisted", (Object)token.asString());
            throw new BlacklistTokenException(string2);
        }
    }

    protected String getKey(Token token) {
        return this.keyPrefix + token.asString() + this.keySuffix;
    }

    protected String getValue(Token token) {
        return token.asString();
    }

    public void setKeyPrefix(String string) {
        this.keyPrefix = string;
    }

    public void setKeySuffix(String string) {
        this.keySuffix = string;
    }
}

