/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.security.token;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import spring.turbo.module.security.token.BasicTokenResolver;
import spring.turbo.module.security.token.BearerTokenResolver;
import spring.turbo.module.security.token.CompositeTokenResolver;
import spring.turbo.module.security.token.HeaderTokenResolver;
import spring.turbo.module.security.token.NullTokenResolver;
import spring.turbo.module.security.token.QueryTokenResolver;
import spring.turbo.module.security.token.TokenResolver;
import spring.turbo.util.CollectionUtils;

public final class TokenResolverBuilder {
    private final List<TokenResolver> list = new ArrayList<TokenResolver>();

    TokenResolverBuilder() {
    }

    public TokenResolverBuilder add(TokenResolver ... tokenResolverArray) {
        CollectionUtils.nullSafeAddAll(this.list, (Object[])tokenResolverArray);
        return this;
    }

    public TokenResolverBuilder add(Collection<TokenResolver> collection) {
        CollectionUtils.nullSafeAddAll(this.list, collection);
        return this;
    }

    public TokenResolverBuilder fromHttpHeader(String string) {
        this.list.add(new HeaderTokenResolver(string));
        return this;
    }

    public TokenResolverBuilder fromHttpHeader(String string, String string2) {
        this.list.add(new HeaderTokenResolver(string, string2));
        return this;
    }

    public TokenResolverBuilder fromHttpQuery(String string) {
        this.list.add(new QueryTokenResolver(string));
        return this;
    }

    public TokenResolverBuilder fromHttpQuery(String string, String string2) {
        this.list.add(new QueryTokenResolver(string, string2));
        return this;
    }

    public TokenResolverBuilder bearerToken() {
        this.list.add(new BearerTokenResolver());
        return this;
    }

    public TokenResolverBuilder basicToken() {
        this.list.add(new BasicTokenResolver());
        return this;
    }

    public TokenResolver build() {
        if (this.list.isEmpty()) {
            return NullTokenResolver.getInstance();
        }
        if (this.list.size() == 1) {
            return this.list.get(0);
        }
        return new CompositeTokenResolver(this.list);
    }
}

