/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.security.token;

import java.util.Optional;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.web.context.request.WebRequest;
import spring.turbo.module.security.token.StringToken;
import spring.turbo.module.security.token.Token;
import spring.turbo.module.security.token.TokenResolver;
import spring.turbo.util.Asserts;
import spring.turbo.util.StringUtils;

public class QueryTokenResolver
implements TokenResolver {
    protected final String paramName;
    protected final String prefix;
    protected final int prefixLen;

    public QueryTokenResolver(@NonNull String string) {
        this(string, "");
    }

    public QueryTokenResolver(@NonNull String string, @Nullable String string2) {
        Asserts.hasText((String)string);
        if (string2 == null) {
            string2 = "";
        }
        this.paramName = string;
        this.prefix = string2;
        this.prefixLen = string2.length();
    }

    @Override
    @NonNull
    public Optional<Token> resolve(WebRequest webRequest) {
        String string = webRequest.getParameter(this.paramName);
        if (string == null || !string.startsWith(this.prefix)) {
            return Optional.empty();
        }
        if (StringUtils.isBlank((String)(string = string.substring(this.prefixLen)))) {
            return Optional.empty();
        }
        return Optional.of(StringToken.of(string));
    }

    @Override
    public int getOrder() {
        return -100;
    }

    public String getParamName() {
        return this.paramName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public int getPrefixLen() {
        return this.prefixLen;
    }
}

