/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.security.token;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.springframework.core.OrderComparator;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.web.context.request.WebRequest;
import spring.turbo.module.security.token.Token;
import spring.turbo.module.security.token.TokenResolver;
import spring.turbo.util.CollectionUtils;

public final class CompositeTokenResolver
implements TokenResolver {
    private final List<TokenResolver> resolvers = new ArrayList<TokenResolver>();

    public CompositeTokenResolver(TokenResolver ... tokenResolverArray) {
        CollectionUtils.nullSafeAddAll(this.resolvers, (Object[])tokenResolverArray);
        OrderComparator.sort(this.resolvers);
    }

    public CompositeTokenResolver(Collection<TokenResolver> collection) {
        CollectionUtils.nullSafeAddAll(this.resolvers, collection);
        OrderComparator.sort(this.resolvers);
    }

    public static CompositeTokenResolver of(TokenResolver ... tokenResolverArray) {
        return new CompositeTokenResolver(tokenResolverArray);
    }

    @Override
    @NonNull
    public Optional<Token> resolve(WebRequest webRequest) {
        for (TokenResolver tokenResolver : this.resolvers) {
            Optional<Token> optional = this.doResolve(tokenResolver, webRequest);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    private Optional<Token> doResolve(@Nullable TokenResolver tokenResolver, WebRequest webRequest) {
        try {
            if (tokenResolver != null) {
                return tokenResolver.resolve(webRequest);
            }
            return Optional.empty();
        }
        catch (Throwable throwable) {
            return Optional.empty();
        }
    }
}

