/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.security.token;

import java.util.Arrays;
import spring.turbo.module.security.token.Token;
import spring.turbo.util.Asserts;
import spring.turbo.util.HexUtils;

public final class BytesToken
implements Token {
    private final byte[] bytes;

    public BytesToken(byte[] byArray) {
        Asserts.notNull((Object)byArray);
        Asserts.isTrue((byArray.length > 0 ? 1 : 0) != 0);
        this.bytes = byArray;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public String asString() {
        return HexUtils.encodeToString((byte[])this.bytes);
    }

    @Override
    public String toString() {
        return this.asString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BytesToken bytesToken = (BytesToken)object;
        return Arrays.equals(this.bytes, bytesToken.bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }
}

