/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.security.jwt.algorithm;

import cn.hutool.crypto.SmUtil;
import cn.hutool.crypto.asymmetric.SM2;
import cn.hutool.jwt.signers.JWTSigner;
import cn.hutool.jwt.signers.JWTSignerUtil;
import java.io.InputStream;
import java.security.KeyPair;
import org.springframework.lang.Nullable;
import spring.turbo.core.ResourceLoaders;
import spring.turbo.module.security.jwt.algorithm.SM2JWTSinger;
import spring.turbo.util.crypto.KeyStorage;

public final class SignerFactories {
    private SignerFactories() {
    }

    public static JWTSigner none() {
        return JWTSignerUtil.none();
    }

    public static JWTSigner HS256(String string) {
        return JWTSignerUtil.hs256((byte[])string.getBytes());
    }

    public static JWTSigner HS384(String string) {
        return JWTSignerUtil.hs384((byte[])string.getBytes());
    }

    public static JWTSigner HS512(String string) {
        return JWTSignerUtil.hs512((byte[])string.getBytes());
    }

    public static JWTSigner RS256(KeyPair keyPair) {
        String string = "RS256";
        return JWTSignerUtil.createSigner((String)string, (KeyPair)keyPair);
    }

    public static JWTSigner RS256(String string, String string2) {
        InputStream inputStream = ResourceLoaders.getDefault().getResource(string).getInputStream();
        InputStream inputStream2 = ResourceLoaders.getDefault().getResource(string2).getInputStream();
        KeyPair keyPair = KeyStorage.loadKeys((String)"RSA", (InputStream)inputStream, (InputStream)inputStream2);
        return SignerFactories.RS256(keyPair);
    }

    public static JWTSigner RS384(KeyPair keyPair) {
        String string = "RS384";
        return JWTSignerUtil.createSigner((String)string, (KeyPair)keyPair);
    }

    public static JWTSigner RS384(String string, String string2) {
        InputStream inputStream = ResourceLoaders.getDefault().getResource(string).getInputStream();
        InputStream inputStream2 = ResourceLoaders.getDefault().getResource(string2).getInputStream();
        KeyPair keyPair = KeyStorage.loadKeys((String)"RSA", (InputStream)inputStream, (InputStream)inputStream2);
        return SignerFactories.RS384(keyPair);
    }

    public static JWTSigner RS512(KeyPair keyPair) {
        String string = "RS512";
        return JWTSignerUtil.createSigner((String)string, (KeyPair)keyPair);
    }

    public static JWTSigner RS512(String string, String string2) {
        InputStream inputStream = ResourceLoaders.getDefault().getResource(string).getInputStream();
        InputStream inputStream2 = ResourceLoaders.getDefault().getResource(string2).getInputStream();
        KeyPair keyPair = KeyStorage.loadKeys((String)"RSA", (InputStream)inputStream, (InputStream)inputStream2);
        return SignerFactories.RS512(keyPair);
    }

    public static JWTSigner ES256(KeyPair keyPair) {
        String string = "ES256";
        return JWTSignerUtil.createSigner((String)string, (KeyPair)keyPair);
    }

    public static JWTSigner ES256(String string, String string2) {
        InputStream inputStream = ResourceLoaders.getDefault().getResource(string).getInputStream();
        InputStream inputStream2 = ResourceLoaders.getDefault().getResource(string2).getInputStream();
        KeyPair keyPair = KeyStorage.loadKeys((String)"EC", (InputStream)inputStream, (InputStream)inputStream2);
        return SignerFactories.ES256(keyPair);
    }

    public static JWTSigner ES384(KeyPair keyPair) {
        String string = "ES384";
        return JWTSignerUtil.createSigner((String)string, (KeyPair)keyPair);
    }

    public static JWTSigner ES384(String string, String string2) {
        InputStream inputStream = ResourceLoaders.getDefault().getResource(string).getInputStream();
        InputStream inputStream2 = ResourceLoaders.getDefault().getResource(string2).getInputStream();
        KeyPair keyPair = KeyStorage.loadKeys((String)"EC", (InputStream)inputStream, (InputStream)inputStream2);
        return SignerFactories.ES384(keyPair);
    }

    public static JWTSigner ES512(KeyPair keyPair) {
        String string = "ES512";
        return JWTSignerUtil.createSigner((String)string, (KeyPair)keyPair);
    }

    public static JWTSigner ES512(String string, String string2) {
        InputStream inputStream = ResourceLoaders.getDefault().getResource(string).getInputStream();
        InputStream inputStream2 = ResourceLoaders.getDefault().getResource(string2).getInputStream();
        KeyPair keyPair = KeyStorage.loadKeys((String)"EC", (InputStream)inputStream, (InputStream)inputStream2);
        return SignerFactories.ES512(keyPair);
    }

    public static JWTSigner PS256(KeyPair keyPair) {
        String string = "PS256";
        return JWTSignerUtil.createSigner((String)string, (KeyPair)keyPair);
    }

    public static JWTSigner PS256(String string, String string2) {
        InputStream inputStream = ResourceLoaders.getDefault().getResource(string).getInputStream();
        InputStream inputStream2 = ResourceLoaders.getDefault().getResource(string2).getInputStream();
        KeyPair keyPair = KeyStorage.loadKeys((String)"RSA", (InputStream)inputStream, (InputStream)inputStream2);
        return SignerFactories.PS256(keyPair);
    }

    public static JWTSigner PS384(KeyPair keyPair) {
        String string = "PS384";
        return JWTSignerUtil.createSigner((String)string, (KeyPair)keyPair);
    }

    public static JWTSigner PS384(String string, String string2) {
        InputStream inputStream = ResourceLoaders.getDefault().getResource(string).getInputStream();
        InputStream inputStream2 = ResourceLoaders.getDefault().getResource(string2).getInputStream();
        KeyPair keyPair = KeyStorage.loadKeys((String)"RSA", (InputStream)inputStream, (InputStream)inputStream2);
        return SignerFactories.PS384(keyPair);
    }

    public static JWTSigner PS512(KeyPair keyPair) {
        String string = "PS512";
        return JWTSignerUtil.createSigner((String)string, (KeyPair)keyPair);
    }

    public static JWTSigner PS512(String string, String string2) {
        InputStream inputStream = ResourceLoaders.getDefault().getResource(string).getInputStream();
        InputStream inputStream2 = ResourceLoaders.getDefault().getResource(string2).getInputStream();
        KeyPair keyPair = KeyStorage.loadKeys((String)"RSA", (InputStream)inputStream, (InputStream)inputStream2);
        return SignerFactories.PS512(keyPair);
    }

    public static JWTSigner SM2(String string, String string2) {
        return SignerFactories.SM2(string, string2, null);
    }

    public static JWTSigner SM2(String string, String string2, @Nullable String string3) {
        SM2 sM2 = SmUtil.sm2((String)string2, (String)string);
        return new SM2JWTSinger(sM2, string3);
    }
}

