/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.security.jwt;

import cn.hutool.jwt.JWTUtil;
import cn.hutool.jwt.signers.JWTSigner;
import java.util.function.Supplier;
import org.springframework.lang.Nullable;
import spring.turbo.module.security.jwt.JwtTokenFactory;
import spring.turbo.util.Asserts;

public final class JwtTokenFactoryImpl
implements JwtTokenFactory {
    private final JWTSigner signer;
    private boolean overrideType = true;
    private boolean overrideAlgorithm = true;
    private boolean overrideIssueAt = true;
    @Nullable
    private Supplier<Nonce> nonceSupplier = null;
    @Nullable
    private Supplier<String> keyIdSupplier = null;

    public JwtTokenFactoryImpl(JWTSigner jWTSigner) {
        Asserts.notNull((Object)jWTSigner, (String)"signer is null");
        this.signer = jWTSigner;
    }

    @Override
    public String create(JwtTokenFactory.Data data) {
        Object object;
        if (this.overrideType) {
            data.type("JWT");
        }
        if (this.overrideAlgorithm) {
            data.algorithm(this.signer.getAlgorithmId());
        }
        if (this.keyIdSupplier != null && (object = this.keyIdSupplier.get()) != null) {
            data.keyId((String)object);
        }
        if (this.overrideIssueAt) {
            data.issuedAtNow();
        }
        if (this.nonceSupplier != null && (object = this.nonceSupplier.get()) != null) {
            String string;
            String string2 = ((Nonce)object).payloadName();
            Supplier<String> supplier = ((Nonce)object).supplier();
            String string3 = string = supplier != null ? supplier.get() : null;
            if (string2 != null && string != null) {
                data.addPayload("nonce", string);
            }
        }
        return JWTUtil.createToken(data.getHeaderMap(), data.getPayloadMap(), (JWTSigner)this.signer);
    }

    public JWTSigner getSigner() {
        return this.signer;
    }

    public void setOverrideType(boolean bl) {
        this.overrideType = bl;
    }

    public void setOverrideAlgorithm(boolean bl) {
        this.overrideAlgorithm = bl;
    }

    public void setOverrideIssueAt(boolean bl) {
        this.overrideIssueAt = bl;
    }

    public void setNonceSupplier(@Nullable Supplier<Nonce> supplier) {
        this.nonceSupplier = supplier;
    }

    public void setKeyIdSupplier(@Nullable Supplier<String> supplier) {
        this.keyIdSupplier = supplier;
    }

    public record Nonce(@Nullable String payloadName, @Nullable Supplier<String> supplier) {
    }
}

