/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.security.jwt;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface JwtTokenFactory {
    public String create(Data var1);

    public static final class Data
    implements Serializable {
        private final Map<String, Object> headerMap = new HashMap<String, Object>();
        private final Map<String, Object> payloadMap = new HashMap<String, Object>();

        private Data() {
        }

        public static Data newInstance() {
            return new Data();
        }

        public Data type(String string) {
            this.headerMap.put("typ", string);
            return this;
        }

        public Data keyId(String string) {
            this.headerMap.put("kid", string);
            return this;
        }

        public Data contentType(String string) {
            this.headerMap.put("cty", string);
            return this;
        }

        public Data algorithm(String string) {
            this.headerMap.put("alg", string);
            return this;
        }

        public Data issuer(String string) {
            this.payloadMap.put("iss", string);
            return this;
        }

        public Data subject(String string) {
            this.payloadMap.put("sub", string);
            return this;
        }

        public Data audience(String ... stringArray) {
            this.payloadMap.put("aud", stringArray);
            return this;
        }

        public Data expiresAt(Date date) {
            this.payloadMap.put("exp", date);
            return this;
        }

        public Data expiresAtFuture(Duration duration) {
            this.payloadMap.put("exp", new Date(System.currentTimeMillis() + duration.toMillis()));
            return this;
        }

        public Data notBefore(Date date) {
            this.payloadMap.put("nbf", date);
            return this;
        }

        public Data notBeforeAtFuture(Duration duration) {
            this.payloadMap.put("nbf", new Date(System.currentTimeMillis() + duration.toMillis()));
            return this;
        }

        public Data issuedAt(Date date) {
            this.payloadMap.put("iat", date);
            return this;
        }

        public Data issuedAtNow() {
            return this.issuedAt(new Date());
        }

        public Data jwtId(Object object) {
            this.payloadMap.put("jti", object);
            return this;
        }

        public Data addPayload(String string, Object object) {
            this.payloadMap.put(string, object);
            return this;
        }

        public Map<String, Object> getHeaderMap() {
            return Collections.unmodifiableMap(this.headerMap);
        }

        public Map<String, Object> getPayloadMap() {
            return Collections.unmodifiableMap(this.payloadMap);
        }
    }
}

