/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.security.jwt;

import cn.hutool.core.convert.NumberWithFormat;
import cn.hutool.json.JSONArray;
import cn.hutool.jwt.JWT;
import java.io.Serializable;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import spring.turbo.util.Asserts;

public final class JwtDecorator
implements Serializable {
    private final JWT jwt;

    private JwtDecorator(JWT jWT) {
        Asserts.notNull((Object)jWT, (String)"jwt is null");
        this.jwt = jWT;
    }

    public static JwtDecorator newInstance(JWT jWT) {
        return new JwtDecorator(jWT);
    }

    @NonNull
    public String getHeaderAlgorithm() {
        return (String)this.jwt.getHeader("alg");
    }

    @NonNull
    public String getHeaderKeyId() {
        return (String)this.jwt.getHeader("kid");
    }

    @NonNull
    public String getHeaderContentType() {
        return (String)this.jwt.getHeader("cty");
    }

    @NonNull
    public String getHeaderType() {
        return (String)this.jwt.getHeader("typ");
    }

    @Nullable
    public String getPayloadString(String string) {
        try {
            return (String)this.jwt.getPayload(string);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    @NonNull
    public String getPayloadRequiredString(String string) {
        String string2 = this.getPayloadString(string);
        Asserts.notNull((Object)string2);
        return string2;
    }

    @Nullable
    public Integer getPayloadInteger(String string) {
        try {
            return ((NumberWithFormat)this.jwt.getPayload(string)).intValue();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    @NonNull
    public Long getPayloadLong(String string) {
        return ((NumberWithFormat)this.jwt.getPayload(string)).longValue();
    }

    @NonNull
    public Long getPayloadRequiredLong(String string) {
        Long l = this.getPayloadLong(string);
        Asserts.notNull((Object)l);
        return l;
    }

    @Nullable
    public Double getPayloadDouble(String string) {
        try {
            return ((NumberWithFormat)this.jwt.getPayload(string)).doubleValue();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    @NonNull
    public Double getPayloadRequiredDouble(String string) {
        Double d = this.getPayloadDouble(string);
        Asserts.notNull((Object)d);
        return d;
    }

    @Nullable
    public String[] getPayloadStringArray(String string) {
        try {
            return (String[])((JSONArray)this.jwt.getPayload(string)).toArray(String[].class);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    @NonNull
    public String[] getPayloadRequiredStringArray(String string) {
        String[] stringArray = this.getPayloadStringArray(string);
        Asserts.notNull((Object)stringArray);
        return stringArray;
    }

    @Nullable
    public Integer[] getPayloadIntegerArray(String string) {
        try {
            return (Integer[])((JSONArray)this.jwt.getPayload(string)).toArray(Integer[].class);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    @NonNull
    public Integer[] getPayloadRequiredIntegerArray(String string) {
        Integer[] integerArray = this.getPayloadIntegerArray(string);
        Asserts.notNull((Object)integerArray);
        return integerArray;
    }

    @Nullable
    public Long[] getPayloadLongArray(String string) {
        try {
            return (Long[])((JSONArray)this.jwt.getPayload(string)).toArray(Long[].class);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    @NonNull
    public Long[] getPayloadRequiredLongArray(String string) {
        Long[] longArray = this.getPayloadLongArray(string);
        Asserts.notNull((Object)longArray);
        return longArray;
    }

    @Nullable
    public Double[] getPayloadDoubleArray(String string) {
        try {
            return (Double[])((JSONArray)this.jwt.getPayload(string)).toArray(Double[].class);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    @NonNull
    public Double[] getPayloadRequiredDoubleArray(String string) {
        Double[] doubleArray = this.getPayloadDoubleArray(string);
        Asserts.notNull((Object)doubleArray);
        return doubleArray;
    }

    public JWT getJwt() {
        return this.jwt;
    }
}

