/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.security.jwt;

import cn.hutool.core.exceptions.ValidateException;
import cn.hutool.jwt.JWT;
import cn.hutool.jwt.JWTValidator;
import cn.hutool.jwt.signers.JWTSigner;
import org.springframework.lang.Nullable;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import spring.turbo.module.security.authentication.TokenToUserConverter;
import spring.turbo.module.security.jwt.exception.BadJwtAlgorithmTokenException;
import spring.turbo.module.security.jwt.exception.BadJwtFormatTokenException;
import spring.turbo.module.security.jwt.exception.BadJwtTimeTokenException;
import spring.turbo.module.security.token.Token;
import spring.turbo.util.Asserts;

public abstract class AbstractJwtTokenToUserConverter
implements TokenToUserConverter {
    private final JWTSigner signer;

    public AbstractJwtTokenToUserConverter(JWTSigner jWTSigner) {
        Asserts.notNull((Object)jWTSigner);
        this.signer = jWTSigner;
    }

    @Override
    @Nullable
    public final UserDetails convert(@Nullable Token token) throws AuthenticationException {
        JWT jWT;
        if (token == null) {
            return null;
        }
        String string = token.asString();
        try {
            jWT = JWT.of((String)string);
        }
        catch (Exception exception) {
            throw new BadJwtFormatTokenException(exception.getMessage(), exception);
        }
        JWTValidator jWTValidator = JWTValidator.of((JWT)jWT);
        try {
            jWTValidator.validateAlgorithm(this.signer);
        }
        catch (ValidateException validateException) {
            throw new BadJwtAlgorithmTokenException(validateException.getMessage(), validateException);
        }
        try {
            jWTValidator.validateDate();
        }
        catch (ValidateException validateException) {
            throw new BadJwtTimeTokenException(validateException.getMessage(), validateException);
        }
        return this.doAuthenticate(string, jWT);
    }

    @Nullable
    protected abstract UserDetails doAuthenticate(String var1, JWT var2) throws AuthenticationException;
}

