/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.security.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.lang.Nullable;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.filter.AbstractRequestLoggingFilter;
import spring.turbo.module.security.filter.SkippableFilter;
import spring.turbo.util.LogLevel;
import spring.turbo.util.Logger;

public class RequestLoggingFilter
extends AbstractRequestLoggingFilter
implements SkippableFilter {
    private final Logger log;
    @Nullable
    private RequestMatcher skipRequestMatcher;

    public RequestLoggingFilter() {
        this(null);
    }

    public RequestLoggingFilter(@Nullable Logger logger) {
        this.log = logger != null ? logger : new Logger(RequestLoggingFilter.class, LogLevel.DEBUG);
        super.setIncludeHeaders(true);
        super.setIncludeQueryString(true);
        super.setIncludeClientInfo(true);
        super.setIncludePayload(false);
    }

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        if (this.skipRequestMatcher != null && this.skipRequestMatcher.matches(httpServletRequest)) {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        super.doFilterInternal(httpServletRequest, httpServletResponse, filterChain);
    }

    protected void beforeRequest(HttpServletRequest httpServletRequest, String string) {
        this.log.log(string, new Object[0]);
    }

    protected void afterRequest(HttpServletRequest httpServletRequest, String string) {
        this.log.log(string, new Object[0]);
    }

    @Override
    public void setSkipRequestMatcher(@Nullable RequestMatcher requestMatcher) {
        this.skipRequestMatcher = requestMatcher;
    }
}

