/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.security.filter;

import org.springframework.security.core.userdetails.UserDetails;
import spring.turbo.module.security.authentication.MapTokenToUserConverter;
import spring.turbo.module.security.authentication.TokenToUserConverter;
import spring.turbo.module.security.filter.TokenAuthenticationFilter;
import spring.turbo.module.security.token.BearerTokenResolver;
import spring.turbo.module.security.user.UserDetailsPlus;
import spring.turbo.util.Asserts;
import spring.turbo.util.RandomStringUtils;

public final class MappingTokenAuthenticationFilter
extends TokenAuthenticationFilter {
    private MappingTokenAuthenticationFilter() {
        super.setTokenResolver(new BearerTokenResolver());
        super.setTokenToUserConverter(new MapTokenToUserConverter());
    }

    public static MappingTokenAuthenticationFilter newInstance() {
        return new MappingTokenAuthenticationFilter();
    }

    public MappingTokenAuthenticationFilter addUserDetails(String string, String ... stringArray) {
        String string2 = RandomStringUtils.randomUUID((boolean)true);
        return this.addUserDetails(string, UserDetailsPlus.builder().id(string2).username(string2).password(string2).authorities(stringArray).build());
    }

    public MappingTokenAuthenticationFilter addUserDetails(String string, UserDetails userDetails) {
        MapTokenToUserConverter mapTokenToUserConverter = (MapTokenToUserConverter)this.getTokenToUserConverter();
        Asserts.notNull((Object)mapTokenToUserConverter);
        mapTokenToUserConverter.add(string, userDetails);
        return this;
    }

    @Override
    public void setTokenToUserConverter(TokenToUserConverter tokenToUserConverter) {
        throw new UnsupportedOperationException();
    }
}

