/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.security.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.springframework.lang.Nullable;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.filter.OncePerRequestFilter;
import spring.turbo.module.security.filter.SkippableFilter;
import spring.turbo.util.CollectionUtils;
import spring.turbo.util.LogLevel;
import spring.turbo.util.Logger;
import spring.turbo.util.StringPool;
import spring.turbo.util.StringUtils;
import spring.turbo.webmvc.HttpRequestSnapshot;

public class HumanReadableRequestLoggingFilter
extends OncePerRequestFilter
implements SkippableFilter {
    private final Logger log;
    @Nullable
    private RequestMatcher skipRequestMatcher;

    public HumanReadableRequestLoggingFilter() {
        this(null);
    }

    public HumanReadableRequestLoggingFilter(@Nullable Logger logger) {
        this.log = Objects.requireNonNullElseGet(logger, () -> new Logger(HumanReadableRequestLoggingFilter.class, LogLevel.DEBUG));
    }

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        if (this.skipRequestMatcher != null && this.skipRequestMatcher.matches(httpServletRequest)) {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        try {
            this.doLog(httpServletRequest);
        }
        catch (Exception exception) {
            // empty catch block
        }
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    private void doLog(HttpServletRequest httpServletRequest) {
        List list;
        if (this.log.isEnabled() && CollectionUtils.isNotEmpty((Collection)(list = HttpRequestSnapshot.of((HttpServletRequest)httpServletRequest).getLinesList()))) {
            String string = "\n" + StringPool.HYPHEN_X_80 + "\n" + StringUtils.nullSafeJoin((Iterable)list, (String)"\n") + "\n" + StringPool.HYPHEN_X_80;
            this.log.log(string, new Object[0]);
        }
    }

    @Override
    public void setSkipRequestMatcher(@Nullable RequestMatcher requestMatcher) {
        this.skipRequestMatcher = requestMatcher;
    }
}

