/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.security.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.lang.Nullable;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;
import spring.turbo.module.security.authentication.Authentication;
import spring.turbo.module.security.authentication.NullUserDetailsFinder;
import spring.turbo.module.security.authentication.UserDetailsFinder;
import spring.turbo.module.security.event.AuthenticationFailureEvent;
import spring.turbo.module.security.event.AuthenticationSuccessEvent;
import spring.turbo.module.security.filter.AbstractAuthenticationFilter;
import spring.turbo.module.security.token.BasicToken;
import spring.turbo.module.security.token.BasicTokenResolver;
import spring.turbo.module.security.token.Token;
import spring.turbo.util.Asserts;

public class BasicAuthenticationFilter
extends AbstractAuthenticationFilter {
    private static final Logger log = LoggerFactory.getLogger(BasicAuthenticationFilter.class);
    @Nullable
    private UserDetailsFinder userDetailsFinder = NullUserDetailsFinder.getInstance();
    private boolean ignoreExceptions = false;

    public BasicAuthenticationFilter() {
        super.setTokenResolver(new BasicTokenResolver());
    }

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        block16: {
            if (!super.authenticationIsRequired()) {
                filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                return;
            }
            if (this.skipRequestMatcher != null && this.skipRequestMatcher.matches(httpServletRequest)) {
                filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                return;
            }
            Asserts.notNull((Object)this.tokenResolver);
            Asserts.notNull((Object)this.userDetailsFinder);
            try {
                String string;
                String string2;
                UserDetails userDetails;
                Token token = this.tokenResolver.resolve((WebRequest)new ServletWebRequest(httpServletRequest, httpServletResponse)).orElse(null);
                if (this.tokenBlacklistManager != null && token != null) {
                    this.tokenBlacklistManager.verify(token);
                }
                if (!(token instanceof BasicToken)) {
                    filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                    return;
                }
                BasicToken basicToken = (BasicToken)token;
                if (log.isDebugEnabled()) {
                    log.debug("token resolved");
                    log.debug("token value (string): {}", (Object)token.asString());
                    log.debug("token username: {}", (Object)((BasicToken)token).getUsername());
                    log.debug("token password: {}", (Object)((BasicToken)token).getPassword());
                }
                if ((userDetails = this.userDetailsFinder.loadUserByUsernameAndPassword(string2 = basicToken.getUsername(), string = basicToken.getPassword())) == null) {
                    filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                    return;
                }
                Authentication authentication = new Authentication(userDetails, token);
                authentication.setAuthenticated(true);
                if (this.requestDetailsProvider != null) {
                    authentication.setDetails(this.requestDetailsProvider.getDetails(httpServletRequest, token));
                }
                SecurityContextHolder.getContext().setAuthentication((org.springframework.security.core.Authentication)authentication);
                if (this.rememberMeServices != null) {
                    this.rememberMeServices.loginSuccess(httpServletRequest, httpServletResponse, (org.springframework.security.core.Authentication)authentication);
                }
                this.onSuccessfulAuthentication(httpServletRequest, httpServletResponse, authentication);
                if (this.applicationEventPublisher != null) {
                    AuthenticationSuccessEvent authenticationSuccessEvent = new AuthenticationSuccessEvent(authentication, token);
                    authenticationSuccessEvent.setRequest(httpServletRequest);
                    authenticationSuccessEvent.setResponse(httpServletResponse);
                    this.applicationEventPublisher.publishEvent((ApplicationEvent)authenticationSuccessEvent);
                }
            }
            catch (AuthenticationException authenticationException) {
                if (log.isDebugEnabled()) {
                    log.debug(authenticationException.getMessage(), (Throwable)authenticationException);
                }
                SecurityContextHolder.clearContext();
                if (this.rememberMeServices != null) {
                    this.rememberMeServices.loginFail(httpServletRequest, httpServletResponse);
                }
                this.onUnsuccessfulAuthentication(httpServletRequest, httpServletResponse, authenticationException);
                if (this.applicationEventPublisher != null) {
                    AuthenticationFailureEvent authenticationFailureEvent = new AuthenticationFailureEvent(authenticationException);
                    authenticationFailureEvent.setRequest(httpServletRequest);
                    authenticationFailureEvent.setResponse(httpServletResponse);
                    this.applicationEventPublisher.publishEvent((ApplicationEvent)authenticationFailureEvent);
                }
                if (this.authenticationEntryPoint != null) {
                    this.authenticationEntryPoint.commence(httpServletRequest, httpServletResponse, authenticationException);
                    return;
                }
            }
            catch (Exception exception) {
                if (this.ignoreExceptions) break block16;
                throw exception;
            }
        }
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    public void setUserDetailsFinder(UserDetailsFinder userDetailsFinder) {
        Asserts.notNull((Object)userDetailsFinder);
        this.userDetailsFinder = userDetailsFinder;
    }

    public void setIgnoreExceptions(boolean bl) {
        this.ignoreExceptions = bl;
    }
}

