/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.security.filter;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.lang.Nullable;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.filter.OncePerRequestFilter;
import spring.turbo.module.security.authentication.RequestDetailsProvider;
import spring.turbo.module.security.filter.SkippableFilter;
import spring.turbo.module.security.token.TokenResolver;
import spring.turbo.module.security.token.blacklist.TokenBlacklistManager;
import spring.turbo.util.Asserts;

public abstract class AbstractAuthenticationFilter
extends OncePerRequestFilter
implements SkippableFilter {
    @Nullable
    protected TokenResolver tokenResolver;
    @Nullable
    protected TokenBlacklistManager tokenBlacklistManager;
    @Nullable
    protected RememberMeServices rememberMeServices;
    @Nullable
    protected RequestDetailsProvider requestDetailsProvider = RequestDetailsProvider.ALWAYS_NULL;
    @Nullable
    protected AuthenticationEntryPoint authenticationEntryPoint;
    @Nullable
    protected ApplicationEventPublisher applicationEventPublisher;
    @Nullable
    protected RequestMatcher skipRequestMatcher;

    protected final boolean authenticationIsRequired() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null || !authentication.isAuthenticated()) {
            return true;
        }
        return authentication instanceof AnonymousAuthenticationToken;
    }

    protected void onSuccessfulAuthentication(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Authentication authentication) {
    }

    protected void onUnsuccessfulAuthentication(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, AuthenticationException authenticationException) {
    }

    public final void setTokenResolver(TokenResolver tokenResolver) {
        Asserts.notNull((Object)tokenResolver);
        this.tokenResolver = tokenResolver;
    }

    public void setTokenBlacklistManager(@Nullable TokenBlacklistManager tokenBlacklistManager) {
        this.tokenBlacklistManager = tokenBlacklistManager;
    }

    public final void setRememberMeServices(@Nullable RememberMeServices rememberMeServices) {
        this.rememberMeServices = rememberMeServices;
    }

    public final void setRequestDetailsProvider(@Nullable RequestDetailsProvider requestDetailsProvider) {
        this.requestDetailsProvider = requestDetailsProvider;
    }

    public final void setAuthenticationEntryPoint(@Nullable AuthenticationEntryPoint authenticationEntryPoint) {
        this.authenticationEntryPoint = authenticationEntryPoint;
    }

    public void setApplicationEventPublisher(@Nullable ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Override
    public void setSkipRequestMatcher(@Nullable RequestMatcher requestMatcher) {
        this.skipRequestMatcher = requestMatcher;
    }
}

