/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.security.exception;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.firewall.RequestRejectedException;
import spring.turbo.module.security.exception.SecurityExceptionHandler;

public class SecurityExceptionHandlerImpl
implements SecurityExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(SecurityExceptionHandlerImpl.class);

    @Override
    public void handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, RequestRejectedException requestRejectedException) throws IOException, ServletException {
        log.debug("handle \"{}\" exception", (Object)requestRejectedException.getClass().getName());
        httpServletRequest.setAttribute("SPRING_SECURITY_REJECTED_EXCEPTION", (Object)requestRejectedException);
        httpServletResponse.setStatus(HttpStatus.BAD_REQUEST.value());
    }

    @Override
    public void commence(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, AuthenticationException authenticationException) throws IOException, ServletException {
        log.debug("handle \"{}\" exception", (Object)((Object)((Object)authenticationException)).getClass().getName());
        httpServletRequest.setAttribute("SPRING_SECURITY_LAST_EXCEPTION", (Object)authenticationException);
        httpServletResponse.setStatus(HttpStatus.UNAUTHORIZED.value());
    }

    @Override
    public void handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, AccessDeniedException accessDeniedException) throws IOException, ServletException {
        log.debug("handle \"{}\" exception", (Object)accessDeniedException.getClass().getName());
        httpServletRequest.setAttribute("SPRING_SECURITY_403_EXCEPTION", (Object)accessDeniedException);
        httpServletResponse.setStatus(HttpStatus.FORBIDDEN.value());
    }
}

